/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.stripe.android.R;
import com.stripe.android.databinding.PaymentSheetBuyButtonBinding;
import com.stripe.android.paymentsheet.BuyButton;
import com.stripe.android.paymentsheet.CurrencyFormatter;
import com.stripe.android.paymentsheet.model.ViewState;
import java.util.Currency;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u0019\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014J\u0006\u0010\u001a\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lcom/stripe/android/paymentsheet/BuyButton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "confirmedIcon", "Landroid/widget/ImageView;", "currencyFormatter", "Lcom/stripe/android/paymentsheet/CurrencyFormatter;", "viewBinding", "Lcom/stripe/android/databinding/PaymentSheetBuyButtonBinding;", "getViewBinding$stripe_release", "()Lcom/stripe/android/databinding/PaymentSheetBuyButtonBinding;", "animateConfirmedIcon", "", "onAnimationEnd", "Lkotlin/Function0;", "fadeIn", "view", "Landroid/view/View;", "fadeOut", "onCompletedState", "onConfirmingState", "onReadyState", "state", "Lcom/stripe/android/paymentsheet/model/ViewState$Ready;", "setEnabled", "enabled", "", "Companion", "stripe_release"})
public final class BuyButton
extends FrameLayout {
    @NotNull
    private final PaymentSheetBuyButtonBinding viewBinding;
    private final ImageView confirmedIcon;
    private final CurrencyFormatter currencyFormatter;
    private static final float ALPHA_ENABLED = 1.0f;
    private static final float ALPHA_DISABLED = 0.5f;
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final PaymentSheetBuyButtonBinding getViewBinding$stripe_release() {
        return this.viewBinding;
    }

    public final void onReadyState(@NotNull ViewState.Ready state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ProgressBar progressBar2 = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.confirmingIcon");
        progressBar2.setVisibility(8);
        String string2 = state.getCurrencyCode();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        Currency currency = Currency.getInstance(string4);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        Resources resources = this.getResources();
        Object[] objectArray = new Object[1];
        long l = state.getAmount();
        Currency currency2 = currency;
        Intrinsics.checkNotNullExpressionValue((Object)currency2, (String)"currency");
        objectArray[0] = this.currencyFormatter.format(l, currency2);
        textView.setText((CharSequence)resources.getString(R.string.stripe_paymentsheet_pay_button_amount, objectArray));
    }

    public final void onConfirmingState() {
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.lockIcon");
        imageView.setVisibility(8);
        ProgressBar progressBar2 = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.confirmingIcon");
        progressBar2.setVisibility(0);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        textView.setText((CharSequence)this.getResources().getString(R.string.stripe_paymentsheet_pay_button_processing));
    }

    public final void onCompletedState(@NotNull Function0<Unit> onAnimationEnd) {
        Intrinsics.checkNotNullParameter(onAnimationEnd, (String)"onAnimationEnd");
        this.setBackgroundResource(R.drawable.stripe_paymentsheet_buy_button_confirmed_background);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        this.fadeOut((View)textView);
        ProgressBar progressBar2 = this.viewBinding.confirmingIcon;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar2, (String)"viewBinding.confirmingIcon");
        this.fadeOut((View)progressBar2);
        this.animateConfirmedIcon(onAnimationEnd);
    }

    private final void animateConfirmedIcon(Function0<Unit> onAnimationEnd) {
        float iconCenter = (float)this.confirmedIcon.getLeft() + (float)(this.confirmedIcon.getRight() - this.confirmedIcon.getLeft()) / 2.0f;
        float targetX = iconCenter - (float)this.getWidth() / 2.0f;
        ImageView imageView = this.viewBinding.confirmedIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.confirmedIcon");
        this.fadeIn((View)imageView, (Function0<Unit>)((Function0)new Function0<Unit>(this, targetX, onAnimationEnd){
            final /* synthetic */ BuyButton this$0;
            final /* synthetic */ float $targetX;
            final /* synthetic */ Function0 $onAnimationEnd;

            public final void invoke() {
                ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)BuyButton.access$getConfirmedIcon$p(this.this$0), (String)"translationX", (float[])new float[]{0.0f, -this.$targetX});
                boolean bl = false;
                boolean bl2 = false;
                ObjectAnimator animator = objectAnimator;
                boolean bl3 = false;
                ObjectAnimator objectAnimator2 = animator;
                Intrinsics.checkNotNullExpressionValue((Object)objectAnimator2, (String)"animator");
                objectAnimator2.setDuration((long)this.this$0.getResources().getInteger(0x10E0000));
                Animator $this$doOnEnd$iv = (Animator)animator;
                boolean $i$f$doOnEnd = false;
                Animator $this$addListener$iv$iv = $this$doOnEnd$iv;
                boolean $i$f$addListener = false;
                Animator.AnimatorListener listener$iv$iv = new Animator.AnimatorListener(this){
                    final /* synthetic */ animateConfirmedIcon.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void onAnimationRepeat(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                    }

                    public void onAnimationEnd(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                        boolean bl = false;
                        this.this$0.$onAnimationEnd.invoke();
                    }

                    public void onAnimationCancel(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                    }

                    public void onAnimationStart(@NotNull Animator animator) {
                        Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                        Animator it = animator;
                    }
                };
                $this$addListener$iv$iv.addListener(listener$iv$iv);
                Animator.AnimatorListener cfr_ignored_0 = (Animator.AnimatorListener)listener$iv$iv;
                objectAnimator.start();
            }
            {
                this.this$0 = buyButton;
                this.$targetX = f;
                this.$onAnimationEnd = function0;
                super(0);
            }
        }));
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        TextView textView = this.viewBinding.label;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.label");
        textView.setAlpha(enabled ? 1.0f : 0.5f);
        ImageView imageView = this.viewBinding.lockIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.lockIcon");
        imageView.setVisibility(enabled ? 0 : 8);
    }

    /*
     * WARNING - void declaration
     */
    private final void fadeIn(View view, Function0<Unit> onAnimationEnd) {
        void animation;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.stripe_paymentsheet_transition_fade_in);
        boolean bl = false;
        boolean bl2 = false;
        Animation animation3 = animation2;
        View view2 = view;
        boolean bl3 = false;
        animation.setAnimationListener(new Animation.AnimationListener(view, onAnimationEnd){
            final /* synthetic */ View $view$inlined;
            final /* synthetic */ Function0 $onAnimationEnd$inlined;
            {
                this.$view$inlined = view;
                this.$onAnimationEnd$inlined = function0;
            }

            public void onAnimationStart(@Nullable Animation p0) {
                this.$view$inlined.setVisibility(0);
            }

            public void onAnimationEnd(@Nullable Animation p0) {
                this.$view$inlined.setVisibility(0);
                this.$onAnimationEnd$inlined.invoke();
            }

            public void onAnimationRepeat(@Nullable Animation p0) {
            }
        });
        Unit unit = Unit.INSTANCE;
        view2.startAnimation(animation2);
    }

    /*
     * WARNING - void declaration
     */
    private final void fadeOut(View view) {
        void animation;
        Animation animation2 = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.stripe_paymentsheet_transition_fade_out);
        boolean bl = false;
        boolean bl2 = false;
        Animation animation3 = animation2;
        View view2 = view;
        boolean bl3 = false;
        animation.setAnimationListener(new Animation.AnimationListener(view){
            final /* synthetic */ View $view$inlined;
            {
                this.$view$inlined = view;
            }

            public void onAnimationStart(@Nullable Animation p0) {
                this.$view$inlined.setVisibility(0);
            }

            public void onAnimationEnd(@Nullable Animation p0) {
                this.$view$inlined.setVisibility(4);
            }

            public void onAnimationRepeat(@Nullable Animation p0) {
            }
        });
        Unit unit = Unit.INSTANCE;
        view2.startAnimation(animation2);
    }

    @JvmOverloads
    public BuyButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        PaymentSheetBuyButtonBinding paymentSheetBuyButtonBinding = PaymentSheetBuyButtonBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)paymentSheetBuyButtonBinding, (String)"PaymentSheetBuyButtonBin\u2026text),\n        this\n    )");
        this.viewBinding = paymentSheetBuyButtonBinding;
        ImageView imageView = this.viewBinding.confirmedIcon;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"viewBinding.confirmedIcon");
        this.confirmedIcon = imageView;
        this.currencyFormatter = new CurrencyFormatter();
        this.setBackgroundResource(R.drawable.stripe_paymentsheet_buy_button_default_background);
        this.setClickable(true);
        this.setEnabled(false);
    }

    public /* synthetic */ BuyButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BuyButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BuyButton(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ ImageView access$getConfirmedIcon$p(BuyButton $this) {
        return $this.confirmedIcon;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/BuyButton$Companion;", "", "()V", "ALPHA_DISABLED", "", "ALPHA_ENABLED", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

