/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeError;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\r\u0018\u0000 &2\u00020\u0001:\u0005%&'()B!\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u0018\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J&\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000eJ.\u0010#\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/IssuingCardPinService;", "", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "stripeRepository", "Lcom/stripe/android/networking/StripeRepository;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/networking/StripeRepository;Lcom/stripe/android/OperationIdFactory;)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "retrievalListeners", "", "", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "updateListeners", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "fireRetrievePinRequest", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operation", "Lcom/stripe/android/EphemeralOperation$Issuing$RetrievePin;", "listener", "fireUpdatePinRequest", "Lcom/stripe/android/EphemeralOperation$Issuing$UpdatePin;", "logMissingListener", "onRetrievePinError", "throwable", "", "onUpdatePinError", "retrievePin", "cardId", "verificationId", "userOneTimeCode", "updatePin", "newPin", "CardPinActionError", "Companion", "IssuingCardPinRetrievalListener", "IssuingCardPinUpdateListener", "Listener", "stripe_release"})
public final class IssuingCardPinService {
    private final Map<String, IssuingCardPinRetrievalListener> retrievalListeners;
    private final Map<String, IssuingCardPinUpdateListener> updateListeners;
    private final EphemeralKeyManager ephemeralKeyManager;
    private final StripeRepository stripeRepository;
    private final OperationIdFactory operationIdFactory;
    private static final String TAG;
    public static final Companion Companion;

    public final void retrievePin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinRetrievalListener listener) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        this.retrievalListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(new EphemeralOperation.Issuing.RetrievePin(cardId, verificationId, userOneTimeCode, operationId));
    }

    public final void updatePin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinUpdateListener listener) {
        Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
        Intrinsics.checkNotNullParameter((Object)newPin, (String)"newPin");
        Intrinsics.checkNotNullParameter((Object)verificationId, (String)"verificationId");
        Intrinsics.checkNotNullParameter((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        this.updateListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(new EphemeralOperation.Issuing.UpdatePin(cardId, newPin, verificationId, userOneTimeCode, operationId));
    }

    private final void fireRetrievePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        Result.Companion companion;
        Object object;
        IssuingCardPinService issuingCardPinService = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            IssuingCardPinService $this$runCatching = issuingCardPinService;
            boolean bl2 = false;
            String pin = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>($this$runCatching, null, operation, ephemeralKey, listener){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ IssuingCardPinService $this_runCatching;
                final /* synthetic */ EphemeralOperation.Issuing.RetrievePin $operation$inlined;
                final /* synthetic */ EphemeralKey $ephemeralKey$inlined;
                final /* synthetic */ IssuingCardPinRetrievalListener $listener$inlined;
                {
                    this.$this_runCatching = issuingCardPinService;
                    this.$operation$inlined = retrievePin;
                    this.$ephemeralKey$inlined = ephemeralKey;
                    this.$listener$inlined = issuingCardPinRetrievalListener;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = IssuingCardPinService.access$getStripeRepository$p(this.$this_runCatching).retrieveIssuingCardPin(this.$operation$inlined.getCardId(), this.$operation$inlined.getVerificationId(), this.$operation$inlined.getUserOneTimeCode(), this.$ephemeralKey$inlined.getSecret(), (Continuation<? super String>)this);
                            Object object3 = object2;
                            if (object2 != object) return object3;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super String>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                    function2.p$ = (CoroutineScope)value;
                    Function2<CoroutineScope, Continuation<? super String>, Object> function22 = function2;
                    return function22;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            listener.onIssuingCardPinRetrieved(pin);
            companion = Unit.INSTANCE;
            bl2 = false;
            object = Result.constructor-impl((Object)companion);
        }
        catch (Throwable throwable) {
            Result.Companion bl2 = Result.Companion;
            boolean pin = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        issuingCardPinService = object;
        bl = false;
        boolean bl3 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)issuingCardPinService);
        if (throwable != null) {
            companion = Result.Companion;
            Throwable it = throwable;
            boolean bl4 = false;
            this.onRetrievePinError(it, listener);
            Unit unit = Unit.INSTANCE;
            boolean bl5 = false;
            Result.constructor-impl((Object)unit);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onRetrievePinError(Throwable throwable, IssuingCardPinRetrievalListener listener) {
        Throwable throwable2 = throwable;
        if (!(throwable2 instanceof InvalidRequestException)) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred while retrieving the PIN.", throwable);
            return;
        }
        StripeError stripeError = ((InvalidRequestException)throwable).getStripeError();
        String string2 = stripeError != null ? stripeError.getCode() : null;
        if (string2 != null) {
            switch (string2) {
                case "expired": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                    return;
                }
                case "incorrect_code": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect.", null);
                    return;
                }
                case "too_many_attempts": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times.", null);
                    return;
                }
                case "already_redeemed": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed.", null);
                    return;
                }
            }
        }
        listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to retrieve the PIN failed, possibly an error with the verification.", throwable);
    }

    private final void fireUpdatePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        boolean bl;
        Result.Companion companion;
        Object object;
        IssuingCardPinService issuingCardPinService = this;
        boolean bl2 = false;
        try {
            object = Result.Companion;
            IssuingCardPinService $this$runCatching = issuingCardPinService;
            boolean bl3 = false;
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$runCatching, null, operation, ephemeralKey, listener){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ IssuingCardPinService $this_runCatching;
                final /* synthetic */ EphemeralOperation.Issuing.UpdatePin $operation$inlined;
                final /* synthetic */ EphemeralKey $ephemeralKey$inlined;
                final /* synthetic */ IssuingCardPinUpdateListener $listener$inlined;
                {
                    this.$this_runCatching = issuingCardPinService;
                    this.$operation$inlined = updatePin;
                    this.$ephemeralKey$inlined = ephemeralKey;
                    this.$listener$inlined = issuingCardPinUpdateListener;
                    super(2, continuation);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$runBlocking = this.p$;
                            this.L$0 = $this$runBlocking;
                            this.label = 1;
                            Object object2 = IssuingCardPinService.access$getStripeRepository$p(this.$this_runCatching).updateIssuingCardPin(this.$operation$inlined.getCardId(), this.$operation$inlined.getNewPin(), this.$operation$inlined.getVerificationId(), this.$operation$inlined.getUserOneTimeCode(), this.$ephemeralKey$inlined.getSecret(), (Continuation<? super Unit>)this);
                            Object object3 = object2;
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope cfr_ignored_0 = (CoroutineScope)value;
                    function2.p$ = (CoroutineScope)value;
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function22 = function2;
                    return function22;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            listener.onIssuingCardPinUpdated();
            companion = Unit.INSTANCE;
            bl3 = false;
            object = Result.constructor-impl((Object)companion);
        }
        catch (Throwable throwable) {
            Result.Companion bl3 = Result.Companion;
            bl = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        issuingCardPinService = object;
        bl2 = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)issuingCardPinService);
        if (throwable != null) {
            companion = Result.Companion;
            Throwable it = throwable;
            boolean bl5 = false;
            this.onUpdatePinError(it, listener);
            Unit unit = Unit.INSTANCE;
            bl = false;
            Result.constructor-impl((Object)unit);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onUpdatePinError(Throwable throwable, IssuingCardPinUpdateListener listener) {
        Throwable throwable2 = throwable;
        if (!(throwable2 instanceof InvalidRequestException)) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred while updating the PIN.", throwable);
            return;
        }
        StripeError stripeError = ((InvalidRequestException)throwable).getStripeError();
        String string2 = stripeError != null ? stripeError.getCode() : null;
        if (string2 != null) {
            switch (string2) {
                case "expired": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired.", null);
                    return;
                }
                case "incorrect_code": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect.", null);
                    return;
                }
                case "too_many_attempts": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times.", null);
                    return;
                }
                case "already_redeemed": {
                    listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed.", null);
                    return;
                }
            }
        }
        listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to update the PIN failed, possibly an error with the verification.", throwable);
    }

    private final void logMissingListener() {
        Log.e((String)TAG, (String)(this.getClass().getName() + " was called without a listener"));
    }

    @VisibleForTesting
    public IssuingCardPinService(@NotNull EphemeralKeyProvider keyProvider, @NotNull StripeRepository stripeRepository, @NotNull OperationIdFactory operationIdFactory) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkNotNullParameter((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkNotNullParameter((Object)operationIdFactory, (String)"operationIdFactory");
        this.stripeRepository = stripeRepository;
        this.operationIdFactory = operationIdFactory;
        boolean bl = false;
        this.retrievalListeners = new LinkedHashMap();
        bl = false;
        this.updateListeners = new LinkedHashMap();
        this.ephemeralKeyManager = new EphemeralKeyManager(keyProvider, new EphemeralKeyManager.KeyManagerListener(this){
            final /* synthetic */ IssuingCardPinService this$0;

            public void onKeyUpdate(@NotNull EphemeralKey ephemeralKey, @NotNull EphemeralOperation operation) {
                block5: {
                    EphemeralOperation ephemeralOperation;
                    block4: {
                        Intrinsics.checkNotNullParameter((Object)ephemeralKey, (String)"ephemeralKey");
                        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                        ephemeralOperation = operation;
                        if (!(ephemeralOperation instanceof EphemeralOperation.Issuing.RetrievePin)) break block4;
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operation.getId$stripe_release());
                        if (issuingCardPinRetrievalListener != null) {
                            IssuingCardPinRetrievalListener issuingCardPinRetrievalListener2 = issuingCardPinRetrievalListener;
                            boolean bl = false;
                            boolean bl2 = false;
                            IssuingCardPinRetrievalListener listener = issuingCardPinRetrievalListener2;
                            boolean bl3 = false;
                            IssuingCardPinService.access$fireRetrievePinRequest(this.this$0, ephemeralKey, (EphemeralOperation.Issuing.RetrievePin)operation, listener);
                        } else {
                            IssuingCardPinService.access$logMissingListener(this.this$0);
                        }
                        break block5;
                    }
                    if (!(ephemeralOperation instanceof EphemeralOperation.Issuing.UpdatePin)) break block5;
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operation.getId$stripe_release());
                    if (issuingCardPinUpdateListener != null) {
                        IssuingCardPinUpdateListener issuingCardPinUpdateListener2 = issuingCardPinUpdateListener;
                        boolean bl = false;
                        boolean bl4 = false;
                        IssuingCardPinUpdateListener listener = issuingCardPinUpdateListener2;
                        boolean bl5 = false;
                        IssuingCardPinService.access$fireUpdatePinRequest(this.this$0, ephemeralKey, (EphemeralOperation.Issuing.UpdatePin)operation, listener);
                    } else {
                        IssuingCardPinService.access$logMissingListener(this.this$0);
                    }
                }
            }

            public void onKeyError(@NotNull String operationId, int errorCode, @NotNull String errorMessage) {
                block1: {
                    IssuingCardPinUpdateListener updateListener;
                    block0: {
                        IssuingCardPinRetrievalListener retrievalListener;
                        Intrinsics.checkNotNullParameter((Object)operationId, (String)"operationId");
                        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                        updateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operationId);
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = retrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operationId);
                        if (issuingCardPinRetrievalListener == null) break block0;
                        issuingCardPinRetrievalListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                        break block1;
                    }
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = updateListener;
                    if (issuingCardPinUpdateListener == null) break block1;
                    issuingCardPinUpdateListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                }
            }
            {
                this.this$0 = this$0;
            }
        }, this.operationIdFactory, true, null, 0L, 48, null);
    }

    public /* synthetic */ IssuingCardPinService(EphemeralKeyProvider ephemeralKeyProvider, StripeRepository stripeRepository, OperationIdFactory operationIdFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        this(ephemeralKeyProvider, stripeRepository, operationIdFactory);
    }

    static {
        Companion = new Companion(null);
        TAG = IssuingCardPinService.class.getName();
    }

    public static final /* synthetic */ StripeRepository access$getStripeRepository$p(IssuingCardPinService $this) {
        return $this.stripeRepository;
    }

    public static final /* synthetic */ Map access$getRetrievalListeners$p(IssuingCardPinService $this) {
        return $this.retrievalListeners;
    }

    public static final /* synthetic */ void access$fireRetrievePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        $this.fireRetrievePinRequest(ephemeralKey, operation, listener);
    }

    public static final /* synthetic */ void access$logMissingListener(IssuingCardPinService $this) {
        $this.logMissingListener();
    }

    public static final /* synthetic */ Map access$getUpdateListeners$p(IssuingCardPinService $this) {
        return $this.updateListeners;
    }

    public static final /* synthetic */ void access$fireUpdatePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        $this.fireUpdatePinRequest(ephemeralKey, operation, listener);
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, keyProvider);
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, publishableKey, keyProvider);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "", "(Ljava/lang/String;I)V", "UNKNOWN_ERROR", "EPHEMERAL_KEY_ERROR", "ONE_TIME_CODE_INCORRECT", "ONE_TIME_CODE_EXPIRED", "ONE_TIME_CODE_TOO_MANY_ATTEMPTS", "ONE_TIME_CODE_ALREADY_REDEEMED", "stripe_release"})
    public static final class CardPinActionError
    extends Enum<CardPinActionError> {
        public static final /* enum */ CardPinActionError UNKNOWN_ERROR;
        public static final /* enum */ CardPinActionError EPHEMERAL_KEY_ERROR;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_INCORRECT;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_EXPIRED;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_TOO_MANY_ATTEMPTS;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_ALREADY_REDEEMED;
        private static final /* synthetic */ CardPinActionError[] $VALUES;

        static {
            CardPinActionError[] cardPinActionErrorArray = new CardPinActionError[6];
            CardPinActionError[] cardPinActionErrorArray2 = cardPinActionErrorArray;
            cardPinActionErrorArray[0] = UNKNOWN_ERROR = new CardPinActionError();
            cardPinActionErrorArray[1] = EPHEMERAL_KEY_ERROR = new CardPinActionError();
            cardPinActionErrorArray[2] = ONE_TIME_CODE_INCORRECT = new CardPinActionError();
            cardPinActionErrorArray[3] = ONE_TIME_CODE_EXPIRED = new CardPinActionError();
            cardPinActionErrorArray[4] = ONE_TIME_CODE_TOO_MANY_ATTEMPTS = new CardPinActionError();
            cardPinActionErrorArray[5] = ONE_TIME_CODE_ALREADY_REDEEMED = new CardPinActionError();
            $VALUES = cardPinActionErrorArray;
        }

        public static CardPinActionError[] values() {
            return (CardPinActionError[])$VALUES.clone();
        }

        public static CardPinActionError valueOf(String string2) {
            return Enum.valueOf(CardPinActionError.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinRetrieved", "", "pin", "", "stripe_release"})
    public static interface IssuingCardPinRetrievalListener
    extends Listener {
        public void onIssuingCardPinRetrieved(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinUpdated", "", "stripe_release"})
    public static interface IssuingCardPinUpdateListener
    extends Listener {
        public void onIssuingCardPinUpdated();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/IssuingCardPinService$Listener;", "", "onError", "", "errorCode", "Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "errorMessage", "", "exception", "", "stripe_release"})
    public static interface Listener {
        public void onError(@NotNull CardPinActionError var1, @Nullable String var2, @Nullable Throwable var3);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/IssuingCardPinService$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "create", "Lcom/stripe/android/IssuingCardPinService;", "context", "Landroid/content/Context;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "publishableKey", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            return this.create(context, PaymentConfiguration.Companion.getInstance(context).getPublishableKey(), keyProvider);
        }

        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
            return new IssuingCardPinService(keyProvider, new StripeApiRepository(context, publishableKey, Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, null, null, 4088, null), new StripeOperationIdFactory());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

