/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.cards.CardNumber;
import com.stripe.android.databinding.CardMultilineWidgetBinding;
import com.stripe.android.model.Address;
import com.stripe.android.model.Card;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.CardParams;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardNumberTextInputLayout;
import com.stripe.android.view.CardValidCallback;
import com.stripe.android.view.CardWidget;
import com.stripe.android.view.CvcEditText;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.PostalCodeEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ff\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001b*\u0001/\u0018\u0000 \u00b0\u00012\u00020\u00012\u00020\u0002:\u0002\u00b0\u0001B/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010|\u001a\u00020}2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010~\u001a\u00020}2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u007f\u001a\u00020}H\u0016J\u0014\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\t\u0010\u0084\u0001\u001a\u00020}H\u0002J\t\u0010\u0085\u0001\u001a\u00020}H\u0002J\t\u0010\u0086\u0001\u001a\u00020}H\u0002J,\u0010\u0087\u0001\u001a\u00020}2\u0007\u0010\u0088\u0001\u001a\u00020:2\u0007\u0010\u0089\u0001\u001a\u00020:2\u0007\u0010\u008a\u0001\u001a\u00020:2\u0006\u0010g\u001a\u00020:H\u0002J\b\u0010K\u001a\u00020\nH\u0016J\t\u0010\u008b\u0001\u001a\u00020}H\u0014J\u0012\u0010\u008c\u0001\u001a\u00020}2\u0007\u0010\u008d\u0001\u001a\u00020\nH\u0016J\u0012\u0010\u008e\u0001\u001a\u00020}2\u0007\u0010\u008f\u0001\u001a\u00020\u001fH\u0016J\u0014\u0010\u0090\u0001\u001a\u00020}2\t\u0010\u0091\u0001\u001a\u0004\u0018\u00010!H\u0016J\u0014\u0010\u0092\u0001\u001a\u00020}2\t\u0010\u0093\u0001\u001a\u0004\u0018\u00010\u001fH\u0016J\u0015\u0010\u0094\u0001\u001a\u00020}2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0096\u0001H\u0016J\u0014\u0010\u0097\u0001\u001a\u00020}2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010-H\u0016J\u0014\u0010\u0099\u0001\u001a\u00020}2\t\u0010\u009a\u0001\u001a\u0004\u0018\u00010\u001fH\u0016J\u0012\u0010\u009b\u0001\u001a\u00020}2\t\u0010\u009c\u0001\u001a\u0004\u0018\u00010\u001fJ\u0015\u0010\u009d\u0001\u001a\u00020}2\n\u0010\u009e\u0001\u001a\u0005\u0018\u00010\u0096\u0001H\u0016J\u0012\u0010\u009f\u0001\u001a\u00020}2\u0007\u0010\u00a0\u0001\u001a\u00020\nH\u0016J\u001f\u0010\u00a1\u0001\u001a\u00020}2\t\b\u0001\u0010\u00a2\u0001\u001a\u00020\b2\t\b\u0001\u0010\u00a3\u0001\u001a\u00020\bH\u0016J\u0015\u0010\u00a4\u0001\u001a\u00020}2\n\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u0096\u0001H\u0016J\u0015\u0010\u00a6\u0001\u001a\u00020}2\n\u0010\u00a7\u0001\u001a\u0005\u0018\u00010\u0096\u0001H\u0016J\u000f\u0010\u00a8\u0001\u001a\u00020}2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u00a9\u0001\u001a\u00020}H\u0002J\t\u0010\u00aa\u0001\u001a\u00020}H\u0002J\u001d\u0010\u00ab\u0001\u001a\u00020}2\t\b\u0001\u0010\u00ac\u0001\u001a\u00020\b2\u0007\u0010\u00ad\u0001\u001a\u00020\nH\u0002J\u0007\u0010\u00ae\u0001\u001a\u00020\nJ\u0007\u0010\u00af\u0001\u001a\u00020\nR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0014\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\u0004\u0018\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0010\u0010,\u001a\u0004\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R\u0010\u00101\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u000203X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u00020\b8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010<\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010=8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020H0G8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u000e\u0010K\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010L\u001a\u0004\u0018\u00010M8F\u00a2\u0006\u0006\u001a\u0004\bN\u0010OR\u0013\u0010P\u001a\u0004\u0018\u00010Q8F\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0016\u0010T\u001a\u0004\u0018\u00010U8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bV\u0010WR\u0016\u0010X\u001a\u0004\u0018\u00010Y8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[R\u000e\u0010\\\u001a\u00020]X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010^\u001a\u00020_X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b`\u0010aR\u001a\u0010b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010d\"\u0004\be\u0010fR\u0014\u0010g\u001a\u00020:X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010iR,\u0010k\u001a\u00020\n2\u0006\u0010j\u001a\u00020\n8\u0000@BX\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bl\u0010\u0014\u001a\u0004\bm\u0010d\"\u0004\bn\u0010fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010o\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R+\u0010q\u001a\u00020\n2\u0006\u0010p\u001a\u00020\n8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bt\u0010u\u001a\u0004\br\u0010d\"\u0004\bs\u0010fR\u0016\u0010v\u001a\u0004\u0018\u00010w8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bx\u0010yR\u000e\u0010z\u001a\u00020{X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b1\u0001"}, d2={"Lcom/stripe/android/view/CardMultilineWidget;", "Landroid/widget/LinearLayout;", "Lcom/stripe/android/view/CardWidget;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "shouldShowPostalCode", "", "(Landroid/content/Context;Landroid/util/AttributeSet;IZ)V", "allFields", "", "Lcom/stripe/android/view/StripeEditText;", "getAllFields", "()Ljava/util/Collection;", "card", "Lcom/stripe/android/model/Card;", "getCard$annotations", "()V", "getCard", "()Lcom/stripe/android/model/Card;", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "cardBuilder", "Lcom/stripe/android/model/Card$Builder;", "getCardBuilder$annotations", "getCardBuilder", "()Lcom/stripe/android/model/Card$Builder;", "cardHintText", "", "cardInputListener", "Lcom/stripe/android/view/CardInputListener;", "cardNumberEditText", "Lcom/stripe/android/view/CardNumberEditText;", "getCardNumberEditText$stripe_release", "()Lcom/stripe/android/view/CardNumberEditText;", "cardNumberTextInputLayout", "Lcom/stripe/android/view/CardNumberTextInputLayout;", "cardParams", "Lcom/stripe/android/model/CardParams;", "getCardParams", "()Lcom/stripe/android/model/CardParams;", "cardValidCallback", "Lcom/stripe/android/view/CardValidCallback;", "cardValidTextWatcher", "com/stripe/android/view/CardMultilineWidget$cardValidTextWatcher$1", "Lcom/stripe/android/view/CardMultilineWidget$cardValidTextWatcher$1;", "customCvcLabel", "cvcEditText", "Lcom/stripe/android/view/CvcEditText;", "getCvcEditText$stripe_release", "()Lcom/stripe/android/view/CvcEditText;", "cvcHelperText", "getCvcHelperText", "()I", "cvcInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "dynamicBufferInPixels", "expiryDate", "Lkotlin/Pair;", "getExpiryDate", "()Lkotlin/Pair;", "expiryDateEditText", "Lcom/stripe/android/view/ExpiryDateEditText;", "getExpiryDateEditText$stripe_release", "()Lcom/stripe/android/view/ExpiryDateEditText;", "expiryTextInputLayout", "hasAdjustedDrawable", "invalidFields", "", "Lcom/stripe/android/view/CardValidCallback$Fields;", "getInvalidFields", "()Ljava/util/Set;", "isEnabled", "paymentMethodBillingDetails", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "getPaymentMethodBillingDetails", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "paymentMethodBillingDetailsBuilder", "Lcom/stripe/android/model/PaymentMethod$BillingDetails$Builder;", "getPaymentMethodBillingDetailsBuilder", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails$Builder;", "paymentMethodCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "getPaymentMethodCard", "()Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodCreateParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "pixelsToAdjust", "", "postalCodeEditText", "Lcom/stripe/android/view/PostalCodeEditText;", "getPostalCodeEditText$stripe_release", "()Lcom/stripe/android/view/PostalCodeEditText;", "postalCodeRequired", "getPostalCodeRequired", "()Z", "setPostalCodeRequired", "(Z)V", "postalInputLayout", "getPostalInputLayout$stripe_release", "()Lcom/google/android/material/textfield/TextInputLayout;", "value", "shouldShowErrorIcon", "getShouldShowErrorIcon$stripe_release$annotations", "getShouldShowErrorIcon$stripe_release", "setShouldShowErrorIcon", "tintColorInt", "<set-?>", "usZipCodeRequired", "getUsZipCodeRequired", "setUsZipCodeRequired", "usZipCodeRequired$delegate", "Lkotlin/properties/ReadWriteProperty;", "validatedCardNumber", "Lcom/stripe/android/cards/CardNumber$Validated;", "getValidatedCardNumber", "()Lcom/stripe/android/cards/CardNumber$Validated;", "viewBinding", "Lcom/stripe/android/databinding/CardMultilineWidgetBinding;", "adjustViewForPostalCodeAttribute", "", "checkAttributeSet", "clear", "createDrawableBounds", "Landroid/graphics/Rect;", "drawable", "Landroid/graphics/drawable/Drawable;", "flipToCvcIconIfNotFinished", "initDeleteEmptyListeners", "initFocusChangeListeners", "initTextInputLayoutErrorHandlers", "cardInputLayout", "expiryInputLayout", "cvcTextInputLayout", "onFinishInflate", "onWindowFocusChanged", "hasWindowFocus", "setCardHint", "cardHint", "setCardInputListener", "listener", "setCardNumber", "cardNumber", "setCardNumberTextWatcher", "cardNumberTextWatcher", "Landroid/text/TextWatcher;", "setCardValidCallback", "callback", "setCvcCode", "cvcCode", "setCvcLabel", "cvcLabel", "setCvcNumberTextWatcher", "cvcNumberTextWatcher", "setEnabled", "enabled", "setExpiryDate", "month", "year", "setExpiryDateTextWatcher", "expiryDateTextWatcher", "setPostalCodeTextWatcher", "postalCodeTextWatcher", "setShouldShowPostalCode", "updateBrandUi", "updateCvc", "updateDrawable", "iconResourceId", "shouldTint", "validateAllFields", "validateCardNumber", "Companion", "stripe_release"})
public final class CardMultilineWidget
extends LinearLayout
implements CardWidget {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final CardMultilineWidgetBinding viewBinding;
    @NotNull
    private final CardNumberEditText cardNumberEditText;
    @NotNull
    private final ExpiryDateEditText expiryDateEditText;
    @NotNull
    private final CvcEditText cvcEditText;
    @NotNull
    private final PostalCodeEditText postalCodeEditText;
    private final CardNumberTextInputLayout cardNumberTextInputLayout;
    private final TextInputLayout expiryTextInputLayout;
    private final TextInputLayout cvcInputLayout;
    @NotNull
    private final TextInputLayout postalInputLayout;
    private CardInputListener cardInputListener;
    private CardValidCallback cardValidCallback;
    private final cardValidTextWatcher.1 cardValidTextWatcher;
    private boolean isEnabled;
    private boolean hasAdjustedDrawable;
    private String customCvcLabel;
    private CardBrand cardBrand;
    @ColorInt
    private final int tintColorInt;
    private String cardHintText;
    private boolean postalCodeRequired;
    @NotNull
    private final ReadWriteProperty usZipCodeRequired$delegate;
    private final double pixelsToAdjust;
    private final int dynamicBufferInPixels;
    private boolean shouldShowErrorIcon;
    private boolean shouldShowPostalCode;
    private static final String CARD_MULTILINE_TOKEN = "CardMultilineView";
    private static final long CARD_NUMBER_HINT_DELAY = 120L;
    private static final long COMMON_HINT_DELAY = 90L;
    private static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(CardMultilineWidget.class, "usZipCodeRequired", "getUsZipCodeRequired()Z", 0))};
        Companion = new Companion(null);
    }

    @NotNull
    public final CardNumberEditText getCardNumberEditText$stripe_release() {
        return this.cardNumberEditText;
    }

    @NotNull
    public final ExpiryDateEditText getExpiryDateEditText$stripe_release() {
        return this.expiryDateEditText;
    }

    @NotNull
    public final CvcEditText getCvcEditText$stripe_release() {
        return this.cvcEditText;
    }

    @NotNull
    public final PostalCodeEditText getPostalCodeEditText$stripe_release() {
        return this.postalCodeEditText;
    }

    @NotNull
    public final TextInputLayout getPostalInputLayout$stripe_release() {
        return this.postalInputLayout;
    }

    private final Set<CardValidCallback.Fields> getInvalidFields() {
        CardValidCallback.Fields[] fieldsArray;
        CardValidCallback.Fields fields = CardValidCallback.Fields.Number;
        boolean bl = false;
        boolean bl2 = false;
        CardValidCallback.Fields fields2 = fields;
        int n = 0;
        CardValidCallback.Fields[] fieldsArray2 = fieldsArray = new CardValidCallback.Fields[3];
        boolean bl3 = false;
        boolean bl4 = this.getValidatedCardNumber() == null;
        fieldsArray[n] = bl4 ? fields : null;
        fields = CardValidCallback.Fields.Expiry;
        bl = false;
        bl2 = false;
        CardValidCallback.Fields it = fields;
        n = 1;
        fieldsArray = fieldsArray2;
        boolean bl5 = false;
        bl4 = this.getExpiryDate() == null;
        fieldsArray[n] = bl4 ? fields : null;
        fields = CardValidCallback.Fields.Cvc;
        bl = false;
        bl2 = false;
        it = fields;
        n = 2;
        fieldsArray = fieldsArray2;
        boolean bl6 = false;
        bl4 = this.cvcEditText.getCvc$stripe_release() == null;
        fieldsArray[n] = bl4 ? fields : null;
        return CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object[])fieldsArray2));
    }

    public final boolean getPostalCodeRequired() {
        return this.postalCodeRequired;
    }

    public final void setPostalCodeRequired(boolean bl) {
        this.postalCodeRequired = bl;
    }

    public final boolean getUsZipCodeRequired() {
        return (Boolean)this.usZipCodeRequired$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setUsZipCodeRequired(boolean bl) {
        this.usZipCodeRequired$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams.Card getPaymentMethodCard() {
        PaymentMethodCreateParams.Card card;
        CardParams cardParams = this.getCardParams();
        if (cardParams != null) {
            CardParams cardParams2 = cardParams;
            boolean bl = false;
            boolean bl2 = false;
            CardParams it = cardParams2;
            boolean bl3 = false;
            Set<String> set = it.getAttribution$stripe_release();
            String string2 = null;
            Integer n = it.getExpYear$stripe_release();
            Integer n2 = it.getExpMonth$stripe_release();
            String string3 = it.getCvc$stripe_release();
            PaymentMethodCreateParams.Card card2 = new PaymentMethodCreateParams.Card(it.getNumber$stripe_release(), n2, n, string3, string2, set, 16, null);
            card = card2;
        } else {
            card = null;
        }
        return card;
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams paymentMethodCreateParams;
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card != null) {
            PaymentMethodCreateParams.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethodCreateParams.Card it = card2;
            boolean bl3 = false;
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, it, this.getPaymentMethodBillingDetails(), null, 4, null);
        } else {
            paymentMethodCreateParams = null;
        }
        return paymentMethodCreateParams;
    }

    @Nullable
    public final PaymentMethod.BillingDetails getPaymentMethodBillingDetails() {
        PaymentMethod.BillingDetails.Builder builder = this.getPaymentMethodBillingDetailsBuilder();
        return builder != null ? builder.build() : null;
    }

    @Nullable
    public final PaymentMethod.BillingDetails.Builder getPaymentMethodBillingDetailsBuilder() {
        return this.shouldShowPostalCode && this.validateAllFields() ? new PaymentMethod.BillingDetails.Builder().setAddress(new Address.Builder().setPostalCode(this.postalCodeEditText.getPostalCode$stripe_release()).build()) : null;
    }

    @Deprecated(message="Use cardParams", replaceWith=@ReplaceWith(imports={}, expression="cardParams"))
    public static /* synthetic */ void getCard$annotations() {
    }

    @Override
    @Nullable
    public Card getCard() {
        Card.Builder builder = this.getCardBuilder();
        return builder != null ? builder.build() : null;
    }

    @Override
    @Nullable
    public CardParams getCardParams() {
        if (!this.validateAllFields()) {
            this.setShouldShowErrorIcon(true);
            return null;
        }
        this.setShouldShowErrorIcon(false);
        Pair<Integer, Integer> pair = this.expiryDateEditText.getValidDateFields();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (pair == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Pair<Integer, Integer> cardDate = pair;
        Editable editable = this.cvcEditText.getText();
        String cvcValue = editable != null ? editable.toString() : null;
        Editable editable2 = this.postalCodeEditText.getText();
        String string3 = editable2 != null ? editable2.toString() : null;
        bl3 = false;
        boolean bl5 = false;
        String it = string3;
        boolean bl6 = false;
        String postalCode = this.shouldShowPostalCode ? string3 : null;
        Set set = SetsKt.setOf((Object)CARD_MULTILINE_TOKEN);
        CardNumber.Validated validated = this.getValidatedCardNumber();
        string3 = validated != null ? validated.getValue$stripe_release() : null;
        bl3 = false;
        String string4 = string3;
        if (string4 == null) {
            string4 = "";
        }
        string3 = postalCode;
        bl3 = false;
        bl5 = false;
        it = string3;
        Address.Builder builder = new Address.Builder();
        String string5 = null;
        String string6 = cvcValue;
        int n = ((Number)cardDate.getSecond()).intValue();
        int n2 = ((Number)cardDate.getFirst()).intValue();
        String string7 = string4;
        Set set2 = set;
        boolean bl7 = false;
        CharSequence charSequence = it;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 416;
        Map map = null;
        String string8 = null;
        Address address = builder.setPostalCode(!bl10 ? string3 : null).build();
        String string9 = string5;
        String string10 = string6;
        int n4 = n;
        int n5 = n2;
        String string11 = string7;
        Set set3 = set2;
        return new CardParams(set3, string11, n5, n4, string10, string9, address, string8, map, n3, defaultConstructorMarker);
    }

    @Deprecated(message="Use cardParams", replaceWith=@ReplaceWith(imports={}, expression="cardParams"))
    public static /* synthetic */ void getCardBuilder$annotations() {
    }

    @Override
    @Nullable
    public Card.Builder getCardBuilder() {
        if (!this.validateAllFields()) {
            this.setShouldShowErrorIcon(true);
            return null;
        }
        this.setShouldShowErrorIcon(false);
        Pair<Integer, Integer> pair = this.expiryDateEditText.getValidDateFields();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (pair == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Pair<Integer, Integer> cardDate = pair;
        Editable editable = this.cvcEditText.getText();
        String cvcValue = editable != null ? editable.toString() : null;
        Editable editable2 = this.postalCodeEditText.getText();
        String string3 = editable2 != null ? editable2.toString() : null;
        bl3 = false;
        boolean bl5 = false;
        String it = string3;
        boolean bl6 = false;
        String postalCode = this.shouldShowPostalCode ? string3 : null;
        CardNumber.Validated validated = this.getValidatedCardNumber();
        return new Card.Builder(validated != null ? validated.getValue$stripe_release() : null, (Integer)cardDate.getFirst(), (Integer)cardDate.getSecond(), cvcValue).addressZip(postalCode).loggingTokens(SetsKt.setOf((Object)CARD_MULTILINE_TOKEN));
    }

    private final CardNumber.Validated getValidatedCardNumber() {
        return this.cardNumberEditText.getValidatedCardNumber$stripe_release();
    }

    private final Pair<Integer, Integer> getExpiryDate() {
        return this.expiryDateEditText.getValidDateFields();
    }

    private final Collection<StripeEditText> getAllFields() {
        return CollectionsKt.listOf((Object[])new StripeEditText[]{this.cardNumberEditText, this.expiryDateEditText, this.cvcEditText, this.postalCodeEditText});
    }

    @StringRes
    private final int getCvcHelperText() {
        return CardBrand.AmericanExpress == this.cardBrand ? R.string.cvc_multiline_helper_amex : R.string.cvc_multiline_helper;
    }

    @VisibleForTesting
    public static /* synthetic */ void getShouldShowErrorIcon$stripe_release$annotations() {
    }

    public final boolean getShouldShowErrorIcon$stripe_release() {
        return this.shouldShowErrorIcon;
    }

    private final void setShouldShowErrorIcon(boolean value) {
        boolean isValueChange = this.shouldShowErrorIcon != value;
        this.shouldShowErrorIcon = value;
        if (isValueChange) {
            this.updateBrandUi();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.postalCodeEditText.setConfig$stripe_release(PostalCodeEditText.Config.Global);
    }

    @Override
    public void clear() {
        this.cardNumberEditText.setText("");
        this.expiryDateEditText.setText("");
        this.cvcEditText.setText("");
        this.postalCodeEditText.setText("");
        this.cardNumberEditText.setShouldShowError(false);
        this.expiryDateEditText.setShouldShowError(false);
        this.cvcEditText.setShouldShowError(false);
        this.postalCodeEditText.setShouldShowError(false);
        this.cardBrand = CardBrand.Unknown;
        this.updateBrandUi();
    }

    @Override
    public void setCardInputListener(@Nullable CardInputListener listener) {
        this.cardInputListener = listener;
    }

    @Override
    public void setCardValidCallback(@Nullable CardValidCallback callback) {
        block3: {
            StripeEditText it;
            this.cardValidCallback = callback;
            Iterable $this$forEach$iv = this.getAllFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StripeEditText)((Object)element$iv);
                boolean bl = false;
                it.removeTextChangedListener(this.cardValidTextWatcher);
            }
            if (callback != null) {
                $this$forEach$iv = this.getAllFields();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (StripeEditText)((Object)element$iv);
                    boolean bl = false;
                    it.addTextChangedListener(this.cardValidTextWatcher);
                }
            }
            CardValidCallback cardValidCallback = this.cardValidCallback;
            if (cardValidCallback == null) break block3;
            cardValidCallback.onInputChanged(this.getInvalidFields().isEmpty(), this.getInvalidFields());
        }
    }

    @Override
    public void setCardHint(@NotNull String cardHint) {
        Intrinsics.checkNotNullParameter((Object)cardHint, (String)"cardHint");
        this.cardHintText = cardHint;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean validateAllFields() {
        block4: {
            block3: {
                cardNumberIsValid = this.getValidatedCardNumber() != null;
                expiryIsValid = this.getExpiryDate() != null;
                cvcIsValid = this.cvcEditText.getCvc$stripe_release() != null;
                this.cardNumberEditText.setShouldShowError(cardNumberIsValid == false);
                this.expiryDateEditText.setShouldShowError(expiryIsValid == false);
                this.cvcEditText.setShouldShowError(cvcIsValid == false);
                if (!this.postalCodeRequired && !this.getUsZipCodeRequired()) ** GOTO lbl-1000
                var4_4 = this.postalCodeEditText.getPostalCode$stripe_release();
                var5_5 = false;
                var6_6 = false;
                if (var4_4 == null || StringsKt.isBlank((CharSequence)var4_4) != false) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                this.postalCodeEditText.setShouldShowError(v0);
                $this$firstOrNull$iv = this.getAllFields();
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (StripeEditText)element$iv;
                    $i$a$-firstOrNull-CardMultilineWidget$validateAllFields$1 = false;
                    if (!it.getShouldShowError()) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            v2 = v1;
            if (v2 == null) break block4;
            v2.requestFocus();
        }
        return cardNumberIsValid != false && expiryIsValid != false && cvcIsValid != false && this.postalCodeEditText.getShouldShowError() == false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.updateBrandUi();
        }
    }

    public final void setCvcLabel(@Nullable String cvcLabel) {
        this.customCvcLabel = cvcLabel;
        this.updateCvc();
    }

    public final void setShouldShowPostalCode(boolean shouldShowPostalCode) {
        this.shouldShowPostalCode = shouldShowPostalCode;
        this.adjustViewForPostalCodeAttribute(shouldShowPostalCode);
    }

    @Override
    public void setCardNumber(@Nullable String cardNumber) {
        this.cardNumberEditText.setText(cardNumber);
    }

    @Override
    public void setExpiryDate(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        this.expiryDateEditText.setText(DateUtils.createDateStringFromIntegerInput(month, year));
    }

    @Override
    public void setCvcCode(@Nullable String cvcCode) {
        this.cvcEditText.setText(cvcCode);
    }

    public final boolean validateCardNumber() {
        boolean cardNumberIsValid = this.getValidatedCardNumber() != null;
        this.cardNumberEditText.setShouldShowError(!cardNumberIsValid);
        return cardNumberIsValid;
    }

    @Override
    public void setCardNumberTextWatcher(@Nullable TextWatcher cardNumberTextWatcher) {
        this.cardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    @Override
    public void setExpiryDateTextWatcher(@Nullable TextWatcher expiryDateTextWatcher) {
        this.expiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    @Override
    public void setCvcNumberTextWatcher(@Nullable TextWatcher cvcNumberTextWatcher) {
        this.cvcEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    @Override
    public void setPostalCodeTextWatcher(@Nullable TextWatcher postalCodeTextWatcher) {
        this.postalCodeEditText.addTextChangedListener(postalCodeTextWatcher);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.expiryTextInputLayout.setEnabled(enabled);
        this.cardNumberTextInputLayout.setEnabled(enabled);
        this.cvcInputLayout.setEnabled(enabled);
        this.postalInputLayout.setEnabled(enabled);
        this.isEnabled = enabled;
    }

    private final void adjustViewForPostalCodeAttribute(boolean shouldShowPostalCode) {
        int expiryLabel = shouldShowPostalCode ? R.string.expiry_label_short : R.string.acc_label_expiry_date;
        this.expiryTextInputLayout.setHint((CharSequence)this.getResources().getString(expiryLabel));
        int focusForward = shouldShowPostalCode ? R.id.et_postal_code : -1;
        this.cvcEditText.setNextFocusForwardId(focusForward);
        this.cvcEditText.setNextFocusDownId(focusForward);
        int postalCodeVisibility = shouldShowPostalCode ? 0 : 8;
        this.postalInputLayout.setVisibility(postalCodeVisibility);
        this.cvcEditText.setImeOptions(postalCodeVisibility == 8 ? 6 : 5);
        int marginPixels = shouldShowPostalCode ? this.getResources().getDimensionPixelSize(R.dimen.stripe_add_card_expiry_middle_margin) : 0;
        ViewGroup.LayoutParams layoutParams = this.cvcInputLayout.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        }
        LinearLayout.LayoutParams linearParams = (LinearLayout.LayoutParams)layoutParams;
        linearParams.setMargins(0, 0, marginPixels, 0);
        linearParams.setMarginEnd(marginPixels);
        this.cvcInputLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAttributeSet(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardElement, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026,\n            0\n        )");
        TypedArray a = typedArray;
        try {
            this.shouldShowPostalCode = a.getBoolean(R.styleable.CardElement_shouldShowPostalCode, true);
            this.postalCodeRequired = a.getBoolean(R.styleable.CardElement_shouldRequirePostalCode, false);
            this.setUsZipCodeRequired(a.getBoolean(R.styleable.CardElement_shouldRequireUsZipCode, false));
        }
        finally {
            a.recycle();
        }
    }

    private final void flipToCvcIconIfNotFinished() {
        if (this.cardBrand.isMaxCvc(this.cvcEditText.getFieldText$stripe_release())) {
            return;
        }
        if (this.shouldShowErrorIcon) {
            this.updateDrawable(this.cardBrand.getErrorIcon(), false);
        } else {
            this.updateDrawable(this.cardBrand.getCvcIcon(), true);
        }
    }

    private final void initDeleteEmptyListeners() {
        this.expiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cardNumberEditText));
        this.cvcEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.expiryDateEditText));
        this.postalCodeEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cvcEditText));
    }

    private final void initFocusChangeListeners() {
        this.cardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardNumberEditText cardNumberEditText = this.this$0.getCardNumberEditText$stripe_release();
                    CharSequence charSequence = CardMultilineWidget.access$getCardHintText$p(this.this$0);
                    CardMultilineWidget.access$Companion();
                    cardNumberEditText.setHintDelayed(charSequence, 120L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange(CardInputListener.FocusField.CardNumber);
                    }
                } else {
                    this.this$0.getCardNumberEditText$stripe_release().setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.expiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    ExpiryDateEditText expiryDateEditText = this.this$0.getExpiryDateEditText$stripe_release();
                    CardMultilineWidget.access$Companion();
                    expiryDateEditText.setHintDelayed(R.string.expiry_date_hint, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange(CardInputListener.FocusField.ExpiryDate);
                    }
                } else {
                    this.this$0.getExpiryDateEditText$stripe_release().setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.cvcEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$flipToCvcIconIfNotFinished(this.this$0);
                    CvcEditText cvcEditText = this.this$0.getCvcEditText$stripe_release();
                    int n = CardMultilineWidget.access$getCvcHelperText$p(this.this$0);
                    CardMultilineWidget.access$Companion();
                    cvcEditText.setHintDelayed(n, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange(CardInputListener.FocusField.Cvc);
                    }
                } else {
                    CardMultilineWidget.access$updateBrandUi(this.this$0);
                    this.this$0.getCvcEditText$stripe_release().setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.postalCodeEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (!CardMultilineWidget.access$getShouldShowPostalCode$p(this.this$0)) {
                    return;
                }
                if (hasFocus) {
                    PostalCodeEditText postalCodeEditText = this.this$0.getPostalCodeEditText$stripe_release();
                    CardMultilineWidget.access$Companion();
                    postalCodeEditText.setHintDelayed(R.string.zip_helper, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange(CardInputListener.FocusField.PostalCode);
                    }
                } else {
                    this.this$0.getPostalCodeEditText$stripe_release().setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
    }

    private final void initTextInputLayoutErrorHandlers(TextInputLayout cardInputLayout, TextInputLayout expiryInputLayout, TextInputLayout cvcTextInputLayout, TextInputLayout postalInputLayout) {
        this.cardNumberEditText.setErrorMessageListener(new ErrorListener(cardInputLayout));
        this.expiryDateEditText.setErrorMessageListener(new ErrorListener(expiryInputLayout));
        this.cvcEditText.setErrorMessageListener(new ErrorListener(cvcTextInputLayout));
        this.postalCodeEditText.setErrorMessageListener(new ErrorListener(postalInputLayout));
    }

    private final void updateBrandUi() {
        this.updateCvc();
        if (this.shouldShowErrorIcon) {
            this.updateDrawable(this.cardBrand.getErrorIcon(), false);
        } else {
            this.updateDrawable(this.cardBrand.getIcon(), CardBrand.Unknown == this.cardBrand);
        }
    }

    private final void updateCvc() {
        this.cvcEditText.updateBrand$stripe_release(this.cardBrand, this.customCvcLabel, this.cvcInputLayout);
    }

    private final void updateDrawable(@DrawableRes int iconResourceId, boolean shouldTint) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)iconResourceId);
        if (drawable2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026iconResourceId) ?: return");
        Drawable icon = drawable2;
        Drawable drawable3 = this.cardNumberEditText.getCompoundDrawablesRelative()[0];
        if (drawable3 == null) {
            return;
        }
        Drawable original = drawable3;
        int iconPadding = this.cardNumberEditText.getCompoundDrawablePadding();
        icon.setBounds(this.createDrawableBounds(original));
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        if (shouldTint) {
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.tintColorInt);
        }
        this.cardNumberEditText.setCompoundDrawablePadding(iconPadding);
        this.cardNumberEditText.setCompoundDrawablesRelative(compatIcon, null, null, null);
    }

    private final Rect createDrawableBounds(Drawable drawable2) {
        Rect newBounds = new Rect();
        drawable2.copyBounds(newBounds);
        if (!this.hasAdjustedDrawable) {
            newBounds.top -= this.dynamicBufferInPixels;
            newBounds.bottom -= this.dynamicBufferInPixels;
            this.hasAdjustedDrawable = true;
        }
        return newBounds;
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, boolean shouldShowPostalCode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.shouldShowPostalCode = shouldShowPostalCode;
        CardMultilineWidgetBinding cardMultilineWidgetBinding = CardMultilineWidgetBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)cardMultilineWidgetBinding, (String)"CardMultilineWidgetBindi\u2026text),\n        this\n    )");
        this.viewBinding = cardMultilineWidgetBinding;
        CardNumberEditText cardNumberEditText = this.viewBinding.etCardNumber;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cardNumberEditText), (String)"viewBinding.etCardNumber");
        this.cardNumberEditText = cardNumberEditText;
        ExpiryDateEditText expiryDateEditText = this.viewBinding.etExpiry;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)expiryDateEditText), (String)"viewBinding.etExpiry");
        this.expiryDateEditText = expiryDateEditText;
        CvcEditText cvcEditText = this.viewBinding.etCvc;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cvcEditText), (String)"viewBinding.etCvc");
        this.cvcEditText = cvcEditText;
        PostalCodeEditText postalCodeEditText = this.viewBinding.etPostalCode;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)postalCodeEditText), (String)"viewBinding.etPostalCode");
        this.postalCodeEditText = postalCodeEditText;
        CardNumberTextInputLayout cardNumberTextInputLayout = this.viewBinding.tlCardNumber;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)cardNumberTextInputLayout), (String)"viewBinding.tlCardNumber");
        this.cardNumberTextInputLayout = cardNumberTextInputLayout;
        TextInputLayout textInputLayout = this.viewBinding.tlExpiry;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout, (String)"viewBinding.tlExpiry");
        this.expiryTextInputLayout = textInputLayout;
        TextInputLayout textInputLayout2 = this.viewBinding.tlCvc;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout2, (String)"viewBinding.tlCvc");
        this.cvcInputLayout = textInputLayout2;
        TextInputLayout textInputLayout3 = this.viewBinding.tlPostalCode;
        Intrinsics.checkNotNullExpressionValue((Object)textInputLayout3, (String)"viewBinding.tlPostalCode");
        this.postalInputLayout = textInputLayout3;
        this.cardValidTextWatcher = new StripeTextWatcher(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public void afterTextChanged(@Nullable Editable s) {
                block0: {
                    super.afterTextChanged(s);
                    CardValidCallback cardValidCallback = CardMultilineWidget.access$getCardValidCallback$p(this.this$0);
                    if (cardValidCallback == null) break block0;
                    cardValidCallback.onInputChanged(CardMultilineWidget.access$getInvalidFields$p(this.this$0).isEmpty(), CardMultilineWidget.access$getInvalidFields$p(this.this$0));
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.cardBrand = CardBrand.Unknown;
        String string2 = this.getResources().getString(R.string.card_number_hint);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.string.card_number_hint)");
        this.cardHintText = string2;
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv2 = false;
        boolean $i$f$observable = false;
        this.usZipCodeRequired$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv2, (Object)initialValue$iv2, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ CardMultilineWidget this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = cardMultilineWidget;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void zipCodeRequired;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                if (zipCodeRequired != false) {
                    this.this$0.getPostalCodeEditText$stripe_release().setConfig$stripe_release(PostalCodeEditText.Config.US);
                } else {
                    this.this$0.getPostalCodeEditText$stripe_release().setConfig$stripe_release(PostalCodeEditText.Config.Global);
                }
            }
        };
        this.pixelsToAdjust = this.getResources().getDimension(R.dimen.stripe_card_icon_multiline_padding_bottom);
        this.dynamicBufferInPixels = new BigDecimal(this.pixelsToAdjust).setScale(0, RoundingMode.HALF_DOWN).intValue();
        this.setOrientation(1);
        ColorStateList colorStateList = this.cardNumberEditText.getHintTextColors();
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"cardNumberEditText.hintTextColors");
        this.tintColorInt = colorStateList.getDefaultColor();
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet this_$iv = attributeSet;
            boolean initialValue$iv2 = false;
            boolean bl = false;
            AttributeSet it = this_$iv;
            boolean bl2 = false;
            this.checkAttributeSet(it);
        }
        this.initTextInputLayoutErrorHandlers(this.cardNumberTextInputLayout, this.expiryTextInputLayout, this.cvcInputLayout, this.postalInputLayout);
        this.initFocusChangeListeners();
        this.initDeleteEmptyListeners();
        this.cardNumberEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    this.getExpiryDateEditText$stripe_release().requestFocus();
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener == null) break block0;
                    cardInputListener.onCardComplete();
                }
            }
        }));
        this.cardNumberEditText.setBrandChangeCallback$stripe_release((Function1<? super CardBrand, Unit>)((Function1)new Function1<CardBrand, Unit>(){

            public final void invoke(@NotNull CardBrand brand) {
                Intrinsics.checkNotNullParameter((Object)((Object)brand), (String)"brand");
                cardBrand = brand;
                this.updateBrandUi();
            }
        }));
        this.expiryDateEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    this.getCvcEditText$stripe_release().requestFocus();
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener == null) break block0;
                    cardInputListener.onExpirationComplete();
                }
            }
        }));
        this.cvcEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public final void onTextChanged(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                if (cardBrand.isMaxCvc(text)) {
                    this.updateBrandUi();
                    if (shouldShowPostalCode) {
                        this.getPostalCodeEditText$stripe_release().requestFocus();
                    }
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener != null) {
                        cardInputListener.onCvcComplete();
                    }
                } else {
                    this.flipToCvcIconIfNotFinished();
                }
                this.getCvcEditText$stripe_release().setShouldShowError(false);
            }
        });
        this.adjustViewForPostalCodeAttribute(this.shouldShowPostalCode);
        CardNumberEditText.updateLengthFilter$stripe_release$default(this.cardNumberEditText, 0, 1, null);
        this.cardBrand = CardBrand.Unknown;
        this.updateBrandUi();
        Iterable $this$forEach$iv = this.getAllFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StripeEditText field = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            TextView $this$doAfterTextChanged$iv = (TextView)field;
            boolean $i$f$doAfterTextChanged = false;
            TextView $this$addTextChangedListener$iv$iv = $this$doAfterTextChanged$iv;
            boolean $i$f$addTextChangedListener = false;
            TextWatcher textWatcher$iv$iv = new TextWatcher(this){
                final /* synthetic */ CardMultilineWidget this$0;
                {
                    this.this$0 = cardMultilineWidget;
                }

                public void afterTextChanged(@Nullable Editable s) {
                    Editable it = s;
                    boolean bl = false;
                    CardMultilineWidget.access$setShouldShowErrorIcon$p(this.this$0, false);
                }

                public void beforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
                    int n = after;
                    int n2 = count;
                    int n3 = start;
                    CharSequence $noName_0 = text;
                }

                public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
                    int n = count;
                    int n2 = before;
                    int n3 = start;
                    CharSequence $noName_0 = text;
                }
            };
            $this$addTextChangedListener$iv$iv.addTextChangedListener(textWatcher$iv$iv);
        }
        this.cardNumberEditText.setLoadingCallback$stripe_release((Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                cardNumberTextInputLayout.setLoading$stripe_release(it);
            }
        }));
        this.isEnabled = true;
    }

    public /* synthetic */ CardMultilineWidget(Context context, AttributeSet attributeSet, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(context, attributeSet, n, bl);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, false, 8, null);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, false, 12, null);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context) {
        this(context, null, 0, false, 14, null);
    }

    public static final /* synthetic */ String access$getCardHintText$p(CardMultilineWidget $this) {
        return $this.cardHintText;
    }

    public static final /* synthetic */ void access$setCardHintText$p(CardMultilineWidget $this, String string2) {
        $this.cardHintText = string2;
    }

    public static final /* synthetic */ void access$setCardInputListener$p(CardMultilineWidget $this, CardInputListener cardInputListener) {
        $this.cardInputListener = cardInputListener;
    }

    public static final /* synthetic */ int access$getCvcHelperText$p(CardMultilineWidget $this) {
        return $this.getCvcHelperText();
    }

    public static final /* synthetic */ void access$setShouldShowPostalCode$p(CardMultilineWidget $this, boolean bl) {
        $this.shouldShowPostalCode = bl;
    }

    public static final /* synthetic */ CardValidCallback access$getCardValidCallback$p(CardMultilineWidget $this) {
        return $this.cardValidCallback;
    }

    public static final /* synthetic */ void access$setCardValidCallback$p(CardMultilineWidget $this, CardValidCallback cardValidCallback) {
        $this.cardValidCallback = cardValidCallback;
    }

    public static final /* synthetic */ Set access$getInvalidFields$p(CardMultilineWidget $this) {
        return $this.getInvalidFields();
    }

    public static final /* synthetic */ boolean access$getShouldShowErrorIcon$p(CardMultilineWidget $this) {
        return $this.shouldShowErrorIcon;
    }

    public static final /* synthetic */ void access$setShouldShowErrorIcon$p(CardMultilineWidget $this, boolean bl) {
        $this.setShouldShowErrorIcon(bl);
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/CardMultilineWidget$Companion;", "", "()V", "CARD_MULTILINE_TOKEN", "", "CARD_NUMBER_HINT_DELAY", "", "COMMON_HINT_DELAY", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

