/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.text.ParcelableSpan;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.ThemeConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/view/CardDisplayTextFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "resources", "Landroid/content/res/Resources;", "themeConfig", "Lcom/stripe/android/view/ThemeConfig;", "(Landroid/content/res/Resources;Lcom/stripe/android/view/ThemeConfig;)V", "createStyled", "Landroid/text/SpannableString;", "brand", "Lcom/stripe/android/model/CardBrand;", "last4", "", "isSelected", "", "createStyled$stripe_release", "createUnstyled", "card", "Lcom/stripe/android/model/PaymentMethod$Card;", "createUnstyled$stripe_release", "setSpan", "", "displayString", "span", "Landroid/text/ParcelableSpan;", "start", "", "end", "stripe_release"})
public final class CardDisplayTextFactory {
    private final Resources resources;
    private final ThemeConfig themeConfig;

    @NotNull
    public final /* synthetic */ SpannableString createStyled$stripe_release(@NotNull CardBrand brand, @Nullable String last4, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)((Object)brand), (String)"brand");
        String brandText = brand.getDisplayName();
        int brandLength = brandText.length();
        if (last4 == null) {
            SpannableString displayString = new SpannableString((CharSequence)brandText);
            this.setSpan(displayString, (ParcelableSpan)new TypefaceSpan("sans-serif-medium"), 0, brandLength);
            return displayString;
        }
        String string2 = this.resources.getString(R.string.card_ending_in, new Object[]{brandText, last4});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(R.st\u2026ing_in, brandText, last4)");
        String cardEndingIn = string2;
        int totalLength = cardEndingIn.length();
        int last4length = last4.length();
        int last4Start = totalLength - last4length;
        int textColor = this.themeConfig.getTextColor$stripe_release(isSelected);
        int lightTextColor = this.themeConfig.getTextAlphaColor$stripe_release(isSelected);
        SpannableString displayString = new SpannableString((CharSequence)cardEndingIn);
        this.setSpan(displayString, (ParcelableSpan)new TypefaceSpan("sans-serif-medium"), 0, brandLength);
        this.setSpan(displayString, (ParcelableSpan)new ForegroundColorSpan(textColor), 0, brandLength);
        this.setSpan(displayString, (ParcelableSpan)new ForegroundColorSpan(lightTextColor), brandLength, last4Start);
        this.setSpan(displayString, (ParcelableSpan)new TypefaceSpan("sans-serif-medium"), last4Start, totalLength);
        this.setSpan(displayString, (ParcelableSpan)new ForegroundColorSpan(textColor), last4Start, totalLength);
        return displayString;
    }

    @NotNull
    public final /* synthetic */ String createUnstyled$stripe_release(@NotNull PaymentMethod.Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        String string2 = this.resources.getString(R.string.card_ending_in, new Object[]{card.brand.getDisplayName(), card.last4});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(\n   \u2026     card.last4\n        )");
        return string2;
    }

    private final void setSpan(SpannableString displayString, ParcelableSpan span, int start, int end) {
        displayString.setSpan((Object)span, start, end, 33);
    }

    public CardDisplayTextFactory(@NotNull Resources resources, @NotNull ThemeConfig themeConfig) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)themeConfig, (String)"themeConfig");
        this.resources = resources;
        this.themeConfig = themeConfig;
    }

    public CardDisplayTextFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        this(resources, new ThemeConfig(context));
    }
}

