/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.StripeConnection;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/ConnectionFactory;", "", "create", "Lcom/stripe/android/StripeConnection;", "request", "Lcom/stripe/android/StripeRequest;", "Default", "stripe_release"})
public interface ConnectionFactory {
    @NotNull
    public StripeConnection create(@NotNull StripeRequest var1) throws IOException, InvalidRequestException;

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/stripe/android/ConnectionFactory$Default;", "Lcom/stripe/android/ConnectionFactory;", "()V", "create", "Lcom/stripe/android/StripeConnection;", "request", "Lcom/stripe/android/StripeRequest;", "openConnection", "Ljavax/net/ssl/HttpsURLConnection;", "requestUrl", "", "Companion", "stripe_release"})
    public static final class Default
    implements ConnectionFactory {
        private static final int CONNECT_TIMEOUT;
        private static final int READ_TIMEOUT;
        private static final String HEADER_CONTENT_TYPE = "Content-Type";
        private static final Companion Companion;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public /* synthetic */ StripeConnection create(@NotNull StripeRequest request) throws IOException, InvalidRequestException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            HttpsURLConnection httpsURLConnection = this.openConnection(request.getUrl$stripe_release());
            boolean bl = false;
            boolean bl2 = false;
            HttpsURLConnection $this$apply = httpsURLConnection;
            boolean bl3 = false;
            $this$apply.setConnectTimeout(CONNECT_TIMEOUT);
            $this$apply.setReadTimeout(READ_TIMEOUT);
            $this$apply.setUseCaches(false);
            $this$apply.setRequestMethod(request.getMethod().getCode());
            Map<String, String> $this$forEach$iv = request.getHeaders$stripe_release();
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void key;
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl6 = false;
                String string2 = entry.getKey();
                entry = $dstr$key$value;
                bl6 = false;
                String value = entry.getValue();
                $this$apply.setRequestProperty((String)key, value);
            }
            if (StripeRequest.Method.POST == request.getMethod()) {
                $this$apply.setDoOutput(true);
                $this$apply.setRequestProperty(HEADER_CONTENT_TYPE, request.getContentType$stripe_release());
                Closeable closeable = $this$apply.getOutputStream();
                boolean bl7 = false;
                boolean bl8 = false;
                Throwable throwable = null;
                try {
                    OutputStream output = (OutputStream)closeable;
                    boolean bl9 = false;
                    OutputStream outputStream = output;
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"output");
                    request.writeBody$stripe_release(outputStream);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            HttpsURLConnection conn = httpsURLConnection;
            return new StripeConnection.Default(conn);
        }

        private final HttpsURLConnection openConnection(String requestUrl) {
            URLConnection uRLConnection = new URL(requestUrl).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            }
            return (HttpsURLConnection)uRLConnection;
        }

        static {
            Companion = new Companion(null);
            CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
            READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(80L);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/ConnectionFactory$Default$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "HEADER_CONTENT_TYPE", "", "READ_TIMEOUT", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

