/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.ApiRequest;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.FileUploadRequest;
import com.stripe.android.Logger;
import com.stripe.android.StripeConnection;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u0007J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0006H&\u00a8\u0006\b"}, d2={"Lcom/stripe/android/ApiRequestExecutor;", "", "execute", "Lcom/stripe/android/StripeResponse;", "request", "Lcom/stripe/android/ApiRequest;", "Lcom/stripe/android/FileUploadRequest;", "Default", "stripe_release"})
public interface ApiRequestExecutor {
    @NotNull
    public StripeResponse execute(@NotNull ApiRequest var1) throws APIConnectionException, InvalidRequestException, UnknownHostException;

    @NotNull
    public StripeResponse execute(@NotNull FileUploadRequest var1) throws APIConnectionException, InvalidRequestException, UnknownHostException;

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/ApiRequestExecutor$Default;", "Lcom/stripe/android/ApiRequestExecutor;", "logger", "Lcom/stripe/android/Logger;", "(Lcom/stripe/android/Logger;)V", "connectionFactory", "Lcom/stripe/android/ConnectionFactory$Default;", "execute", "Lcom/stripe/android/StripeResponse;", "request", "Lcom/stripe/android/ApiRequest;", "Lcom/stripe/android/FileUploadRequest;", "executeInternal", "Lcom/stripe/android/StripeRequest;", "stripe_release"})
    public static final class Default
    implements ApiRequestExecutor {
        private final ConnectionFactory.Default connectionFactory;
        private final Logger logger;

        @Override
        @NotNull
        public StripeResponse execute(@NotNull ApiRequest request) throws APIConnectionException, InvalidRequestException, UnknownHostException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return this.executeInternal(request);
        }

        @Override
        @NotNull
        public StripeResponse execute(@NotNull FileUploadRequest request) throws APIConnectionException, InvalidRequestException, UnknownHostException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            return this.executeInternal(request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final StripeResponse executeInternal(StripeRequest request) {
            this.logger.info(request.toString());
            Closeable closeable = this.connectionFactory.create(request);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                StripeConnection it = (StripeConnection)closeable;
                boolean bl3 = false;
                try {
                    StripeResponse stripeResponse = it.getResponse();
                    this.logger.info(stripeResponse.toString());
                    StripeResponse stripeResponse2 = stripeResponse;
                    return stripeResponse2;
                }
                catch (IOException e) {
                    try {
                        this.logger.error("Exception while making Stripe API request", e);
                        throw (Throwable)APIConnectionException.Companion.create$stripe_release(e, request.getBaseUrl());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public Default(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            this.connectionFactory = new ConnectionFactory.Default();
        }

        public /* synthetic */ Default(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                logger = Logger.Companion.noop$stripe_release();
            }
            this(logger);
        }

        public Default() {
            this(null, 1, null);
        }
    }
}

