/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.Address;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.parsers.AddressJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser$WhenMappings;
import com.stripe.android.model.parsers.WalletJsonParser;
import com.stripe.android.model.wallets.Wallet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\t\u0007\b\t\n\u000b\f\r\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod;", "()V", "parse", "json", "Lorg/json/JSONObject;", "AuBecsDebitJsonParser", "BacsDebitJsonParser", "BillingDetails", "CardJsonParser", "Companion", "FpxJsonParser", "IdealJsonParser", "SepaDebitJsonParser", "SofortJsonParser", "stripe_release"})
public final class PaymentMethodJsonParser
implements ModelJsonParser<PaymentMethod> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_TYPE = "type";
    private static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public PaymentMethod parse(@NotNull JSONObject json) {
        PaymentMethod.BillingDetails billingDetails;
        StripeModel stripeModel;
        JSONObject it;
        PaymentMethod.Builder builder;
        boolean bl;
        boolean bl2;
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        PaymentMethod.Type type = PaymentMethod.Type.Companion.fromCode$stripe_release(StripeJsonUtils.optString(json, FIELD_TYPE));
        PaymentMethod.Builder builder2 = new PaymentMethod.Builder().setId(StripeJsonUtils.optString(json, FIELD_ID)).setType(type).setCreated(StripeJsonUtils.INSTANCE.optLong$stripe_release(json, FIELD_CREATED));
        JSONObject jSONObject2 = json.optJSONObject(FIELD_BILLING_DETAILS);
        if (jSONObject2 != null) {
            jSONObject = jSONObject2;
            bl2 = false;
            bl = false;
            JSONObject jSONObject3 = jSONObject;
            builder = builder2;
            boolean bl3 = false;
            stripeModel = new BillingDetails().parse(it);
            builder2 = builder;
            billingDetails = stripeModel;
        } else {
            billingDetails = null;
        }
        PaymentMethod.Builder builder3 = builder2.setBillingDetails(billingDetails).setCustomerId(StripeJsonUtils.optString(json, FIELD_CUSTOMER)).setLiveMode(json.optBoolean(FIELD_LIVEMODE));
        PaymentMethod.Type type2 = type;
        if (type2 != null) {
            switch (PaymentMethodJsonParser$WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1: {
                    StripeModel stripeModel2;
                    PaymentMethod.Builder builder4 = builder3;
                    JSONObject jSONObject4 = json.optJSONObject(type.code);
                    if (jSONObject4 != null) {
                        jSONObject = jSONObject4;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder4;
                        boolean bl4 = false;
                        stripeModel = new CardJsonParser().parse(it);
                        builder4 = builder;
                        stripeModel2 = stripeModel;
                    } else {
                        stripeModel2 = null;
                    }
                    builder4.setCard((PaymentMethod.Card)stripeModel2);
                    break;
                }
                case 2: {
                    builder3.setCardPresent(PaymentMethod.CardPresent.Companion.getEMPTY$stripe_release());
                    break;
                }
                case 3: {
                    StripeModel stripeModel3;
                    PaymentMethod.Builder builder5 = builder3;
                    JSONObject jSONObject5 = json.optJSONObject(type.code);
                    if (jSONObject5 != null) {
                        jSONObject = jSONObject5;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder5;
                        boolean bl5 = false;
                        stripeModel = new IdealJsonParser().parse(it);
                        builder5 = builder;
                        stripeModel3 = stripeModel;
                    } else {
                        stripeModel3 = null;
                    }
                    builder5.setIdeal((PaymentMethod.Ideal)stripeModel3);
                    break;
                }
                case 4: {
                    StripeModel stripeModel4;
                    PaymentMethod.Builder builder6 = builder3;
                    JSONObject jSONObject6 = json.optJSONObject(type.code);
                    if (jSONObject6 != null) {
                        jSONObject = jSONObject6;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder6;
                        boolean bl6 = false;
                        stripeModel = new FpxJsonParser().parse(it);
                        builder6 = builder;
                        stripeModel4 = stripeModel;
                    } else {
                        stripeModel4 = null;
                    }
                    builder6.setFpx((PaymentMethod.Fpx)stripeModel4);
                    break;
                }
                case 5: {
                    StripeModel stripeModel5;
                    PaymentMethod.Builder builder7 = builder3;
                    JSONObject jSONObject7 = json.optJSONObject(type.code);
                    if (jSONObject7 != null) {
                        jSONObject = jSONObject7;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder7;
                        boolean bl7 = false;
                        stripeModel = new SepaDebitJsonParser().parse(it);
                        builder7 = builder;
                        stripeModel5 = stripeModel;
                    } else {
                        stripeModel5 = null;
                    }
                    builder7.setSepaDebit((PaymentMethod.SepaDebit)stripeModel5);
                    break;
                }
                case 6: {
                    StripeModel stripeModel6;
                    PaymentMethod.Builder builder8 = builder3;
                    JSONObject jSONObject8 = json.optJSONObject(type.code);
                    if (jSONObject8 != null) {
                        jSONObject = jSONObject8;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder8;
                        boolean bl8 = false;
                        stripeModel = new AuBecsDebitJsonParser().parse(it);
                        builder8 = builder;
                        stripeModel6 = stripeModel;
                    } else {
                        stripeModel6 = null;
                    }
                    builder8.setAuBecsDebit((PaymentMethod.AuBecsDebit)stripeModel6);
                    break;
                }
                case 7: {
                    StripeModel stripeModel7;
                    PaymentMethod.Builder builder9 = builder3;
                    JSONObject jSONObject9 = json.optJSONObject(type.code);
                    if (jSONObject9 != null) {
                        jSONObject = jSONObject9;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder9;
                        boolean bl9 = false;
                        stripeModel = new BacsDebitJsonParser().parse(it);
                        builder9 = builder;
                        stripeModel7 = stripeModel;
                    } else {
                        stripeModel7 = null;
                    }
                    builder9.setBacsDebit((PaymentMethod.BacsDebit)stripeModel7);
                    break;
                }
                case 8: {
                    StripeModel stripeModel8;
                    PaymentMethod.Builder builder10 = builder3;
                    JSONObject jSONObject10 = json.optJSONObject(type.code);
                    if (jSONObject10 != null) {
                        jSONObject = jSONObject10;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        builder = builder10;
                        boolean bl10 = false;
                        stripeModel = new SofortJsonParser().parse(it);
                        builder10 = builder;
                        stripeModel8 = stripeModel;
                    } else {
                        stripeModel8 = null;
                    }
                    builder10.setSofort((PaymentMethod.Sofort)stripeModel8);
                    break;
                }
            }
        }
        return builder3.build();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BillingDetails;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class BillingDetails
    implements ModelJsonParser<PaymentMethod.BillingDetails> {
        private static final String FIELD_ADDRESS = "address";
        private static final String FIELD_EMAIL = "email";
        private static final String FIELD_NAME = "name";
        private static final String FIELD_PHONE = "phone";
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentMethod.BillingDetails parse(@NotNull JSONObject json) {
            Address address;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            JSONObject jSONObject = json.optJSONObject(FIELD_ADDRESS);
            if (jSONObject != null) {
                Address address2;
                JSONObject jSONObject2 = jSONObject;
                boolean bl = false;
                boolean bl2 = false;
                JSONObject it = jSONObject2;
                boolean bl3 = false;
                address = address2 = new AddressJsonParser().parse(it);
            } else {
                address = null;
            }
            String string2 = StripeJsonUtils.optString(json, FIELD_PHONE);
            String string3 = StripeJsonUtils.optString(json, FIELD_NAME);
            String string4 = StripeJsonUtils.optString(json, FIELD_EMAIL);
            Address address3 = address;
            return new PaymentMethod.BillingDetails(address3, string4, string3, string2);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BillingDetails$Companion;", "", "()V", "FIELD_ADDRESS", "", "FIELD_EMAIL", "FIELD_NAME", "FIELD_PHONE", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0007\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card;", "()V", "parse", "json", "Lorg/json/JSONObject;", "ChecksJsonParser", "Companion", "NetworksJsonParser", "ThreeDSecureUsageJsonParser", "stripe_release"})
    public static final class CardJsonParser
    implements ModelJsonParser<PaymentMethod.Card> {
        private static final String FIELD_BRAND = "brand";
        private static final String FIELD_CHECKS = "checks";
        private static final String FIELD_COUNTRY = "country";
        private static final String FIELD_EXP_MONTH = "exp_month";
        private static final String FIELD_EXP_YEAR = "exp_year";
        private static final String FIELD_FUNDING = "funding";
        private static final String FIELD_LAST4 = "last4";
        private static final String FIELD_THREE_D_SECURE_USAGE = "three_d_secure_usage";
        private static final String FIELD_WALLET = "wallet";
        private static final String FIELD_NETWORKS = "networks";
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentMethod.Card parse(@NotNull JSONObject json) {
            PaymentMethod.Card.Networks networks;
            Wallet wallet;
            Wallet wallet2;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage2;
            String string2;
            Integer n;
            Integer n2;
            String string3;
            String string4;
            PaymentMethod.Card.Checks checks;
            PaymentMethod.Card.Checks checks2;
            JSONObject it;
            CardBrand cardBrand;
            boolean bl;
            boolean bl2;
            JSONObject jSONObject;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            CardBrand cardBrand2 = CardBrand.Companion.fromCode(StripeJsonUtils.optString(json, FIELD_BRAND));
            JSONObject jSONObject2 = json.optJSONObject(FIELD_CHECKS);
            if (jSONObject2 != null) {
                jSONObject = jSONObject2;
                bl2 = false;
                bl = false;
                JSONObject jSONObject3 = jSONObject;
                cardBrand = cardBrand2;
                boolean bl3 = false;
                checks2 = new ChecksJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks = checks2;
            } else {
                checks = null;
            }
            String string5 = StripeJsonUtils.optString(json, FIELD_COUNTRY);
            Integer n3 = StripeJsonUtils.INSTANCE.optInteger$stripe_release(json, FIELD_EXP_MONTH);
            Integer n4 = StripeJsonUtils.INSTANCE.optInteger$stripe_release(json, FIELD_EXP_YEAR);
            String string6 = StripeJsonUtils.optString(json, FIELD_FUNDING);
            String string7 = StripeJsonUtils.optString(json, FIELD_LAST4);
            JSONObject jSONObject4 = json.optJSONObject(FIELD_THREE_D_SECURE_USAGE);
            if (jSONObject4 != null) {
                jSONObject = jSONObject4;
                bl2 = false;
                bl = false;
                it = jSONObject;
                string4 = string7;
                string3 = string6;
                n2 = n4;
                n = n3;
                string2 = string5;
                checks2 = checks;
                cardBrand = cardBrand2;
                boolean bl4 = false;
                threeDSecureUsage2 = new ThreeDSecureUsageJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks = checks2;
                string5 = string2;
                n3 = n;
                n4 = n2;
                string6 = string3;
                string7 = string4;
                threeDSecureUsage = threeDSecureUsage2;
            } else {
                threeDSecureUsage = null;
            }
            JSONObject jSONObject5 = json.optJSONObject(FIELD_WALLET);
            if (jSONObject5 != null) {
                jSONObject = jSONObject5;
                bl2 = false;
                bl = false;
                it = jSONObject;
                threeDSecureUsage2 = threeDSecureUsage;
                string4 = string7;
                string3 = string6;
                n2 = n4;
                n = n3;
                string2 = string5;
                checks2 = checks;
                cardBrand = cardBrand2;
                boolean bl5 = false;
                wallet2 = new WalletJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks = checks2;
                string5 = string2;
                n3 = n;
                n4 = n2;
                string6 = string3;
                string7 = string4;
                threeDSecureUsage = threeDSecureUsage2;
                wallet = wallet2;
            } else {
                wallet = null;
            }
            JSONObject jSONObject6 = json.optJSONObject(FIELD_NETWORKS);
            if (jSONObject6 != null) {
                jSONObject = jSONObject6;
                bl2 = false;
                bl = false;
                it = jSONObject;
                wallet2 = wallet;
                threeDSecureUsage2 = threeDSecureUsage;
                string4 = string7;
                string3 = string6;
                n2 = n4;
                n = n3;
                string2 = string5;
                checks2 = checks;
                cardBrand = cardBrand2;
                boolean bl6 = false;
                PaymentMethod.Card.Networks networks2 = new NetworksJsonParser().parse(it);
                cardBrand2 = cardBrand;
                checks = checks2;
                string5 = string2;
                n3 = n;
                n4 = n2;
                string6 = string3;
                string7 = string4;
                threeDSecureUsage = threeDSecureUsage2;
                wallet = wallet2;
                networks = networks2;
            } else {
                networks = null;
            }
            PaymentMethod.Card.Networks networks3 = networks;
            Wallet wallet3 = wallet;
            PaymentMethod.Card.ThreeDSecureUsage threeDSecureUsage3 = threeDSecureUsage;
            String string8 = string7;
            String string9 = string6;
            Integer n5 = n4;
            Integer n6 = n3;
            String string10 = string5;
            PaymentMethod.Card.Checks checks3 = checks;
            CardBrand cardBrand3 = cardBrand2;
            return new PaymentMethod.Card(cardBrand3, checks3, string10, n6, n5, string9, string8, threeDSecureUsage3, wallet3, networks3);
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ChecksJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$Checks;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
        public static final class ChecksJsonParser
        implements ModelJsonParser<PaymentMethod.Card.Checks> {
            private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
            private static final String FIELD_ADDRESS_POSTAL_CODE_CHECK = "address_postal_code_check";
            private static final String FIELD_CVC_CHECK = "cvc_check";
            private static final Companion Companion = new Companion(null);

            @Override
            @NotNull
            public PaymentMethod.Card.Checks parse(@NotNull JSONObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                return new PaymentMethod.Card.Checks(StripeJsonUtils.optString(json, FIELD_ADDRESS_LINE1_CHECK), StripeJsonUtils.optString(json, FIELD_ADDRESS_POSTAL_CODE_CHECK), StripeJsonUtils.optString(json, FIELD_CVC_CHECK));
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ChecksJsonParser$Companion;", "", "()V", "FIELD_ADDRESS_LINE1_CHECK", "", "FIELD_ADDRESS_POSTAL_CODE_CHECK", "FIELD_CVC_CHECK", "stripe_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ThreeDSecureUsageJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$ThreeDSecureUsage;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
        public static final class ThreeDSecureUsageJsonParser
        implements ModelJsonParser<PaymentMethod.Card.ThreeDSecureUsage> {
            private static final String FIELD_IS_SUPPORTED = "supported";
            private static final Companion Companion = new Companion(null);

            @Override
            @NotNull
            public PaymentMethod.Card.ThreeDSecureUsage parse(@NotNull JSONObject json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                return new PaymentMethod.Card.ThreeDSecureUsage(StripeJsonUtils.INSTANCE.optBoolean$stripe_release(json, FIELD_IS_SUPPORTED));
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$ThreeDSecureUsageJsonParser$Companion;", "", "()V", "FIELD_IS_SUPPORTED", "", "stripe_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Card$Networks;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
        public static final class NetworksJsonParser
        implements ModelJsonParser<PaymentMethod.Card.Networks> {
            private static final String FIELD_AVAIABLE = "available";
            private static final String FIELD_SELECTION_MANDATORY = "selection_mandatory";
            private static final String FIELD_PREFERRED = "preferred";
            private static final Companion Companion = new Companion(null);

            /*
             * WARNING - void declaration
             */
            @Override
            @Nullable
            public PaymentMethod.Card.Networks parse(@NotNull JSONObject json) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                List list = StripeJsonUtils.INSTANCE.jsonArrayToList$stripe_release(json.optJSONArray(FIELD_AVAIABLE));
                boolean bl = false;
                List list2 = list;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object item$iv$iv;
                    Object t = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string2 = it.toString();
                    collection.add(string2);
                }
                Set available = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                return new PaymentMethod.Card.Networks(available, StripeJsonUtils.INSTANCE.optBoolean$stripe_release(json, FIELD_SELECTION_MANDATORY), StripeJsonUtils.optString(json, FIELD_PREFERRED));
            }

            @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$NetworksJsonParser$Companion;", "", "()V", "FIELD_AVAIABLE", "", "FIELD_PREFERRED", "FIELD_SELECTION_MANDATORY", "stripe_release"})
            private static final class Companion {
                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$CardJsonParser$Companion;", "", "()V", "FIELD_BRAND", "", "FIELD_CHECKS", "FIELD_COUNTRY", "FIELD_EXP_MONTH", "FIELD_EXP_YEAR", "FIELD_FUNDING", "FIELD_LAST4", "FIELD_NETWORKS", "FIELD_THREE_D_SECURE_USAGE", "FIELD_WALLET", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$IdealJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Ideal;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class IdealJsonParser
    implements ModelJsonParser<PaymentMethod.Ideal> {
        private static final String FIELD_BANK = "bank";
        private static final String FIELD_BIC = "bic";
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentMethod.Ideal parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Ideal(StripeJsonUtils.optString(json, FIELD_BANK), StripeJsonUtils.optString(json, FIELD_BIC));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$IdealJsonParser$Companion;", "", "()V", "FIELD_BANK", "", "FIELD_BIC", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$FpxJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Fpx;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class FpxJsonParser
    implements ModelJsonParser<PaymentMethod.Fpx> {
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        private static final String FIELD_BANK = "bank";
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentMethod.Fpx parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Fpx(StripeJsonUtils.optString(json, FIELD_BANK), StripeJsonUtils.optString(json, FIELD_ACCOUNT_HOLDER_TYPE));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$FpxJsonParser$Companion;", "", "()V", "FIELD_ACCOUNT_HOLDER_TYPE", "", "FIELD_BANK", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SepaDebitJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$SepaDebit;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class SepaDebitJsonParser
    implements ModelJsonParser<PaymentMethod.SepaDebit> {
        private static final String FIELD_BANK_CODE = "bank_code";
        private static final String FIELD_BRANCH_CODE = "branch_code";
        private static final String FIELD_COUNTRY = "country";
        private static final String FIELD_FINGERPRINT = "fingerprint";
        private static final String FIELD_LAST4 = "last4";
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentMethod.SepaDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.SepaDebit(StripeJsonUtils.optString(json, FIELD_BANK_CODE), StripeJsonUtils.optString(json, FIELD_BRANCH_CODE), StripeJsonUtils.optString(json, FIELD_COUNTRY), StripeJsonUtils.optString(json, FIELD_FINGERPRINT), StripeJsonUtils.optString(json, FIELD_LAST4));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SepaDebitJsonParser$Companion;", "", "()V", "FIELD_BANK_CODE", "", "FIELD_BRANCH_CODE", "FIELD_COUNTRY", "FIELD_FINGERPRINT", "FIELD_LAST4", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$AuBecsDebitJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$AuBecsDebit;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class AuBecsDebitJsonParser
    implements ModelJsonParser<PaymentMethod.AuBecsDebit> {
        private static final String FIELD_BSB_NUMBER = "bsb_number";
        private static final String FIELD_FINGERPRINT = "fingerprint";
        private static final String FIELD_LAST4 = "last4";
        private static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public PaymentMethod.AuBecsDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.AuBecsDebit(StripeJsonUtils.optString(json, FIELD_BSB_NUMBER), StripeJsonUtils.optString(json, FIELD_FINGERPRINT), StripeJsonUtils.optString(json, FIELD_LAST4));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$AuBecsDebitJsonParser$Companion;", "", "()V", "FIELD_BSB_NUMBER", "", "FIELD_FINGERPRINT", "FIELD_LAST4", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BacsDebitJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$BacsDebit;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class BacsDebitJsonParser
    implements ModelJsonParser<PaymentMethod.BacsDebit> {
        private static final String FIELD_FINGERPRINT = "fingerprint";
        private static final String FIELD_LAST4 = "last4";
        private static final String FIELD_SORT_CODE = "sort_code";
        private static final Companion Companion = new Companion(null);

        @Override
        @Nullable
        public PaymentMethod.BacsDebit parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.BacsDebit(StripeJsonUtils.optString(json, FIELD_FINGERPRINT), StripeJsonUtils.optString(json, FIELD_LAST4), StripeJsonUtils.optString(json, FIELD_SORT_CODE));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$BacsDebitJsonParser$Companion;", "", "()V", "FIELD_FINGERPRINT", "", "FIELD_LAST4", "FIELD_SORT_CODE", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SofortJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentMethod$Sofort;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class SofortJsonParser
    implements ModelJsonParser<PaymentMethod.Sofort> {
        private static final String FIELD_COUNTRY = "country";
        private static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentMethod.Sofort parse(@NotNull JSONObject json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            return new PaymentMethod.Sofort(StripeJsonUtils.optString(json, FIELD_COUNTRY));
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$SofortJsonParser$Companion;", "", "()V", "FIELD_COUNTRY", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/PaymentMethodJsonParser$Companion;", "", "()V", "FIELD_BILLING_DETAILS", "", "FIELD_CREATED", "FIELD_CUSTOMER", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_TYPE", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

