/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.checkout;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.checkout.CheckoutPaymentMethodsAdapter$WhenMappings;
import com.stripe.android.databinding.LayoutCheckoutAddCardItemBinding;
import com.stripe.android.databinding.LayoutCheckoutPaymentMethodItemBinding;
import com.stripe.android.model.PaymentMethod;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001d\u001e\u001f B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/stripe/android/checkout/CheckoutPaymentMethodsAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "addCardClickListener", "Landroid/view/View$OnClickListener;", "(Ljava/util/List;Landroid/view/View$OnClickListener;)V", "getAddCardClickListener", "()Landroid/view/View$OnClickListener;", "getPaymentMethods", "()Ljava/util/List;", "selectedPaymentMethodId", "", "getItemCount", "", "getItemId", "", "position", "getItemViewType", "onBindViewHolder", "", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateSelectedPaymentMethod", "AddCardViewHolder", "CardViewHolder", "Companion", "ViewType", "stripe_release"})
public final class CheckoutPaymentMethodsAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private String selectedPaymentMethodId;
    @NotNull
    private final List<PaymentMethod> paymentMethods;
    @NotNull
    private final View.OnClickListener addCardClickListener;
    private static final long ADD_CARD_ID = 1234L;
    private static final Companion Companion = new Companion(null);

    private final void updateSelectedPaymentMethod(int position) {
        int currentlySelectedPosition;
        block3: {
            int n;
            List<PaymentMethod> $this$indexOfFirst$iv = this.paymentMethods;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<PaymentMethod> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod item$iv;
                PaymentMethod it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.id, (Object)this.selectedPaymentMethodId)) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = currentlySelectedPosition = -1;
        }
        if (currentlySelectedPosition != position) {
            this.notifyItemChanged(currentlySelectedPosition);
            this.notifyItemChanged(position);
            PaymentMethod paymentMethod = (PaymentMethod)CollectionsKt.getOrNull(this.paymentMethods, (int)position);
            this.selectedPaymentMethodId = paymentMethod != null ? paymentMethod.id : null;
        }
    }

    public long getItemId(int position) {
        int n = position;
        return n == this.paymentMethods.size() ? 1234L : (long)this.paymentMethods.get(position).hashCode();
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        switch (CheckoutPaymentMethodsAdapter$WhenMappings.$EnumSwitchMapping$0[ViewType.values()[viewType].ordinal()]) {
            case 1: {
                viewHolder = new CardViewHolder(parent);
                break;
            }
            case 2: {
                AddCardViewHolder addCardViewHolder = new AddCardViewHolder(parent);
                boolean bl = false;
                boolean bl2 = false;
                AddCardViewHolder $this$apply = addCardViewHolder;
                boolean bl3 = false;
                $this$apply.itemView.setOnClickListener(this.addCardClickListener);
                viewHolder = addCardViewHolder;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unsupported view type");
            }
        }
        return viewHolder;
    }

    public int getItemCount() {
        return this.paymentMethods.size() + 1;
    }

    public int getItemViewType(int position) {
        int n = position;
        ViewType type = n == this.paymentMethods.size() ? ViewType.AddCard : ViewType.Card;
        return type.ordinal();
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder instanceof CardViewHolder) {
            PaymentMethod paymentMethod = this.paymentMethods.get(position);
            ((CardViewHolder)holder).setPaymentMethod(paymentMethod);
            ((CardViewHolder)holder).setSelected(Intrinsics.areEqual((Object)paymentMethod.id, (Object)this.selectedPaymentMethodId));
            holder.itemView.setOnClickListener(new View.OnClickListener(this, holder){
                final /* synthetic */ CheckoutPaymentMethodsAdapter this$0;
                final /* synthetic */ RecyclerView.ViewHolder $holder;

                public final void onClick(View it) {
                    CheckoutPaymentMethodsAdapter.access$updateSelectedPaymentMethod(this.this$0, ((CardViewHolder)this.$holder).getAdapterPosition());
                }
                {
                    this.this$0 = checkoutPaymentMethodsAdapter;
                    this.$holder = viewHolder;
                }
            });
        }
    }

    @NotNull
    public final List<PaymentMethod> getPaymentMethods() {
        return this.paymentMethods;
    }

    @NotNull
    public final View.OnClickListener getAddCardClickListener() {
        return this.addCardClickListener;
    }

    public CheckoutPaymentMethodsAdapter(@NotNull List<PaymentMethod> paymentMethods, @NotNull View.OnClickListener addCardClickListener) {
        Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
        Intrinsics.checkNotNullParameter((Object)addCardClickListener, (String)"addCardClickListener");
        this.paymentMethods = paymentMethods;
        this.addCardClickListener = addCardClickListener;
        this.setHasStableIds(true);
    }

    public static final /* synthetic */ void access$updateSelectedPaymentMethod(CheckoutPaymentMethodsAdapter $this, int position) {
        $this.updateSelectedPaymentMethod(position);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/checkout/CheckoutPaymentMethodsAdapter$CardViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "binding", "Lcom/stripe/android/databinding/LayoutCheckoutPaymentMethodItemBinding;", "(Lcom/stripe/android/databinding/LayoutCheckoutPaymentMethodItemBinding;)V", "setPaymentMethod", "", "method", "Lcom/stripe/android/model/PaymentMethod;", "setSelected", "selected", "", "stripe_release"})
    private static final class CardViewHolder
    extends RecyclerView.ViewHolder {
        private final LayoutCheckoutPaymentMethodItemBinding binding;

        public final void setPaymentMethod(@NotNull PaymentMethod method) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                PaymentMethod.Card card = method.card;
                if (card == null) break block0;
                PaymentMethod.Card card2 = card;
                boolean bl = false;
                boolean bl2 = false;
                PaymentMethod.Card card3 = card2;
                boolean bl3 = false;
                this.binding.brandIcon.setImageResource(card3.brand.getIcon());
                TextView textView = this.binding.cardNumber;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.cardNumber");
                View view = this.itemView;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
                textView.setText((CharSequence)view.getContext().getString(R.string.checkout_payment_method_item_card_number, new Object[]{card3.last4}));
            }
        }

        public final void setSelected(boolean selected) {
            ImageView imageView = this.binding.checkIcon;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.checkIcon");
            imageView.setVisibility(selected ? 0 : 8);
        }

        public CardViewHolder(@NotNull LayoutCheckoutPaymentMethodItemBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }

        public CardViewHolder(@NotNull ViewGroup parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            LayoutCheckoutPaymentMethodItemBinding layoutCheckoutPaymentMethodItemBinding = LayoutCheckoutPaymentMethodItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)layoutCheckoutPaymentMethodItemBinding, (String)"LayoutCheckoutPaymentMet\u2026.context), parent, false)");
            this(layoutCheckoutPaymentMethodItemBinding);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/checkout/CheckoutPaymentMethodsAdapter$AddCardViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "stripe_release"})
    private static final class AddCardViewHolder
    extends RecyclerView.ViewHolder {
        public AddCardViewHolder(@NotNull ViewGroup parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            LayoutCheckoutAddCardItemBinding layoutCheckoutAddCardItemBinding = LayoutCheckoutAddCardItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
            Intrinsics.checkNotNullExpressionValue((Object)layoutCheckoutAddCardItemBinding, (String)"LayoutCheckoutAddCardIte\u2026.context), parent, false)");
            super((View)layoutCheckoutAddCardItemBinding.getRoot());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/checkout/CheckoutPaymentMethodsAdapter$ViewType;", "", "(Ljava/lang/String;I)V", "Card", "AddCard", "GooglePay", "stripe_release"})
    private static final class ViewType
    extends Enum<ViewType> {
        public static final /* enum */ ViewType Card;
        public static final /* enum */ ViewType AddCard;
        public static final /* enum */ ViewType GooglePay;
        private static final /* synthetic */ ViewType[] $VALUES;

        static {
            ViewType[] viewTypeArray = new ViewType[3];
            ViewType[] viewTypeArray2 = viewTypeArray;
            viewTypeArray[0] = Card = new ViewType();
            viewTypeArray[1] = AddCard = new ViewType();
            viewTypeArray[2] = GooglePay = new ViewType();
            $VALUES = viewTypeArray;
        }

        public static ViewType[] values() {
            return (ViewType[])$VALUES.clone();
        }

        public static ViewType valueOf(String string2) {
            return Enum.valueOf(ViewType.class, string2);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/checkout/CheckoutPaymentMethodsAdapter$Companion;", "", "()V", "ADD_CARD_ID", "", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

