/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.CardMetadata;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.parsers.ModelJsonParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/parsers/CardMetadataJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/CardMetadata;", "binPrefix", "", "(Ljava/lang/String;)V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
public final class CardMetadataJsonParser
implements ModelJsonParser<CardMetadata> {
    private final String binPrefix;
    @NotNull
    public static final String FIELD_ACCOUNT_RANGE_HIGH = "account_range_high";
    @NotNull
    public static final String FIELD_ACCOUNT_RANGE_LOW = "account_range_low";
    @NotNull
    public static final String FIELD_PAN_LENGTH = "pan_length";
    @NotNull
    public static final String FIELD_BRAND = "brand";
    @NotNull
    public static final String FIELD_COUNTRY = "country";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CardMetadata parse(@NotNull JSONObject json) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        JSONArray data = json.getJSONArray("data");
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)data.length());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CardMetadata.AccountRange accountRange;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            JSONObject jsonEntry = data.getJSONObject(it);
            String accountRangeHigh = StripeJsonUtils.optString(jsonEntry, FIELD_ACCOUNT_RANGE_HIGH);
            String accountRangeLow = StripeJsonUtils.optString(jsonEntry, FIELD_ACCOUNT_RANGE_LOW);
            JSONObject jSONObject = jsonEntry;
            Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"jsonEntry");
            Integer panLength = StripeJsonUtils.INSTANCE.optInteger$stripe_release(jSONObject, FIELD_PAN_LENGTH);
            String brand = StripeJsonUtils.optString(jsonEntry, FIELD_BRAND);
            String country = StripeJsonUtils.optString(jsonEntry, FIELD_COUNTRY);
            if ((accountRangeHigh != null && accountRangeLow != null && panLength != null && brand != null && country != null ? new CardMetadata.AccountRange(accountRangeHigh, accountRangeLow, panLength, brand, country) : null) == null) continue;
            accountRange = accountRange;
            boolean bl3 = false;
            boolean bl4 = false;
            CardMetadata.AccountRange it$iv$iv = accountRange;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List accountRanges = (List)destination$iv$iv;
        return new CardMetadata(this.binPrefix, accountRanges);
    }

    public CardMetadataJsonParser(@NotNull String binPrefix) {
        Intrinsics.checkParameterIsNotNull((Object)binPrefix, (String)"binPrefix");
        this.binPrefix = binPrefix;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/CardMetadataJsonParser$Companion;", "", "()V", "FIELD_ACCOUNT_RANGE_HIGH", "", "FIELD_ACCOUNT_RANGE_LOW", "FIELD_BRAND", "FIELD_COUNTRY", "FIELD_PAN_LENGTH", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

