/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import androidx.annotation.StringRes;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.exception.APIException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001-B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\"H\u0002J\"\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0&0%0$H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020)2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "customerSession", "Lcom/stripe/android/CustomerSession;", "selectedPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Lcom/stripe/android/CustomerSession;Ljava/lang/String;Z)V", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "productUsage", "", "getProductUsage$stripe_release", "()Ljava/util/Set;", "progressData", "Landroidx/lifecycle/MutableLiveData;", "getProgressData$stripe_release", "()Landroidx/lifecycle/MutableLiveData;", "resources", "Landroid/content/res/Resources;", "kotlin.jvm.PlatformType", "getSelectedPaymentMethodId$stripe_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$stripe_release", "(Ljava/lang/String;)V", "snackbarData", "getSnackbarData$stripe_release", "createSnackbarText", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stringRes", "", "getPaymentMethods", "Landroidx/lifecycle/LiveData;", "Lkotlin/Result;", "", "getPaymentMethods$stripe_release", "onPaymentMethodAdded", "", "onPaymentMethodAdded$stripe_release", "onPaymentMethodRemoved", "onPaymentMethodRemoved$stripe_release", "Factory", "stripe_release"})
public final class PaymentMethodsViewModel
extends AndroidViewModel {
    private final Resources resources;
    private final CardDisplayTextFactory cardDisplayTextFactory;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final MutableLiveData<String> snackbarData;
    @NotNull
    private final MutableLiveData<Boolean> progressData;
    private final CustomerSession customerSession;
    @Nullable
    private String selectedPaymentMethodId;
    private final boolean startedFromPaymentSession;

    @NotNull
    public final Set<String> getProductUsage$stripe_release() {
        return this.productUsage;
    }

    @NotNull
    public final MutableLiveData<String> getSnackbarData$stripe_release() {
        return this.snackbarData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getProgressData$stripe_release() {
        return this.progressData;
    }

    public final void onPaymentMethodAdded$stripe_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.added);
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    public final void onPaymentMethodRemoved$stripe_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.removed);
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    private final String createSnackbarText(PaymentMethod paymentMethod, @StringRes int stringRes) {
        String string2;
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethod.Card paymentMethodId = card2;
            boolean bl3 = false;
            string2 = this.resources.getString(stringRes, new Object[]{this.cardDisplayTextFactory.createUnstyled$stripe_release(paymentMethodId)});
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final /* synthetic */ LiveData<Result<List<PaymentMethod>>> getPaymentMethods$stripe_release() {
        MutableLiveData resultData = new MutableLiveData();
        this.progressData.setValue((Object)true);
        CustomerSession.getPaymentMethods$stripe_release$default(this.customerSession, PaymentMethod.Type.Card, null, null, null, this.productUsage, new CustomerSession.PaymentMethodsRetrievalListener(this, resultData){
            final /* synthetic */ PaymentMethodsViewModel this$0;
            final /* synthetic */ MutableLiveData $resultData;

            public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                Result.Companion companion = Result.Companion;
                MutableLiveData mutableLiveData = this.$resultData;
                boolean bl = false;
                Object object = Result.constructor-impl(paymentMethods);
                mutableLiveData.setValue((Object)Result.box-impl((Object)object));
                this.this$0.getProgressData$stripe_release().setValue((Object)false);
            }

            public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                Result.Companion companion = Result.Companion;
                Throwable throwable = new APIException(stripeError, null, errorCode, errorMessage, null, 18, null);
                MutableLiveData mutableLiveData = this.$resultData;
                boolean bl = false;
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                mutableLiveData.setValue((Object)Result.box-impl((Object)object));
                this.this$0.getProgressData$stripe_release().setValue((Object)false);
            }
            {
                this.this$0 = $outer;
                this.$resultData = $captured_local_variable$1;
            }
        }, 14, null);
        return (LiveData)resultData;
    }

    @Nullable
    public final String getSelectedPaymentMethodId$stripe_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$stripe_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    public PaymentMethodsViewModel(@NotNull Application application, @NotNull CustomerSession customerSession2, @Nullable String selectedPaymentMethodId, boolean startedFromPaymentSession2) {
        String string2;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
        super(application);
        this.customerSession = customerSession2;
        this.selectedPaymentMethodId = selectedPaymentMethodId;
        this.startedFromPaymentSession = startedFromPaymentSession2;
        this.resources = application.getResources();
        this.cardDisplayTextFactory = new CardDisplayTextFactory((Context)application);
        String string3 = "PaymentSession";
        int n = 0;
        Object[] objectArray2 = objectArray = new String[2];
        PaymentMethodsViewModel paymentMethodsViewModel = this;
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        objectArray[n] = string2 = this.startedFromPaymentSession ? string3 : null;
        objectArray2[1] = "PaymentMethodsActivity";
        paymentMethodsViewModel.productUsage = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2));
        this.snackbarData = new MutableLiveData();
        this.progressData = new MutableLiveData();
    }

    public /* synthetic */ PaymentMethodsViewModel(Application application, CustomerSession customerSession2, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(application, customerSession2, string2, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "customerSession", "Lcom/stripe/android/CustomerSession;", "initialPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Lcom/stripe/android/CustomerSession;Ljava/lang/String;Z)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Application application;
        private final CustomerSession customerSession;
        private final String initialPaymentMethodId;
        private final boolean startedFromPaymentSession;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
            return (T)((ViewModel)new PaymentMethodsViewModel(this.application, this.customerSession, this.initialPaymentMethodId, this.startedFromPaymentSession));
        }

        public Factory(@NotNull Application application, @NotNull CustomerSession customerSession2, @Nullable String initialPaymentMethodId, boolean startedFromPaymentSession2) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
            this.application = application;
            this.customerSession = customerSession2;
            this.initialPaymentMethodId = initialPaymentMethodId;
            this.startedFromPaymentSession = startedFromPaymentSession2;
        }
    }
}

