/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.core.graphics.drawable.DrawableCompat;
import com.stripe.android.databinding.CardBrandViewBinding;
import com.stripe.android.model.CardBrand;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u001cR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\u00078\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/view/CardBrandView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "iconView", "Landroid/widget/ImageView;", "tintColorInt", "getTintColorInt$stripe_release", "()I", "setTintColorInt$stripe_release", "(I)V", "viewBinding", "Lcom/stripe/android/databinding/CardBrandViewBinding;", "applyTint", "", "applyTint$stripe_release", "showBrandIcon", "brand", "Lcom/stripe/android/model/CardBrand;", "shouldShowErrorIcon", "", "showBrandIcon$stripe_release", "showCvcIcon", "showCvcIcon$stripe_release", "stripe_release"})
public final class CardBrandView
extends FrameLayout {
    private final CardBrandViewBinding viewBinding;
    private final ImageView iconView;
    @ColorInt
    private int tintColorInt;

    public final int getTintColorInt$stripe_release() {
        return this.tintColorInt;
    }

    public final void setTintColorInt$stripe_release(int n) {
        this.tintColorInt = n;
    }

    public final void showBrandIcon$stripe_release(@NotNull CardBrand brand, boolean shouldShowErrorIcon) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
        if (shouldShowErrorIcon) {
            this.iconView.setImageResource(brand.getErrorIcon());
        } else {
            this.iconView.setImageResource(brand.getIcon());
            if (brand == CardBrand.Unknown) {
                this.applyTint$stripe_release();
            }
        }
    }

    public final void showCvcIcon$stripe_release(@NotNull CardBrand brand) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
        this.iconView.setImageResource(brand.getCvcIcon());
        this.applyTint$stripe_release();
    }

    public final void applyTint$stripe_release() {
        Drawable icon = this.iconView.getDrawable();
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.tintColorInt);
        this.iconView.setImageDrawable(DrawableCompat.unwrap((Drawable)compatIcon));
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        CardBrandViewBinding cardBrandViewBinding = CardBrandViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)cardBrandViewBinding, (String)"CardBrandViewBinding.inf\u2026text),\n        this\n    )");
        this.viewBinding = cardBrandViewBinding;
        ImageView imageView = this.viewBinding.icon;
        Intrinsics.checkExpressionValueIsNotNull((Object)imageView, (String)"viewBinding.icon");
        this.iconView = imageView;
        this.setClickable(false);
        this.setFocusable(false);
    }

    public /* synthetic */ CardBrandView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardBrandView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

