/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.ApiRequest;
import com.stripe.android.AppInfo;
import com.stripe.android.RequestHeadersFactory;
import com.stripe.android.StripeRequest;
import com.stripe.android.model.StripeFileParams;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 32\u00020\u0001:\u00013BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0015\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010/\u001a\u00020*2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\nH\u0002R\u0014\u0010\r\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\n8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\n8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u0003\u0018\u00010#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\n8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b'\u0010\u0014\u001a\u0004\b(\u0010\u000f\u00a8\u00064"}, d2={"Lcom/stripe/android/FileUploadRequest;", "Lcom/stripe/android/StripeRequest;", "fileParams", "Lcom/stripe/android/model/StripeFileParams;", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "systemPropertySupplier", "Lkotlin/Function1;", "", "boundary", "(Lcom/stripe/android/model/StripeFileParams;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/AppInfo;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "baseUrl", "getBaseUrl", "()Ljava/lang/String;", "contentType", "getContentType$stripe_release", "fileMetadata", "fileMetadata$annotations", "()V", "getFileMetadata$stripe_release", "headersFactory", "Lcom/stripe/android/RequestHeadersFactory;", "getHeadersFactory", "()Lcom/stripe/android/RequestHeadersFactory;", "method", "Lcom/stripe/android/StripeRequest$Method;", "getMethod", "()Lcom/stripe/android/StripeRequest$Method;", "mimeType", "Lcom/stripe/android/StripeRequest$MimeType;", "getMimeType", "()Lcom/stripe/android/StripeRequest$MimeType;", "params", "", "getParams", "()Ljava/util/Map;", "purposeContents", "purposeContents$annotations", "getPurposeContents$stripe_release", "writeBody", "", "outputStream", "Ljava/io/OutputStream;", "writeBody$stripe_release", "writeFile", "writeString", "writer", "Ljava/io/PrintWriter;", "contents", "Companion", "stripe_release"})
public final class FileUploadRequest
extends StripeRequest {
    @NotNull
    private final StripeRequest.Method method;
    @NotNull
    private final String baseUrl = "https://files.stripe.com/v1/files";
    @Nullable
    private final Map<String, ?> params;
    @NotNull
    private final StripeRequest.MimeType mimeType;
    @NotNull
    private final RequestHeadersFactory headersFactory;
    private final StripeFileParams fileParams;
    private final String boundary;
    private static final String LINE_BREAK = "\r\n";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public StripeRequest.Method getMethod() {
        return this.method;
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nullable
    public Map<String, ?> getParams() {
        return this.params;
    }

    @Override
    @NotNull
    public StripeRequest.MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    @NotNull
    public RequestHeadersFactory getHeadersFactory() {
        return this.headersFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBody$stripe_release(@NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        Closeable closeable = outputStream;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        closeable = new OutputStreamWriter((OutputStream)closeable, charset);
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new PrintWriter((Writer)it, true);
            boolean bl4 = false;
            Throwable throwable2 = null;
            try {
                PrintWriter writer = (PrintWriter)closeable2;
                boolean bl5 = false;
                this.writeString(writer, this.getPurposeContents$stripe_release());
                this.writeString(writer, this.getFileMetadata$stripe_release());
                this.writeFile(outputStream);
                writer.write(LINE_BREAK);
                writer.write("--" + this.boundary + "--");
                writer.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void writeString(PrintWriter writer, String contents) {
        writer.write(StringsKt.replace$default((String)contents, (String)"\n", (String)LINE_BREAK, (boolean)false, (int)4, null));
        writer.flush();
    }

    private final void writeFile(OutputStream outputStream) {
        File file = this.fileParams.getFile$stripe_release();
        boolean bl = false;
        ByteStreamsKt.copyTo$default((InputStream)new FileInputStream(file), (OutputStream)outputStream, (int)0, (int)2, null);
    }

    @Override
    @NotNull
    public String getContentType$stripe_release() {
        return this.getMimeType().getCode() + "; boundary=" + this.boundary;
    }

    @VisibleForTesting
    public static /* synthetic */ void fileMetadata$annotations() {
    }

    @NotNull
    public final String getFileMetadata$stripe_release() {
        String fileName = this.fileParams.getFile$stripe_release().getName();
        String probableContentType = URLConnection.guessContentTypeFromName(fileName);
        return StringsKt.trimIndent((String)("\n                --" + this.boundary + "\n                Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\n                Content-Type: " + probableContentType + "\n                Content-Transfer-Encoding: binary\n\n\n            "));
    }

    @VisibleForTesting
    public static /* synthetic */ void purposeContents$annotations() {
    }

    @NotNull
    public final String getPurposeContents$stripe_release() {
        return StringsKt.trimIndent((String)("\n                --" + this.boundary + "\n                Content-Disposition: form-data; name=\"purpose\"\n\n                " + this.fileParams.getPurpose$stripe_release().getCode$stripe_release() + "\n\n            "));
    }

    public FileUploadRequest(@NotNull StripeFileParams fileParams, @NotNull ApiRequest.Options options, @Nullable AppInfo appInfo, @NotNull Function1<? super String, String> systemPropertySupplier, @NotNull String boundary) {
        Intrinsics.checkParameterIsNotNull((Object)fileParams, (String)"fileParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(systemPropertySupplier, (String)"systemPropertySupplier");
        Intrinsics.checkParameterIsNotNull((Object)boundary, (String)"boundary");
        this.fileParams = fileParams;
        this.boundary = boundary;
        this.method = StripeRequest.Method.POST;
        this.baseUrl = "https://files.stripe.com/v1/files";
        this.mimeType = StripeRequest.MimeType.MultipartForm;
        this.headersFactory = new RequestHeadersFactory.Api(options, appInfo, null, systemPropertySupplier, null, null, 52, null);
    }

    public /* synthetic */ FileUploadRequest(StripeFileParams stripeFileParams, ApiRequest.Options options, AppInfo appInfo, Function1 function1, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            appInfo = null;
        }
        if ((n & 8) != 0) {
            function1 = StripeRequest.Companion.getDEFAULT_SYSTEM_PROPERTY_SUPPLIER$stripe_release();
        }
        if ((n & 0x10) != 0) {
            string2 = FileUploadRequest.Companion.createBoundary();
        }
        this(stripeFileParams, options, appInfo, function1, string2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/FileUploadRequest$Companion;", "", "()V", "LINE_BREAK", "", "createBoundary", "stripe_release"})
    public static final class Companion {
        private final String createBoundary() {
            return String.valueOf(Random.Default.nextLong(0L, Long.MAX_VALUE));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

