/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.ConfigurationCompat;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.databinding.CountryAutocompleteViewBinding;
import com.stripe.android.view.Country;
import com.stripe.android.view.CountryAdapter;
import com.stripe.android.view.CountryAutoCompleteTextView;
import com.stripe.android.view.CountryUtils;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\u0014H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u001b\u0010%\u001a\u00020\u00142\f\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'H\u0000\u00a2\u0006\u0002\b(J\u0015\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020#H\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020\u0014H\u0002J\u0015\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020#H\u0001\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u0013H\u0002J\r\u00101\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b2R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/stripe/android/view/CountryAutoCompleteTextView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "countryAdapter", "Lcom/stripe/android/view/CountryAdapter;", "countryAutocomplete", "Landroid/widget/AutoCompleteTextView;", "countryAutocomplete$annotations", "()V", "getCountryAutocomplete$stripe_release", "()Landroid/widget/AutoCompleteTextView;", "countryChangeCallback", "Lkotlin/Function1;", "Lcom/stripe/android/view/Country;", "", "getCountryChangeCallback$stripe_release", "()Lkotlin/jvm/functions/Function1;", "setCountryChangeCallback$stripe_release", "(Lkotlin/jvm/functions/Function1;)V", "selectedCountry", "selectedCountry$annotations", "getSelectedCountry", "()Lcom/stripe/android/view/Country;", "setSelectedCountry", "(Lcom/stripe/android/view/Country;)V", "viewBinding", "Lcom/stripe/android/databinding/CountryAutocompleteViewBinding;", "clearError", "getDisplayCountry", "", "countryCode", "setAllowedCountryCodes", "allowedCountryCodes", "", "setAllowedCountryCodes$stripe_release", "setCountrySelected", "setCountrySelected$stripe_release", "updateInitialCountry", "updateUiForCountryEntered", "displayCountryEntered", "updateUiForCountryEntered$stripe_release", "updatedSelectedCountryCode", "country", "validateCountry", "validateCountry$stripe_release", "stripe_release"})
public final class CountryAutoCompleteTextView
extends FrameLayout {
    private final CountryAutocompleteViewBinding viewBinding;
    private final CountryAdapter countryAdapter;
    @NotNull
    private final AutoCompleteTextView countryAutocomplete;
    @Nullable
    private Country selectedCountry;
    @NotNull
    private /* synthetic */ Function1<? super Country, Unit> countryChangeCallback;

    @VisibleForTesting
    public static /* synthetic */ void countryAutocomplete$annotations() {
    }

    @NotNull
    public final AutoCompleteTextView getCountryAutocomplete$stripe_release() {
        return this.countryAutocomplete;
    }

    @VisibleForTesting
    public static /* synthetic */ void selectedCountry$annotations() {
    }

    @Nullable
    public final Country getSelectedCountry() {
        return this.selectedCountry;
    }

    public final void setSelectedCountry(@Nullable Country country) {
        this.selectedCountry = country;
    }

    @NotNull
    public final Function1<Country, Unit> getCountryChangeCallback$stripe_release() {
        return this.countryChangeCallback;
    }

    public final void setCountryChangeCallback$stripe_release(@NotNull Function1<? super Country, Unit> function1) {
        Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
        this.countryChangeCallback = function1;
    }

    private final void updateInitialCountry() {
        Country initialCountry = this.countryAdapter.getFirstItem$stripe_release();
        this.countryAutocomplete.setText((CharSequence)initialCountry.getName());
        this.selectedCountry = initialCountry;
        this.countryChangeCallback.invoke((Object)initialCountry);
    }

    public final void setAllowedCountryCodes$stripe_release(@NotNull Set<String> allowedCountryCodes) {
        Intrinsics.checkParameterIsNotNull(allowedCountryCodes, (String)"allowedCountryCodes");
        boolean isUpdated = this.countryAdapter.updateUnfilteredCountries$stripe_release(allowedCountryCodes);
        if (isUpdated) {
            this.updateInitialCountry();
        }
    }

    public final void setCountrySelected$stripe_release(@NotNull String countryCode) {
        Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
        this.updateUiForCountryEntered$stripe_release(this.getDisplayCountry(countryCode));
    }

    @VisibleForTesting
    public final void updateUiForCountryEntered$stripe_release(@NotNull String displayCountryEntered) {
        String string2;
        Country country;
        Intrinsics.checkParameterIsNotNull((Object)displayCountryEntered, (String)"displayCountryEntered");
        Country country2 = country = CountryUtils.INSTANCE.getCountryByName$stripe_release(displayCountryEntered);
        if (country2 != null) {
            Country country3 = country2;
            boolean bl = false;
            boolean bl2 = false;
            Country it = country3;
            boolean bl3 = false;
            this.updatedSelectedCountryCode(it);
            string2 = displayCountryEntered;
        } else {
            Country country4 = this.selectedCountry;
            string2 = country4 != null ? country4.getName() : null;
        }
        String displayCountry = string2;
        this.countryAutocomplete.setText((CharSequence)displayCountry);
    }

    private final void updatedSelectedCountryCode(Country country) {
        this.clearError();
        if (Intrinsics.areEqual((Object)this.selectedCountry, (Object)country) ^ true) {
            this.selectedCountry = country;
            this.countryChangeCallback.invoke((Object)country);
        }
    }

    private final String getDisplayCountry(String countryCode) {
        Object object = CountryUtils.INSTANCE.getCountryByCode$stripe_release(countryCode);
        if (object == null || (object = ((Country)object).getName()) == null) {
            String string2 = new Locale("", countryCode).getDisplayCountry();
            object = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale(\"\", countryCode).displayCountry");
        }
        return object;
    }

    public final void validateCountry$stripe_release() {
        this.countryAutocomplete.performValidation();
    }

    private final void clearError() {
        TextInputLayout textInputLayout = this.viewBinding.countryTextInputLayout;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout, (String)"viewBinding.countryTextInputLayout");
        textInputLayout.setError((CharSequence)null);
        TextInputLayout textInputLayout2 = this.viewBinding.countryTextInputLayout;
        Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout2, (String)"viewBinding.countryTextInputLayout");
        textInputLayout2.setErrorEnabled(false);
    }

    @JvmOverloads
    public CountryAutoCompleteTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        CountryAutocompleteViewBinding countryAutocompleteViewBinding = CountryAutocompleteViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkExpressionValueIsNotNull((Object)countryAutocompleteViewBinding, (String)"CountryAutocompleteViewB\u2026           this\n        )");
        this.viewBinding = countryAutocompleteViewBinding;
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Locale locale = ConfigurationCompat.getLocales((Configuration)resources.getConfiguration()).get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"ConfigurationCompat.getL\u2026sources.configuration)[0]");
        this.countryAdapter = new CountryAdapter(context, CountryUtils.INSTANCE.getOrderedCountries$stripe_release(locale));
        AutoCompleteTextView autoCompleteTextView = this.viewBinding.countryAutocomplete;
        Intrinsics.checkExpressionValueIsNotNull((Object)autoCompleteTextView, (String)"viewBinding.countryAutocomplete");
        this.countryAutocomplete = autoCompleteTextView;
        this.countryChangeCallback = countryChangeCallback.1.INSTANCE;
        this.countryAutocomplete.setThreshold(0);
        this.countryAutocomplete.setAdapter((ListAdapter)this.countryAdapter);
        this.countryAutocomplete.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public final void onItemClick(AdapterView<?> $noName_0, View $noName_1, int position, long $noName_3) {
                this.updatedSelectedCountryCode(countryAdapter.getItem(position));
            }
        });
        this.countryAutocomplete.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public final void onFocusChange(View $noName_0, boolean focused) {
                if (focused) {
                    this.getCountryAutocomplete$stripe_release().showDropDown();
                } else {
                    String countryEntered = this.getCountryAutocomplete$stripe_release().getText().toString();
                    this.updateUiForCountryEntered$stripe_release(countryEntered);
                }
            }
        });
        this.selectedCountry = this.countryAdapter.getFirstItem$stripe_release();
        this.updateInitialCountry();
        String string2 = this.getResources().getString(R.string.address_country_invalid);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(R.st\u2026.address_country_invalid)");
        final String errorMessage = string2;
        this.countryAutocomplete.setValidator(new AutoCompleteTextView.Validator(){

            @NotNull
            public CharSequence fixText(@Nullable CharSequence invalidText) {
                CharSequence charSequence = invalidText;
                if (charSequence == null) {
                    charSequence = "";
                }
                return charSequence;
            }

            public boolean isValid(@Nullable CharSequence text) {
                Object v0;
                block3: {
                    Iterable $this$firstOrNull$iv = countryAdapter.getUnfilteredCountries$stripe_release();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Country it = (Country)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)String.valueOf(text))) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                Country validCountry = v0;
                this.setSelectedCountry(validCountry);
                if (validCountry != null) {
                    this.clearError();
                } else {
                    TextInputLayout textInputLayout = ((CountryAutoCompleteTextView)this).viewBinding.countryTextInputLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout, (String)"viewBinding.countryTextInputLayout");
                    textInputLayout.setError((CharSequence)errorMessage);
                    TextInputLayout textInputLayout2 = ((CountryAutoCompleteTextView)this).viewBinding.countryTextInputLayout;
                    Intrinsics.checkExpressionValueIsNotNull((Object)textInputLayout2, (String)"viewBinding.countryTextInputLayout");
                    textInputLayout2.setErrorEnabled(true);
                }
                return validCountry != null;
            }
        });
    }

    public /* synthetic */ CountryAutoCompleteTextView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CountryAutoCompleteTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CountryAutoCompleteTextView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

