/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ClientFingerprintDataStore;
import com.stripe.android.utils.ContextUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B1\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0002J\u0019\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0000\u00a2\u0006\u0002\b\u0013J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0011H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/FingerprintRequestParamsFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "displayMetrics", "Landroid/util/DisplayMetrics;", "packageName", "", "versionName", "timeZone", "clientFingerprintDataStore", "Lcom/stripe/android/ClientFingerprintDataStore;", "(Landroid/util/DisplayMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/ClientFingerprintDataStore;)V", "androidVersionString", "screen", "createFirstMap", "", "createParams", "createParams$stripe_release", "createSecondMap", "createValueMap", "value", "Companion", "stripe_release"})
public final class FingerprintRequestParamsFactory {
    private final String screen;
    private final String androidVersionString;
    private final DisplayMetrics displayMetrics;
    private final String packageName;
    private final String versionName;
    private final String timeZone;
    private final ClientFingerprintDataStore clientFingerprintDataStore;
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final /* synthetic */ Map<String, Object> createParams$stripe_release() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"v2", (Object)1), TuplesKt.to((Object)"tag", (Object)"14.5.0"), TuplesKt.to((Object)"src", (Object)"android-sdk"), TuplesKt.to((Object)"a", this.createFirstMap()), TuplesKt.to((Object)"b", this.createSecondMap())});
    }

    private final Map<String, Object> createFirstMap() {
        Pair[] pairArray = new Pair[4];
        String string2 = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().toString()");
        pairArray[0] = TuplesKt.to((Object)"c", this.createValueMap(string2));
        pairArray[1] = TuplesKt.to((Object)"d", this.createValueMap(this.androidVersionString));
        pairArray[2] = TuplesKt.to((Object)"f", this.createValueMap(this.screen));
        pairArray[3] = TuplesKt.to((Object)"g", this.createValueMap(this.timeZone));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> createSecondMap() {
        Object object;
        Object object2;
        boolean bl;
        Map map;
        String string2;
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"d", (Object)this.clientFingerprintDataStore.getMuid()), TuplesKt.to((Object)"e", (Object)this.clientFingerprintDataStore.getSid()), TuplesKt.to((Object)"k", (Object)this.packageName), TuplesKt.to((Object)"o", (Object)Build.VERSION.RELEASE), TuplesKt.to((Object)"p", (Object)Build.VERSION.SDK_INT), TuplesKt.to((Object)"q", (Object)Build.MANUFACTURER), TuplesKt.to((Object)"r", (Object)Build.BRAND), TuplesKt.to((Object)"s", (Object)Build.MODEL), TuplesKt.to((Object)"t", (Object)Build.TAGS)});
        String string3 = this.versionName;
        if (string3 != null) {
            string2 = string3;
            map = map2;
            bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            object2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"l", (Object)it));
            map2 = map;
            object = object2;
        } else {
            object = null;
        }
        string2 = object;
        map = map2;
        bl = false;
        Object object3 = string2;
        if (object3 == null) {
            object3 = MapsKt.emptyMap();
        }
        object2 = object3;
        return MapsKt.plus((Map)map, (Map)object2);
    }

    private final Map<String, Object> createValueMap(String value) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"v", (Object)value));
    }

    @VisibleForTesting
    public FingerprintRequestParamsFactory(@NotNull DisplayMetrics displayMetrics, @NotNull String packageName, @Nullable String versionName, @NotNull String timeZone, @NotNull ClientFingerprintDataStore clientFingerprintDataStore) {
        Intrinsics.checkParameterIsNotNull((Object)displayMetrics, (String)"displayMetrics");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
        Intrinsics.checkParameterIsNotNull((Object)clientFingerprintDataStore, (String)"clientFingerprintDataStore");
        this.displayMetrics = displayMetrics;
        this.packageName = packageName;
        this.versionName = versionName;
        this.timeZone = timeZone;
        this.clientFingerprintDataStore = clientFingerprintDataStore;
        this.screen = this.displayMetrics.widthPixels + "w_" + this.displayMetrics.heightPixels + "h_" + this.displayMetrics.densityDpi + "dpi";
        this.androidVersionString = "Android " + Build.VERSION.RELEASE + ' ' + Build.VERSION.CODENAME + ' ' + Build.VERSION.SDK_INT;
    }

    public FingerprintRequestParamsFactory(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Intrinsics.checkExpressionValueIsNotNull((Object)displayMetrics, (String)"context.resources.displayMetrics");
        String string2 = context.getPackageName();
        DisplayMetrics displayMetrics2 = displayMetrics;
        FingerprintRequestParamsFactory fingerprintRequestParamsFactory = this;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo$stripe_release(context);
        fingerprintRequestParamsFactory(displayMetrics2, string4, packageInfo != null ? packageInfo.versionName : null, FingerprintRequestParamsFactory.Companion.createTimezone(), new ClientFingerprintDataStore.Default(context, null, 2, null));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/FingerprintRequestParamsFactory$Companion;", "", "()V", "createTimezone", "", "stripe_release"})
    private static final class Companion {
        private final String createTimezone() {
            TimeZone timeZone = TimeZone.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)timeZone, (String)"TimeZone.getDefault()");
            int minutes = (int)TimeUnit.MINUTES.convert(timeZone.getRawOffset(), TimeUnit.MILLISECONDS);
            if (minutes % 60 == 0) {
                return String.valueOf(minutes / 60);
            }
            BigDecimal decimalValue = new BigDecimal(minutes).setScale(2, 6);
            BigDecimal decHours = decimalValue.divide(new BigDecimal(60), new MathContext(2)).setScale(2, 6);
            String string2 = decHours.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"decHours.toString()");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

