/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.stripe.android.FingerprintData;
import com.stripe.android.FingerprintDataRepository;
import com.stripe.android.FingerprintDataStore;
import com.stripe.android.FingerprintRequestExecutor;
import com.stripe.android.FingerprintRequestFactory;
import com.stripe.android.Stripe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001:\u0001\bJ\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\t"}, d2={"Lcom/stripe/android/FingerprintDataRepository;", "", "get", "Lcom/stripe/android/FingerprintData;", "refresh", "", "save", "fingerprintData", "Default", "stripe_release"})
public interface FingerprintDataRepository {
    public void refresh();

    @Nullable
    public FingerprintData get();

    public void save(@NotNull FingerprintData var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\n\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/FingerprintDataRepository$Default;", "Lcom/stripe/android/FingerprintDataRepository;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "store", "Lcom/stripe/android/FingerprintDataStore;", "fingerprintRequestFactory", "Lcom/stripe/android/FingerprintRequestFactory;", "fingerprintRequestExecutor", "Lcom/stripe/android/FingerprintRequestExecutor;", "handler", "Landroid/os/Handler;", "(Lcom/stripe/android/FingerprintDataStore;Lcom/stripe/android/FingerprintRequestFactory;Lcom/stripe/android/FingerprintRequestExecutor;Landroid/os/Handler;)V", "cachedFingerprintData", "Lcom/stripe/android/FingerprintData;", "timestampSupplier", "Lkotlin/Function0;", "", "get", "refresh", "", "save", "fingerprintData", "stripe_release"})
    public static final class Default
    implements FingerprintDataRepository {
        private FingerprintData cachedFingerprintData;
        private final Function0<Long> timestampSupplier;
        private final FingerprintDataStore store;
        private final FingerprintRequestFactory fingerprintRequestFactory;
        private final FingerprintRequestExecutor fingerprintRequestExecutor;
        private final Handler handler;

        @Override
        public void refresh() {
            if (Stripe.Companion.getAdvancedFraudSignalsEnabled()) {
                this.handler.post(new Runnable(this){
                    final /* synthetic */ Default this$0;

                    public final void run() {
                        LiveData<FingerprintData> liveData = Default.access$getStore$p(this.this$0).get();
                        liveData.observeForever((Observer)new Observer<FingerprintData>(this, liveData){
                            final /* synthetic */ refresh.1 this$0;
                            final /* synthetic */ LiveData $liveData;

                            public void onChanged(@NotNull FingerprintData localFingerprintData) {
                                Intrinsics.checkParameterIsNotNull((Object)localFingerprintData, (String)"localFingerprintData");
                                if (localFingerprintData.isExpired(((Number)Default.access$getTimestampSupplier$p(this.this$0.this$0).invoke()).longValue())) {
                                    Default.access$getFingerprintRequestExecutor$p(this.this$0.this$0).execute(Default.access$getFingerprintRequestFactory$p(this.this$0.this$0).create(localFingerprintData.getGuid$stripe_release()), (Function1<? super FingerprintData, Unit>)((Function1)new Function1<FingerprintData, Unit>(this){
                                        final /* synthetic */ Default.refresh.1 this$0;

                                        public final void invoke(@Nullable FingerprintData remoteFingerprintData) {
                                            FingerprintData fingerprintData = remoteFingerprintData;
                                            if (fingerprintData != null) {
                                                FingerprintData fingerprintData2 = fingerprintData;
                                                boolean bl = false;
                                                boolean bl2 = false;
                                                FingerprintData it = fingerprintData2;
                                                boolean bl3 = false;
                                                this.this$0.this$0.this$0.save(it);
                                            }
                                            this.this$0.$liveData.removeObserver((Observer)this.this$0);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(1);
                                        }
                                    }));
                                } else {
                                    Default.access$setCachedFingerprintData$p(this.this$0.this$0, localFingerprintData);
                                    this.$liveData.removeObserver((Observer)this);
                                }
                            }
                            {
                                this.this$0 = $outer;
                                this.$liveData = $captured_local_variable$1;
                            }
                        });
                    }
                    {
                        this.this$0 = default_;
                    }
                });
            }
        }

        @Override
        @Nullable
        public FingerprintData get() {
            FingerprintData fingerprintData = this.cachedFingerprintData;
            boolean bl = false;
            boolean bl2 = false;
            FingerprintData it = fingerprintData;
            boolean bl3 = false;
            return Stripe.Companion.getAdvancedFraudSignalsEnabled() ? fingerprintData : null;
        }

        @Override
        public void save(@NotNull FingerprintData fingerprintData) {
            Intrinsics.checkParameterIsNotNull((Object)fingerprintData, (String)"fingerprintData");
            this.cachedFingerprintData = fingerprintData;
            this.store.save(fingerprintData);
        }

        public Default(@NotNull FingerprintDataStore store, @NotNull FingerprintRequestFactory fingerprintRequestFactory, @NotNull FingerprintRequestExecutor fingerprintRequestExecutor, @NotNull Handler handler) {
            Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
            Intrinsics.checkParameterIsNotNull((Object)fingerprintRequestFactory, (String)"fingerprintRequestFactory");
            Intrinsics.checkParameterIsNotNull((Object)fingerprintRequestExecutor, (String)"fingerprintRequestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            this.store = store;
            this.fingerprintRequestFactory = fingerprintRequestFactory;
            this.fingerprintRequestExecutor = fingerprintRequestExecutor;
            this.handler = handler;
            this.timestampSupplier = timestampSupplier.1.INSTANCE;
        }

        public /* synthetic */ Default(FingerprintDataStore fingerprintDataStore, FingerprintRequestFactory fingerprintRequestFactory, FingerprintRequestExecutor fingerprintRequestExecutor, Handler handler, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                fingerprintRequestExecutor = new FingerprintRequestExecutor.Default(null, null, 3, null);
            }
            if ((n & 8) != 0) {
                handler = new Handler(Looper.getMainLooper());
            }
            this(fingerprintDataStore, fingerprintRequestFactory, fingerprintRequestExecutor, handler);
        }

        public Default(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this(new FingerprintDataStore.Default(context), new FingerprintRequestFactory(context), null, null, 12, null);
        }

        public static final /* synthetic */ FingerprintDataStore access$getStore$p(Default $this) {
            return $this.store;
        }

        public static final /* synthetic */ Function0 access$getTimestampSupplier$p(Default $this) {
            return $this.timestampSupplier;
        }

        public static final /* synthetic */ FingerprintRequestExecutor access$getFingerprintRequestExecutor$p(Default $this) {
            return $this.fingerprintRequestExecutor;
        }

        public static final /* synthetic */ FingerprintRequestFactory access$getFingerprintRequestFactory$p(Default $this) {
            return $this.fingerprintRequestFactory;
        }

        public static final /* synthetic */ FingerprintData access$getCachedFingerprintData$p(Default $this) {
            return $this.cachedFingerprintData;
        }

        public static final /* synthetic */ void access$setCachedFingerprintData$p(Default $this, FingerprintData fingerprintData) {
            $this.cachedFingerprintData = fingerprintData;
        }
    }
}

