/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Application;
import android.content.Context;
import androidx.annotation.StringRes;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.CardDisplayTextFactory;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002,-B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001f\u001a\u00020 2\b\b\u0001\u0010!\u001a\u00020\"H\u0002J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b)J\u0015\u0010*\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b+R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "customerSession", "Lcom/stripe/android/CustomerSession;", "selectedPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Lcom/stripe/android/CustomerSession;Ljava/lang/String;Z)V", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "productUsage", "", "getProductUsage$stripe_release", "()Ljava/util/Set;", "progressData", "Landroidx/lifecycle/MutableLiveData;", "getProgressData$stripe_release", "()Landroidx/lifecycle/MutableLiveData;", "getSelectedPaymentMethodId$stripe_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$stripe_release", "(Ljava/lang/String;)V", "snackbarData", "getSnackbarData$stripe_release", "createSnackbarText", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stringRes", "", "getPaymentMethods", "Landroidx/lifecycle/LiveData;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "getPaymentMethods$stripe_release", "onPaymentMethodAdded", "", "onPaymentMethodAdded$stripe_release", "onPaymentMethodRemoved", "onPaymentMethodRemoved$stripe_release", "Factory", "Result", "stripe_release"})
public final class PaymentMethodsViewModel
extends AndroidViewModel {
    private final Context context;
    private final CardDisplayTextFactory cardDisplayTextFactory;
    @NotNull
    private final Set<String> productUsage;
    @NotNull
    private final MutableLiveData<String> snackbarData;
    @NotNull
    private final MutableLiveData<Boolean> progressData;
    private final CustomerSession customerSession;
    @Nullable
    private String selectedPaymentMethodId;
    private final boolean startedFromPaymentSession;

    @NotNull
    public final Set<String> getProductUsage$stripe_release() {
        return this.productUsage;
    }

    @NotNull
    public final MutableLiveData<String> getSnackbarData$stripe_release() {
        return this.snackbarData;
    }

    @NotNull
    public final MutableLiveData<Boolean> getProgressData$stripe_release() {
        return this.progressData;
    }

    public final void onPaymentMethodAdded$stripe_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.added);
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    public final void onPaymentMethodRemoved$stripe_release(@NotNull PaymentMethod paymentMethod) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            String string2 = this.createSnackbarText(paymentMethod, R.string.removed);
            if (string2 == null) break block0;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.snackbarData.setValue((Object)it);
            this.snackbarData.setValue(null);
        }
    }

    private final String createSnackbarText(PaymentMethod paymentMethod, @StringRes int stringRes) {
        String string2;
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethod.Card paymentMethodId = card2;
            boolean bl3 = false;
            string2 = this.context.getString(stringRes, new Object[]{this.cardDisplayTextFactory.createUnstyled$stripe_release(paymentMethodId)});
        } else {
            string2 = null;
        }
        return string2;
    }

    @NotNull
    public final /* synthetic */ LiveData<Result> getPaymentMethods$stripe_release() {
        MutableLiveData resultData = new MutableLiveData();
        this.progressData.setValue((Object)true);
        CustomerSession.getPaymentMethods$stripe_release$default(this.customerSession, PaymentMethod.Type.Card, null, null, null, this.productUsage, new CustomerSession.PaymentMethodsRetrievalListener(this, resultData){
            final /* synthetic */ PaymentMethodsViewModel this$0;
            final /* synthetic */ MutableLiveData $resultData;

            public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                this.$resultData.setValue((Object)new Result.Success(paymentMethods));
                this.this$0.getProgressData$stripe_release().setValue((Object)false);
            }

            public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                this.$resultData.setValue((Object)new Result.Error(new APIException(stripeError, null, errorCode, errorMessage, null, 18, null)));
                this.this$0.getProgressData$stripe_release().setValue((Object)false);
            }
            {
                this.this$0 = $outer;
                this.$resultData = $captured_local_variable$1;
            }
        }, 14, null);
        return (LiveData)resultData;
    }

    @Nullable
    public final String getSelectedPaymentMethodId$stripe_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$stripe_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    public PaymentMethodsViewModel(@NotNull Application application, @NotNull CustomerSession customerSession2, @Nullable String selectedPaymentMethodId, boolean startedFromPaymentSession2) {
        String string2;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
        super(application);
        this.customerSession = customerSession2;
        this.selectedPaymentMethodId = selectedPaymentMethodId;
        this.startedFromPaymentSession = startedFromPaymentSession2;
        Context context = this.context = application.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        this.cardDisplayTextFactory = new CardDisplayTextFactory(context);
        String string3 = "PaymentSession";
        int n = 0;
        Object[] objectArray2 = objectArray = new String[2];
        PaymentMethodsViewModel paymentMethodsViewModel = this;
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        objectArray[n] = string2 = this.startedFromPaymentSession ? string3 : null;
        objectArray2[1] = "PaymentMethodsActivity";
        paymentMethodsViewModel.productUsage = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2));
        this.snackbarData = new MutableLiveData();
        this.progressData = new MutableLiveData();
    }

    public /* synthetic */ PaymentMethodsViewModel(Application application, CustomerSession customerSession2, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(application, customerSession2, string2, bl);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "", "()V", "Error", "Success", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Success;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Error;", "stripe_release"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Success;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "(Ljava/util/List;)V", "getPaymentMethods", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class Success
        extends Result {
            @NotNull
            private final List<PaymentMethod> paymentMethods;

            @NotNull
            public final List<PaymentMethod> getPaymentMethods() {
                return this.paymentMethods;
            }

            public Success(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                super(null);
                this.paymentMethods = paymentMethods;
            }

            @NotNull
            public final List<PaymentMethod> component1() {
                return this.paymentMethods;
            }

            @NotNull
            public final Success copy(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                return new Success(paymentMethods);
            }

            public static /* synthetic */ Success copy$default(Success success, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = success.paymentMethods;
                }
                return success.copy(list);
            }

            @NotNull
            public String toString() {
                return "Success(paymentMethods=" + this.paymentMethods + ")";
            }

            public int hashCode() {
                List<PaymentMethod> list = this.paymentMethods;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Success)) break block3;
                        Success success = (Success)object;
                        if (!Intrinsics.areEqual(this.paymentMethods, success.paymentMethods)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Error;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "exception", "Lcom/stripe/android/exception/StripeException;", "(Lcom/stripe/android/exception/StripeException;)V", "getException", "()Lcom/stripe/android/exception/StripeException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class Error
        extends Result {
            @NotNull
            private final StripeException exception;

            @NotNull
            public final StripeException getException() {
                return this.exception;
            }

            public Error(@NotNull StripeException exception) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
            }

            @NotNull
            public final StripeException component1() {
                return this.exception;
            }

            @NotNull
            public final Error copy(@NotNull StripeException exception) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                return new Error(exception);
            }

            public static /* synthetic */ Error copy$default(Error error, StripeException stripeException, int n, Object object) {
                if ((n & 1) != 0) {
                    stripeException = error.exception;
                }
                return error.copy(stripeException);
            }

            @NotNull
            public String toString() {
                return "Error(exception=" + this.exception + ")";
            }

            public int hashCode() {
                StripeException stripeException = this.exception;
                return stripeException != null ? ((Object)stripeException).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Error)) break block3;
                        Error error = (Error)object;
                        if (!Intrinsics.areEqual((Object)this.exception, (Object)error.exception)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ'\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "application", "Landroid/app/Application;", "customerSession", "Lcom/stripe/android/CustomerSession;", "initialPaymentMethodId", "", "startedFromPaymentSession", "", "(Landroid/app/Application;Lcom/stripe/android/CustomerSession;Ljava/lang/String;Z)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Application application;
        private final CustomerSession customerSession;
        private final String initialPaymentMethodId;
        private final boolean startedFromPaymentSession;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
            return (T)((ViewModel)new PaymentMethodsViewModel(this.application, this.customerSession, this.initialPaymentMethodId, this.startedFromPaymentSession));
        }

        public Factory(@NotNull Application application, @NotNull CustomerSession customerSession2, @Nullable String initialPaymentMethodId, boolean startedFromPaymentSession2) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
            this.application = application;
            this.customerSession = customerSession2;
            this.initialPaymentMethodId = initialPaymentMethodId;
            this.startedFromPaymentSession = startedFromPaymentSession2;
        }
    }
}

