/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.AnalyticsEvent;
import com.stripe.android.AnalyticsRequest;
import com.stripe.android.AnalyticsRequestExecutor;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.Logger;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.StripePaymentController$WhenMappings;
import com.stripe.android.StripeRepository;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceRedirect;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.Stripe3dsRedirect;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ChallengeProgressDialogActivity;
import com.stripe.android.view.AuthActivityStarter;
import com.stripe.android.view.Stripe3ds2CompletionActivity;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 K2\u00020\u0001:\u0007IJKLMNOBy\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\"\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010,\u001a\u0004\u0018\u00010\u0005H\u0002J>\u0010-\u001a\b\u0012\u0004\u0012\u00020$0.2\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00052\b\b\u0002\u00102\u001a\u00020\t2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040.H\u0002J>\u00105\u001a\b\u0012\u0004\u0012\u00020$0.2\u0006\u0010'\u001a\u00020(2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00052\b\b\u0002\u00102\u001a\u00020\t2\f\u00106\u001a\b\u0012\u0004\u0012\u0002070.H\u0002J \u00108\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0017J\u001e\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040.H\u0016J\u001e\u0010<\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\f\u00103\u001a\b\u0012\u0004\u0012\u0002070.H\u0016J\u001e\u0010=\u001a\u00020 2\u0006\u0010:\u001a\u00020;2\f\u00103\u001a\b\u0012\u0004\u0012\u00020+0.H\u0016J \u0010>\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010?\u001a\u00020\t2\u0006\u0010@\u001a\u0002002\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u001a\u0010A\u001a\u00020\t2\u0006\u0010@\u001a\u0002002\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u001a\u0010B\u001a\u00020\t2\u0006\u0010@\u001a\u0002002\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J \u0010C\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010D\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J \u0010E\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0016J \u0010F\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010G\u001a\u00020H2\u0006\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006P"}, d2={"Lcom/stripe/android/StripePaymentController;", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "publishableKey", "", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "enableLogging", "", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "config", "Lcom/stripe/android/PaymentAuthConfig;", "threeDs2Service", "Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;", "analyticsRequestExecutor", "Lcom/stripe/android/AnalyticsRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "challengeFlowStarter", "Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter;", "challengeProgressDialogActivityStarter", "Lcom/stripe/android/StripePaymentController$ChallengeProgressDialogActivityStarter;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "(Landroid/content/Context;Ljava/lang/String;Lcom/stripe/android/StripeRepository;ZLcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/PaymentAuthConfig;Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;Lcom/stripe/android/AnalyticsRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter;Lcom/stripe/android/StripePaymentController$ChallengeProgressDialogActivityStarter;Lkotlinx/coroutines/CoroutineScope;)V", "analyticsRequestFactory", "Lcom/stripe/android/AnalyticsRequest$Factory;", "logger", "Lcom/stripe/android/Logger;", "begin3ds2Auth", "", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "stripe3ds2Fingerprint", "Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "bypassAuth", "source", "Lcom/stripe/android/model/Source;", "stripeAccountId", "createPaymentIntentCallback", "Lcom/stripe/android/ApiResultCallback;", "flowOutcome", "", "sourceId", "shouldCancelSource", "callback", "Lcom/stripe/android/PaymentIntentResult;", "createSetupIntentCallback", "resultCallback", "Lcom/stripe/android/SetupIntentResult;", "handleNextAction", "handlePaymentResult", "data", "Landroid/content/Intent;", "handleSetupResult", "handleSourceResult", "onSourceRetrieved", "shouldHandlePaymentResult", "requestCode", "shouldHandleSetupResult", "shouldHandleSourceResult", "startAuth", "clientSecret", "startAuthenticateSource", "startConfirmAndAuth", "confirmStripeIntentParams", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "ChallengeFlowStarter", "ChallengeProgressDialogActivityStarter", "Companion", "ConfirmStripeIntentCallback", "ConfirmStripeIntentTask", "PaymentAuth3ds2ChallengeStatusReceiver", "Stripe3ds2AuthCallback", "stripe_release"})
public final class StripePaymentController
implements PaymentController {
    private final Logger logger;
    private final AnalyticsRequest.Factory analyticsRequestFactory;
    private final String publishableKey;
    private final StripeRepository stripeRepository;
    private final boolean enableLogging;
    private final MessageVersionRegistry messageVersionRegistry;
    private final PaymentAuthConfig config;
    private final StripeThreeDs2Service threeDs2Service;
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final AnalyticsDataFactory analyticsDataFactory;
    private final ChallengeFlowStarter challengeFlowStarter;
    private final ChallengeProgressDialogActivityStarter challengeProgressDialogActivityStarter;
    private final CoroutineScope workScope;
    public static final int PAYMENT_REQUEST_CODE = 50000;
    public static final int SETUP_REQUEST_CODE = 50001;
    public static final int SOURCE_REQUEST_CODE = 50002;
    private static final List<String> EXPAND_PAYMENT_METHOD;
    public static final Companion Companion;

    @Override
    public void startConfirmAndAuth(@NotNull AuthActivityStarter.Host host, @NotNull ConfirmStripeIntentParams confirmStripeIntentParams, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)confirmStripeIntentParams, (String)"confirmStripeIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        new ConfirmStripeIntentTask(this.stripeRepository, confirmStripeIntentParams, requestOptions, this.workScope, new ConfirmStripeIntentCallback(host, requestOptions, this, Companion.getRequestCode$stripe_release(confirmStripeIntentParams))).execute$stripe_release();
    }

    @Override
    public void startAuth(@NotNull AuthActivityStarter.Host host, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeRepository.DefaultImpls.retrieveIntent$default(this.stripeRepository, clientSecret, requestOptions, null, new ApiResultCallback<StripeIntent>(this, host, requestOptions){
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ ApiRequest.Options $requestOptions;

            public void onSuccess(@NotNull StripeIntent result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                this.this$0.handleNextAction(this.$host, result, this.$requestOptions);
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                com.stripe.android.StripePaymentController$Companion.access$handleError(StripePaymentController.Companion, this.$host, 50000, e);
            }
            {
                this.this$0 = $outer;
                this.$host = $captured_local_variable$1;
                this.$requestOptions = $captured_local_variable$2;
            }
        }, 4, null);
    }

    @Override
    public void startAuthenticateSource(@NotNull AuthActivityStarter.Host host, @NotNull Source source, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(this.analyticsRequestFactory, this.analyticsDataFactory.createAuthSourceParams$stripe_release(AnalyticsEvent.AuthSourceStart, source.getId()), requestOptions, null, 4, null));
        String string2 = source.getId();
        StripeRepository stripeRepository = this.stripeRepository;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        string2 = source.getClientSecret();
        bl = false;
        String string5 = string2;
        if (string5 == null) {
            string5 = "";
        }
        String string6 = string5;
        stripeRepository.retrieveSource(string4, string6, requestOptions, new ApiResultCallback<Source>(this, host, requestOptions){
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ AuthActivityStarter.Host $host;
            final /* synthetic */ ApiRequest.Options $requestOptions;

            public void onSuccess(@NotNull Source result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                StripePaymentController.access$onSourceRetrieved(this.this$0, this.$host, result, this.$requestOptions);
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                com.stripe.android.StripePaymentController$Companion.access$handleError(StripePaymentController.Companion, this.$host, 50002, e);
            }
            {
                this.this$0 = $outer;
                this.$host = $captured_local_variable$1;
                this.$requestOptions = $captured_local_variable$2;
            }
        });
    }

    private final void onSourceRetrieved(AuthActivityStarter.Host host, Source source, ApiRequest.Options requestOptions) {
        if (Intrinsics.areEqual((Object)source.getFlow(), (Object)"redirect")) {
            this.analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(this.analyticsRequestFactory, this.analyticsDataFactory.createAuthSourceParams$stripe_release(AnalyticsEvent.AuthSourceRedirect, source.getId()), requestOptions, null, 4, null));
            String string2 = source.getClientSecret();
            PaymentAuthWebViewStarter paymentAuthWebViewStarter = new PaymentAuthWebViewStarter(host, 50002);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            SourceRedirect sourceRedirect = source.getRedirect();
            string2 = sourceRedirect != null ? sourceRedirect.getUrl() : null;
            bl = false;
            String string5 = string2;
            if (string5 == null) {
                string5 = "";
            }
            String string6 = string5;
            SourceRedirect sourceRedirect2 = source.getRedirect();
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            String string7 = requestOptions.getStripeAccount$stripe_release();
            StripeToolbarCustomization stripeToolbarCustomization = null;
            boolean bl2 = this.enableLogging;
            String string8 = sourceRedirect2 != null ? sourceRedirect2.getReturnUrl() : null;
            String string9 = string6;
            String string10 = string4;
            paymentAuthWebViewStarter.start(new PaymentAuthWebViewStarter.Args(string10, string9, string8, bl2, stripeToolbarCustomization, string7, n, defaultConstructorMarker));
        } else {
            this.bypassAuth(host, source, requestOptions.getStripeAccount$stripe_release());
        }
    }

    @Override
    public boolean shouldHandlePaymentResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50000 && data != null;
    }

    @Override
    public boolean shouldHandleSetupResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50001 && data != null;
    }

    @Override
    public boolean shouldHandleSourceResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50002 && data != null;
    }

    @Override
    public void handlePaymentResult(@NotNull Intent data, @NotNull ApiResultCallback<PaymentIntentResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        PaymentController.Result result = PaymentController.Result.Companion.fromIntent$stripe_release(data);
        if (result == null) {
            result = new PaymentController.Result(null, 0, null, false, null, null, null, 127, null);
        }
        PaymentController.Result result2 = result;
        StripeException authException = result2.getException$stripe_release();
        if (authException instanceof Exception) {
            callback.onError(authException);
            return;
        }
        boolean shouldCancelSource = result2.getShouldCancelSource$stripe_release();
        String string2 = result2.getSourceId$stripe_release();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String sourceId = string3;
        int flowOutcome2 = result2.getFlowOutcome$stripe_release();
        ApiRequest.Options requestOptions = new ApiRequest.Options(this.publishableKey, result2.getStripeAccountId$stripe_release(), null, 4, null);
        this.stripeRepository.retrieveIntent(Companion.getClientSecret$stripe_release(data), requestOptions, EXPAND_PAYMENT_METHOD, this.createPaymentIntentCallback(requestOptions, flowOutcome2, sourceId, shouldCancelSource, callback));
    }

    @Override
    public void handleSetupResult(@NotNull Intent data, @NotNull ApiResultCallback<SetupIntentResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        PaymentController.Result result = PaymentController.Result.Companion.fromIntent$stripe_release(data);
        if (result == null) {
            result = new PaymentController.Result(null, 0, null, false, null, null, null, 127, null);
        }
        PaymentController.Result result2 = result;
        StripeException authException = result2.getException$stripe_release();
        if (authException instanceof Exception) {
            callback.onError(authException);
            return;
        }
        boolean shouldCancelSource = result2.getShouldCancelSource$stripe_release();
        String string2 = result2.getSourceId$stripe_release();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String sourceId = string3;
        int flowOutcome2 = result2.getFlowOutcome$stripe_release();
        ApiRequest.Options requestOptions = new ApiRequest.Options(this.publishableKey, result2.getStripeAccountId$stripe_release(), null, 4, null);
        this.stripeRepository.retrieveIntent(Companion.getClientSecret$stripe_release(data), requestOptions, EXPAND_PAYMENT_METHOD, this.createSetupIntentCallback(requestOptions, flowOutcome2, sourceId, shouldCancelSource, callback));
    }

    @Override
    public void handleSourceResult(@NotNull Intent data, @NotNull ApiResultCallback<Source> callback) {
        PaymentController.Result result;
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        PaymentController.Result result2 = result = PaymentController.Result.Companion.fromIntent$stripe_release(data);
        String string2 = result2 != null ? result2.getSourceId$stripe_release() : null;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String sourceId = string3;
        PaymentController.Result result3 = result;
        String string4 = result3 != null ? result3.getClientSecret$stripe_release() : null;
        boolean bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            string5 = "";
        }
        String clientSecret = string5;
        PaymentController.Result result4 = result;
        ApiRequest.Options requestOptions = new ApiRequest.Options(this.publishableKey, result4 != null ? result4.getStripeAccountId$stripe_release() : null, null, 4, null);
        this.analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(this.analyticsRequestFactory, this.analyticsDataFactory.createAuthSourceParams$stripe_release(AnalyticsEvent.AuthSourceResult, sourceId), requestOptions, null, 4, null));
        this.stripeRepository.retrieveSource(sourceId, clientSecret, requestOptions, callback);
    }

    private final ApiResultCallback<StripeIntent> createPaymentIntentCallback(ApiRequest.Options requestOptions, int flowOutcome2, String sourceId, boolean shouldCancelSource, ApiResultCallback<PaymentIntentResult> callback) {
        return new ApiResultCallback<StripeIntent>(this, shouldCancelSource, sourceId, requestOptions, flowOutcome2, callback){
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ boolean $shouldCancelSource;
            final /* synthetic */ String $sourceId;
            final /* synthetic */ ApiRequest.Options $requestOptions;
            final /* synthetic */ int $flowOutcome;
            final /* synthetic */ ApiResultCallback $callback;

            public void onSuccess(@NotNull StripeIntent result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                if (result instanceof PaymentIntent) {
                    if (this.$shouldCancelSource && result.requiresAction()) {
                        StripePaymentController.access$getLogger$p(this.this$0).debug("Canceling source '" + this.$sourceId + "' for PaymentIntent");
                        StripePaymentController.access$getStripeRepository$p(this.this$0).cancelIntent(result, this.$sourceId, this.$requestOptions, StripePaymentController.access$createPaymentIntentCallback(this.this$0, this.$requestOptions, this.$flowOutcome, this.$sourceId, false, this.$callback));
                    } else {
                        StripePaymentController.access$getLogger$p(this.this$0).debug("Dispatching PaymentIntentResult for " + result.getId());
                        this.$callback.onSuccess(new PaymentIntentResult((PaymentIntent)result, this.$flowOutcome));
                    }
                } else {
                    this.$callback.onError(new IllegalArgumentException("Expected a PaymentIntent, received a " + result.getClass().getSimpleName()));
                }
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onError(e);
            }
            {
                this.this$0 = $outer;
                this.$shouldCancelSource = $captured_local_variable$1;
                this.$sourceId = $captured_local_variable$2;
                this.$requestOptions = $captured_local_variable$3;
                this.$flowOutcome = $captured_local_variable$4;
                this.$callback = $captured_local_variable$5;
            }
        };
    }

    static /* synthetic */ ApiResultCallback createPaymentIntentCallback$default(StripePaymentController stripePaymentController, ApiRequest.Options options, int n, String string2, boolean bl, ApiResultCallback apiResultCallback, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return stripePaymentController.createPaymentIntentCallback(options, n, string2, bl, apiResultCallback);
    }

    private final ApiResultCallback<StripeIntent> createSetupIntentCallback(ApiRequest.Options requestOptions, int flowOutcome2, String sourceId, boolean shouldCancelSource, ApiResultCallback<SetupIntentResult> resultCallback) {
        return new ApiResultCallback<StripeIntent>(this, shouldCancelSource, sourceId, requestOptions, flowOutcome2, resultCallback){
            final /* synthetic */ StripePaymentController this$0;
            final /* synthetic */ boolean $shouldCancelSource;
            final /* synthetic */ String $sourceId;
            final /* synthetic */ ApiRequest.Options $requestOptions;
            final /* synthetic */ int $flowOutcome;
            final /* synthetic */ ApiResultCallback $resultCallback;

            public void onSuccess(@NotNull StripeIntent result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                if (result instanceof SetupIntent) {
                    if (this.$shouldCancelSource && result.requiresAction()) {
                        StripePaymentController.access$getLogger$p(this.this$0).debug("Canceling source '" + this.$sourceId + "' for SetupIntent");
                        StripePaymentController.access$getStripeRepository$p(this.this$0).cancelIntent(result, this.$sourceId, this.$requestOptions, StripePaymentController.access$createSetupIntentCallback(this.this$0, this.$requestOptions, this.$flowOutcome, this.$sourceId, false, this.$resultCallback));
                    } else {
                        StripePaymentController.access$getLogger$p(this.this$0).debug("Dispatching SetupIntentResult for " + result.getId());
                        this.$resultCallback.onSuccess(new SetupIntentResult((SetupIntent)result, this.$flowOutcome));
                    }
                } else {
                    this.$resultCallback.onError(new IllegalArgumentException("Expected a SetupIntent, received a " + result.getClass().getSimpleName()));
                }
            }

            public void onError(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$resultCallback.onError(e);
            }
            {
                this.this$0 = $outer;
                this.$shouldCancelSource = $captured_local_variable$1;
                this.$sourceId = $captured_local_variable$2;
                this.$requestOptions = $captured_local_variable$3;
                this.$flowOutcome = $captured_local_variable$4;
                this.$resultCallback = $captured_local_variable$5;
            }
        };
    }

    static /* synthetic */ ApiResultCallback createSetupIntentCallback$default(StripePaymentController stripePaymentController, ApiRequest.Options options, int n, String string2, boolean bl, ApiResultCallback apiResultCallback, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl = false;
        }
        return stripePaymentController.createSetupIntentCallback(options, n, string2, bl, apiResultCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @VisibleForTesting
    public void handleNextAction(@NotNull AuthActivityStarter.Host host, @NotNull StripeIntent stripeIntent, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        if (!stripeIntent.requiresAction()) {
            this.bypassAuth(host, stripeIntent, requestOptions.getStripeAccount$stripe_release());
            return;
        }
        StripeIntent.NextActionType nextActionType = stripeIntent.getNextActionType();
        if (nextActionType != null) {
            switch (StripePaymentController$WhenMappings.$EnumSwitchMapping$0[nextActionType.ordinal()]) {
                case 1: {
                    StripeIntent.SdkData sdkData = stripeIntent.getStripeSdkData();
                    StripeIntent.SdkData sdkData2 = sdkData;
                    if (sdkData2 != null && sdkData2.is3ds2()) {
                        String string2 = stripeIntent.getId();
                        AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds2Fingerprint;
                        AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                        AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
                        AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            string3 = "";
                        }
                        String string4 = string3;
                        analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.createAuthParams$stripe_release(analyticsEvent, string4), requestOptions, null, 4, null));
                        try {
                            this.begin3ds2Auth(host, stripeIntent, Stripe3ds2Fingerprint.Companion.create$stripe_release(sdkData), requestOptions);
                            return;
                        }
                        catch (CertificateException e) {
                            StripePaymentController.Companion.handleError(host, StripePaymentController.Companion.getRequestCode$stripe_release(stripeIntent), e);
                            return;
                        }
                    }
                    StripeIntent.SdkData sdkData3 = sdkData;
                    if (sdkData3 != null && sdkData3.is3ds1()) {
                        String string5 = stripeIntent.getId();
                        AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds1Sdk;
                        AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                        Object object = this.analyticsRequestFactory;
                        Object object2 = this.analyticsRequestExecutor;
                        boolean bl = false;
                        String string6 = string5;
                        if (string6 == null) {
                            string6 = "";
                        }
                        String string7 = string6;
                        object2.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default((AnalyticsRequest.Factory)object, analyticsDataFactory.createAuthParams$stripe_release(analyticsEvent, string7), requestOptions, null, 4, null));
                        string5 = stripeIntent.getClientSecret();
                        int n = Companion.getRequestCode$stripe_release(stripeIntent);
                        object = host;
                        object2 = Companion;
                        bl = false;
                        String string8 = string5;
                        if (string8 == null) {
                            string8 = "";
                        }
                        String string9 = string8;
                        com.stripe.android.StripePaymentController$Companion.beginWebAuth$default((Companion)object2, (AuthActivityStarter.Host)object, n, string9, Stripe3dsRedirect.Companion.create$stripe_release(sdkData).getUrl(), requestOptions.getStripeAccount$stripe_release(), null, this.enableLogging, 32, null);
                        return;
                    }
                    this.bypassAuth(host, stripeIntent, requestOptions.getStripeAccount$stripe_release());
                    return;
                }
                case 2: {
                    String sdkData = stripeIntent.getId();
                    AnalyticsEvent analyticsEvent = AnalyticsEvent.AuthRedirect;
                    AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                    Object object = this.analyticsRequestFactory;
                    Object object3 = this.analyticsRequestExecutor;
                    boolean bl = false;
                    String string10 = sdkData;
                    if (string10 == null) {
                        string10 = "";
                    }
                    String string11 = string10;
                    object3.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default((AnalyticsRequest.Factory)object, analyticsDataFactory.createAuthParams$stripe_release(analyticsEvent, string11), requestOptions, null, 4, null));
                    StripeIntent.RedirectData redirectData = stripeIntent.getRedirectData();
                    String string12 = stripeIntent.getClientSecret();
                    int n = Companion.getRequestCode$stripe_release(stripeIntent);
                    object = host;
                    object3 = Companion;
                    boolean bl2 = false;
                    String string13 = string12;
                    if (string13 == null) {
                        string13 = "";
                    }
                    String string14 = string13;
                    StripeIntent.RedirectData redirectData2 = redirectData;
                    StripeIntent.RedirectData redirectData3 = redirectData;
                    ((Companion)object3).beginWebAuth((AuthActivityStarter.Host)object, n, string14, String.valueOf(redirectData2 != null ? redirectData2.getUrl() : null), requestOptions.getStripeAccount$stripe_release(), redirectData3 != null ? redirectData3.getReturnUrl() : null, this.enableLogging);
                    return;
                }
            }
        }
        this.bypassAuth(host, stripeIntent, requestOptions.getStripeAccount$stripe_release());
    }

    private final void bypassAuth(AuthActivityStarter.Host host, StripeIntent stripeIntent, String stripeAccountId) {
        PaymentRelayStarter.Companion.create$stripe_release(host, Companion.getRequestCode$stripe_release(stripeIntent)).start(PaymentRelayStarter.Args.Companion.create$stripe_release(stripeIntent, stripeAccountId));
    }

    private final void bypassAuth(AuthActivityStarter.Host host, Source source, String stripeAccountId) {
        PaymentRelayStarter.Companion.create$stripe_release(host, 50002).start(PaymentRelayStarter.Args.Companion.create$stripe_release(source, stripeAccountId));
    }

    private final void begin3ds2Auth(AuthActivityStarter.Host host, StripeIntent stripeIntent, Stripe3ds2Fingerprint stripe3ds2Fingerprint, ApiRequest.Options requestOptions) {
        StripeIntent.RedirectData redirectData;
        Activity activity = host.getActivity$stripe_release();
        if (activity == null) {
            return;
        }
        Activity activity2 = activity;
        Transaction transaction = this.threeDs2Service.createTransaction(stripe3ds2Fingerprint.getDirectoryServer().getId(), this.messageVersionRegistry.getCurrent(), stripeIntent.isLiveMode(), stripe3ds2Fingerprint.getDirectoryServer().getNetworkName(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getRootCerts(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getDirectoryServerPublicKey(), stripe3ds2Fingerprint.getDirectoryServerEncryption().getKeyId(), new Intent((Context)activity2, Stripe3ds2CompletionActivity.class).putExtra("extra_client_secret", stripeIntent.getClientSecret()).putExtra("extra_stripe_account", requestOptions.getStripeAccount$stripe_release()).addFlags(0x2000000), Companion.getRequestCode$stripe_release(stripeIntent));
        this.challengeProgressDialogActivityStarter.start((Context)activity2, stripe3ds2Fingerprint.getDirectoryServer().getNetworkName(), false, this.config.getStripe3ds2Config$stripe_release().getUiCustomization$stripe_release().getUiCustomization());
        StripeIntent.RedirectData redirectData2 = redirectData = stripeIntent.getRedirectData();
        String returnUrl = redirectData2 != null ? redirectData2.getReturnUrl() : null;
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.config.getStripe3ds2Config$stripe_release().getTimeout$stripe_release();
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.getSource(), areqParams.getSdkAppId(), areqParams.getSdkReferenceNumber(), areqParams.getSdkTransactionId(), areqParams.getDeviceData(), areqParams.getSdkEphemeralPublicKey(), areqParams.getMessageVersion(), timeout, returnUrl);
        String string2 = stripeIntent.getId();
        Stripe3ds2AuthParams stripe3ds2AuthParams = authParams;
        StripeRepository stripeRepository = this.stripeRepository;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        stripeRepository.start3ds2Auth(stripe3ds2AuthParams, string4, requestOptions, new Stripe3ds2AuthCallback(host, this.stripeRepository, transaction, timeout, stripeIntent, stripe3ds2Fingerprint.getSource(), requestOptions, this.analyticsRequestExecutor, this.analyticsDataFactory, this.challengeFlowStarter, this.enableLogging, null, 2048, null));
    }

    public StripePaymentController(@NotNull Context context, @NotNull String publishableKey, @NotNull StripeRepository stripeRepository, boolean enableLogging, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull PaymentAuthConfig config, @NotNull StripeThreeDs2Service threeDs2Service, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull ChallengeFlowStarter challengeFlowStarter, @NotNull ChallengeProgressDialogActivityStarter challengeProgressDialogActivityStarter, @NotNull CoroutineScope workScope) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)threeDs2Service, (String)"threeDs2Service");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
        Intrinsics.checkParameterIsNotNull((Object)challengeFlowStarter, (String)"challengeFlowStarter");
        Intrinsics.checkParameterIsNotNull((Object)challengeProgressDialogActivityStarter, (String)"challengeProgressDialogActivityStarter");
        Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
        this.publishableKey = publishableKey;
        this.stripeRepository = stripeRepository;
        this.enableLogging = enableLogging;
        this.messageVersionRegistry = messageVersionRegistry;
        this.config = config;
        this.threeDs2Service = threeDs2Service;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.analyticsDataFactory = analyticsDataFactory;
        this.challengeFlowStarter = challengeFlowStarter;
        this.challengeProgressDialogActivityStarter = challengeProgressDialogActivityStarter;
        this.workScope = workScope;
        this.logger = Logger.Companion.getInstance$stripe_release(this.enableLogging);
        this.analyticsRequestFactory = new AnalyticsRequest.Factory(this.logger);
        this.threeDs2Service.initialize((UiCustomization)this.config.getStripe3ds2Config$stripe_release().getUiCustomization$stripe_release().getUiCustomization());
    }

    public /* synthetic */ StripePaymentController(Context context, String string2, StripeRepository stripeRepository, boolean bl, MessageVersionRegistry messageVersionRegistry, PaymentAuthConfig paymentAuthConfig, StripeThreeDs2Service stripeThreeDs2Service, AnalyticsRequestExecutor analyticsRequestExecutor, AnalyticsDataFactory analyticsDataFactory, ChallengeFlowStarter challengeFlowStarter, ChallengeProgressDialogActivityStarter challengeProgressDialogActivityStarter, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            messageVersionRegistry = new MessageVersionRegistry();
        }
        if ((n & 0x20) != 0) {
            paymentAuthConfig = PaymentAuthConfig.Companion.get();
        }
        if ((n & 0x40) != 0) {
            stripeThreeDs2Service = (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context, (SSLSocketFactory)new StripeSSLSocketFactory(), bl);
        }
        if ((n & 0x80) != 0) {
            analyticsRequestExecutor = new AnalyticsRequestExecutor.Default(Logger.Companion.getInstance$stripe_release(bl));
        }
        if ((n & 0x100) != 0) {
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            analyticsDataFactory = new AnalyticsDataFactory(context2, string2);
        }
        if ((n & 0x200) != 0) {
            challengeFlowStarter = new ChallengeFlowStarter.Default();
        }
        if ((n & 0x400) != 0) {
            challengeProgressDialogActivityStarter = new ChallengeProgressDialogActivityStarter.Default();
        }
        if ((n & 0x800) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        }
        this(context, string2, stripeRepository, bl, messageVersionRegistry, paymentAuthConfig, stripeThreeDs2Service, analyticsRequestExecutor, analyticsDataFactory, challengeFlowStarter, challengeProgressDialogActivityStarter, coroutineScope);
    }

    static {
        Companion = new Companion(null);
        EXPAND_PAYMENT_METHOD = CollectionsKt.listOf((Object)"payment_method");
    }

    public static final /* synthetic */ void access$onSourceRetrieved(StripePaymentController $this, AuthActivityStarter.Host host, Source source, ApiRequest.Options requestOptions) {
        $this.onSourceRetrieved(host, source, requestOptions);
    }

    public static final /* synthetic */ Logger access$getLogger$p(StripePaymentController $this) {
        return $this.logger;
    }

    public static final /* synthetic */ StripeRepository access$getStripeRepository$p(StripePaymentController $this) {
        return $this.stripeRepository;
    }

    public static final /* synthetic */ ApiResultCallback access$createPaymentIntentCallback(StripePaymentController $this, ApiRequest.Options requestOptions, int flowOutcome2, String sourceId, boolean shouldCancelSource, ApiResultCallback callback) {
        return $this.createPaymentIntentCallback(requestOptions, flowOutcome2, sourceId, shouldCancelSource, callback);
    }

    public static final /* synthetic */ ApiResultCallback access$createSetupIntentCallback(StripePaymentController $this, ApiRequest.Options requestOptions, int flowOutcome2, String sourceId, boolean shouldCancelSource, ApiResultCallback resultCallback) {
        return $this.createSetupIntentCallback(requestOptions, flowOutcome2, sourceId, shouldCancelSource, resultCallback);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull String publishableKey, @NotNull StripeRepository stripeRepository, boolean enableLogging) {
        return Companion.create(context, publishableKey, stripeRepository, enableLogging);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PaymentController create(@NotNull Context context, @NotNull String publishableKey, @NotNull StripeRepository stripeRepository) {
        return com.stripe.android.StripePaymentController$Companion.create$default(Companion, context, publishableKey, stripeRepository, false, 8, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/StripePaymentController$ConfirmStripeIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "params", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/ConfirmStripeIntentParams;Lcom/stripe/android/ApiRequest$Options;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class ConfirmStripeIntentTask
    extends ApiOperation<StripeIntent> {
        private final ConfirmStripeIntentParams params;
        private final StripeRepository stripeRepository;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super StripeIntent> $completion) throws StripeException {
            ConfirmStripeIntentParams confirmStripeIntentParams = this.params;
            return confirmStripeIntentParams instanceof ConfirmPaymentIntentParams ? (StripeIntent)this.stripeRepository.confirmPaymentIntent((ConfirmPaymentIntentParams)this.params, this.requestOptions, EXPAND_PAYMENT_METHOD) : (confirmStripeIntentParams instanceof ConfirmSetupIntentParams ? (StripeIntent)this.stripeRepository.confirmSetupIntent((ConfirmSetupIntentParams)this.params, this.requestOptions, EXPAND_PAYMENT_METHOD) : null);
        }

        public ConfirmStripeIntentTask(@NotNull StripeRepository stripeRepository, @NotNull ConfirmStripeIntentParams params, @NotNull ApiRequest.Options requestOptions, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.requestOptions = requestOptions;
            this.params = params.withShouldUseStripeSdk(true);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/StripePaymentController$ConfirmStripeIntentCallback;", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/StripeIntent;", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "paymentController", "Lcom/stripe/android/PaymentController;", "requestCode", "", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/PaymentController;I)V", "onError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "result", "stripe_release"})
    private static final class ConfirmStripeIntentCallback
    implements ApiResultCallback<StripeIntent> {
        private final AuthActivityStarter.Host host;
        private final ApiRequest.Options requestOptions;
        private final PaymentController paymentController;
        private final int requestCode;

        @Override
        public void onSuccess(@NotNull StripeIntent result) {
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            this.paymentController.handleNextAction(this.host, result, this.requestOptions);
        }

        @Override
        public void onError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Companion.handleError(this.host, this.requestCode, e);
        }

        public ConfirmStripeIntentCallback(@NotNull AuthActivityStarter.Host host, @NotNull ApiRequest.Options requestOptions, @NotNull PaymentController paymentController, int requestCode) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
            this.host = host;
            this.requestOptions = requestOptions;
            this.paymentController = paymentController;
            this.requestCode = requestCode;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001Bk\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u0002H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u001fH\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/stripe/android/StripePaymentController$Stripe3ds2AuthCallback;", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "maxTimeout", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "analyticsRequestExecutor", "Lcom/stripe/android/AnalyticsRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "challengeFlowStarter", "Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter;", "enableLogging", "", "paymentRelayStarter", "Lcom/stripe/android/PaymentRelayStarter;", "(Lcom/stripe/android/view/AuthActivityStarter$Host;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/stripe3ds2/transaction/Transaction;ILcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/AnalyticsRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter;ZLcom/stripe/android/PaymentRelayStarter;)V", "analyticsRequestFactory", "Lcom/stripe/android/AnalyticsRequest$Factory;", "onError", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "result", "startChallengeFlow", "ares", "Lcom/stripe/android/model/Stripe3ds2AuthResult$Ares;", "startFrictionlessFlow", "stripe_release"})
    public static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<Stripe3ds2AuthResult> {
        private final AnalyticsRequest.Factory analyticsRequestFactory;
        private final AuthActivityStarter.Host host;
        private final StripeRepository stripeRepository;
        private final Transaction transaction;
        private final int maxTimeout;
        private final StripeIntent stripeIntent;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;
        private final AnalyticsRequestExecutor analyticsRequestExecutor;
        private final AnalyticsDataFactory analyticsDataFactory;
        private final ChallengeFlowStarter challengeFlowStarter;
        private final boolean enableLogging;
        private final PaymentRelayStarter paymentRelayStarter;

        @Override
        public void onSuccess(@NotNull Stripe3ds2AuthResult result) {
            Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
            Stripe3ds2AuthResult.Ares ares = result.getAres();
            if (ares != null) {
                if (ares.isChallenge()) {
                    this.startChallengeFlow(ares);
                } else {
                    this.startFrictionlessFlow();
                }
            } else if (result.getFallbackRedirectUrl() != null) {
                String string2 = this.stripeIntent.getId();
                Object object = AnalyticsEvent.Auth3ds2Fallback;
                AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
                Object object2 = this.analyticsRequestFactory;
                Object object3 = this.analyticsRequestExecutor;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = string3;
                object3.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default((AnalyticsRequest.Factory)object2, analyticsDataFactory.createAuthParams$stripe_release((AnalyticsEvent)((Object)object), string4), this.requestOptions, null, 4, null));
                string2 = this.stripeIntent.getClientSecret();
                int n = Companion.getRequestCode$stripe_release(this.stripeIntent);
                object2 = this.host;
                object3 = Companion;
                bl = false;
                String string5 = string2;
                if (string5 == null) {
                    string5 = "";
                }
                object = string5;
                com.stripe.android.StripePaymentController$Companion.beginWebAuth$default((Companion)object3, (AuthActivityStarter.Host)object2, n, (String)object, result.getFallbackRedirectUrl(), this.requestOptions.getStripeAccount$stripe_release(), null, this.enableLogging, 32, null);
            } else {
                Stripe3ds2AuthResult.ThreeDS2Error error = result.getError();
                String errorMessage = null;
                errorMessage = error != null ? "Code: " + error.getErrorCode() + ", " + "Detail: " + error.getErrorDetail() + ", " + "Description: " + error.getErrorDescription() + ", " + "Component: " + error.getErrorComponent() : "Invalid 3DS2 authentication response";
                this.onError(new RuntimeException("Error encountered during 3DS2 authentication request. " + errorMessage));
            }
        }

        @Override
        public void onError(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            Exception exception = e;
            this.paymentRelayStarter.start(PaymentRelayStarter.Args.Companion.create$stripe_release(exception instanceof StripeException ? (StripeException)e : (StripeException)new APIException(e)));
        }

        private final void startFrictionlessFlow() {
            String string2 = this.stripeIntent.getId();
            AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds2Frictionless;
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.createAuthParams$stripe_release(analyticsEvent, string4), this.requestOptions, null, 4, null));
            this.paymentRelayStarter.start(PaymentRelayStarter.Args.Companion.create$stripe_release$default(PaymentRelayStarter.Args.Companion, this.stripeIntent, null, 2, null));
        }

        private final void startChallengeFlow(Stripe3ds2AuthResult.Ares ares) {
            block0: {
                StripeChallengeParameters stripeChallengeParameters = new StripeChallengeParameters();
                boolean bl = false;
                boolean bl2 = false;
                StripeChallengeParameters it = stripeChallengeParameters;
                boolean bl3 = false;
                it.setAcsSignedContent(ares.getAcsSignedContent$stripe_release());
                it.setThreeDsServerTransactionId(ares.getThreeDSServerTransId$stripe_release());
                it.setAcsTransactionId(ares.getAcsTransId$stripe_release());
                StripeChallengeParameters challengeParameters = stripeChallengeParameters;
                Activity activity = this.host.getActivity$stripe_release();
                if (activity == null) break block0;
                stripeChallengeParameters = activity;
                bl = false;
                bl2 = false;
                StripeChallengeParameters activity2 = stripeChallengeParameters;
                boolean bl4 = false;
                this.challengeFlowStarter.start(new Runnable((Activity)activity2, this, challengeParameters){
                    final /* synthetic */ Activity $activity;
                    final /* synthetic */ Stripe3ds2AuthCallback this$0;
                    final /* synthetic */ StripeChallengeParameters $challengeParameters$inlined;
                    {
                        this.$activity = activity;
                        this.this$0 = stripe3ds2AuthCallback;
                        this.$challengeParameters$inlined = stripeChallengeParameters;
                    }

                    public final void run() {
                        Stripe3ds2AuthCallback.access$getTransaction$p(this.this$0).doChallenge(this.$activity, (ChallengeParameters)this.$challengeParameters$inlined, (ChallengeStatusReceiver)PaymentAuth3ds2ChallengeStatusReceiver.Companion.create$stripe_release(Stripe3ds2AuthCallback.access$getStripeRepository$p(this.this$0), Stripe3ds2AuthCallback.access$getStripeIntent$p(this.this$0), Stripe3ds2AuthCallback.access$getSourceId$p(this.this$0), Stripe3ds2AuthCallback.access$getRequestOptions$p(this.this$0), Stripe3ds2AuthCallback.access$getAnalyticsRequestExecutor$p(this.this$0), Stripe3ds2AuthCallback.access$getAnalyticsDataFactory$p(this.this$0), Stripe3ds2AuthCallback.access$getTransaction$p(this.this$0), Stripe3ds2AuthCallback.access$getAnalyticsRequestFactory$p(this.this$0)), Stripe3ds2AuthCallback.access$getMaxTimeout$p(this.this$0));
                    }
                });
            }
        }

        @VisibleForTesting
        public Stripe3ds2AuthCallback(@NotNull AuthActivityStarter.Host host, @NotNull StripeRepository stripeRepository, @NotNull Transaction transaction, int maxTimeout, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull ChallengeFlowStarter challengeFlowStarter, boolean enableLogging, @NotNull PaymentRelayStarter paymentRelayStarter) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
            Intrinsics.checkParameterIsNotNull((Object)challengeFlowStarter, (String)"challengeFlowStarter");
            Intrinsics.checkParameterIsNotNull((Object)paymentRelayStarter, (String)"paymentRelayStarter");
            this.host = host;
            this.stripeRepository = stripeRepository;
            this.transaction = transaction;
            this.maxTimeout = maxTimeout;
            this.stripeIntent = stripeIntent;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
            this.analyticsRequestExecutor = analyticsRequestExecutor;
            this.analyticsDataFactory = analyticsDataFactory;
            this.challengeFlowStarter = challengeFlowStarter;
            this.enableLogging = enableLogging;
            this.paymentRelayStarter = paymentRelayStarter;
            this.analyticsRequestFactory = new AnalyticsRequest.Factory(Logger.Companion.getInstance$stripe_release(this.enableLogging));
        }

        public /* synthetic */ Stripe3ds2AuthCallback(AuthActivityStarter.Host host, StripeRepository stripeRepository, Transaction transaction, int n, StripeIntent stripeIntent, String string2, ApiRequest.Options options, AnalyticsRequestExecutor analyticsRequestExecutor, AnalyticsDataFactory analyticsDataFactory, ChallengeFlowStarter challengeFlowStarter, boolean bl, PaymentRelayStarter paymentRelayStarter, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x400) != 0) {
                bl = false;
            }
            if ((n2 & 0x800) != 0) {
                paymentRelayStarter = PaymentRelayStarter.Companion.create$stripe_release(host, Companion.getRequestCode$stripe_release(stripeIntent));
            }
            this(host, stripeRepository, transaction, n, stripeIntent, string2, options, analyticsRequestExecutor, analyticsDataFactory, challengeFlowStarter, bl, paymentRelayStarter);
        }

        public static final /* synthetic */ Transaction access$getTransaction$p(Stripe3ds2AuthCallback $this) {
            return $this.transaction;
        }

        public static final /* synthetic */ StripeRepository access$getStripeRepository$p(Stripe3ds2AuthCallback $this) {
            return $this.stripeRepository;
        }

        public static final /* synthetic */ StripeIntent access$getStripeIntent$p(Stripe3ds2AuthCallback $this) {
            return $this.stripeIntent;
        }

        public static final /* synthetic */ String access$getSourceId$p(Stripe3ds2AuthCallback $this) {
            return $this.sourceId;
        }

        public static final /* synthetic */ ApiRequest.Options access$getRequestOptions$p(Stripe3ds2AuthCallback $this) {
            return $this.requestOptions;
        }

        public static final /* synthetic */ AnalyticsRequestExecutor access$getAnalyticsRequestExecutor$p(Stripe3ds2AuthCallback $this) {
            return $this.analyticsRequestExecutor;
        }

        public static final /* synthetic */ AnalyticsDataFactory access$getAnalyticsDataFactory$p(Stripe3ds2AuthCallback $this) {
            return $this.analyticsDataFactory;
        }

        public static final /* synthetic */ AnalyticsRequest.Factory access$getAnalyticsRequestFactory$p(Stripe3ds2AuthCallback $this) {
            return $this.analyticsRequestFactory;
        }

        public static final /* synthetic */ int access$getMaxTimeout$p(Stripe3ds2AuthCallback $this) {
            return $this.maxTimeout;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$BG\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0016J&\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0016J\u0016\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0002J\u001e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0016J\u001e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0016J\u001e\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lcom/stripe/android/StripePaymentController$PaymentAuth3ds2ChallengeStatusReceiver;", "Lcom/stripe/android/stripe3ds2/transaction/StripeChallengeStatusReceiver;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "analyticsRequestExecutor", "Lcom/stripe/android/AnalyticsRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "analyticsRequestFactory", "Lcom/stripe/android/AnalyticsRequest$Factory;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/AnalyticsRequestExecutor;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/stripe3ds2/transaction/Transaction;Lcom/stripe/android/AnalyticsRequest$Factory;)V", "cancelled", "", "uiTypeCode", "onReceiverCompleted", "Lkotlin/Function0;", "completed", "completionEvent", "Lcom/stripe/android/stripe3ds2/transaction/CompletionEvent;", "notifyCompletion", "completed3ds2Callback", "protocolError", "protocolErrorEvent", "Lcom/stripe/android/stripe3ds2/transaction/ProtocolErrorEvent;", "runtimeError", "runtimeErrorEvent", "Lcom/stripe/android/stripe3ds2/transaction/RuntimeErrorEvent;", "timedout", "Companion", "stripe_release"})
    public static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        private final StripeRepository stripeRepository;
        private final StripeIntent stripeIntent;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;
        private final AnalyticsRequestExecutor analyticsRequestExecutor;
        private final AnalyticsDataFactory analyticsDataFactory;
        private final Transaction transaction;
        private final AnalyticsRequest.Factory analyticsRequestFactory;
        public static final Companion Companion = new Companion(null);

        public void completed(@NotNull CompletionEvent completionEvent, @NotNull String uiTypeCode, @NotNull Function0<Unit> onReceiverCompleted) {
            Intrinsics.checkParameterIsNotNull((Object)completionEvent, (String)"completionEvent");
            Intrinsics.checkParameterIsNotNull((Object)uiTypeCode, (String)"uiTypeCode");
            Intrinsics.checkParameterIsNotNull(onReceiverCompleted, (String)"onReceiverCompleted");
            super.completed(completionEvent, uiTypeCode, onReceiverCompleted);
            String string2 = this.stripeIntent.getId();
            AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds2ChallengeCompleted;
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.create3ds2ChallengeParams$stripe_release(analyticsEvent, string4, uiTypeCode), this.requestOptions, null, 4, null));
            this.notifyCompletion(onReceiverCompleted);
        }

        public void cancelled(@NotNull String uiTypeCode, @NotNull Function0<Unit> onReceiverCompleted) {
            Intrinsics.checkParameterIsNotNull((Object)uiTypeCode, (String)"uiTypeCode");
            Intrinsics.checkParameterIsNotNull(onReceiverCompleted, (String)"onReceiverCompleted");
            super.cancelled(uiTypeCode, onReceiverCompleted);
            String string2 = this.stripeIntent.getId();
            AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds2ChallengeCanceled;
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.create3ds2ChallengeParams$stripe_release(analyticsEvent, string4, uiTypeCode), this.requestOptions, null, 4, null));
            this.notifyCompletion(onReceiverCompleted);
        }

        public void timedout(@NotNull String uiTypeCode, @NotNull Function0<Unit> onReceiverCompleted) {
            Intrinsics.checkParameterIsNotNull((Object)uiTypeCode, (String)"uiTypeCode");
            Intrinsics.checkParameterIsNotNull(onReceiverCompleted, (String)"onReceiverCompleted");
            super.timedout(uiTypeCode, onReceiverCompleted);
            String string2 = this.stripeIntent.getId();
            AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds2ChallengeTimedOut;
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.create3ds2ChallengeParams$stripe_release(analyticsEvent, string4, uiTypeCode), this.requestOptions, null, 4, null));
            this.notifyCompletion(onReceiverCompleted);
        }

        public void protocolError(@NotNull ProtocolErrorEvent protocolErrorEvent, @NotNull Function0<Unit> onReceiverCompleted) {
            Intrinsics.checkParameterIsNotNull((Object)protocolErrorEvent, (String)"protocolErrorEvent");
            Intrinsics.checkParameterIsNotNull(onReceiverCompleted, (String)"onReceiverCompleted");
            super.protocolError(protocolErrorEvent, onReceiverCompleted);
            String string2 = this.stripeIntent.getId();
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.create3ds2ChallengeErrorParams$stripe_release(string4, protocolErrorEvent), this.requestOptions, null, 4, null));
            this.notifyCompletion(onReceiverCompleted);
        }

        public void runtimeError(@NotNull RuntimeErrorEvent runtimeErrorEvent, @NotNull Function0<Unit> onReceiverCompleted) {
            Intrinsics.checkParameterIsNotNull((Object)runtimeErrorEvent, (String)"runtimeErrorEvent");
            Intrinsics.checkParameterIsNotNull(onReceiverCompleted, (String)"onReceiverCompleted");
            super.runtimeError(runtimeErrorEvent, onReceiverCompleted);
            String string2 = this.stripeIntent.getId();
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.create3ds2ChallengeErrorParams$stripe_release(string4, runtimeErrorEvent), this.requestOptions, null, 4, null));
            this.notifyCompletion(onReceiverCompleted);
        }

        private final void notifyCompletion(Function0<Unit> completed3ds2Callback) {
            String string2 = this.stripeIntent.getId();
            AnalyticsEvent analyticsEvent = AnalyticsEvent.Auth3ds2ChallengePresented;
            AnalyticsDataFactory analyticsDataFactory = this.analyticsDataFactory;
            AnalyticsRequest.Factory factory = this.analyticsRequestFactory;
            AnalyticsRequestExecutor analyticsRequestExecutor = this.analyticsRequestExecutor;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            string2 = this.transaction.getInitialChallengeUiType();
            bl = false;
            String string5 = string2;
            if (string5 == null) {
                string5 = "";
            }
            String string6 = string5;
            analyticsRequestExecutor.executeAsync(AnalyticsRequest.Factory.create$stripe_release$default(factory, analyticsDataFactory.create3ds2ChallengeParams$stripe_release(analyticsEvent, string4, string6), this.requestOptions, null, 4, null));
            this.stripeRepository.complete3ds2Auth(this.sourceId, this.requestOptions, new ApiResultCallback<Boolean>(completed3ds2Callback){
                final /* synthetic */ Function0 $completed3ds2Callback;

                public void onSuccess(boolean result) {
                    this.$completed3ds2Callback.invoke();
                }

                public void onError(@NotNull Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                    this.$completed3ds2Callback.invoke();
                }
                {
                    this.$completed3ds2Callback = $captured_local_variable$0;
                }
            });
        }

        public PaymentAuth3ds2ChallengeStatusReceiver(@NotNull StripeRepository stripeRepository, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull Transaction transaction, @NotNull AnalyticsRequest.Factory analyticsRequestFactory) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
            Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
            Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
            Intrinsics.checkParameterIsNotNull((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
            this.stripeRepository = stripeRepository;
            this.stripeIntent = stripeIntent;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
            this.analyticsRequestExecutor = analyticsRequestExecutor;
            this.analyticsDataFactory = analyticsDataFactory;
            this.transaction = transaction;
            this.analyticsRequestFactory = analyticsRequestFactory;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JM\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/StripePaymentController$PaymentAuth3ds2ChallengeStatusReceiver$Companion;", "", "()V", "create", "Lcom/stripe/android/StripePaymentController$PaymentAuth3ds2ChallengeStatusReceiver;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "analyticsRequestExecutor", "Lcom/stripe/android/AnalyticsRequestExecutor;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "transaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "analyticsRequestFactory", "Lcom/stripe/android/AnalyticsRequest$Factory;", "create$stripe_release", "stripe_release"})
        public static final class Companion {
            @NotNull
            public final PaymentAuth3ds2ChallengeStatusReceiver create$stripe_release(@NotNull StripeRepository stripeRepository, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull Transaction transaction, @NotNull AnalyticsRequest.Factory analyticsRequestFactory) {
                Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
                Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
                Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
                Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
                Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
                Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
                Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
                Intrinsics.checkParameterIsNotNull((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
                return new PaymentAuth3ds2ChallengeStatusReceiver(stripeRepository, stripeIntent, sourceId, requestOptions, analyticsRequestExecutor, analyticsDataFactory, transaction, analyticsRequestFactory);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter;", "", "start", "", "runnable", "Ljava/lang/Runnable;", "Default", "stripe_release"})
    public static interface ChallengeFlowStarter {
        public void start(@NotNull Runnable var1);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\b"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter$Default;", "Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter;", "()V", "start", "", "runnable", "Ljava/lang/Runnable;", "Companion", "stripe_release"})
        public static final class Default
        implements ChallengeFlowStarter {
            private static final long DELAY_SECONDS = 2L;
            @Deprecated
            public static final Companion Companion = new Companion(null);

            @Override
            public void start(@NotNull Runnable runnable) {
                Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
                HandlerThread handlerThread = new HandlerThread(Stripe3ds2AuthCallback.class.getSimpleName());
                Handler handler = Default.Companion.createHandler(handlerThread);
                handler.postDelayed(new Runnable(runnable, handlerThread){
                    final /* synthetic */ Runnable $runnable;
                    final /* synthetic */ HandlerThread $handlerThread;

                    public final void run() {
                        this.$runnable.run();
                        this.$handlerThread.quitSafely();
                    }
                    {
                        this.$runnable = runnable;
                        this.$handlerThread = handlerThread;
                    }
                }, TimeUnit.SECONDS.toMillis(2L));
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeFlowStarter$Default$Companion;", "", "()V", "DELAY_SECONDS", "", "createHandler", "Landroid/os/Handler;", "handlerThread", "Landroid/os/HandlerThread;", "stripe_release"})
            private static final class Companion {
                private final Handler createHandler(HandlerThread handlerThread) {
                    handlerThread.start();
                    return new Handler(handlerThread.getLooper());
                }

                private Companion() {
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\fJ(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeProgressDialogActivityStarter;", "", "start", "", "context", "Landroid/content/Context;", "directoryServerName", "", "cancelable", "", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "Default", "stripe_release"})
    public static interface ChallengeProgressDialogActivityStarter {
        public void start(@NotNull Context var1, @NotNull String var2, boolean var3, @NotNull StripeUiCustomization var4);

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lcom/stripe/android/StripePaymentController$ChallengeProgressDialogActivityStarter$Default;", "Lcom/stripe/android/StripePaymentController$ChallengeProgressDialogActivityStarter;", "()V", "start", "", "context", "Landroid/content/Context;", "directoryServerName", "", "cancelable", "", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "stripe_release"})
        public static final class Default
        implements ChallengeProgressDialogActivityStarter {
            @Override
            public void start(@NotNull Context context, @NotNull String directoryServerName, boolean cancelable, @NotNull StripeUiCustomization uiCustomization) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)directoryServerName, (String)"directoryServerName");
                Intrinsics.checkParameterIsNotNull((Object)uiCustomization, (String)"uiCustomization");
                ChallengeProgressDialogActivity.Companion.show(context, directoryServerName, cancelable, uiCustomization);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JH\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J*\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007J\u0015\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0015\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0015\u0010 \u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b#J$\u0010&\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\n\u0010'\u001a\u00060(j\u0002`)H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"Lcom/stripe/android/StripePaymentController$Companion;", "", "()V", "EXPAND_PAYMENT_METHOD", "", "", "PAYMENT_REQUEST_CODE", "", "SETUP_REQUEST_CODE", "SOURCE_REQUEST_CODE", "beginWebAuth", "", "host", "Lcom/stripe/android/view/AuthActivityStarter$Host;", "requestCode", "clientSecret", "authUrl", "stripeAccount", "returnUrl", "enableLogging", "", "create", "Lcom/stripe/android/PaymentController;", "context", "Landroid/content/Context;", "publishableKey", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "getClientSecret", "data", "Landroid/content/Intent;", "getClientSecret$stripe_release", "getRequestCode", "params", "Lcom/stripe/android/model/ConfirmStripeIntentParams;", "getRequestCode$stripe_release", "intent", "Lcom/stripe/android/model/StripeIntent;", "handleError", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "stripe_release"})
    public static final class Companion {
        public final /* synthetic */ int getRequestCode$stripe_release(@NotNull StripeIntent intent) {
            Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
            return intent instanceof PaymentIntent ? 50000 : 50001;
        }

        public final /* synthetic */ int getRequestCode$stripe_release(@NotNull ConfirmStripeIntentParams params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            return params instanceof ConfirmPaymentIntentParams ? 50000 : 50001;
        }

        private final void beginWebAuth(AuthActivityStarter.Host host, int requestCode, String clientSecret, String authUrl, String stripeAccount, String returnUrl, boolean enableLogging) {
            Logger.Companion.getInstance$stripe_release(enableLogging).debug("PaymentAuthWebViewStarter#start()");
            PaymentAuthWebViewStarter starter = new PaymentAuthWebViewStarter(host, requestCode);
            starter.start(new PaymentAuthWebViewStarter.Args(clientSecret, authUrl, returnUrl, enableLogging, null, stripeAccount, 16, null));
        }

        static /* synthetic */ void beginWebAuth$default(Companion companion, AuthActivityStarter.Host host, int n, String string2, String string3, String string4, String string5, boolean bl, int n2, Object object) {
            if ((n2 & 0x20) != 0) {
                string5 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            companion.beginWebAuth(host, n, string2, string3, string4, string5, bl);
        }

        private final void handleError(AuthActivityStarter.Host host, int requestCode, Exception exception) {
            Exception exception2;
            PaymentRelayStarter.Companion.create$stripe_release(host, requestCode).start(PaymentRelayStarter.Args.Companion.create$stripe_release((exception2 = exception) instanceof StripeException ? (StripeException)exception : (StripeException)new APIException(exception)));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull String publishableKey, @NotNull StripeRepository stripeRepository, boolean enableLogging) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
            return new StripePaymentController(context2, publishableKey, stripeRepository, enableLogging, null, null, null, null, null, null, null, null, 4080, null);
        }

        public static /* synthetic */ PaymentController create$default(Companion companion, Context context, String string2, StripeRepository stripeRepository, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            return companion.create(context, string2, stripeRepository, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PaymentController create(@NotNull Context context, @NotNull String publishableKey, @NotNull StripeRepository stripeRepository) {
            return com.stripe.android.StripePaymentController$Companion.create$default(this, context, publishableKey, stripeRepository, false, 8, null);
        }

        @NotNull
        public final /* synthetic */ String getClientSecret$stripe_release(@NotNull Intent data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            PaymentController.Result result = PaymentController.Result.Companion.fromIntent$stripe_release(data);
            String string2 = result != null ? result.getClientSecret$stripe_release() : null;
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (string2 == null) {
                boolean bl4 = false;
                String string3 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

