/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import com.stripe.android.view.CountryUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a8\u0006\f"}, d2={"Lcom/stripe/android/view/PostalCodeValidator;", "", "()V", "isValid", "", "postalCode", "", "countryCode", "optionalShippingInfoFields", "", "hiddenShippingInfoFields", "Companion", "stripe_release"})
public final class PostalCodeValidator {
    private static final Map<String, Pattern> POSTAL_CODE_PATTERNS;
    @Deprecated
    public static final Companion Companion;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid(@NotNull String postalCode, @Nullable String countryCode, @NotNull List<String> optionalShippingInfoFields, @NotNull List<String> hiddenShippingInfoFields) {
        Intrinsics.checkParameterIsNotNull((Object)postalCode, (String)"postalCode");
        Intrinsics.checkParameterIsNotNull(optionalShippingInfoFields, (String)"optionalShippingInfoFields");
        Intrinsics.checkParameterIsNotNull(hiddenShippingInfoFields, (String)"hiddenShippingInfoFields");
        if (countryCode == null) {
            return false;
        }
        CharSequence charSequence = postalCode;
        boolean bl = false;
        if (charSequence.length() == 0 && PostalCodeValidator.Companion.isPostalCodeNotRequired(optionalShippingInfoFields, hiddenShippingInfoFields)) {
            return true;
        }
        Object object = POSTAL_CODE_PATTERNS.get(countryCode);
        if (object == null || (object = ((Pattern)object).matcher(postalCode)) == null) {
            if (!CountryUtils.INSTANCE.doesCountryUsePostalCode$stripe_release(countryCode)) return true;
            charSequence = postalCode;
            bl = false;
            if (StringsKt.isBlank((CharSequence)charSequence)) return false;
            return true;
        }
        boolean bl2 = ((Matcher)object).matches();
        return bl2;
    }

    static {
        Companion = new Companion(null);
        Pair[] pairArray = new Pair[2];
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        pairArray[0] = TuplesKt.to((Object)locale.getCountry(), (Object)Pattern.compile("^[0-9]{5}(?:-[0-9]{4})?$"));
        Locale locale2 = Locale.CANADA;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"Locale.CANADA");
        pairArray[1] = TuplesKt.to((Object)locale2.getCountry(), (Object)Pattern.compile("^(?!.*[DFIOQU])[A-VXY][0-9][A-Z] ?[0-9][A-Z][0-9]$"));
        POSTAL_CODE_PATTERNS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0002R*\u0010\u0003\u001a\u001e\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/PostalCodeValidator$Companion;", "", "()V", "POSTAL_CODE_PATTERNS", "", "", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "isPostalCodeNotRequired", "", "optionalShippingInfoFields", "", "hiddenShippingInfoFields", "stripe_release"})
    private static final class Companion {
        private final boolean isPostalCodeNotRequired(List<String> optionalShippingInfoFields, List<String> hiddenShippingInfoFields) {
            return optionalShippingInfoFields.contains("postal_code") || hiddenShippingInfoFields.contains("postal_code");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

