/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeError;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \"2\u00020\u0001:\u0005!\"#$%B!\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00192\b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u0012H\u0002J&\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000eJ.\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/stripe/android/IssuingCardPinService;", "", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/OperationIdFactory;)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "retrievalListeners", "", "", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "updateListeners", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "fireRetrievePinRequest", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operation", "Lcom/stripe/android/EphemeralOperation$Issuing$RetrievePin;", "listener", "fireUpdatePinRequest", "Lcom/stripe/android/EphemeralOperation$Issuing$UpdatePin;", "logMissingListener", "retrievePin", "cardId", "verificationId", "userOneTimeCode", "updatePin", "newPin", "CardPinActionError", "Companion", "IssuingCardPinRetrievalListener", "IssuingCardPinUpdateListener", "Listener", "stripe_release"})
public final class IssuingCardPinService {
    private final Map<String, IssuingCardPinRetrievalListener> retrievalListeners;
    private final Map<String, IssuingCardPinUpdateListener> updateListeners;
    private final EphemeralKeyManager ephemeralKeyManager;
    private final StripeRepository stripeRepository;
    private final OperationIdFactory operationIdFactory;
    private static final String TAG;
    public static final Companion Companion;

    public final void retrievePin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        this.retrievalListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(new EphemeralOperation.Issuing.RetrievePin(cardId, verificationId, userOneTimeCode, operationId));
    }

    public final void updatePin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinUpdateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)newPin, (String)"newPin");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        String operationId = this.operationIdFactory.create();
        this.updateListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(new EphemeralOperation.Issuing.UpdatePin(cardId, newPin, verificationId, userOneTimeCode, operationId));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireRetrievePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        if (listener == null) {
            this.logMissingListener();
            return;
        }
        try {
            String pin = this.stripeRepository.retrieveIssuingCardPin(operation.getCardId(), operation.getVerificationId(), operation.getUserOneTimeCode(), ephemeralKey.getSecret());
            listener.onIssuingCardPinRetrieved(pin);
            return;
        }
        catch (InvalidRequestException e) {
            StripeError stripeError = e.getStripeError();
            String string2 = stripeError != null ? stripeError.getCode() : null;
            if (string2 != null) {
                switch (string2) {
                    case "expired": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                        return;
                    }
                    case "incorrect_code": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect", null);
                        return;
                    }
                    case "too_many_attempts": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times", null);
                        return;
                    }
                    case "already_redeemed": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed", null);
                        return;
                    }
                }
            }
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to retrieve the PIN failed, possibly an error with the verification. Please check the exception.", e);
            return;
        }
        catch (APIConnectionException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (APIException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (AuthenticationException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (JSONException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (CardException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireUpdatePinRequest(EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        if (listener == null) {
            this.logMissingListener();
            return;
        }
        try {
            this.stripeRepository.updateIssuingCardPin(operation.getCardId(), operation.getNewPin(), operation.getVerificationId(), operation.getUserOneTimeCode(), ephemeralKey.getSecret());
            listener.onIssuingCardPinUpdated();
            return;
        }
        catch (InvalidRequestException e) {
            StripeError stripeError = e.getStripeError();
            String string2 = stripeError != null ? stripeError.getCode() : null;
            if (string2 != null) {
                switch (string2) {
                    case "expired": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                        return;
                    }
                    case "incorrect_code": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect", null);
                        return;
                    }
                    case "too_many_attempts": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times", null);
                        return;
                    }
                    case "already_redeemed": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed", null);
                        return;
                    }
                }
            }
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to update the PIN failed, possibly an error with the verification. Please check the exception.", e);
            return;
        }
        catch (APIConnectionException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
            return;
        }
        catch (APIException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
            return;
        }
        catch (AuthenticationException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
            return;
        }
        catch (CardException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
        }
    }

    private final void logMissingListener() {
        Log.e((String)TAG, (String)(this.getClass().getName() + " was called without a listener"));
    }

    @VisibleForTesting
    public IssuingCardPinService(@NotNull EphemeralKeyProvider keyProvider, @NotNull StripeRepository stripeRepository, @NotNull OperationIdFactory operationIdFactory) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)operationIdFactory, (String)"operationIdFactory");
        this.stripeRepository = stripeRepository;
        this.operationIdFactory = operationIdFactory;
        IssuingCardPinService issuingCardPinService = this;
        boolean bl = false;
        issuingCardPinService.retrievalListeners = map = (Map)new LinkedHashMap();
        issuingCardPinService = this;
        bl = false;
        issuingCardPinService.updateListeners = map = (Map)new LinkedHashMap();
        this.ephemeralKeyManager = new EphemeralKeyManager(keyProvider, new EphemeralKeyManager.KeyManagerListener(this){
            final /* synthetic */ IssuingCardPinService this$0;

            public void onKeyUpdate(@NotNull EphemeralKey ephemeralKey, @NotNull EphemeralOperation operation) {
                block5: {
                    EphemeralOperation ephemeralOperation;
                    block4: {
                        Intrinsics.checkParameterIsNotNull((Object)ephemeralKey, (String)"ephemeralKey");
                        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
                        ephemeralOperation = operation;
                        if (!(ephemeralOperation instanceof EphemeralOperation.Issuing.RetrievePin)) break block4;
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operation.getId$stripe_release());
                        if (issuingCardPinRetrievalListener != null) {
                            IssuingCardPinRetrievalListener issuingCardPinRetrievalListener2 = issuingCardPinRetrievalListener;
                            boolean bl = false;
                            boolean bl2 = false;
                            IssuingCardPinRetrievalListener listener = issuingCardPinRetrievalListener2;
                            boolean bl3 = false;
                            IssuingCardPinService.access$fireRetrievePinRequest(this.this$0, ephemeralKey, (EphemeralOperation.Issuing.RetrievePin)operation, listener);
                        } else {
                            IssuingCardPinService.access$logMissingListener(this.this$0);
                        }
                        break block5;
                    }
                    if (!(ephemeralOperation instanceof EphemeralOperation.Issuing.UpdatePin)) break block5;
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operation.getId$stripe_release());
                    if (issuingCardPinUpdateListener != null) {
                        IssuingCardPinUpdateListener issuingCardPinUpdateListener2 = issuingCardPinUpdateListener;
                        boolean bl = false;
                        boolean bl4 = false;
                        IssuingCardPinUpdateListener listener = issuingCardPinUpdateListener2;
                        boolean bl5 = false;
                        IssuingCardPinService.access$fireUpdatePinRequest(this.this$0, ephemeralKey, (EphemeralOperation.Issuing.UpdatePin)operation, listener);
                    } else {
                        IssuingCardPinService.access$logMissingListener(this.this$0);
                    }
                }
            }

            public void onKeyError(@NotNull String operationId, int errorCode, @NotNull String errorMessage) {
                block1: {
                    IssuingCardPinUpdateListener updateListener;
                    block0: {
                        IssuingCardPinRetrievalListener retrievalListener;
                        Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                        updateListener = (IssuingCardPinUpdateListener)IssuingCardPinService.access$getUpdateListeners$p(this.this$0).remove(operationId);
                        IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = retrievalListener = (IssuingCardPinRetrievalListener)IssuingCardPinService.access$getRetrievalListeners$p(this.this$0).remove(operationId);
                        if (issuingCardPinRetrievalListener == null) break block0;
                        issuingCardPinRetrievalListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                        break block1;
                    }
                    IssuingCardPinUpdateListener issuingCardPinUpdateListener = updateListener;
                    if (issuingCardPinUpdateListener == null) break block1;
                    issuingCardPinUpdateListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                }
            }
            {
                this.this$0 = $outer;
            }
        }, this.operationIdFactory, true, null, 0L, 48, null);
    }

    public /* synthetic */ IssuingCardPinService(EphemeralKeyProvider ephemeralKeyProvider, StripeRepository stripeRepository, OperationIdFactory operationIdFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        this(ephemeralKeyProvider, stripeRepository, operationIdFactory);
    }

    static {
        Companion = new Companion(null);
        String string2 = IssuingCardPinService.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"IssuingCardPinService::class.java.name");
        TAG = string2;
    }

    public static final /* synthetic */ Map access$getRetrievalListeners$p(IssuingCardPinService $this) {
        return $this.retrievalListeners;
    }

    public static final /* synthetic */ void access$fireRetrievePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.RetrievePin operation, IssuingCardPinRetrievalListener listener) {
        $this.fireRetrievePinRequest(ephemeralKey, operation, listener);
    }

    public static final /* synthetic */ void access$logMissingListener(IssuingCardPinService $this) {
        $this.logMissingListener();
    }

    public static final /* synthetic */ Map access$getUpdateListeners$p(IssuingCardPinService $this) {
        return $this.updateListeners;
    }

    public static final /* synthetic */ void access$fireUpdatePinRequest(IssuingCardPinService $this, EphemeralKey ephemeralKey, EphemeralOperation.Issuing.UpdatePin operation, IssuingCardPinUpdateListener listener) {
        $this.fireUpdatePinRequest(ephemeralKey, operation, listener);
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, keyProvider);
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, publishableKey, keyProvider);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "", "(Ljava/lang/String;I)V", "UNKNOWN_ERROR", "EPHEMERAL_KEY_ERROR", "ONE_TIME_CODE_INCORRECT", "ONE_TIME_CODE_EXPIRED", "ONE_TIME_CODE_TOO_MANY_ATTEMPTS", "ONE_TIME_CODE_ALREADY_REDEEMED", "stripe_release"})
    public static final class CardPinActionError
    extends Enum<CardPinActionError> {
        public static final /* enum */ CardPinActionError UNKNOWN_ERROR;
        public static final /* enum */ CardPinActionError EPHEMERAL_KEY_ERROR;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_INCORRECT;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_EXPIRED;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_TOO_MANY_ATTEMPTS;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_ALREADY_REDEEMED;
        private static final /* synthetic */ CardPinActionError[] $VALUES;

        static {
            CardPinActionError[] cardPinActionErrorArray = new CardPinActionError[6];
            CardPinActionError[] cardPinActionErrorArray2 = cardPinActionErrorArray;
            cardPinActionErrorArray[0] = UNKNOWN_ERROR = new CardPinActionError();
            cardPinActionErrorArray[1] = EPHEMERAL_KEY_ERROR = new CardPinActionError();
            cardPinActionErrorArray[2] = ONE_TIME_CODE_INCORRECT = new CardPinActionError();
            cardPinActionErrorArray[3] = ONE_TIME_CODE_EXPIRED = new CardPinActionError();
            cardPinActionErrorArray[4] = ONE_TIME_CODE_TOO_MANY_ATTEMPTS = new CardPinActionError();
            cardPinActionErrorArray[5] = ONE_TIME_CODE_ALREADY_REDEEMED = new CardPinActionError();
            $VALUES = cardPinActionErrorArray;
        }

        public static CardPinActionError[] values() {
            return (CardPinActionError[])$VALUES.clone();
        }

        public static CardPinActionError valueOf(String string2) {
            return Enum.valueOf(CardPinActionError.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinRetrieved", "", "pin", "", "stripe_release"})
    public static interface IssuingCardPinRetrievalListener
    extends Listener {
        public void onIssuingCardPinRetrieved(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "Lcom/stripe/android/IssuingCardPinService$Listener;", "onIssuingCardPinUpdated", "", "stripe_release"})
    public static interface IssuingCardPinUpdateListener
    extends Listener {
        public void onIssuingCardPinUpdated();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/IssuingCardPinService$Listener;", "", "onError", "", "errorCode", "Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "errorMessage", "", "exception", "", "stripe_release"})
    public static interface Listener {
        public void onError(@NotNull CardPinActionError var1, @Nullable String var2, @Nullable Throwable var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/IssuingCardPinService$Companion;", "", "()V", "TAG", "", "create", "Lcom/stripe/android/IssuingCardPinService;", "context", "Landroid/content/Context;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "publishableKey", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)keyProvider, (String)"keyProvider");
            return this.create(context, PaymentConfiguration.Companion.getInstance(context).getPublishableKey(), keyProvider);
        }

        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull String publishableKey, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull((Object)keyProvider, (String)"keyProvider");
            return new IssuingCardPinService(keyProvider, new StripeApiRepository(context, publishableKey, Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, null, null, null, 8184, null), new StripeOperationIdFactory());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

