/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "ErrorJsonParser", "stripe_release"})
public final class PaymentIntentJsonParser
implements ModelJsonParser<PaymentIntent> {
    private static final String OBJECT_TYPE = "payment_intent";
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CANCELED_AT = "canceled_at";
    private static final String FIELD_CANCELLATION_REASON = "cancellation_reason";
    private static final String FIELD_CAPTURE_METHOD = "capture_method";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_LAST_PAYMENT_ERROR = "last_payment_error";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_NEXT_ACTION = "next_action";
    private static final String FIELD_PAYMENT_METHOD_ID = "payment_method_id";
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    private static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_SETUP_FUTURE_USAGE = "setup_future_usage";
    @Deprecated
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public PaymentIntent parse(@NotNull JSONObject json) {
        PaymentIntent.Error error;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        if (Intrinsics.areEqual((Object)OBJECT_TYPE, (Object)json.optString(FIELD_OBJECT)) ^ true) {
            return null;
        }
        String id2 = StripeJsonUtils.optString(json, FIELD_ID);
        String objectType = StripeJsonUtils.optString(json, FIELD_OBJECT);
        List<String> paymentMethodTypes = ModelJsonParser.Companion.jsonArrayToList$stripe_release(json.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Long amount = StripeJsonUtils.INSTANCE.optLong$stripe_release(json, FIELD_AMOUNT);
        long canceledAt = json.optLong(FIELD_CANCELED_AT);
        PaymentIntent.CancellationReason cancellationReason = PaymentIntent.CancellationReason.Companion.fromCode$stripe_release(StripeJsonUtils.optString(json, FIELD_CANCELLATION_REASON));
        String captureMethod = StripeJsonUtils.optString(json, FIELD_CAPTURE_METHOD);
        String clientSecret = StripeJsonUtils.optString(json, FIELD_CLIENT_SECRET);
        String confirmationMethod = StripeJsonUtils.optString(json, FIELD_CONFIRMATION_METHOD);
        long created = json.optLong(FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency$stripe_release(json, FIELD_CURRENCY);
        String description = StripeJsonUtils.optString(json, FIELD_DESCRIPTION);
        boolean livemode = StripeJsonUtils.INSTANCE.optBoolean$stripe_release(json, FIELD_LIVEMODE);
        String paymentMethodId = StripeJsonUtils.optString(json, FIELD_PAYMENT_METHOD_ID);
        String receiptEmail = StripeJsonUtils.optString(json, FIELD_RECEIPT_EMAIL);
        StripeIntent.Status status = StripeIntent.Status.Companion.fromCode$stripe_release(StripeJsonUtils.optString(json, FIELD_STATUS));
        StripeIntent.Usage setupFutureUsage = StripeIntent.Usage.Companion.fromCode$stripe_release(StripeJsonUtils.optString(json, FIELD_SETUP_FUTURE_USAGE));
        Map<String, Object> nextAction = StripeJsonUtils.INSTANCE.optMap$stripe_release(json, FIELD_NEXT_ACTION);
        JSONObject jSONObject = json.optJSONObject(FIELD_LAST_PAYMENT_ERROR);
        if (jSONObject != null) {
            JSONObject jSONObject2 = jSONObject;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject it = jSONObject2;
            boolean bl3 = false;
            error = new ErrorJsonParser().parse(it);
        } else {
            error = null;
        }
        PaymentIntent.Error lastPaymentError = error;
        return new PaymentIntent(id2, objectType, paymentMethodTypes, amount, canceledAt, cancellationReason, captureMethod, clientSecret, confirmationMethod, created, currency, description, livemode, nextAction, paymentMethodId, receiptEmail, status, setupFutureUsage, lastPaymentError);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ErrorJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/PaymentIntent$Error;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
    public static final class ErrorJsonParser
    implements ModelJsonParser<PaymentIntent.Error> {
        private static final String FIELD_CHARGE = "charge";
        private static final String FIELD_CODE = "code";
        private static final String FIELD_DECLINE_CODE = "decline_code";
        private static final String FIELD_DOC_URL = "doc_url";
        private static final String FIELD_MESSAGE = "message";
        private static final String FIELD_PARAM = "param";
        private static final String FIELD_PAYMENT_METHOD = "payment_method";
        private static final String FIELD_TYPE = "type";
        @Deprecated
        public static final Companion Companion = new Companion(null);

        @Override
        @NotNull
        public PaymentIntent.Error parse(@NotNull JSONObject json) {
            PaymentMethod paymentMethod;
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            String string2 = StripeJsonUtils.optString(json, FIELD_CHARGE);
            String string3 = StripeJsonUtils.optString(json, FIELD_CODE);
            String string4 = StripeJsonUtils.optString(json, FIELD_DECLINE_CODE);
            String string5 = StripeJsonUtils.optString(json, FIELD_DOC_URL);
            String string6 = StripeJsonUtils.optString(json, FIELD_MESSAGE);
            String string7 = StripeJsonUtils.optString(json, FIELD_PARAM);
            JSONObject jSONObject = json.optJSONObject(FIELD_PAYMENT_METHOD);
            if (jSONObject != null) {
                JSONObject jSONObject2 = jSONObject;
                String string8 = string7;
                String string9 = string6;
                String string10 = string5;
                String string11 = string4;
                String string12 = string3;
                String string13 = string2;
                boolean bl = false;
                boolean bl2 = false;
                JSONObject it = jSONObject2;
                boolean bl3 = false;
                PaymentMethod paymentMethod2 = new PaymentMethodJsonParser().parse(it);
                string2 = string13;
                string3 = string12;
                string4 = string11;
                string5 = string10;
                string6 = string9;
                string7 = string8;
                paymentMethod = paymentMethod2;
            } else {
                paymentMethod = null;
            }
            PaymentIntent.Error.Type type = PaymentIntent.Error.Type.Companion.fromCode$stripe_release(StripeJsonUtils.optString(json, FIELD_TYPE));
            PaymentMethod paymentMethod3 = paymentMethod;
            String string14 = string7;
            String string15 = string6;
            String string16 = string5;
            String string17 = string4;
            String string18 = string3;
            String string19 = string2;
            return new PaymentIntent.Error(string19, string18, string17, string16, string15, string14, paymentMethod3, type);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$ErrorJsonParser$Companion;", "", "()V", "FIELD_CHARGE", "", "FIELD_CODE", "FIELD_DECLINE_CODE", "FIELD_DOC_URL", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_PAYMENT_METHOD", "FIELD_TYPE", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0014\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/model/parsers/PaymentIntentJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CANCELED_AT", "FIELD_CANCELLATION_REASON", "FIELD_CAPTURE_METHOD", "FIELD_CLIENT_SECRET", "FIELD_CONFIRMATION_METHOD", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_DESCRIPTION", "FIELD_ID", "FIELD_LAST_PAYMENT_ERROR", "FIELD_LIVEMODE", "FIELD_NEXT_ACTION", "FIELD_OBJECT", "FIELD_PAYMENT_METHOD_ID", "FIELD_PAYMENT_METHOD_TYPES", "FIELD_RECEIPT_EMAIL", "FIELD_SETUP_FUTURE_USAGE", "FIELD_STATUS", "OBJECT_TYPE", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

