/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.CustomerSession;
import com.stripe.android.Stripe;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.i18n.ErrorMessageTranslator;
import com.stripe.android.view.i18n.TranslatorManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/AddPaymentMethodViewModel;", "Landroidx/lifecycle/ViewModel;", "stripe", "Lcom/stripe/android/Stripe;", "customerSession", "Lcom/stripe/android/CustomerSession;", "args", "Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "errorMessageTranslator", "Lcom/stripe/android/view/i18n/ErrorMessageTranslator;", "(Lcom/stripe/android/Stripe;Lcom/stripe/android/CustomerSession;Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;Lcom/stripe/android/view/i18n/ErrorMessageTranslator;)V", "attachPaymentMethod", "Landroidx/lifecycle/LiveData;", "Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "attachPaymentMethod$stripe_release", "createPaymentMethod", "params", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "createPaymentMethod$stripe_release", "logProductUsage", "", "logProductUsage$stripe_release", "Factory", "PaymentMethodResult", "stripe_release"})
public final class AddPaymentMethodViewModel
extends ViewModel {
    private final Stripe stripe;
    private final CustomerSession customerSession;
    private final AddPaymentMethodActivityStarter.Args args;
    private final ErrorMessageTranslator errorMessageTranslator;

    public final /* synthetic */ void logProductUsage$stripe_release() {
        if (this.args.getShouldInitCustomerSessionTokens$stripe_release()) {
            this.customerSession.addProductUsageTokenIfValid$stripe_release("AddPaymentMethodActivity");
            if (this.args.isPaymentSessionActive$stripe_release()) {
                this.customerSession.addProductUsageTokenIfValid$stripe_release("PaymentSession");
            }
        }
    }

    @NotNull
    public final LiveData<PaymentMethodResult> createPaymentMethod$stripe_release(@NotNull PaymentMethodCreateParams params) {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        MutableLiveData resultData = new MutableLiveData();
        Stripe.createPaymentMethod$default(this.stripe, params, null, new ApiResultCallback<PaymentMethod>(resultData){
            final /* synthetic */ MutableLiveData $resultData;

            public void onSuccess(@NotNull PaymentMethod result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                this.$resultData.setValue((Object)new PaymentMethodResult.Success(result));
            }

            public void onError(@NotNull Exception e) {
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String string3 = e.getLocalizedMessage();
                MutableLiveData mutableLiveData = this.$resultData;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    string4 = "";
                }
                String string5 = string2 = string4;
                mutableLiveData.setValue((Object)new PaymentMethodResult.Error(string5));
            }
            {
                this.$resultData = $captured_local_variable$0;
            }
        }, 2, null);
        return (LiveData)resultData;
    }

    @NotNull
    public final /* synthetic */ LiveData<PaymentMethodResult> attachPaymentMethod$stripe_release(@NotNull PaymentMethod paymentMethod) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
        MutableLiveData resultData = new MutableLiveData();
        String string2 = paymentMethod.id;
        CustomerSession customerSession2 = this.customerSession;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string3;
        customerSession2.attachPaymentMethod(string4, new CustomerSession.PaymentMethodRetrievalListener(this, resultData){
            final /* synthetic */ AddPaymentMethodViewModel this$0;
            final /* synthetic */ MutableLiveData $resultData;

            public void onPaymentMethodRetrieved(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                this.$resultData.setValue((Object)new PaymentMethodResult.Success(paymentMethod));
            }

            public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                this.$resultData.setValue((Object)new PaymentMethodResult.Error(AddPaymentMethodViewModel.access$getErrorMessageTranslator$p(this.this$0).translate(errorCode, errorMessage, stripeError)));
            }
            {
                this.this$0 = $outer;
                this.$resultData = $captured_local_variable$1;
            }
        });
        return (LiveData)resultData;
    }

    public AddPaymentMethodViewModel(@NotNull Stripe stripe2, @NotNull CustomerSession customerSession2, @NotNull AddPaymentMethodActivityStarter.Args args2, @NotNull ErrorMessageTranslator errorMessageTranslator) {
        Intrinsics.checkParameterIsNotNull((Object)stripe2, (String)"stripe");
        Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
        Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)errorMessageTranslator, (String)"errorMessageTranslator");
        this.stripe = stripe2;
        this.customerSession = customerSession2;
        this.args = args2;
        this.errorMessageTranslator = errorMessageTranslator;
    }

    public /* synthetic */ AddPaymentMethodViewModel(Stripe stripe2, CustomerSession customerSession2, AddPaymentMethodActivityStarter.Args args2, ErrorMessageTranslator errorMessageTranslator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            errorMessageTranslator = TranslatorManager.INSTANCE.getErrorMessageTranslator();
        }
        this(stripe2, customerSession2, args2, errorMessageTranslator);
    }

    public static final /* synthetic */ ErrorMessageTranslator access$getErrorMessageTranslator$p(AddPaymentMethodViewModel $this) {
        return $this.errorMessageTranslator;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "", "()V", "Error", "Success", "Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Success;", "Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Error;", "stripe_release"})
    public static abstract class PaymentMethodResult {
        private PaymentMethodResult() {
        }

        public /* synthetic */ PaymentMethodResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Success;", "Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "(Lcom/stripe/android/model/PaymentMethod;)V", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class Success
        extends PaymentMethodResult {
            @NotNull
            private final PaymentMethod paymentMethod;

            @NotNull
            public final PaymentMethod getPaymentMethod() {
                return this.paymentMethod;
            }

            public Success(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                super(null);
                this.paymentMethod = paymentMethod;
            }

            @NotNull
            public final PaymentMethod component1() {
                return this.paymentMethod;
            }

            @NotNull
            public final Success copy(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                return new Success(paymentMethod);
            }

            public static /* synthetic */ Success copy$default(Success success, PaymentMethod paymentMethod, int n, Object object) {
                if ((n & 1) != 0) {
                    paymentMethod = success.paymentMethod;
                }
                return success.copy(paymentMethod);
            }

            @NotNull
            public String toString() {
                return "Success(paymentMethod=" + this.paymentMethod + ")";
            }

            public int hashCode() {
                PaymentMethod paymentMethod = this.paymentMethod;
                return paymentMethod != null ? ((Object)paymentMethod).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Success)) break block3;
                        Success success = (Success)object;
                        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)success.paymentMethod)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult$Error;", "Lcom/stripe/android/view/AddPaymentMethodViewModel$PaymentMethodResult;", "errorMessage", "", "(Ljava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stripe_release"})
        public static final class Error
        extends PaymentMethodResult {
            @NotNull
            private final String errorMessage;

            @NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            public Error(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                super(null);
                this.errorMessage = errorMessage;
            }

            @NotNull
            public final String component1() {
                return this.errorMessage;
            }

            @NotNull
            public final Error copy(@NotNull String errorMessage) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                return new Error(errorMessage);
            }

            public static /* synthetic */ Error copy$default(Error error, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = error.errorMessage;
                }
                return error.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Error(errorMessage=" + this.errorMessage + ")";
            }

            public int hashCode() {
                String string2 = this.errorMessage;
                return string2 != null ? string2.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Error)) break block3;
                        Error error = (Error)object;
                        if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)error.errorMessage)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ'\u0010\t\u001a\u0002H\n\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/AddPaymentMethodViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "stripe", "Lcom/stripe/android/Stripe;", "customerSession", "Lcom/stripe/android/CustomerSession;", "args", "Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "(Lcom/stripe/android/Stripe;Lcom/stripe/android/CustomerSession;Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final Stripe stripe;
        private final CustomerSession customerSession;
        private final AddPaymentMethodActivityStarter.Args args;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
            return (T)((Object)new AddPaymentMethodViewModel(this.stripe, this.customerSession, this.args, null, 8, null));
        }

        public Factory(@NotNull Stripe stripe2, @NotNull CustomerSession customerSession2, @NotNull AddPaymentMethodActivityStarter.Args args2) {
            Intrinsics.checkParameterIsNotNull((Object)stripe2, (String)"stripe");
            Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
            Intrinsics.checkParameterIsNotNull((Object)args2, (String)"args");
            this.stripe = stripe2;
            this.customerSession = customerSession2;
            this.args = args2;
        }
    }
}

