/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AppInfo;
import com.stripe.android.CustomerSessionEphemeralKeyManagerListener;
import com.stripe.android.CustomerSessionHandler;
import com.stripe.android.CustomerSessionProductUsage;
import com.stripe.android.CustomerSessionRunnableFactory;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeError;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\f\u0018\u0000 b2\u00020\u0001:\n^_`abcdefgB;\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rBM\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0014J\u001e\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020:J\u0017\u0010;\u001a\u0002062\b\u0010<\u001a\u0004\u0018\u00010\tH\u0001\u00a2\u0006\u0002\b=J\u0016\u0010>\u001a\u0002062\u0006\u0010?\u001a\u00020\t2\u0006\u00109\u001a\u00020@J\b\u0010A\u001a\u00020BH\u0002J\u0016\u0010C\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00109\u001a\u00020:J\u0016\u0010D\u001a\u0002062\u0006\u0010?\u001a\u00020\t2\u0006\u00109\u001a\u00020@J\b\u0010E\u001a\u00020\u000fH\u0002J#\u0010F\u001a\u0004\u0018\u0001HG\"\n\b\u0000\u0010G*\u0004\u0018\u00010*2\u0006\u0010H\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010IJ\u0016\u0010J\u001a\u0002062\u0006\u0010K\u001a\u00020L2\u0006\u00109\u001a\u00020MJ\u0018\u0010N\u001a\u0002062\u0006\u0010H\u001a\u00020\t2\u0006\u0010O\u001a\u00020PH\u0002J\r\u0010Q\u001a\u000206H\u0000\u00a2\u0006\u0002\bRJ\u000e\u0010S\u001a\u0002062\u0006\u00109\u001a\u00020TJ\u001e\u0010U\u001a\u0002062\u0006\u00107\u001a\u00020\t2\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020TJ\u0016\u0010V\u001a\u0002062\u0006\u0010W\u001a\u00020X2\u0006\u00109\u001a\u00020TJ2\u0010Y\u001a\u0002062\b\u0010Z\u001a\u0004\u0018\u00010\t2\u0014\u0010[\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\\2\b\u00109\u001a\u0004\u0018\u00010*H\u0002J\u000e\u0010]\u001a\u0002062\u0006\u00109\u001a\u00020TR\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010/\u001a\b\u0012\u0004\u0012\u00020\t008@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b1\u00102\u001a\u0004\b3\u00104R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/stripe/android/CustomerSession;", "", "context", "Landroid/content/Context;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "appInfo", "Lcom/stripe/android/AppInfo;", "publishableKey", "", "stripeAccountId", "shouldPrefetchEphemeralKey", "", "(Landroid/content/Context;Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/AppInfo;Ljava/lang/String;Ljava/lang/String;Z)V", "proxyNowCalendar", "Ljava/util/Calendar;", "threadPoolExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "(Landroid/content/Context;Lcom/stripe/android/EphemeralKeyProvider;Ljava/util/Calendar;Ljava/util/concurrent/ThreadPoolExecutor;Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Z)V", "cachedCustomer", "Lcom/stripe/android/model/Customer;", "getCachedCustomer", "()Lcom/stripe/android/model/Customer;", "canUseCachedCustomer", "getCanUseCachedCustomer", "()Z", "customer", "getCustomer$stripe_release", "setCustomer$stripe_release", "(Lcom/stripe/android/model/Customer;)V", "customerCacheTime", "", "getCustomerCacheTime$stripe_release", "()J", "setCustomerCacheTime$stripe_release", "(J)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "listeners", "", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "operationIdFactory", "Lcom/stripe/android/StripeOperationIdFactory;", "productUsage", "Lcom/stripe/android/CustomerSessionProductUsage;", "productUsageTokens", "", "productUsageTokens$annotations", "()V", "getProductUsageTokens$stripe_release", "()Ljava/util/Set;", "addCustomerSource", "", "sourceId", "sourceType", "listener", "Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "addProductUsageTokenIfValid", "token", "addProductUsageTokenIfValid$stripe_release", "attachPaymentMethod", "paymentMethodId", "Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "createHandler", "Landroid/os/Handler;", "deleteCustomerSource", "detachPaymentMethod", "getCalendarInstance", "getListener", "L", "operationId", "(Ljava/lang/String;)Lcom/stripe/android/CustomerSession$RetrievalListener;", "getPaymentMethods", "paymentMethodType", "Lcom/stripe/android/model/PaymentMethod$Type;", "Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "handleRetrievalError", "exception", "Lcom/stripe/android/exception/StripeException;", "resetUsageTokens", "resetUsageTokens$stripe_release", "retrieveCurrentCustomer", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "setCustomerDefaultSource", "setCustomerShippingInformation", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "startOperation", "action", "arguments", "", "updateCurrentCustomer", "ActivityCustomerRetrievalListener", "ActivityPaymentMethodRetrievalListener", "ActivityPaymentMethodsRetrievalListener", "ActivitySourceRetrievalListener", "Companion", "CustomerRetrievalListener", "PaymentMethodRetrievalListener", "PaymentMethodsRetrievalListener", "RetrievalListener", "SourceRetrievalListener", "stripe_release"})
public final class CustomerSession {
    private /* synthetic */ long customerCacheTime;
    @Nullable
    private /* synthetic */ Customer customer;
    private final StripeOperationIdFactory operationIdFactory;
    private final CustomerSessionProductUsage productUsage;
    private final Map<String, RetrievalListener> listeners;
    private final EphemeralKeyManager ephemeralKeyManager;
    private final Calendar proxyNowCalendar;
    private final ThreadPoolExecutor threadPoolExecutor;
    @NotNull
    public static final String ACTION_ADD_SOURCE = "add_source";
    @NotNull
    public static final String ACTION_DELETE_SOURCE = "delete_source";
    @NotNull
    public static final String ACTION_ATTACH_PAYMENT_METHOD = "attach_payment_method";
    @NotNull
    public static final String ACTION_DETACH_PAYMENT_METHOD = "detach_payment_method";
    @NotNull
    public static final String ACTION_GET_PAYMENT_METHODS = "get_payment_methods";
    @NotNull
    public static final String ACTION_SET_DEFAULT_SOURCE = "default_source";
    @NotNull
    public static final String ACTION_SET_CUSTOMER_SHIPPING_INFO = "set_shipping_info";
    @NotNull
    public static final String KEY_PAYMENT_METHOD = "payment_method";
    @NotNull
    public static final String KEY_PAYMENT_METHOD_TYPE = "payment_method_type";
    @NotNull
    public static final String KEY_SOURCE = "source";
    @NotNull
    public static final String KEY_SOURCE_TYPE = "source_type";
    @NotNull
    public static final String KEY_SHIPPING_INFO = "shipping_info";
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private static final long KEY_REFRESH_BUFFER_IN_SECONDS = 30L;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS;
    @Nullable
    private static /* synthetic */ CustomerSession instance;
    public static final Companion Companion;

    public final long getCustomerCacheTime$stripe_release() {
        return this.customerCacheTime;
    }

    public final void setCustomerCacheTime$stripe_release(long l) {
        this.customerCacheTime = l;
    }

    @Nullable
    public final Customer getCustomer$stripe_release() {
        return this.customer;
    }

    public final void setCustomer$stripe_release(@Nullable Customer customer) {
        this.customer = customer;
    }

    @VisibleForTesting
    public static /* synthetic */ void productUsageTokens$annotations() {
    }

    @NotNull
    public final Set<String> getProductUsageTokens$stripe_release() {
        return this.productUsage.get();
    }

    private final Handler createHandler() {
        return new CustomerSessionHandler(new CustomerSessionHandler.Listener(this){
            final /* synthetic */ CustomerSession this$0;

            public void onCustomerRetrieved(@Nullable Customer customer, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    this.this$0.setCustomer$stripe_release(customer);
                    this.this$0.setCustomerCacheTime$stripe_release(CustomerSession.access$getCalendarInstance(this.this$0).getTimeInMillis());
                    CustomerRetrievalListener listener = (CustomerRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (customer == null) break block1;
                    CustomerRetrievalListener customerRetrievalListener = listener;
                    if (customerRetrievalListener != null) {
                        customerRetrievalListener.onCustomerRetrieved(customer);
                    }
                }
            }

            public void onSourceRetrieved(@Nullable Source source, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    SourceRetrievalListener listener = (SourceRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (source == null) break block1;
                    SourceRetrievalListener sourceRetrievalListener = listener;
                    if (sourceRetrievalListener != null) {
                        sourceRetrievalListener.onSourceRetrieved(source);
                    }
                }
            }

            public void onPaymentMethodRetrieved(@Nullable PaymentMethod paymentMethod, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    PaymentMethodRetrievalListener listener = (PaymentMethodRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (paymentMethod == null) break block1;
                    PaymentMethodRetrievalListener paymentMethodRetrievalListener = listener;
                    if (paymentMethodRetrievalListener != null) {
                        paymentMethodRetrievalListener.onPaymentMethodRetrieved(paymentMethod);
                    }
                }
            }

            public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods, @NotNull String operationId) {
                block0: {
                    PaymentMethodsRetrievalListener listener;
                    Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    PaymentMethodsRetrievalListener paymentMethodsRetrievalListener = listener = (PaymentMethodsRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (paymentMethodsRetrievalListener == null) break block0;
                    paymentMethodsRetrievalListener.onPaymentMethodsRetrieved(paymentMethods);
                }
            }

            public void onCustomerShippingInfoSaved(@Nullable Customer customer, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    this.this$0.setCustomer$stripe_release(customer);
                    CustomerRetrievalListener listener = (CustomerRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (customer == null) break block1;
                    CustomerRetrievalListener customerRetrievalListener = listener;
                    if (customerRetrievalListener != null) {
                        customerRetrievalListener.onCustomerRetrieved(customer);
                    }
                }
            }

            public void onError(@NotNull StripeException exception, @NotNull String operationId) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                CustomerSession.access$handleRetrievalError(this.this$0, operationId, exception);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final /* synthetic */ void addProductUsageTokenIfValid$stripe_release(@Nullable String token) {
        this.productUsage.add(token);
    }

    public final void retrieveCurrentCustomer(@NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Customer customer = this.getCachedCustomer();
        if (customer != null) {
            Customer customer2 = customer;
            boolean bl = false;
            boolean bl2 = false;
            Customer it = customer2;
            boolean bl3 = false;
            listener.onCustomerRetrieved(it);
        } else {
            this.updateCurrentCustomer(listener);
        }
    }

    public final void updateCurrentCustomer(@NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.customer = null;
        this.startOperation(null, null, listener);
    }

    @Nullable
    public final Customer getCachedCustomer() {
        Customer customer = this.customer;
        boolean bl = false;
        boolean bl2 = false;
        Customer it = customer;
        boolean bl3 = false;
        return this.getCanUseCachedCustomer() ? customer : null;
    }

    public final void addCustomerSource(@NotNull String sourceId, @NotNull String sourceType, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KEY_SOURCE, (Object)sourceId), TuplesKt.to((Object)KEY_SOURCE_TYPE, (Object)sourceType)});
        this.startOperation(ACTION_ADD_SOURCE, arguments, listener);
    }

    public final void deleteCustomerSource(@NotNull String sourceId, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair)TuplesKt.to((Object)KEY_SOURCE, (Object)sourceId));
        this.startOperation(ACTION_DELETE_SOURCE, arguments, listener);
    }

    public final void attachPaymentMethod(@NotNull String paymentMethodId, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair)TuplesKt.to((Object)KEY_PAYMENT_METHOD, (Object)paymentMethodId));
        this.startOperation(ACTION_ATTACH_PAYMENT_METHOD, arguments, listener);
    }

    public final void detachPaymentMethod(@NotNull String paymentMethodId, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair)TuplesKt.to((Object)KEY_PAYMENT_METHOD, (Object)paymentMethodId));
        this.startOperation(ACTION_DETACH_PAYMENT_METHOD, arguments, listener);
    }

    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair)TuplesKt.to((Object)KEY_PAYMENT_METHOD_TYPE, (Object)paymentMethodType2.code));
        this.startOperation(ACTION_GET_PAYMENT_METHODS, arguments, listener);
    }

    public final void setCustomerShippingInformation(@NotNull ShippingInformation shippingInformation, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair)TuplesKt.to((Object)KEY_SHIPPING_INFO, (Object)shippingInformation));
        this.startOperation(ACTION_SET_CUSTOMER_SHIPPING_INFO, arguments, listener);
    }

    public final void setCustomerDefaultSource(@NotNull String sourceId, @NotNull String sourceType, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)KEY_SOURCE, (Object)sourceId), TuplesKt.to((Object)KEY_SOURCE_TYPE, (Object)sourceType)});
        this.startOperation(ACTION_SET_DEFAULT_SOURCE, arguments, listener);
    }

    private final void startOperation(String action, Map<String, ? extends Object> arguments, RetrievalListener listener) {
        String operationId = this.operationIdFactory.create();
        this.listeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey(operationId, action, arguments);
    }

    public final /* synthetic */ void resetUsageTokens$stripe_release() {
        this.productUsage.reset();
    }

    private final boolean getCanUseCachedCustomer() {
        long currentTime = this.getCalendarInstance().getTimeInMillis();
        return this.customer != null && currentTime - this.customerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    private final void handleRetrievalError(String operationId, StripeException exception) {
        RetrievalListener retrievalListener = this.listeners.remove(operationId);
        if (retrievalListener != null) {
            RetrievalListener retrievalListener2 = retrievalListener;
            boolean bl = false;
            boolean bl2 = false;
            RetrievalListener listener = retrievalListener2;
            boolean bl3 = false;
            String string = exception.getLocalizedMessage();
            boolean bl4 = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            String message = string2;
            listener.onError(exception.getStatusCode(), message, exception.getStripeError());
        }
        this.resetUsageTokens$stripe_release();
    }

    private final Calendar getCalendarInstance() {
        Calendar calendar = this.proxyNowCalendar;
        if (calendar == null) {
            Calendar calendar2 = Calendar.getInstance();
            calendar = calendar2;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"Calendar.getInstance()");
        }
        return calendar;
    }

    private final <L extends RetrievalListener> L getListener(String operationId) {
        return (L)this.listeners.remove(operationId);
    }

    @VisibleForTesting
    public CustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider, @Nullable Calendar proxyNowCalendar, @NotNull ThreadPoolExecutor threadPoolExecutor, @NotNull StripeRepository stripeRepository, @NotNull String publishableKey, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkParameterIsNotNull((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        this.proxyNowCalendar = proxyNowCalendar;
        this.threadPoolExecutor = threadPoolExecutor;
        this.operationIdFactory = new StripeOperationIdFactory();
        this.productUsage = new CustomerSessionProductUsage();
        CustomerSession customerSession2 = this;
        boolean bl = false;
        customerSession2.listeners = map = (Map)new LinkedHashMap();
        CustomerSessionEphemeralKeyManagerListener keyManagerListener = new CustomerSessionEphemeralKeyManagerListener(new CustomerSessionRunnableFactory(stripeRepository, this.createHandler(), publishableKey, stripeAccountId, this.productUsage), this.threadPoolExecutor, this.listeners, this.productUsage);
        this.ephemeralKeyManager = new EphemeralKeyManager(keyProvider, keyManagerListener, 30L, this.proxyNowCalendar, this.operationIdFactory, shouldPrefetchEphemeralKey);
    }

    public /* synthetic */ CustomerSession(Context context, EphemeralKeyProvider ephemeralKeyProvider, Calendar calendar, ThreadPoolExecutor threadPoolExecutor, StripeRepository stripeRepository, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            calendar = null;
        }
        this(context, ephemeralKeyProvider, calendar, threadPoolExecutor, stripeRepository, string, string2, bl);
    }

    private CustomerSession(Context context, EphemeralKeyProvider keyProvider, AppInfo appInfo, String publishableKey, String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        this(context, keyProvider, null, CustomerSession.Companion.createThreadPoolExecutor(), new StripeApiRepository(context, appInfo, null, null, null, null, null, null, null, null, null, 2044, null), publishableKey, stripeAccountId, shouldPrefetchEphemeralKey);
    }

    static {
        Companion = new Companion(null);
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    }

    public static final /* synthetic */ Calendar access$getCalendarInstance(CustomerSession $this) {
        return $this.getCalendarInstance();
    }

    public static final /* synthetic */ RetrievalListener access$getListener(CustomerSession $this, String operationId) {
        return $this.getListener(operationId);
    }

    public static final /* synthetic */ void access$handleRetrievalError(CustomerSession $this, String operationId, StripeException exception) {
        $this.handleRetrievalError(operationId, exception);
    }

    public /* synthetic */ CustomerSession(Context context, EphemeralKeyProvider keyProvider, AppInfo appInfo, String publishableKey, String stripeAccountId, boolean shouldPrefetchEphemeralKey, DefaultConstructorMarker $constructor_marker) {
        this(context, keyProvider, appInfo, publishableKey, stripeAccountId, shouldPrefetchEphemeralKey);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        Companion.initCustomerSession(context, ephemeralKeyProvider, stripeAccountId, shouldPrefetchEphemeralKey);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId) {
        com.stripe.android.CustomerSession$Companion.initCustomerSession$default(Companion, context, ephemeralKeyProvider, stripeAccountId, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider) {
        com.stripe.android.CustomerSession$Companion.initCustomerSession$default(Companion, context, ephemeralKeyProvider, null, false, 12, null);
    }

    @JvmStatic
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
        Companion.initCustomerSession(context, ephemeralKeyProvider, shouldPrefetchEphemeralKey);
    }

    @JvmStatic
    @NotNull
    public static final CustomerSession getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void endCustomerSession() {
        Companion.endCustomerSession();
    }

    @JvmStatic
    public static final void cancelCallbacks() {
        Companion.cancelCallbacks();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivityCustomerRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivityCustomerRetrievalListener<A extends Activity>
    implements CustomerRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityCustomerRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onCustomerRetrieved", "", "customer", "Lcom/stripe/android/model/Customer;", "stripe_release"})
    public static interface CustomerRetrievalListener
    extends RetrievalListener {
        public void onCustomerRetrieved(@NotNull Customer var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onSourceRetrieved", "", "source", "Lcom/stripe/android/model/Source;", "stripe_release"})
    public static interface SourceRetrievalListener
    extends RetrievalListener {
        public void onSourceRetrieved(@NotNull Source var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onPaymentMethodRetrieved", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface PaymentMethodRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodRetrieved(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onPaymentMethodsRetrieved", "", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface PaymentMethodsRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$RetrievalListener;", "", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "stripe_release"})
    public static interface RetrievalListener {
        public void onError(int var1, @NotNull String var2, @Nullable StripeError var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivityPaymentMethodsRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivityPaymentMethodsRetrievalListener<A extends Activity>
    implements PaymentMethodsRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityPaymentMethodsRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivitySourceRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivitySourceRetrievalListener<A extends Activity>
    implements SourceRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivitySourceRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivityPaymentMethodRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivityPaymentMethodRetrievalListener<A extends Activity>
    implements PaymentMethodRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityPaymentMethodRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\r\u0010 \u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020\u001fH\u0007J\b\u0010%\u001a\u00020\u0019H\u0007J \u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0007J.\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010+\u001a\u00020,H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006."}, d2={"Lcom/stripe/android/CustomerSession$Companion;", "", "()V", "ACTION_ADD_SOURCE", "", "ACTION_ATTACH_PAYMENT_METHOD", "ACTION_DELETE_SOURCE", "ACTION_DETACH_PAYMENT_METHOD", "ACTION_GET_PAYMENT_METHODS", "ACTION_SET_CUSTOMER_SHIPPING_INFO", "ACTION_SET_DEFAULT_SOURCE", "CUSTOMER_CACHE_DURATION_MILLISECONDS", "", "KEEP_ALIVE_TIME", "", "KEEP_ALIVE_TIME_UNIT", "Ljava/util/concurrent/TimeUnit;", "KEY_PAYMENT_METHOD", "KEY_PAYMENT_METHOD_TYPE", "KEY_REFRESH_BUFFER_IN_SECONDS", "KEY_SHIPPING_INFO", "KEY_SOURCE", "KEY_SOURCE_TYPE", "THREAD_POOL_SIZE", "instance", "Lcom/stripe/android/CustomerSession;", "getInstance$stripe_release", "()Lcom/stripe/android/CustomerSession;", "setInstance$stripe_release", "(Lcom/stripe/android/CustomerSession;)V", "cancelCallbacks", "", "clearInstance", "clearInstance$stripe_release", "createThreadPoolExecutor", "Ljava/util/concurrent/ThreadPoolExecutor;", "endCustomerSession", "getInstance", "initCustomerSession", "context", "Landroid/content/Context;", "ephemeralKeyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "shouldPrefetchEphemeralKey", "", "stripeAccountId", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
            this.setInstance$stripe_release(new CustomerSession(context, ephemeralKeyProvider, Stripe.Companion.getAppInfo(), PaymentConfiguration.Companion.getInstance(context).getPublishableKey(), stripeAccountId, shouldPrefetchEphemeralKey, null));
        }

        public static /* synthetic */ void initCustomerSession$default(Companion companion, Context context, EphemeralKeyProvider ephemeralKeyProvider, String string, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                string = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            companion.initCustomerSession(context, ephemeralKeyProvider, string, bl);
        }

        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId) {
            com.stripe.android.CustomerSession$Companion.initCustomerSession$default(this, context, ephemeralKeyProvider, stripeAccountId, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider) {
            com.stripe.android.CustomerSession$Companion.initCustomerSession$default(this, context, ephemeralKeyProvider, null, false, 12, null);
        }

        @JvmStatic
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
            this.initCustomerSession(context, ephemeralKeyProvider, null, shouldPrefetchEphemeralKey);
        }

        @Nullable
        public final CustomerSession getInstance$stripe_release() {
            return instance;
        }

        public final void setInstance$stripe_release(@Nullable CustomerSession customerSession2) {
            instance = customerSession2;
        }

        @JvmStatic
        @NotNull
        public final CustomerSession getInstance() {
            CustomerSession customerSession2 = this.getInstance$stripe_release();
            boolean bl = false;
            boolean bl2 = false;
            if (customerSession2 == null) {
                boolean bl3 = false;
                String string = "Attempted to get instance of CustomerSession without initialization.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return customerSession2;
        }

        @JvmStatic
        public final void endCustomerSession() {
            this.clearInstance$stripe_release();
        }

        @VisibleForTesting
        public final /* synthetic */ void clearInstance$stripe_release() {
            Object object = this.getInstance$stripe_release();
            if (object != null && (object = ((CustomerSession)object).listeners) != null) {
                object.clear();
            }
            this.cancelCallbacks();
            this.setInstance$stripe_release(null);
        }

        @JvmStatic
        public final void cancelCallbacks() {
            block0: {
                Object object = this.getInstance$stripe_release();
                if (object == null || (object = ((CustomerSession)object).threadPoolExecutor) == null) break block0;
                ((ThreadPoolExecutor)object).shutdownNow();
            }
        }

        private final ThreadPoolExecutor createThreadPoolExecutor() {
            return new ThreadPoolExecutor(3, 3, 2, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

