/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.CardBrand;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import com.stripe.android.view.ViewUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0014\u0018\u0000 :2\u00020\u0001:\u0001:B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010-\u001a\u00020\u0010H\u0002J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u00020\u000fH\u0002J\u0015\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b2J\r\u00103\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b4J%\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b9R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR<\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R,\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f8\u0006@@X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0013\u0010\u001e\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020'2\u0006\u0010\u0016\u001a\u00020'@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006;"}, d2={"Lcom/stripe/android/view/CardNumberEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "accessibilityText", "", "getAccessibilityText", "()Ljava/lang/String;", "callback", "Lkotlin/Function1;", "Lcom/stripe/android/model/CardBrand;", "", "brandChangeCallback", "getBrandChangeCallback$stripe_release", "()Lkotlin/jvm/functions/Function1;", "setBrandChangeCallback$stripe_release", "(Lkotlin/jvm/functions/Function1;)V", "<set-?>", "cardBrand", "cardBrand$annotations", "()V", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "setCardBrand$stripe_release", "(Lcom/stripe/android/model/CardBrand;)V", "cardNumber", "getCardNumber", "completionCallback", "Lkotlin/Function0;", "getCompletionCallback$stripe_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$stripe_release", "(Lkotlin/jvm/functions/Function0;)V", "ignoreChanges", "", "isCardNumberValid", "()Z", "lengthMax", "getLengthMax", "()I", "listenForTextChanges", "updateCardBrand", "brand", "updateCardBrandFromNumber", "partialNumber", "updateCardBrandFromNumber$stripe_release", "updateLengthFilter", "updateLengthFilter$stripe_release", "updateSelectionIndex", "newLength", "editActionStart", "editActionAddition", "updateSelectionIndex$stripe_release", "Companion", "stripe_release"})
public final class CardNumberEditText
extends StripeEditText {
    @NotNull
    private CardBrand cardBrand;
    @NotNull
    private /* synthetic */ Function1<? super CardBrand, Unit> brandChangeCallback;
    @NotNull
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean ignoreChanges;
    private boolean isCardNumberValid;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    @VisibleForTesting
    public static /* synthetic */ void cardBrand$annotations() {
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public final void setCardBrand$stripe_release(@NotNull CardBrand cardBrand) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)cardBrand), (String)"<set-?>");
        this.cardBrand = cardBrand;
    }

    @NotNull
    public final Function1<CardBrand, Unit> getBrandChangeCallback$stripe_release() {
        return this.brandChangeCallback;
    }

    public final void setBrandChangeCallback$stripe_release(@NotNull Function1<? super CardBrand, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.brandChangeCallback = callback;
        callback.invoke((Object)this.cardBrand);
    }

    @NotNull
    public final Function0<Unit> getCompletionCallback$stripe_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$stripe_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final int getLengthMax() {
        return this.cardBrand.getMaxLengthWithSpaces();
    }

    public final boolean isCardNumberValid() {
        return this.isCardNumberValid;
    }

    @Nullable
    public final String getCardNumber() {
        return this.isCardNumberValid ? StripeTextUtils.removeSpacesAndHyphens(this.getFieldText()) : null;
    }

    @Override
    @Nullable
    protected String getAccessibilityText() {
        return this.getResources().getString(R.string.acc_label_card_number_node, new Object[]{this.getText()});
    }

    public final /* synthetic */ void updateLengthFilter$stripe_release() {
        this.setFilters(new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(this.getLengthMax())});
    }

    public final /* synthetic */ int updateSelectionIndex$stripe_release(int newLength, int editActionStart, int editActionAddition) {
        int gapsJumped = 0;
        Set<Integer> gapSet = this.cardBrand.getSpacePositions();
        boolean skipBack = false;
        Iterable $this$forEach$iv = gapSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int gap = ((Number)element$iv).intValue();
            boolean bl = false;
            if (editActionStart <= gap && editActionStart + editActionAddition > gap) {
                int n = gapsJumped;
                gapsJumped = n + 1;
            }
            if (editActionAddition != 0 || editActionStart != gap + 1) continue;
            skipBack = true;
        }
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        return newPosition <= newLength ? newPosition : newLength;
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new StripeTextWatcher(this){
            private int latestChangeStart;
            private int latestInsertionSize;
            private Integer newCursorPosition;
            private String formattedNumber;
            final /* synthetic */ CardNumberEditText this$0;

            public void beforeTextChanged(@Nullable CharSequence s, int start2, int count, int after) {
                if (!CardNumberEditText.access$getIgnoreChanges$p(this.this$0)) {
                    this.latestChangeStart = start2;
                    this.latestInsertionSize = after;
                }
            }

            public void onTextChanged(@Nullable CharSequence s, int start2, int before, int count) {
                String inputText;
                if (CardNumberEditText.access$getIgnoreChanges$p(this.this$0)) {
                    return;
                }
                CharSequence charSequence = s;
                String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = inputText = "";
                }
                if (start2 < 4) {
                    this.this$0.updateCardBrandFromNumber$stripe_release(inputText);
                }
                if (start2 > 16) {
                    return;
                }
                String string4 = StripeTextUtils.removeSpacesAndHyphens(inputText);
                if (string4 == null) {
                    return;
                }
                String spacelessNumber = string4;
                String formattedNumber = CardNumberEditText.Companion.createFormattedNumber$stripe_release(ViewUtils.separateCardNumberGroups(spacelessNumber, this.this$0.getCardBrand()));
                this.newCursorPosition = this.this$0.updateSelectionIndex$stripe_release(formattedNumber.length(), this.latestChangeStart, this.latestInsertionSize);
                this.formattedNumber = formattedNumber;
            }

            public void afterTextChanged(@Nullable Editable s) {
                if (CardNumberEditText.access$getIgnoreChanges$p(this.this$0)) {
                    return;
                }
                CardNumberEditText.access$setIgnoreChanges$p(this.this$0, true);
                if (!this.this$0.isLastKeyDelete() && this.formattedNumber != null) {
                    this.this$0.setText(this.formattedNumber);
                    Integer n = this.newCursorPosition;
                    if (n != null) {
                        Integer n2 = n;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = ((Number)n2).intValue();
                        boolean bl3 = false;
                        this.this$0.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)this.this$0.getFieldText().length()));
                    }
                }
                this.formattedNumber = null;
                this.newCursorPosition = null;
                CardNumberEditText.access$setIgnoreChanges$p(this.this$0, false);
                if (this.this$0.getFieldText().length() == this.this$0.getLengthMax()) {
                    boolean wasCardNumberValid = this.this$0.isCardNumberValid();
                    CardNumberEditText.access$setCardNumberValid$p(this.this$0, CardUtils.isValidCardNumber(this.this$0.getFieldText()));
                    this.this$0.setShouldShowError(!this.this$0.isCardNumberValid());
                    if (!wasCardNumberValid && this.this$0.isCardNumberValid()) {
                        this.this$0.getCompletionCallback$stripe_release().invoke();
                    }
                } else {
                    CardNumberEditText.access$setCardNumberValid$p(this.this$0, CardUtils.isValidCardNumber(this.this$0.getFieldText()));
                    this.this$0.setShouldShowError(false);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void updateCardBrand(CardBrand brand) {
        if (this.cardBrand == brand) {
            return;
        }
        int oldLength = this.getLengthMax();
        this.cardBrand = brand;
        this.brandChangeCallback.invoke((Object)this.cardBrand);
        if (oldLength != this.getLengthMax()) {
            this.updateLengthFilter$stripe_release();
        }
    }

    public final /* synthetic */ void updateCardBrandFromNumber$stripe_release(@NotNull String partialNumber) {
        Intrinsics.checkParameterIsNotNull((Object)partialNumber, (String)"partialNumber");
        this.updateCardBrand(CardUtils.getPossibleCardType(partialNumber));
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.cardBrand = CardBrand.Unknown;
        this.brandChangeCallback = brandChangeCallback.1.INSTANCE;
        this.completionCallback = completionCallback.1.INSTANCE;
        this.setErrorMessage(this.getResources().getString(R.string.invalid_card_number));
        this.listenForTextChanges();
    }

    public /* synthetic */ CardNumberEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardNumberEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreChanges$p(CardNumberEditText $this) {
        return $this.ignoreChanges;
    }

    public static final /* synthetic */ void access$setIgnoreChanges$p(CardNumberEditText $this, boolean bl) {
        $this.ignoreChanges = bl;
    }

    public static final /* synthetic */ boolean access$isCardNumberValid$p(CardNumberEditText $this) {
        return $this.isCardNumberValid;
    }

    public static final /* synthetic */ void access$setCardNumberValid$p(CardNumberEditText $this, boolean bl) {
        $this.isCardNumberValid = bl;
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/CardNumberEditText$Companion;", "", "()V", "createFormattedNumber", "", "cardParts", "", "createFormattedNumber$stripe_release", "([Ljava/lang/String;)Ljava/lang/String;", "stripe_release"})
    public static final class Companion {
        @NotNull
        public final /* synthetic */ String createFormattedNumber$stripe_release(@NotNull String[] cardParts) {
            Intrinsics.checkParameterIsNotNull((Object)cardParts, (String)"cardParts");
            String[] $this$takeWhile$iv = cardParts;
            boolean $i$f$takeWhile = false;
            ArrayList<String> list$iv = new ArrayList<String>();
            String[] stringArray = $this$takeWhile$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String item$iv;
                String it = item$iv = stringArray[i];
                boolean bl = false;
                if (!(it != null)) break;
                list$iv.add(item$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)list$iv, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

