/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.stripe.android.CustomerSession;
import com.stripe.android.StripeError;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentMethod;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel;", "Landroidx/lifecycle/ViewModel;", "customerSession", "Lcom/stripe/android/CustomerSession;", "selectedPaymentMethodId", "", "(Lcom/stripe/android/CustomerSession;Ljava/lang/String;)V", "getSelectedPaymentMethodId$stripe_release", "()Ljava/lang/String;", "setSelectedPaymentMethodId$stripe_release", "(Ljava/lang/String;)V", "getPaymentMethods", "Landroidx/lifecycle/LiveData;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "getPaymentMethods$stripe_release", "Factory", "Result", "stripe_release"})
public final class PaymentMethodsViewModel
extends ViewModel {
    private final CustomerSession customerSession;
    @Nullable
    private String selectedPaymentMethodId;

    @NotNull
    public final /* synthetic */ LiveData<Result> getPaymentMethods$stripe_release() {
        MutableLiveData resultData = new MutableLiveData();
        this.customerSession.getPaymentMethods(PaymentMethod.Type.Card, new CustomerSession.PaymentMethodsRetrievalListener(resultData){
            final /* synthetic */ MutableLiveData $resultData;

            public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                this.$resultData.setValue((Object)new Result.Success(paymentMethods));
            }

            public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                this.$resultData.setValue((Object)new Result.Error(new APIException(stripeError, null, errorCode, errorMessage, null, 18, null)));
            }
            {
                this.$resultData = $captured_local_variable$0;
            }
        });
        return (LiveData)resultData;
    }

    @Nullable
    public final String getSelectedPaymentMethodId$stripe_release() {
        return this.selectedPaymentMethodId;
    }

    public final void setSelectedPaymentMethodId$stripe_release(@Nullable String string2) {
        this.selectedPaymentMethodId = string2;
    }

    public PaymentMethodsViewModel(@NotNull CustomerSession customerSession2, @Nullable String selectedPaymentMethodId) {
        Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
        this.customerSession = customerSession2;
        this.selectedPaymentMethodId = selectedPaymentMethodId;
    }

    public /* synthetic */ PaymentMethodsViewModel(CustomerSession customerSession2, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(customerSession2, string2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "", "()V", "Error", "Success", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Success;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Error;", "stripe_release"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Success;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "(Ljava/util/List;)V", "getPaymentMethods", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class Success
        extends Result {
            @NotNull
            private final List<PaymentMethod> paymentMethods;

            @NotNull
            public final List<PaymentMethod> getPaymentMethods() {
                return this.paymentMethods;
            }

            public Success(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                super(null);
                this.paymentMethods = paymentMethods;
            }

            @NotNull
            public final List<PaymentMethod> component1() {
                return this.paymentMethods;
            }

            @NotNull
            public final Success copy(@NotNull List<PaymentMethod> paymentMethods) {
                Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                return new Success(paymentMethods);
            }

            public static /* synthetic */ Success copy$default(Success success, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = success.paymentMethods;
                }
                return success.copy(list);
            }

            @NotNull
            public String toString() {
                return "Success(paymentMethods=" + this.paymentMethods + ")";
            }

            public int hashCode() {
                List<PaymentMethod> list = this.paymentMethods;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Success)) break block3;
                        Success success = (Success)object;
                        if (!Intrinsics.areEqual(this.paymentMethods, success.paymentMethods)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Result$Error;", "Lcom/stripe/android/view/PaymentMethodsViewModel$Result;", "exception", "Lcom/stripe/android/exception/StripeException;", "(Lcom/stripe/android/exception/StripeException;)V", "getException", "()Lcom/stripe/android/exception/StripeException;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stripe_release"})
        public static final class Error
        extends Result {
            @NotNull
            private final StripeException exception;

            @NotNull
            public final StripeException getException() {
                return this.exception;
            }

            public Error(@NotNull StripeException exception) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
            }

            @NotNull
            public final StripeException component1() {
                return this.exception;
            }

            @NotNull
            public final Error copy(@NotNull StripeException exception) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                return new Error(exception);
            }

            public static /* synthetic */ Error copy$default(Error error, StripeException stripeException, int n, Object object) {
                if ((n & 1) != 0) {
                    stripeException = error.exception;
                }
                return error.copy(stripeException);
            }

            @NotNull
            public String toString() {
                return "Error(exception=" + this.exception + ")";
            }

            public int hashCode() {
                StripeException stripeException = this.exception;
                return stripeException != null ? stripeException.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Error)) break block3;
                        Error error = (Error)object;
                        if (!Intrinsics.areEqual((Object)this.exception, (Object)error.exception)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010\u0007\u001a\u0002H\b\"\n\b\u0000\u0010\b*\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\b0\u000bH\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/PaymentMethodsViewModel$Factory;", "Landroidx/lifecycle/ViewModelProvider$Factory;", "customerSession", "Lcom/stripe/android/CustomerSession;", "initialPaymentMethodId", "", "(Lcom/stripe/android/CustomerSession;Ljava/lang/String;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "modelClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    implements ViewModelProvider.Factory {
        private final CustomerSession customerSession;
        private final String initialPaymentMethodId;

        public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
            Intrinsics.checkParameterIsNotNull(modelClass, (String)"modelClass");
            return (T)((Object)new PaymentMethodsViewModel(this.customerSession, this.initialPaymentMethodId));
        }

        public Factory(@NotNull CustomerSession customerSession2, @Nullable String initialPaymentMethodId) {
            Intrinsics.checkParameterIsNotNull((Object)customerSession2, (String)"customerSession");
            this.customerSession = customerSession2;
            this.initialPaymentMethodId = initialPaymentMethodId;
        }
    }
}

