/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.StripeError;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.parsers.ModelJsonParser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/StripeErrorJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/StripeError;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
public final class StripeErrorJsonParser
implements ModelJsonParser<StripeError> {
    @NotNull
    public static final String MALFORMED_RESPONSE_MESSAGE = "An improperly formatted error response was found.";
    private static final String FIELD_CHARGE = "charge";
    private static final String FIELD_CODE = "code";
    private static final String FIELD_DECLINE_CODE = "decline_code";
    private static final String FIELD_DOC_URL = "doc_url";
    private static final String FIELD_ERROR = "error";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_PARAM = "param";
    private static final String FIELD_TYPE = "type";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public StripeError parse(@NotNull JSONObject json) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        try {
            object = json.getJSONObject(FIELD_ERROR);
            boolean bl = false;
            boolean bl2 = false;
            JSONObject errorObject = object;
            boolean bl3 = false;
            String string = StripeJsonUtils.optString(errorObject, FIELD_DOC_URL);
            String string2 = StripeJsonUtils.optString(errorObject, FIELD_TYPE);
            String string3 = StripeJsonUtils.optString(errorObject, FIELD_PARAM);
            String string4 = StripeJsonUtils.optString(errorObject, FIELD_MESSAGE);
            String string5 = StripeJsonUtils.optString(errorObject, FIELD_DECLINE_CODE);
            String string6 = StripeJsonUtils.optString(errorObject, FIELD_CODE);
            String string7 = StripeJsonUtils.optString(errorObject, FIELD_CHARGE);
            object = new StripeError(string2, string4, string6, string3, string5, string7, string);
        }
        catch (JSONException jsonException) {
            object = new StripeError(null, MALFORMED_RESPONSE_MESSAGE, null, null, null, null, null, 125, null);
        }
        return object;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/StripeErrorJsonParser$Companion;", "", "()V", "FIELD_CHARGE", "", "FIELD_CODE", "FIELD_DECLINE_CODE", "FIELD_DOC_URL", "FIELD_ERROR", "FIELD_MESSAGE", "FIELD_PARAM", "FIELD_TYPE", "MALFORMED_RESPONSE_MESSAGE", "MALFORMED_RESPONSE_MESSAGE$annotations", "stripe_release"})
    public static final class Companion {
        @VisibleForTesting
        public static /* synthetic */ void MALFORMED_RESPONSE_MESSAGE$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

