/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Transformation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.R;
import com.stripe.android.model.Address;
import com.stripe.android.model.Card;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardInputWidget$WhenMappings;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardWidget;
import com.stripe.android.view.CvcEditText;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.PostalCodeEditText;
import com.stripe.android.view.StripeEditText;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 \u00b3\u00012\u00020\u00012\u00020\u0002:\u001c\u00af\u0001\u00b0\u0001\u00b1\u0001\u00b2\u0001\u00b3\u0001\u00b4\u0001\u00b5\u0001\u00b6\u0001\u00b7\u0001\u00b8\u0001\u00b9\u0001\u00ba\u0001\u00bb\u0001\u00bc\u0001B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010j\u001a\u00020k2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010l\u001a\u00020k2\u0006\u0010m\u001a\u00020(H\u0002J\b\u0010n\u001a\u00020kH\u0016J\u0018\u0010o\u001a\u00020\b2\u0006\u0010p\u001a\u0002032\u0006\u0010q\u001a\u00020\fH\u0002J\u0017\u0010r\u001a\u0004\u0018\u00010s2\u0006\u0010t\u001a\u00020\bH\u0001\u00a2\u0006\u0002\buJ\u0012\u0010v\u001a\u00020k2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010w\u001a\u00020(H\u0016J\u0010\u0010x\u001a\u00020(2\u0006\u0010y\u001a\u00020zH\u0016J1\u0010{\u001a\u00020k2\u0006\u0010|\u001a\u00020(2\u0006\u0010}\u001a\u00020\b2\u0006\u0010~\u001a\u00020\b2\u0006\u0010\u007f\u001a\u00020\b2\u0007\u0010\u0080\u0001\u001a\u00020\bH\u0014J\u0013\u0010\u0081\u0001\u001a\u00020k2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0014J\n\u0010\u0084\u0001\u001a\u00030\u0083\u0001H\u0014J\u0012\u0010\u0085\u0001\u001a\u00020k2\u0007\u0010\u0086\u0001\u001a\u00020(H\u0016J\t\u0010\u0087\u0001\u001a\u00020kH\u0002J\t\u0010\u0088\u0001\u001a\u00020kH\u0002J\u0012\u0010\u0089\u0001\u001a\u00020k2\u0007\u0010\u008a\u0001\u001a\u000203H\u0016J\u0014\u0010\u008b\u0001\u001a\u00020k2\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010$H\u0016J\u0014\u0010\u008d\u0001\u001a\u00020k2\t\u0010\u008e\u0001\u001a\u0004\u0018\u000103H\u0016J\u0013\u0010\u008f\u0001\u001a\u00020k2\n\u0010\u0090\u0001\u001a\u0005\u0018\u00010\u0091\u0001J\u0014\u0010\u0092\u0001\u001a\u00020k2\t\u0010\u0093\u0001\u001a\u0004\u0018\u000103H\u0016J\u0013\u0010\u0094\u0001\u001a\u00020k2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0091\u0001J\u0011\u0010\u0096\u0001\u001a\u00020k2\u0006\u0010w\u001a\u00020(H\u0016J\u001f\u0010\u0097\u0001\u001a\u00020k2\t\b\u0001\u0010\u0098\u0001\u001a\u00020\b2\t\b\u0001\u0010\u0099\u0001\u001a\u00020\bH\u0016J\u0013\u0010\u009a\u0001\u001a\u00020k2\n\u0010\u009b\u0001\u001a\u0005\u0018\u00010\u0091\u0001J\u001a\u0010\u009c\u0001\u001a\u00020k2\t\u0010\u009d\u0001\u001a\u0004\u0018\u000103H\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u0019\u0010\u009f\u0001\u001a\u00020k2\u000e\u0010\u00a0\u0001\u001a\t\u0012\u0005\u0012\u00030\u00a1\u00010\u000bH\u0002J$\u0010\u00a2\u0001\u001a\u00020k2\u0007\u0010\u00a3\u0001\u001a\u00020s2\u0007\u0010\u00a4\u0001\u001a\u00020\b2\u0007\u0010\u00a5\u0001\u001a\u00020\bH\u0002J\t\u0010\u00a6\u0001\u001a\u00020kH\u0002J\u001d\u0010\u00a7\u0001\u001a\u00020k2\u0007\u0010\u00a8\u0001\u001a\u00020(2\t\u0010\u00a9\u0001\u001a\u0004\u0018\u000103H\u0002J\t\u0010\u00aa\u0001\u001a\u00020kH\u0002J\u0011\u0010\u00ab\u0001\u001a\u00020k2\u0006\u0010w\u001a\u00020(H\u0002J\u0018\u0010\u00ac\u0001\u001a\u00020k2\u0007\u0010\u00ad\u0001\u001a\u00020(H\u0001\u00a2\u0006\u0003\b\u00ae\u0001R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u0001038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00105R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R \u0010@\u001a\b\u0012\u0004\u0012\u00020\b0AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0014\u0010F\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u00105R\u000e\u0010H\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010I\u001a\u00020JX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010L\"\u0004\bM\u0010NR\u0016\u0010O\u001a\u0004\u0018\u00010P8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u0016\u0010S\u001a\u0004\u0018\u00010T8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0014\u0010W\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u00105R\u0014\u0010Y\u001a\u00020ZX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\\R\u000e\u0010]\u001a\u00020^X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010`\u001a\u00020(2\u0006\u0010_\u001a\u00020(@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010*\"\u0004\bb\u0010,R\u000e\u0010c\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010d\u001a\u0004\u0018\u0001038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\be\u00105R\"\u0010f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bg\u0010\u000e\u001a\u0004\bh\u0010\u0010R\u0012\u0010i\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00bd\u0001"}, d2={"Lcom/stripe/android/view/CardInputWidget;", "Landroid/widget/LinearLayout;", "Lcom/stripe/android/view/CardWidget;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "allFields", "", "Lcom/stripe/android/view/StripeEditText;", "allFields$annotations", "()V", "getAllFields$stripe_release", "()Ljava/util/List;", "billingDetails", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "getBillingDetails", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "brand", "Lcom/stripe/android/model/CardBrand;", "getBrand", "()Lcom/stripe/android/model/CardBrand;", "card", "Lcom/stripe/android/model/Card;", "getCard", "()Lcom/stripe/android/model/Card;", "cardBuilder", "Lcom/stripe/android/model/Card$Builder;", "getCardBuilder", "()Lcom/stripe/android/model/Card$Builder;", "cardIconImageView", "Landroid/widget/ImageView;", "cardInputListener", "Lcom/stripe/android/view/CardInputListener;", "cardNumberEditText", "Lcom/stripe/android/view/CardNumberEditText;", "cardNumberIsViewed", "", "getCardNumberIsViewed$stripe_release", "()Z", "setCardNumberIsViewed$stripe_release", "(Z)V", "cardNumberTextInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "cvcNumberEditText", "Lcom/stripe/android/view/CvcEditText;", "cvcNumberTextInputLayout", "cvcPlaceHolder", "", "getCvcPlaceHolder", "()Ljava/lang/String;", "cvcValue", "getCvcValue", "expiryDateEditText", "Lcom/stripe/android/view/ExpiryDateEditText;", "expiryDateTextInputLayout", "frameLayout", "Landroid/widget/FrameLayout;", "frameWidth", "getFrameWidth", "()I", "frameWidthSupplier", "Lkotlin/Function0;", "getFrameWidthSupplier$stripe_release", "()Lkotlin/jvm/functions/Function0;", "setFrameWidthSupplier$stripe_release", "(Lkotlin/jvm/functions/Function0;)V", "hiddenCardText", "getHiddenCardText", "initFlag", "layoutWidthCalculator", "Lcom/stripe/android/view/CardInputWidget$LayoutWidthCalculator;", "getLayoutWidthCalculator$stripe_release", "()Lcom/stripe/android/view/CardInputWidget$LayoutWidthCalculator;", "setLayoutWidthCalculator$stripe_release", "(Lcom/stripe/android/view/CardInputWidget$LayoutWidthCalculator;)V", "paymentMethodCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "getPaymentMethodCard", "()Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodCreateParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "peekCardText", "getPeekCardText", "placementParameters", "Lcom/stripe/android/view/CardInputWidget$PlacementParameters;", "getPlacementParameters$stripe_release", "()Lcom/stripe/android/view/CardInputWidget$PlacementParameters;", "postalCodeEditText", "Lcom/stripe/android/view/PostalCodeEditText;", "value", "postalCodeEnabled", "getPostalCodeEnabled", "setPostalCodeEnabled", "postalCodeTextInputLayout", "postalCodeValue", "getPostalCodeValue", "standardFields", "standardFields$annotations", "getStandardFields$stripe_release", "tintColorInt", "applyAttributes", "", "applyTint", "isCvc", "clear", "getDesiredWidthInPixels", "text", "editText", "getFocusRequestOnTouch", "Landroid/view/View;", "touchX", "getFocusRequestOnTouch$stripe_release", "initView", "isEnabled", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onLayout", "changed", "l", "t", "r", "b", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onWindowFocusChanged", "hasWindowFocus", "scrollLeft", "scrollRight", "setCardHint", "cardHint", "setCardInputListener", "listener", "setCardNumber", "cardNumber", "setCardNumberTextWatcher", "cardNumberTextWatcher", "Landroid/text/TextWatcher;", "setCvcCode", "cvcCode", "setCvcNumberTextWatcher", "cvcNumberTextWatcher", "setEnabled", "setExpiryDate", "month", "year", "setExpiryDateTextWatcher", "expiryDateTextWatcher", "setPostalCode", "postalCode", "setPostalCode$stripe_release", "startSlideAnimation", "animations", "Landroid/view/animation/Animation;", "updateFieldLayout", "view", "width", "leftMargin", "updateIcon", "updateIconCvc", "hasFocus", "cvcText", "updateIconForCvcEntry", "updatePostalCodeEditText", "updateSpaceSizes", "isCardViewed", "updateSpaceSizes$stripe_release", "AnimationEndListener", "CardFieldAnimation", "CardNumberSlideLeftAnimation", "CardNumberSlideRightAnimation", "Companion", "CvcSlideLeftAnimation", "CvcSlideRightAnimation", "DefaultLayoutWidthCalculator", "ExpiryDateSlideLeftAnimation", "ExpiryDateSlideRightAnimation", "LayoutWidthCalculator", "PlacementParameters", "PostalCodeSlideLeftAnimation", "PostalCodeSlideRightAnimation", "stripe_release"})
public final class CardInputWidget
extends LinearLayout
implements CardWidget {
    private final ImageView cardIconImageView;
    private final FrameLayout frameLayout;
    private final TextInputLayout cardNumberTextInputLayout;
    private final TextInputLayout expiryDateTextInputLayout;
    private final TextInputLayout cvcNumberTextInputLayout;
    private final TextInputLayout postalCodeTextInputLayout;
    private final CardNumberEditText cardNumberEditText;
    private final ExpiryDateEditText expiryDateEditText;
    private final CvcEditText cvcNumberEditText;
    private final PostalCodeEditText postalCodeEditText;
    private CardInputListener cardInputListener;
    private /* synthetic */ boolean cardNumberIsViewed;
    @ColorInt
    private int tintColorInt;
    private boolean initFlag;
    @NotNull
    private /* synthetic */ LayoutWidthCalculator layoutWidthCalculator;
    @NotNull
    private final PlacementParameters placementParameters;
    @NotNull
    private final /* synthetic */ List<StripeEditText> standardFields;
    @NotNull
    private /* synthetic */ Function0<Integer> frameWidthSupplier;
    private boolean postalCodeEnabled;
    @NotNull
    public static final String LOGGING_TOKEN = "CardInputView";
    private static final String PEEK_TEXT_COMMON = "4242";
    private static final String PEEK_TEXT_DINERS = "88";
    private static final String PEEK_TEXT_AMEX = "34343";
    private static final String CVC_PLACEHOLDER_COMMON = "CVC";
    private static final String CVC_PLACEHOLDER_AMEX = "2345";
    private static final String HIDDEN_TEXT_AMEX = "3434 343434 ";
    private static final String HIDDEN_TEXT_COMMON = "4242 4242 4242 ";
    private static final String FULL_SIZING_CARD_TEXT = "4242 4242 4242 4242";
    private static final String FULL_SIZING_DATE_TEXT = "MM/MM";
    private static final String FULL_SIZING_POSTAL_CODE_TEXT = "1234567890";
    private static final String STATE_CARD_VIEWED = "state_card_viewed";
    private static final String STATE_SUPER_STATE = "state_super_state";
    private static final String STATE_POSTAL_CODE_ENABLED = "state_postal_code_enabled";
    @IdRes
    private static final int DEFAULT_READER_ID;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    public final boolean getCardNumberIsViewed$stripe_release() {
        return this.cardNumberIsViewed;
    }

    public final void setCardNumberIsViewed$stripe_release(boolean bl) {
        this.cardNumberIsViewed = bl;
    }

    @NotNull
    public final LayoutWidthCalculator getLayoutWidthCalculator$stripe_release() {
        return this.layoutWidthCalculator;
    }

    public final void setLayoutWidthCalculator$stripe_release(@NotNull LayoutWidthCalculator layoutWidthCalculator) {
        Intrinsics.checkParameterIsNotNull((Object)layoutWidthCalculator, (String)"<set-?>");
        this.layoutWidthCalculator = layoutWidthCalculator;
    }

    @NotNull
    public final PlacementParameters getPlacementParameters$stripe_release() {
        return this.placementParameters;
    }

    private final String getPostalCodeValue() {
        return this.postalCodeEnabled ? String.valueOf(this.postalCodeEditText.getText()) : null;
    }

    private final String getCvcValue() {
        return this.cvcNumberEditText.getCvcValue();
    }

    private final CardBrand getBrand() {
        return this.cardNumberEditText.getCardBrand();
    }

    @VisibleForTesting
    public static /* synthetic */ void standardFields$annotations() {
    }

    @NotNull
    public final List<StripeEditText> getStandardFields$stripe_release() {
        return this.standardFields;
    }

    @VisibleForTesting
    public static /* synthetic */ void allFields$annotations() {
    }

    @NotNull
    public final /* synthetic */ List<StripeEditText> getAllFields$stripe_release() {
        PostalCodeEditText postalCodeEditText = this.postalCodeEditText;
        Collection collection = this.standardFields;
        boolean bl = false;
        boolean bl2 = false;
        PostalCodeEditText it = postalCodeEditText;
        boolean bl3 = false;
        PostalCodeEditText postalCodeEditText2 = this.postalCodeEnabled ? postalCodeEditText : null;
        return CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)collection, (Object)((Object)postalCodeEditText2)));
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams.Card getPaymentMethodCard() {
        PaymentMethodCreateParams.Card card;
        Card card2 = this.getCard();
        if (card2 != null) {
            Card card3 = card2;
            boolean bl = false;
            boolean bl2 = false;
            Card it = card3;
            boolean bl3 = false;
            String string2 = null;
            Integer n = it.getExpYear();
            Integer n2 = it.getExpMonth();
            String string3 = it.getCvc();
            PaymentMethodCreateParams.Card card4 = new PaymentMethodCreateParams.Card(it.getNumber(), n2, n, string3, string2, 16, null);
            card = card4;
        } else {
            card = null;
        }
        return card;
    }

    private final PaymentMethod.BillingDetails getBillingDetails() {
        PaymentMethod.BillingDetails billingDetails;
        String string2 = this.getPostalCodeValue();
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            billingDetails = new PaymentMethod.BillingDetails(new Address(null, null, null, null, it, null, 47, null), null, null, null, 14, null);
        } else {
            billingDetails = null;
        }
        return billingDetails;
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams paymentMethodCreateParams;
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card != null) {
            PaymentMethodCreateParams.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethodCreateParams.Card card3 = card2;
            boolean bl3 = false;
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, card3, this.getBillingDetails(), null, 4, null);
        } else {
            paymentMethodCreateParams = null;
        }
        return paymentMethodCreateParams;
    }

    @Override
    @Nullable
    public Card getCard() {
        Card.Builder builder = this.getCardBuilder();
        return builder != null ? builder.build() : null;
    }

    @Override
    @Nullable
    public Card.Builder getCardBuilder() {
        String cardNumber = this.cardNumberEditText.getCardNumber();
        Pair<Integer, Integer> cardDate = this.expiryDateEditText.getValidDateFields();
        String cvcValue = this.getCvcValue();
        if (cardNumber == null) {
            this.cardNumberEditText.requestFocus();
        } else if (cardDate == null) {
            this.expiryDateEditText.requestFocus();
        } else if (cvcValue == null) {
            this.cvcNumberEditText.requestFocus();
        } else {
            return new Card.Builder(cardNumber, (Integer)cardDate.getFirst(), (Integer)cardDate.getSecond(), cvcValue).addressZip(this.getPostalCodeValue()).loggingTokens(CollectionsKt.listOf((Object)LOGGING_TOKEN));
        }
        return null;
    }

    private final int getFrameWidth() {
        return ((Number)this.frameWidthSupplier.invoke()).intValue();
    }

    @NotNull
    public final Function0<Integer> getFrameWidthSupplier$stripe_release() {
        return this.frameWidthSupplier;
    }

    public final void setFrameWidthSupplier$stripe_release(@NotNull Function0<Integer> function0) {
        Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
        this.frameWidthSupplier = function0;
    }

    public final boolean getPostalCodeEnabled() {
        return this.postalCodeEnabled;
    }

    public final void setPostalCodeEnabled(boolean value) {
        this.updatePostalCodeEditText(value);
        this.postalCodeEnabled = value;
    }

    @Override
    public void setCardInputListener(@Nullable CardInputListener listener) {
        this.cardInputListener = listener;
    }

    @Override
    public void setCardNumber(@Nullable String cardNumber) {
        this.cardNumberEditText.setText(cardNumber);
        this.cardNumberIsViewed = !this.cardNumberEditText.isCardNumberValid();
    }

    @Override
    public void setCardHint(@NotNull String cardHint) {
        Intrinsics.checkParameterIsNotNull((Object)cardHint, (String)"cardHint");
        this.cardNumberEditText.setHint(cardHint);
    }

    @Override
    public void setExpiryDate(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        this.expiryDateEditText.setText(DateUtils.createDateStringFromIntegerInput(month, year));
    }

    @Override
    public void setCvcCode(@Nullable String cvcCode) {
        this.cvcNumberEditText.setText(cvcCode);
    }

    public final /* synthetic */ void setPostalCode$stripe_release(@Nullable String postalCode) {
        this.postalCodeEditText.setText(postalCode);
    }

    @Override
    public void clear() {
        StripeEditText it;
        boolean bl;
        block5: {
            Iterable $this$any$iv = this.getAllFields$stripe_release();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (StripeEditText)((Object)element$iv);
                    boolean bl2 = false;
                    if (!it.hasFocus()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl || this.hasFocus()) {
            this.cardNumberEditText.requestFocus();
        }
        Iterable $this$forEach$iv = this.getAllFields$stripe_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StripeEditText)((Object)element$iv);
            boolean bl3 = false;
            it.setText("");
        }
    }

    public void setEnabled(boolean isEnabled) {
        Iterable $this$forEach$iv = this.getAllFields$stripe_release();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StripeEditText it = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            it.setEnabled(isEnabled);
        }
    }

    public final void setCardNumberTextWatcher(@Nullable TextWatcher cardNumberTextWatcher) {
        this.cardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    public final void setExpiryDateTextWatcher(@Nullable TextWatcher expiryDateTextWatcher) {
        this.expiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    public final void setCvcNumberTextWatcher(@Nullable TextWatcher cvcNumberTextWatcher) {
        this.cvcNumberEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    public boolean isEnabled() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.standardFields;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StripeEditText it = (StripeEditText)((Object)element$iv);
                    boolean bl2 = false;
                    if (it.isEnabled()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        if (ev.getAction() != 0) {
            return super.onInterceptTouchEvent(ev);
        }
        View view = this.getFocusRequestOnTouch$stripe_release((int)ev.getX());
        if (view != null) {
            View view2 = view;
            boolean bl2 = false;
            boolean bl3 = false;
            View it = view2;
            boolean bl4 = false;
            it.requestFocus();
            bl = true;
        } else {
            bl = super.onInterceptTouchEvent(ev);
        }
        return bl;
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        boolean bl = false;
        boolean bl2 = false;
        Bundle $this$apply = bundle;
        boolean bl3 = false;
        $this$apply.putParcelable(STATE_SUPER_STATE, super.onSaveInstanceState());
        $this$apply.putBoolean(STATE_CARD_VIEWED, this.cardNumberIsViewed);
        $this$apply.putBoolean(STATE_POSTAL_CODE_ENABLED, this.postalCodeEnabled);
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof Bundle) {
            this.setPostalCodeEnabled(((Bundle)state).getBoolean(STATE_POSTAL_CODE_ENABLED, true));
            this.cardNumberIsViewed = ((Bundle)state).getBoolean(STATE_CARD_VIEWED, true);
            this.updateSpaceSizes$stripe_release(this.cardNumberIsViewed);
            this.placementParameters.setTotalLengthInPixels$stripe_release(this.getFrameWidth());
            int cardLeftMargin = 0;
            int dateLeftMargin = 0;
            int cvcLeftMargin = 0;
            int postalCodeLeftMargin = 0;
            if (this.cardNumberIsViewed) {
                cardLeftMargin = 0;
                dateLeftMargin = this.placementParameters.getDateLeftMargin$stripe_release(true);
                cvcLeftMargin = this.placementParameters.getCvcLeftMargin$stripe_release(true);
                postalCodeLeftMargin = this.placementParameters.getPostalCodeLeftMargin$stripe_release(true);
            } else {
                cardLeftMargin = -1 * this.placementParameters.getHiddenCardWidth$stripe_release();
                dateLeftMargin = this.placementParameters.getDateLeftMargin$stripe_release(false);
                cvcLeftMargin = this.placementParameters.getCvcLeftMargin$stripe_release(false);
                postalCodeLeftMargin = this.postalCodeEnabled ? this.placementParameters.getPostalCodeLeftMargin$stripe_release(false) : this.placementParameters.getTotalLengthInPixels$stripe_release();
            }
            this.updateFieldLayout((View)this.cardNumberTextInputLayout, this.placementParameters.getCardWidth$stripe_release(), cardLeftMargin);
            this.updateFieldLayout((View)this.expiryDateTextInputLayout, this.placementParameters.getDateWidth$stripe_release(), dateLeftMargin);
            this.updateFieldLayout((View)this.cvcNumberTextInputLayout, this.placementParameters.getCvcWidth$stripe_release(), cvcLeftMargin);
            this.updateFieldLayout((View)this.postalCodeTextInputLayout, this.placementParameters.getPostalCodeWidth$stripe_release(), postalCodeLeftMargin);
            super.onRestoreInstanceState(((Bundle)state).getParcelable(STATE_SUPER_STATE));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    private final void updatePostalCodeEditText(boolean isEnabled) {
        if (isEnabled) {
            this.postalCodeEditText.setEnabled(true);
            this.postalCodeTextInputLayout.setVisibility(0);
            this.cvcNumberEditText.setImeOptions(5);
        } else {
            this.postalCodeEditText.setEnabled(false);
            this.postalCodeTextInputLayout.setVisibility(8);
            this.cvcNumberEditText.setImeOptions(6);
        }
    }

    @VisibleForTesting
    @Nullable
    public final View getFocusRequestOnTouch$stripe_release(int touchX) {
        int frameStart = this.frameLayout.getLeft();
        return this.cardNumberIsViewed ? (View)(touchX < frameStart + this.placementParameters.getCardWidth$stripe_release() ? null : (touchX < this.placementParameters.getCardTouchBufferLimit$stripe_release() ? (StripeEditText)this.cardNumberEditText : (touchX < this.placementParameters.getDateStartPosition$stripe_release() ? (StripeEditText)this.expiryDateEditText : null))) : (this.postalCodeEnabled ? (View)(touchX < frameStart + this.placementParameters.getPeekCardWidth$stripe_release() ? null : (touchX < this.placementParameters.getCardTouchBufferLimit$stripe_release() ? (StripeEditText)this.cardNumberEditText : (touchX < this.placementParameters.getDateStartPosition$stripe_release() ? (StripeEditText)this.expiryDateEditText : (touchX < this.placementParameters.getDateStartPosition$stripe_release() + this.placementParameters.getDateWidth$stripe_release() ? null : (touchX < this.placementParameters.getDateRightTouchBufferLimit$stripe_release() ? (StripeEditText)this.expiryDateEditText : (touchX < this.placementParameters.getCvcStartPosition$stripe_release() ? (StripeEditText)this.cvcNumberEditText : (touchX < this.placementParameters.getCvcStartPosition$stripe_release() + this.placementParameters.getCvcWidth$stripe_release() ? null : (touchX < this.placementParameters.getCvcRightTouchBufferLimit$stripe_release() ? (StripeEditText)this.cvcNumberEditText : (touchX < this.placementParameters.getPostalCodeStartPosition$stripe_release() ? (StripeEditText)this.postalCodeEditText : null))))))))) : (View)(touchX < frameStart + this.placementParameters.getPeekCardWidth$stripe_release() ? null : (touchX < this.placementParameters.getCardTouchBufferLimit$stripe_release() ? (StripeEditText)this.cardNumberEditText : (touchX < this.placementParameters.getDateStartPosition$stripe_release() ? (StripeEditText)this.expiryDateEditText : (touchX < this.placementParameters.getDateStartPosition$stripe_release() + this.placementParameters.getDateWidth$stripe_release() ? null : (touchX < this.placementParameters.getDateRightTouchBufferLimit$stripe_release() ? (StripeEditText)this.expiryDateEditText : (touchX < this.placementParameters.getCvcStartPosition$stripe_release() ? (StripeEditText)this.cvcNumberEditText : null)))))));
    }

    @VisibleForTesting
    public final void updateSpaceSizes$stripe_release(boolean isCardViewed) {
        int frameWidth = this.getFrameWidth();
        int frameStart = this.frameLayout.getLeft();
        if (frameWidth == 0) {
            return;
        }
        this.placementParameters.setCardWidth$stripe_release(this.getDesiredWidthInPixels(FULL_SIZING_CARD_TEXT, this.cardNumberEditText));
        this.placementParameters.setDateWidth$stripe_release(this.getDesiredWidthInPixels(FULL_SIZING_DATE_TEXT, this.expiryDateEditText));
        this.placementParameters.setHiddenCardWidth$stripe_release(this.getDesiredWidthInPixels(this.getHiddenCardText(), this.cardNumberEditText));
        this.placementParameters.setCvcWidth$stripe_release(this.getDesiredWidthInPixels(this.getCvcPlaceHolder(), this.cvcNumberEditText));
        this.placementParameters.setPostalCodeWidth$stripe_release(this.getDesiredWidthInPixels(FULL_SIZING_POSTAL_CODE_TEXT, this.postalCodeEditText));
        this.placementParameters.setPeekCardWidth$stripe_release(this.getDesiredWidthInPixels(this.getPeekCardText(), this.cardNumberEditText));
        this.placementParameters.updateSpacing$stripe_release(isCardViewed, this.postalCodeEnabled, frameStart, frameWidth);
    }

    private final void updateFieldLayout(View view, int width, int leftMargin) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
        FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
        View view2 = view;
        boolean bl = false;
        boolean bl2 = false;
        FrameLayout.LayoutParams $this$apply = layoutParams2;
        boolean bl3 = false;
        $this$apply.width = width;
        $this$apply.leftMargin = leftMargin;
        FrameLayout.LayoutParams layoutParams3 = layoutParams2;
        view2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
    }

    private final int getDesiredWidthInPixels(String text, StripeEditText editText) {
        TextPaint textPaint = editText.getPaint();
        Intrinsics.checkExpressionValueIsNotNull((Object)textPaint, (String)"editText.paint");
        return this.layoutWidthCalculator.calculate(text, textPaint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initView(AttributeSet attrs) {
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            this.applyAttributes(it);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            this.cardNumberEditText.setAutofillHints(new String[]{"creditCardNumber"});
            this.expiryDateEditText.setAutofillHints(new String[]{"creditCardExpirationDate"});
            this.cvcNumberEditText.setAutofillHints(new String[]{"creditCardSecurityCode"});
            this.postalCodeEditText.setAutofillHints(new String[]{"postalCode"});
        }
        ViewCompat.setAccessibilityDelegate((View)((View)this.cardNumberEditText), (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
                Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setHintText((CharSequence)null);
            }
        });
        ViewCompat.setAccessibilityDelegate((View)((View)this.cvcNumberEditText), (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
                Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setText((CharSequence)this.this$0.getResources().getString(R.string.acc_label_cvc_node, new Object[]{CardInputWidget.access$getCvcNumberEditText$p(this.this$0).getText()}));
            }
            {
                this.this$0 = $outer;
            }
        });
        this.cardNumberIsViewed = true;
        int errorColorInt = this.cardNumberEditText.getDefaultErrorColorInt();
        ColorStateList colorStateList = this.cardNumberEditText.getHintTextColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"cardNumberEditText.hintTextColors");
        this.tintColorInt = colorStateList.getDefaultColor();
        String cardHintText = null;
        if (attrs != null) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardInputView, 0, 0);
            try {
                this.tintColorInt = a.getColor(R.styleable.CardInputView_cardTint, this.tintColorInt);
                errorColorInt = a.getColor(R.styleable.CardInputView_cardTextErrorColor, errorColorInt);
                cardHintText = a.getString(R.styleable.CardInputView_cardHintText);
            }
            finally {
                a.recycle();
            }
        }
        String string2 = cardHintText;
        if (string2 != null) {
            String a = string2;
            boolean it = false;
            boolean bl = false;
            String it2 = a;
            boolean bl4 = false;
            this.cardNumberEditText.setHint(it2);
        }
        Iterable $this$forEach$iv = this.standardFields;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StripeEditText it = (StripeEditText)((Object)element$iv);
            boolean bl = false;
            it.setErrorColor(errorColorInt);
        }
        this.cardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                block1: {
                    if (!hasFocus) break block1;
                    CardInputWidget.access$scrollLeft(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_card");
                    }
                }
            }
            {
                this.this$0 = cardInputWidget;
            }
        });
        this.expiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                block1: {
                    if (!hasFocus) break block1;
                    CardInputWidget.access$scrollRight(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_expiry");
                    }
                }
            }
            {
                this.this$0 = cardInputWidget;
            }
        });
        this.expiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cardNumberEditText));
        this.cvcNumberEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.expiryDateEditText));
        this.postalCodeEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cvcNumberEditText));
        this.cvcNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardInputWidget.access$scrollRight(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_cvc");
                    }
                }
                CardInputWidget.access$updateIconCvc(this.this$0, hasFocus, CardInputWidget.access$getCvcValue$p(this.this$0));
            }
            {
                this.this$0 = cardInputWidget;
            }
        });
        this.cvcNumberEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onTextChanged(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (CardInputWidget.access$getBrand$p(this.this$0).isMaxCvc(text)) {
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onCvcComplete();
                    }
                }
                CardInputWidget.access$updateIconCvc(this.this$0, CardInputWidget.access$getCvcNumberEditText$p(this.this$0).hasFocus(), text);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.cardNumberEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void invoke() {
                block0: {
                    CardInputWidget.access$scrollRight(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener == null) break block0;
                    cardInputListener.onCardComplete();
                }
            }
            {
                this.this$0 = cardInputWidget;
                super(0);
            }
        }));
        this.cardNumberEditText.setBrandChangeCallback$stripe_release((Function1<? super CardBrand, Unit>)((Function1)new Function1<CardBrand, Unit>(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void invoke(@NotNull CardBrand brand) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
                CardInputWidget.access$updateIcon(this.this$0);
                CvcEditText.updateBrand$stripe_release$default(CardInputWidget.access$getCvcNumberEditText$p(this.this$0), brand, null, null, 6, null);
            }
            {
                this.this$0 = cardInputWidget;
                super(1);
            }
        }));
        this.expiryDateEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void invoke() {
                block0: {
                    CardInputWidget.access$getCvcNumberEditText$p(this.this$0).requestFocus();
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener == null) break block0;
                    cardInputListener.onExpirationComplete();
                }
            }
            {
                this.this$0 = cardInputWidget;
                super(0);
            }
        }));
        this.cvcNumberEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void invoke() {
                if (this.this$0.getPostalCodeEnabled()) {
                    CardInputWidget.access$getPostalCodeEditText$p(this.this$0).requestFocus();
                }
            }
            {
                this.this$0 = cardInputWidget;
                super(0);
            }
        }));
        this.cardNumberEditText.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyAttributes(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardElement, 0, 0);
        try {
            this.setPostalCodeEnabled(typedArray.getBoolean(R.styleable.CardElement_shouldShowPostalCode, true));
        }
        finally {
            typedArray.recycle();
        }
    }

    private final void scrollLeft() {
        if (this.cardNumberIsViewed || !this.initFlag) {
            return;
        }
        int dateStartPosition = this.placementParameters.getDateLeftMargin$stripe_release(false);
        int cvcStartPosition = this.placementParameters.getCvcLeftMargin$stripe_release(false);
        int postalCodeStartPosition = this.placementParameters.getPostalCodeLeftMargin$stripe_release(false);
        this.updateSpaceSizes$stripe_release(true);
        CardNumberSlideLeftAnimation slideCardLeftAnimation = new CardNumberSlideLeftAnimation((View)this.cardNumberTextInputLayout);
        int dateDestination = this.placementParameters.getDateLeftMargin$stripe_release(true);
        ExpiryDateSlideLeftAnimation slideDateLeftAnimation = new ExpiryDateSlideLeftAnimation((View)this.expiryDateTextInputLayout, dateStartPosition, dateDestination);
        int cvcDestination = cvcStartPosition + (dateDestination - dateStartPosition);
        CvcSlideLeftAnimation slideCvcLeftAnimation = new CvcSlideLeftAnimation((View)this.cvcNumberTextInputLayout, cvcStartPosition, cvcDestination, this.placementParameters.getCvcWidth$stripe_release());
        int postalCodeDestination = postalCodeStartPosition + (cvcDestination - cvcStartPosition);
        PostalCodeSlideLeftAnimation slidePostalCodeLeftAnimation = this.postalCodeEnabled ? new PostalCodeSlideLeftAnimation((View)this.postalCodeTextInputLayout, postalCodeStartPosition, postalCodeDestination, this.placementParameters.getPostalCodeWidth$stripe_release()) : null;
        this.startSlideAnimation(CollectionsKt.listOfNotNull((Object[])new CardFieldAnimation[]{slideCardLeftAnimation, slideDateLeftAnimation, slideCvcLeftAnimation, slidePostalCodeLeftAnimation}));
        this.cardNumberIsViewed = true;
    }

    private final void scrollRight() {
        if (!this.cardNumberIsViewed || !this.initFlag) {
            return;
        }
        int dateStartMargin = this.placementParameters.getDateLeftMargin$stripe_release(true);
        this.updateSpaceSizes$stripe_release(false);
        CardNumberSlideRightAnimation slideCardRightAnimation = new CardNumberSlideRightAnimation((View)this.cardNumberTextInputLayout, this.placementParameters.getHiddenCardWidth$stripe_release(), (View)this.expiryDateEditText);
        int dateDestination = this.placementParameters.getDateLeftMargin$stripe_release(false);
        ExpiryDateSlideRightAnimation slideDateRightAnimation = new ExpiryDateSlideRightAnimation((View)this.expiryDateTextInputLayout, dateStartMargin, dateDestination);
        int cvcDestination = this.placementParameters.getCvcLeftMargin$stripe_release(false);
        int cvcStartMargin = cvcDestination + (dateStartMargin - dateDestination);
        CvcSlideRightAnimation slideCvcRightAnimation = new CvcSlideRightAnimation((View)this.cvcNumberTextInputLayout, cvcStartMargin, cvcDestination, this.placementParameters.getCvcWidth$stripe_release());
        int postalCodeDestination = this.placementParameters.getPostalCodeLeftMargin$stripe_release(false);
        int postalCodeStartMargin = postalCodeDestination + (cvcStartMargin - cvcDestination);
        PostalCodeSlideRightAnimation slidePostalCodeRightAnimation = this.postalCodeEnabled ? new PostalCodeSlideRightAnimation((View)this.postalCodeTextInputLayout, postalCodeStartMargin, postalCodeDestination, this.placementParameters.getPostalCodeWidth$stripe_release()) : null;
        this.startSlideAnimation(CollectionsKt.listOfNotNull((Object[])new CardFieldAnimation[]{slideCardRightAnimation, slideDateRightAnimation, slideCvcRightAnimation, slidePostalCodeRightAnimation}));
        this.cardNumberIsViewed = false;
    }

    private final void startSlideAnimation(List<? extends Animation> animations) {
        AnimationSet animationSet = new AnimationSet(true);
        boolean bl = false;
        boolean bl2 = false;
        AnimationSet $this$apply = animationSet;
        boolean bl3 = false;
        Iterable $this$forEach$iv = animations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Animation it = (Animation)element$iv;
            boolean bl4 = false;
            $this$apply.addAnimation(it);
        }
        AnimationSet animationSet2 = animationSet;
        this.frameLayout.startAnimation((Animation)animationSet2);
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.applyTint(false);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!this.initFlag && this.getWidth() != 0) {
            this.initFlag = true;
            this.placementParameters.setTotalLengthInPixels$stripe_release(this.getFrameWidth());
            this.updateSpaceSizes$stripe_release(this.cardNumberIsViewed);
            this.updateFieldLayout((View)this.cardNumberTextInputLayout, this.placementParameters.getCardWidth$stripe_release(), this.cardNumberIsViewed ? 0 : -1 * this.placementParameters.getHiddenCardWidth$stripe_release());
            this.updateFieldLayout((View)this.expiryDateTextInputLayout, this.placementParameters.getDateWidth$stripe_release(), this.placementParameters.getDateLeftMargin$stripe_release(this.cardNumberIsViewed));
            this.updateFieldLayout((View)this.cvcNumberTextInputLayout, this.placementParameters.getCvcWidth$stripe_release(), this.placementParameters.getCvcLeftMargin$stripe_release(this.cardNumberIsViewed));
            this.updateFieldLayout((View)this.postalCodeTextInputLayout, this.placementParameters.getPostalCodeWidth$stripe_release(), this.placementParameters.getPostalCodeLeftMargin$stripe_release(this.cardNumberIsViewed));
        }
    }

    private final String getHiddenCardText() {
        return CardBrand.AmericanExpress == this.getBrand() ? HIDDEN_TEXT_AMEX : HIDDEN_TEXT_COMMON;
    }

    private final String getCvcPlaceHolder() {
        return CardBrand.AmericanExpress == this.getBrand() ? CVC_PLACEHOLDER_AMEX : CVC_PLACEHOLDER_COMMON;
    }

    private final String getPeekCardText() {
        String string2;
        switch (CardInputWidget$WhenMappings.$EnumSwitchMapping$0[this.getBrand().ordinal()]) {
            case 1: {
                string2 = PEEK_TEXT_AMEX;
                break;
            }
            case 2: {
                string2 = PEEK_TEXT_DINERS;
                break;
            }
            default: {
                string2 = PEEK_TEXT_COMMON;
            }
        }
        return string2;
    }

    private final void applyTint(boolean isCvc) {
        if (isCvc || CardBrand.Unknown == this.getBrand()) {
            Drawable icon = this.cardIconImageView.getDrawable();
            Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.tintColorInt);
            this.cardIconImageView.setImageDrawable(DrawableCompat.unwrap((Drawable)compatIcon));
        }
    }

    private final void updateIcon() {
        this.cardIconImageView.setImageResource(this.getBrand().getIcon());
        if (this.getBrand() == CardBrand.Unknown) {
            this.applyTint(false);
        }
    }

    private final void updateIconCvc(boolean hasFocus, String cvcText) {
        if (Companion.shouldIconShowBrand$stripe_release(this.getBrand(), hasFocus, cvcText)) {
            this.updateIcon();
        } else {
            this.updateIconForCvcEntry();
        }
    }

    private final void updateIconForCvcEntry() {
        this.cardIconImageView.setImageResource(this.getBrand().getCvcIcon());
        this.applyTint(true);
    }

    @JvmOverloads
    public CardInputWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.cardNumberIsViewed = true;
        this.layoutWidthCalculator = new DefaultLayoutWidthCalculator();
        this.placementParameters = new PlacementParameters();
        this.postalCodeEnabled = true;
        View.inflate((Context)this.getContext(), (int)R.layout.card_input_widget, (ViewGroup)((ViewGroup)this));
        if (this.getId() == -1) {
            this.setId(DEFAULT_READER_ID);
        }
        this.setOrientation(0);
        this.setMinimumWidth(this.getResources().getDimensionPixelSize(R.dimen.stripe_card_widget_min_width));
        View view = this.findViewById(R.id.frame_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.frame_container)");
        this.frameLayout = (FrameLayout)view;
        View view2 = this.frameLayout.findViewById(R.id.tl_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"frameLayout.findViewById(R.id.tl_card_number)");
        this.cardNumberTextInputLayout = (TextInputLayout)view2;
        View view3 = this.frameLayout.findViewById(R.id.tl_expiry_date);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"frameLayout.findViewById(R.id.tl_expiry_date)");
        this.expiryDateTextInputLayout = (TextInputLayout)view3;
        View view4 = this.frameLayout.findViewById(R.id.tl_cvc);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"frameLayout.findViewById(R.id.tl_cvc)");
        this.cvcNumberTextInputLayout = (TextInputLayout)view4;
        View view5 = this.frameLayout.findViewById(R.id.tl_postal_code);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"frameLayout.findViewById(R.id.tl_postal_code)");
        this.postalCodeTextInputLayout = (TextInputLayout)view5;
        View view6 = this.cardNumberTextInputLayout.findViewById(R.id.et_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"cardNumberTextInputLayou\u2026ById(R.id.et_card_number)");
        this.cardNumberEditText = (CardNumberEditText)view6;
        View view7 = this.expiryDateTextInputLayout.findViewById(R.id.et_expiry_date);
        Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"expiryDateTextInputLayou\u2026ById(R.id.et_expiry_date)");
        this.expiryDateEditText = (ExpiryDateEditText)view7;
        View view8 = this.cvcNumberTextInputLayout.findViewById(R.id.et_cvc);
        Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"cvcNumberTextInputLayout.findViewById(R.id.et_cvc)");
        this.cvcNumberEditText = (CvcEditText)view8;
        View view9 = this.postalCodeTextInputLayout.findViewById(R.id.et_postal_code);
        Intrinsics.checkExpressionValueIsNotNull((Object)view9, (String)"postalCodeTextInputLayou\u2026ById(R.id.et_postal_code)");
        this.postalCodeEditText = (PostalCodeEditText)view9;
        this.postalCodeEditText.configureForGlobal$stripe_release();
        this.frameWidthSupplier = (Function0)new Function0<Integer>(){

            public final int invoke() {
                return frameLayout.getWidth();
            }
        };
        View view10 = this.findViewById(R.id.iv_card_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view10, (String)"findViewById(R.id.iv_card_icon)");
        this.cardIconImageView = (ImageView)view10;
        this.standardFields = CollectionsKt.listOf((Object[])new StripeEditText[]{this.cardNumberEditText, this.cvcNumberEditText, this.expiryDateEditText});
        this.initView(attrs);
    }

    public /* synthetic */ CardInputWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CardInputWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardInputWidget(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_READER_ID = R.id.stripe_default_reader_id;
    }

    public static final /* synthetic */ CvcEditText access$getCvcNumberEditText$p(CardInputWidget $this) {
        return $this.cvcNumberEditText;
    }

    public static final /* synthetic */ void access$scrollLeft(CardInputWidget $this) {
        $this.scrollLeft();
    }

    public static final /* synthetic */ CardInputListener access$getCardInputListener$p(CardInputWidget $this) {
        return $this.cardInputListener;
    }

    public static final /* synthetic */ void access$setCardInputListener$p(CardInputWidget $this, CardInputListener cardInputListener) {
        $this.cardInputListener = cardInputListener;
    }

    public static final /* synthetic */ void access$scrollRight(CardInputWidget $this) {
        $this.scrollRight();
    }

    public static final /* synthetic */ void access$updateIconCvc(CardInputWidget $this, boolean hasFocus, String cvcText) {
        $this.updateIconCvc(hasFocus, cvcText);
    }

    public static final /* synthetic */ String access$getCvcValue$p(CardInputWidget $this) {
        return $this.getCvcValue();
    }

    public static final /* synthetic */ CardBrand access$getBrand$p(CardInputWidget $this) {
        return $this.getBrand();
    }

    public static final /* synthetic */ void access$updateIcon(CardInputWidget $this) {
        $this.updateIcon();
    }

    public static final /* synthetic */ PostalCodeEditText access$getPostalCodeEditText$p(CardInputWidget $this) {
        return $this.postalCodeEditText;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b9\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\b?J\u0015\u0010@\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020\u00042\u0006\u0010=\u001a\u00020>H\u0000\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020EH\u0016J-\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020>2\u0006\u0010I\u001a\u00020>2\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\bLR\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u001a\u0010\u000f\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR\u001a\u0010$\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u001a\u0010'\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0006\"\u0004\b)\u0010\bR\u001a\u0010*\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0006\"\u0004\b/\u0010\bR\u001a\u00100\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0006\"\u0004\b2\u0010\bR\u001a\u00103\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0006\"\u0004\b5\u0010\bR\u001a\u00106\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u0006\"\u0004\b8\u0010\bR\u001a\u00109\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0006\"\u0004\b;\u0010\b\u00a8\u0006M"}, d2={"Lcom/stripe/android/view/CardInputWidget$PlacementParameters;", "", "()V", "cardDateSeparation", "", "getCardDateSeparation$stripe_release", "()I", "setCardDateSeparation$stripe_release", "(I)V", "cardPeekCvcLeftMargin", "getCardPeekCvcLeftMargin", "cardPeekDateLeftMargin", "getCardPeekDateLeftMargin", "cardPeekPostalCodeLeftMargin", "getCardPeekPostalCodeLeftMargin$stripe_release", "cardTouchBufferLimit", "getCardTouchBufferLimit$stripe_release", "setCardTouchBufferLimit$stripe_release", "cardWidth", "getCardWidth$stripe_release", "setCardWidth$stripe_release", "cvcPostalCodeSeparation", "getCvcPostalCodeSeparation$stripe_release", "setCvcPostalCodeSeparation$stripe_release", "cvcRightTouchBufferLimit", "getCvcRightTouchBufferLimit$stripe_release", "setCvcRightTouchBufferLimit$stripe_release", "cvcStartPosition", "getCvcStartPosition$stripe_release", "setCvcStartPosition$stripe_release", "cvcWidth", "getCvcWidth$stripe_release", "setCvcWidth$stripe_release", "dateCvcSeparation", "getDateCvcSeparation$stripe_release", "setDateCvcSeparation$stripe_release", "dateRightTouchBufferLimit", "getDateRightTouchBufferLimit$stripe_release", "setDateRightTouchBufferLimit$stripe_release", "dateStartPosition", "getDateStartPosition$stripe_release", "setDateStartPosition$stripe_release", "dateWidth", "getDateWidth$stripe_release", "setDateWidth$stripe_release", "hiddenCardWidth", "getHiddenCardWidth$stripe_release", "setHiddenCardWidth$stripe_release", "peekCardWidth", "getPeekCardWidth$stripe_release", "setPeekCardWidth$stripe_release", "postalCodeStartPosition", "getPostalCodeStartPosition$stripe_release", "setPostalCodeStartPosition$stripe_release", "postalCodeWidth", "getPostalCodeWidth$stripe_release", "setPostalCodeWidth$stripe_release", "totalLengthInPixels", "getTotalLengthInPixels$stripe_release", "setTotalLengthInPixels$stripe_release", "getCvcLeftMargin", "isFullCard", "", "getCvcLeftMargin$stripe_release", "getDateLeftMargin", "getDateLeftMargin$stripe_release", "getPostalCodeLeftMargin", "getPostalCodeLeftMargin$stripe_release", "toString", "", "updateSpacing", "", "isCardViewed", "postalCodeEnabled", "frameStart", "frameWidth", "updateSpacing$stripe_release", "stripe_release"})
    public static final class PlacementParameters {
        private int totalLengthInPixels;
        private int cardWidth;
        private int hiddenCardWidth;
        private int peekCardWidth;
        private int cardDateSeparation;
        private int dateWidth;
        private int dateCvcSeparation;
        private int cvcWidth;
        private int cvcPostalCodeSeparation;
        private int postalCodeWidth;
        private int cardTouchBufferLimit;
        private int dateStartPosition;
        private int dateRightTouchBufferLimit;
        private int cvcStartPosition;
        private int cvcRightTouchBufferLimit;
        private int postalCodeStartPosition;

        public final int getTotalLengthInPixels$stripe_release() {
            return this.totalLengthInPixels;
        }

        public final void setTotalLengthInPixels$stripe_release(int n) {
            this.totalLengthInPixels = n;
        }

        public final int getCardWidth$stripe_release() {
            return this.cardWidth;
        }

        public final void setCardWidth$stripe_release(int n) {
            this.cardWidth = n;
        }

        public final int getHiddenCardWidth$stripe_release() {
            return this.hiddenCardWidth;
        }

        public final void setHiddenCardWidth$stripe_release(int n) {
            this.hiddenCardWidth = n;
        }

        public final int getPeekCardWidth$stripe_release() {
            return this.peekCardWidth;
        }

        public final void setPeekCardWidth$stripe_release(int n) {
            this.peekCardWidth = n;
        }

        public final int getCardDateSeparation$stripe_release() {
            return this.cardDateSeparation;
        }

        public final void setCardDateSeparation$stripe_release(int n) {
            this.cardDateSeparation = n;
        }

        public final int getDateWidth$stripe_release() {
            return this.dateWidth;
        }

        public final void setDateWidth$stripe_release(int n) {
            this.dateWidth = n;
        }

        public final int getDateCvcSeparation$stripe_release() {
            return this.dateCvcSeparation;
        }

        public final void setDateCvcSeparation$stripe_release(int n) {
            this.dateCvcSeparation = n;
        }

        public final int getCvcWidth$stripe_release() {
            return this.cvcWidth;
        }

        public final void setCvcWidth$stripe_release(int n) {
            this.cvcWidth = n;
        }

        public final int getCvcPostalCodeSeparation$stripe_release() {
            return this.cvcPostalCodeSeparation;
        }

        public final void setCvcPostalCodeSeparation$stripe_release(int n) {
            this.cvcPostalCodeSeparation = n;
        }

        public final int getPostalCodeWidth$stripe_release() {
            return this.postalCodeWidth;
        }

        public final void setPostalCodeWidth$stripe_release(int n) {
            this.postalCodeWidth = n;
        }

        public final int getCardTouchBufferLimit$stripe_release() {
            return this.cardTouchBufferLimit;
        }

        public final void setCardTouchBufferLimit$stripe_release(int n) {
            this.cardTouchBufferLimit = n;
        }

        public final int getDateStartPosition$stripe_release() {
            return this.dateStartPosition;
        }

        public final void setDateStartPosition$stripe_release(int n) {
            this.dateStartPosition = n;
        }

        public final int getDateRightTouchBufferLimit$stripe_release() {
            return this.dateRightTouchBufferLimit;
        }

        public final void setDateRightTouchBufferLimit$stripe_release(int n) {
            this.dateRightTouchBufferLimit = n;
        }

        public final int getCvcStartPosition$stripe_release() {
            return this.cvcStartPosition;
        }

        public final void setCvcStartPosition$stripe_release(int n) {
            this.cvcStartPosition = n;
        }

        public final int getCvcRightTouchBufferLimit$stripe_release() {
            return this.cvcRightTouchBufferLimit;
        }

        public final void setCvcRightTouchBufferLimit$stripe_release(int n) {
            this.cvcRightTouchBufferLimit = n;
        }

        public final int getPostalCodeStartPosition$stripe_release() {
            return this.postalCodeStartPosition;
        }

        public final void setPostalCodeStartPosition$stripe_release(int n) {
            this.postalCodeStartPosition = n;
        }

        private final /* synthetic */ int getCardPeekDateLeftMargin() {
            return this.peekCardWidth + this.cardDateSeparation;
        }

        private final /* synthetic */ int getCardPeekCvcLeftMargin() {
            return this.getCardPeekDateLeftMargin() + this.dateWidth + this.dateCvcSeparation;
        }

        public final /* synthetic */ int getCardPeekPostalCodeLeftMargin$stripe_release() {
            return this.getCardPeekCvcLeftMargin() + this.postalCodeWidth + this.cvcPostalCodeSeparation;
        }

        public final /* synthetic */ int getDateLeftMargin$stripe_release(boolean isFullCard) {
            return isFullCard ? this.cardWidth + this.cardDateSeparation : this.getCardPeekDateLeftMargin();
        }

        public final /* synthetic */ int getCvcLeftMargin$stripe_release(boolean isFullCard) {
            return isFullCard ? this.totalLengthInPixels : this.getCardPeekCvcLeftMargin();
        }

        public final /* synthetic */ int getPostalCodeLeftMargin$stripe_release(boolean isFullCard) {
            return isFullCard ? this.totalLengthInPixels : this.getCardPeekPostalCodeLeftMargin$stripe_release();
        }

        public final /* synthetic */ void updateSpacing$stripe_release(boolean isCardViewed, boolean postalCodeEnabled, int frameStart, int frameWidth) {
            if (isCardViewed) {
                this.cardDateSeparation = frameWidth - this.cardWidth - this.dateWidth;
                this.cardTouchBufferLimit = frameStart + this.cardWidth + this.cardDateSeparation / 2;
                this.dateStartPosition = frameStart + this.cardWidth + this.cardDateSeparation;
            } else if (postalCodeEnabled) {
                this.cardDateSeparation = frameWidth * 3 / 10 - this.peekCardWidth - this.dateWidth / 4;
                this.dateCvcSeparation = frameWidth * 3 / 5 - this.peekCardWidth - this.cardDateSeparation - this.dateWidth - this.cvcWidth;
                this.cvcPostalCodeSeparation = frameWidth * 4 / 5 - this.peekCardWidth - this.cardDateSeparation - this.dateWidth - this.cvcWidth - this.dateCvcSeparation - this.postalCodeWidth;
                int dateStartPosition = frameStart + this.peekCardWidth + this.cardDateSeparation;
                this.cardTouchBufferLimit = dateStartPosition / 3;
                this.dateStartPosition = dateStartPosition;
                int cvcStartPosition = dateStartPosition + this.dateWidth + this.dateCvcSeparation;
                this.dateRightTouchBufferLimit = cvcStartPosition / 3;
                this.cvcStartPosition = cvcStartPosition;
                int postalCodeStartPosition = cvcStartPosition + this.cvcWidth + this.cvcPostalCodeSeparation;
                this.cvcRightTouchBufferLimit = postalCodeStartPosition / 3;
                this.postalCodeStartPosition = postalCodeStartPosition;
            } else {
                this.cardDateSeparation = frameWidth / 2 - this.peekCardWidth - this.dateWidth / 2;
                this.dateCvcSeparation = frameWidth - this.peekCardWidth - this.cardDateSeparation - this.dateWidth - this.cvcWidth;
                this.cardTouchBufferLimit = frameStart + this.peekCardWidth + this.cardDateSeparation / 2;
                this.dateStartPosition = frameStart + this.peekCardWidth + this.cardDateSeparation;
                this.dateRightTouchBufferLimit = this.dateStartPosition + this.dateWidth + this.dateCvcSeparation / 2;
                this.cvcStartPosition = this.dateStartPosition + this.dateWidth + this.dateCvcSeparation;
            }
        }

        @NotNull
        public String toString() {
            String touchBufferData = "\n                Touch Buffer Data:\n                \"CardTouchBufferLimit = " + this.cardTouchBufferLimit + "\n                \"DateStartPosition = " + this.dateStartPosition + "\n                \"DateRightTouchBufferLimit = " + this.dateRightTouchBufferLimit + "\n                \"CvcStartPosition = " + this.cvcStartPosition + "\"\n                ";
            String elementSizeData = "\n                CardWidth = " + this.cardWidth + "\n                HiddenCardWidth = " + this.hiddenCardWidth + "\n                PeekCardWidth = " + this.peekCardWidth + "\n                CardDateSeparation = " + this.cardDateSeparation + "\n                DateWidth = " + this.dateWidth + "\n                DateCvcSeparation = " + this.dateCvcSeparation + "\n                CvcWidth = " + this.cvcWidth + "\n                CvcPostalCodeSeparation = " + this.cvcPostalCodeSeparation + "\n                PostalCodeWidth: " + this.postalCodeWidth + "\n                ";
            return elementSizeData + touchBufferData;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "Landroid/view/animation/Animation;", "()V", "Companion", "stripe_release"})
    private static abstract class CardFieldAnimation
    extends Animation {
        private static final long ANIMATION_LENGTH = 150L;
        @Deprecated
        public static final Companion Companion = new Companion(null);

        public CardFieldAnimation() {
            this.setDuration(150L);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation$Companion;", "", "()V", "ANIMATION_LENGTH", "", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/view/CardInputWidget$CardNumberSlideLeftAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "(Landroid/view/View;)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class CardNumberSlideLeftAnimation
    extends CardFieldAnimation {
        private final View view;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)((float)$this$apply.leftMargin * (1.0f - interpolatedTime));
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public CardNumberSlideLeftAnimation(@NotNull View view) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.setAnimationListener(new AnimationEndListener(){

                public void onAnimationEnd(@NotNull Animation animation) {
                    Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                    view.requestFocus();
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/CardInputWidget$ExpiryDateSlideLeftAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "startPosition", "", "destination", "(Landroid/view/View;II)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class ExpiryDateSlideLeftAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int startPosition;
        private final int destination;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(interpolatedTime * (float)this.destination + (1.0f - interpolatedTime) * (float)this.startPosition);
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public ExpiryDateSlideLeftAnimation(@NotNull View view, int startPosition, int destination) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.startPosition = startPosition;
            this.destination = destination;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/CardInputWidget$CvcSlideLeftAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "startPosition", "", "destination", "newWidth", "(Landroid/view/View;III)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class CvcSlideLeftAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int startPosition;
        private final int destination;
        private final int newWidth;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(interpolatedTime * (float)this.destination + (1.0f - interpolatedTime) * (float)this.startPosition);
            $this$apply.rightMargin = 0;
            $this$apply.width = this.newWidth;
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public CvcSlideLeftAnimation(@NotNull View view, int startPosition, int destination, int newWidth) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.startPosition = startPosition;
            this.destination = destination;
            this.newWidth = newWidth;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/CardInputWidget$PostalCodeSlideLeftAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "startPosition", "", "destination", "newWidth", "(Landroid/view/View;III)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class PostalCodeSlideLeftAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int startPosition;
        private final int destination;
        private final int newWidth;

        protected void applyTransformation(float interpolatedTime, @Nullable Transformation t) {
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(interpolatedTime * (float)this.destination + (1.0f - interpolatedTime) * (float)this.startPosition);
            $this$apply.rightMargin = 0;
            $this$apply.width = this.newWidth;
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public PostalCodeSlideLeftAnimation(@NotNull View view, int startPosition, int destination, int newWidth) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.startPosition = startPosition;
            this.destination = destination;
            this.newWidth = newWidth;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/CardInputWidget$CardNumberSlideRightAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "hiddenCardWidth", "", "focusOnEndView", "(Landroid/view/View;ILandroid/view/View;)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class CardNumberSlideRightAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int hiddenCardWidth;
        private final View focusOnEndView;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(-1.0f * (float)this.hiddenCardWidth * interpolatedTime);
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public CardNumberSlideRightAnimation(@NotNull View view, int hiddenCardWidth, @NotNull View focusOnEndView) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            Intrinsics.checkParameterIsNotNull((Object)focusOnEndView, (String)"focusOnEndView");
            this.view = view;
            this.hiddenCardWidth = hiddenCardWidth;
            this.focusOnEndView = focusOnEndView;
            this.setAnimationListener(new AnimationEndListener(){

                public void onAnimationEnd(@NotNull Animation animation) {
                    Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                    focusOnEndView.requestFocus();
                }
            });
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/CardInputWidget$ExpiryDateSlideRightAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "startMargin", "", "destination", "(Landroid/view/View;II)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class ExpiryDateSlideRightAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int startMargin;
        private final int destination;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(interpolatedTime * (float)this.destination + (1.0f - interpolatedTime) * (float)this.startMargin);
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public ExpiryDateSlideRightAnimation(@NotNull View view, int startMargin, int destination) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.startMargin = startMargin;
            this.destination = destination;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/CardInputWidget$CvcSlideRightAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "startMargin", "", "destination", "newWidth", "(Landroid/view/View;III)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class CvcSlideRightAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int startMargin;
        private final int destination;
        private final int newWidth;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(interpolatedTime * (float)this.destination + (1.0f - interpolatedTime) * (float)this.startMargin);
            $this$apply.rightMargin = 0;
            $this$apply.width = this.newWidth;
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public CvcSlideRightAnimation(@NotNull View view, int startMargin, int destination, int newWidth) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.startMargin = startMargin;
            this.destination = destination;
            this.newWidth = newWidth;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/CardInputWidget$PostalCodeSlideRightAnimation;", "Lcom/stripe/android/view/CardInputWidget$CardFieldAnimation;", "view", "Landroid/view/View;", "startMargin", "", "destination", "newWidth", "(Landroid/view/View;III)V", "applyTransformation", "", "interpolatedTime", "", "t", "Landroid/view/animation/Transformation;", "stripe_release"})
    private static final class PostalCodeSlideRightAnimation
    extends CardFieldAnimation {
        private final View view;
        private final int startMargin;
        private final int destination;
        private final int newWidth;

        protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            super.applyTransformation(interpolatedTime, t);
            ViewGroup.LayoutParams layoutParams = this.view.getLayoutParams();
            if (layoutParams == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
            }
            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
            View view = this.view;
            boolean bl = false;
            boolean bl2 = false;
            FrameLayout.LayoutParams $this$apply = layoutParams2;
            boolean bl3 = false;
            $this$apply.leftMargin = (int)(interpolatedTime * (float)this.destination + (1.0f - interpolatedTime) * (float)this.startMargin);
            $this$apply.rightMargin = 0;
            $this$apply.width = this.newWidth;
            FrameLayout.LayoutParams layoutParams3 = layoutParams2;
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }

        public PostalCodeSlideRightAnimation(@NotNull View view, int startMargin, int destination, int newWidth) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.view = view;
            this.startMargin = startMargin;
            this.destination = destination;
            this.newWidth = newWidth;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/CardInputWidget$AnimationEndListener;", "Landroid/view/animation/Animation$AnimationListener;", "()V", "onAnimationRepeat", "", "animation", "Landroid/view/animation/Animation;", "onAnimationStart", "stripe_release"})
    private static abstract class AnimationEndListener
    implements Animation.AnimationListener {
        public void onAnimationStart(@NotNull Animation animation) {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        }

        public void onAnimationRepeat(@NotNull Animation animation) {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/CardInputWidget$LayoutWidthCalculator;", "", "calculate", "", "text", "", "paint", "Landroid/text/TextPaint;", "stripe_release"})
    public static interface LayoutWidthCalculator {
        public int calculate(@NotNull String var1, @NotNull TextPaint var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/CardInputWidget$DefaultLayoutWidthCalculator;", "Lcom/stripe/android/view/CardInputWidget$LayoutWidthCalculator;", "()V", "calculate", "", "text", "", "paint", "Landroid/text/TextPaint;", "stripe_release"})
    public static final class DefaultLayoutWidthCalculator
    implements LayoutWidthCalculator {
        @Override
        public int calculate(@NotNull String text, @NotNull TextPaint paint) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
            return (int)Layout.getDesiredWidth((CharSequence)text, (TextPaint)paint);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0001\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/view/CardInputWidget$Companion;", "", "()V", "CVC_PLACEHOLDER_AMEX", "", "CVC_PLACEHOLDER_COMMON", "DEFAULT_READER_ID", "", "FULL_SIZING_CARD_TEXT", "FULL_SIZING_DATE_TEXT", "FULL_SIZING_POSTAL_CODE_TEXT", "HIDDEN_TEXT_AMEX", "HIDDEN_TEXT_COMMON", "LOGGING_TOKEN", "PEEK_TEXT_AMEX", "PEEK_TEXT_COMMON", "PEEK_TEXT_DINERS", "STATE_CARD_VIEWED", "STATE_POSTAL_CODE_ENABLED", "STATE_SUPER_STATE", "shouldIconShowBrand", "", "brand", "Lcom/stripe/android/model/CardBrand;", "cvcHasFocus", "cvcText", "shouldIconShowBrand$stripe_release", "stripe_release"})
    public static final class Companion {
        @VisibleForTesting
        public final boolean shouldIconShowBrand$stripe_release(@NotNull CardBrand brand, boolean cvcHasFocus, @Nullable String cvcText) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
            return !cvcHasFocus || brand.isMaxCvc(cvcText);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

