/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import com.stripe.android.GooglePayConfig;
import com.stripe.android.PayWithGoogleUtils;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001c2\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J#\u0010\r\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J<\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u000f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/stripe/android/GooglePayJsonFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "googlePayConfig", "Lcom/stripe/android/GooglePayConfig;", "(Lcom/stripe/android/GooglePayConfig;)V", "createBaseCardPaymentMethodParams", "Lorg/json/JSONObject;", "createCardPaymentMethod", "billingAddressParameters", "Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;", "createIsReadyToPayRequest", "existingPaymentMethodRequired", "", "(Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;Ljava/lang/Boolean;)Lorg/json/JSONObject;", "createPaymentDataRequest", "transactionInfo", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "shippingAddressParameters", "Lcom/stripe/android/GooglePayJsonFactory$ShippingAddressParameters;", "isEmailRequired", "merchantInfo", "Lcom/stripe/android/GooglePayJsonFactory$MerchantInfo;", "createShippingAddressParameters", "createTransactionInfo", "BillingAddressParameters", "Companion", "MerchantInfo", "ShippingAddressParameters", "TransactionInfo", "stripe_release"})
public final class GooglePayJsonFactory {
    private final GooglePayConfig googlePayConfig;
    private static final int API_VERSION = 2;
    private static final int API_VERSION_MINOR = 0;
    private static final String CARD_PAYMENT_METHOD = "CARD";
    private static final List<String> ALLOWED_AUTH_METHODS;
    private static final List<String> ALLOWED_CARD_NETWORKS;
    public static final Companion Companion;

    @NotNull
    public final JSONObject createIsReadyToPayRequest(@Nullable BillingAddressParameters billingAddressParameters, @Nullable Boolean existingPaymentMethodRequired) {
        JSONObject jSONObject = new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0).put("allowedPaymentMethods", (Object)new JSONArray().put((Object)this.createCardPaymentMethod(billingAddressParameters)));
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        if (existingPaymentMethodRequired != null) {
            $this$apply.put("existingPaymentMethodRequired", existingPaymentMethodRequired.booleanValue());
        }
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"JSONObject()\n           \u2026          }\n            }");
        return jSONObject2;
    }

    public static /* synthetic */ JSONObject createIsReadyToPayRequest$default(GooglePayJsonFactory googlePayJsonFactory, BillingAddressParameters billingAddressParameters, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            billingAddressParameters = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        return googlePayJsonFactory.createIsReadyToPayRequest(billingAddressParameters, bl);
    }

    @NotNull
    public final JSONObject createPaymentDataRequest(@NotNull TransactionInfo transactionInfo, @Nullable BillingAddressParameters billingAddressParameters, @Nullable ShippingAddressParameters shippingAddressParameters, boolean isEmailRequired, @Nullable MerchantInfo merchantInfo) {
        Intrinsics.checkParameterIsNotNull((Object)transactionInfo, (String)"transactionInfo");
        JSONObject jSONObject = new JSONObject().put("apiVersion", 2).put("apiVersionMinor", 0).put("allowedPaymentMethods", (Object)new JSONArray().put((Object)this.createCardPaymentMethod(billingAddressParameters))).put("transactionInfo", (Object)this.createTransactionInfo(transactionInfo)).put("emailRequired", isEmailRequired);
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        ShippingAddressParameters shippingAddressParameters2 = shippingAddressParameters;
        if (shippingAddressParameters2 != null) {
            if (shippingAddressParameters2.isRequired$stripe_release()) {
                $this$apply.put("shippingAddressRequired", true);
                $this$apply.put("shippingAddressParameters", (Object)this.createShippingAddressParameters(shippingAddressParameters));
            }
        }
        if (merchantInfo != null) {
            CharSequence charSequence = merchantInfo.getMerchantName$stripe_release();
            boolean bl4 = false;
            boolean bl5 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                $this$apply.put("merchantInfo", (Object)new JSONObject().put("merchantName", (Object)merchantInfo.getMerchantName$stripe_release()));
            }
        }
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"JSONObject()\n           \u2026          }\n            }");
        return jSONObject2;
    }

    public static /* synthetic */ JSONObject createPaymentDataRequest$default(GooglePayJsonFactory googlePayJsonFactory, TransactionInfo transactionInfo, BillingAddressParameters billingAddressParameters, ShippingAddressParameters shippingAddressParameters, boolean bl, MerchantInfo merchantInfo, int n, Object object) {
        if ((n & 2) != 0) {
            billingAddressParameters = null;
        }
        if ((n & 4) != 0) {
            shippingAddressParameters = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            merchantInfo = null;
        }
        return googlePayJsonFactory.createPaymentDataRequest(transactionInfo, billingAddressParameters, shippingAddressParameters, bl, merchantInfo);
    }

    private final JSONObject createTransactionInfo(TransactionInfo transactionInfo) {
        String it;
        boolean bl;
        boolean bl2;
        Object object;
        JSONObject jSONObject = new JSONObject().put("currencyCode", (Object)transactionInfo.getCurrencyCode$stripe_release()).put("totalPriceStatus", (Object)transactionInfo.getTotalPriceStatus$stripe_release().getCode$stripe_release());
        boolean bl3 = false;
        boolean bl4 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl5 = false;
        String string2 = transactionInfo.getCountryCode$stripe_release();
        if (string2 != null) {
            object = string2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl6 = false;
            $this$apply.put("countryCode", (Object)it);
        }
        String string3 = transactionInfo.getTransactionId$stripe_release();
        if (string3 != null) {
            object = string3;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            $this$apply.put("transactionId", (Object)it);
        }
        Integer n = transactionInfo.getTotalPrice$stripe_release();
        if (n != null) {
            object = n;
            bl2 = false;
            bl = false;
            int it2 = ((Number)object).intValue();
            boolean bl8 = false;
            Currency currency = Currency.getInstance(transactionInfo.getCurrencyCode$stripe_release());
            Intrinsics.checkExpressionValueIsNotNull((Object)currency, (String)"Currency.getInstance(transactionInfo.currencyCode)");
            $this$apply.put("totalPrice", (Object)PayWithGoogleUtils.getPriceString(it2, currency));
        }
        String string4 = transactionInfo.getTotalPriceLabel$stripe_release();
        if (string4 != null) {
            object = string4;
            bl2 = false;
            bl = false;
            Object it3 = object;
            boolean bl9 = false;
            $this$apply.put("totalPriceLabel", it3);
        }
        TransactionInfo.CheckoutOption checkoutOption = transactionInfo.getCheckoutOption$stripe_release();
        if (checkoutOption != null) {
            object = checkoutOption;
            bl2 = false;
            bl = false;
            Object it4 = object;
            boolean bl10 = false;
            $this$apply.put("checkoutOption", (Object)((TransactionInfo.CheckoutOption)((Object)it4)).getCode$stripe_release());
        }
        JSONObject jSONObject2 = jSONObject;
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"JSONObject()\n           \u2026          }\n            }");
        return jSONObject2;
    }

    private final JSONObject createShippingAddressParameters(ShippingAddressParameters shippingAddressParameters) {
        JSONObject jSONObject = new JSONObject().put("allowedCountryCodes", (Object)new JSONArray((Collection)shippingAddressParameters.getAllowedCountryCodes$stripe_release())).put("phoneNumberRequired", shippingAddressParameters.getPhoneNumberRequired$stripe_release());
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"JSONObject()\n           \u2026ters.phoneNumberRequired)");
        return jSONObject;
    }

    private final JSONObject createCardPaymentMethod(BillingAddressParameters billingAddressParameters) {
        JSONObject jSONObject = this.createBaseCardPaymentMethodParams();
        boolean bl = false;
        boolean bl2 = false;
        JSONObject $this$apply = jSONObject;
        boolean bl3 = false;
        BillingAddressParameters billingAddressParameters2 = billingAddressParameters;
        if (billingAddressParameters2 != null) {
            if (billingAddressParameters2.isRequired$stripe_release()) {
                $this$apply.put("billingAddressRequired", true);
                $this$apply.put("billingAddressParameters", (Object)new JSONObject().put("phoneNumberRequired", billingAddressParameters.isPhoneNumberRequired$stripe_release()).put("format", (Object)billingAddressParameters.getFormat$stripe_release().getCode$stripe_release()));
            }
        }
        JSONObject cardPaymentMethodParams = jSONObject;
        JSONObject jSONObject2 = new JSONObject().put("type", (Object)CARD_PAYMENT_METHOD).put("parameters", (Object)cardPaymentMethodParams).put("tokenizationSpecification", (Object)this.googlePayConfig.getTokenizationSpecification());
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject2, (String)"JSONObject()\n           \u2026okenizationSpecification)");
        return jSONObject2;
    }

    private final JSONObject createBaseCardPaymentMethodParams() {
        JSONObject jSONObject = new JSONObject().put("allowedAuthMethods", (Object)new JSONArray((Collection)ALLOWED_AUTH_METHODS)).put("allowedCardNetworks", (Object)new JSONArray((Collection)ALLOWED_CARD_NETWORKS));
        Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"JSONObject()\n           \u2026y(ALLOWED_CARD_NETWORKS))");
        return jSONObject;
    }

    public GooglePayJsonFactory(@NotNull GooglePayConfig googlePayConfig) {
        Intrinsics.checkParameterIsNotNull((Object)googlePayConfig, (String)"googlePayConfig");
        this.googlePayConfig = googlePayConfig;
    }

    public GooglePayJsonFactory(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(new GooglePayConfig(context, null, 2, null));
    }

    static {
        Companion = new Companion(null);
        ALLOWED_AUTH_METHODS = CollectionsKt.listOf((Object[])new String[]{"PAN_ONLY", "CRYPTOGRAM_3DS"});
        ALLOWED_CARD_NETWORKS = CollectionsKt.listOf((Object[])new String[]{"AMEX", "DISCOVER", "INTERAC", "JCB", "MASTERCARD", "VISA"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001aB%\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters;", "", "isRequired", "", "format", "Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;", "isPhoneNumberRequired", "(ZLcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;Z)V", "getFormat$stripe_release", "()Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;", "isPhoneNumberRequired$stripe_release", "()Z", "isRequired$stripe_release", "component1", "component1$stripe_release", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "copy", "equals", "other", "hashCode", "", "toString", "", "Format", "stripe_release"})
    public static final class BillingAddressParameters {
        private final boolean isRequired;
        @NotNull
        private final Format format;
        private final boolean isPhoneNumberRequired;

        public final boolean isRequired$stripe_release() {
            return this.isRequired;
        }

        @NotNull
        public final Format getFormat$stripe_release() {
            return this.format;
        }

        public final boolean isPhoneNumberRequired$stripe_release() {
            return this.isPhoneNumberRequired;
        }

        @JvmOverloads
        public BillingAddressParameters(boolean isRequired, @NotNull Format format, boolean isPhoneNumberRequired) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            this.isRequired = isRequired;
            this.format = format;
            this.isPhoneNumberRequired = isPhoneNumberRequired;
        }

        public /* synthetic */ BillingAddressParameters(boolean bl, Format format, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                format = Format.Min;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(bl, format, bl2);
        }

        @JvmOverloads
        public BillingAddressParameters(boolean isRequired, @NotNull Format format) {
            this(isRequired, format, false, 4, null);
        }

        @JvmOverloads
        public BillingAddressParameters(boolean isRequired) {
            this(isRequired, null, false, 6, null);
        }

        @JvmOverloads
        public BillingAddressParameters() {
            this(false, null, false, 7, null);
        }

        public final boolean component1$stripe_release() {
            return this.isRequired;
        }

        @NotNull
        public final Format component2$stripe_release() {
            return this.format;
        }

        public final boolean component3$stripe_release() {
            return this.isPhoneNumberRequired;
        }

        @NotNull
        public final BillingAddressParameters copy(boolean isRequired, @NotNull Format format, boolean isPhoneNumberRequired) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)format), (String)"format");
            return new BillingAddressParameters(isRequired, format, isPhoneNumberRequired);
        }

        public static /* synthetic */ BillingAddressParameters copy$default(BillingAddressParameters billingAddressParameters, boolean bl, Format format, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = billingAddressParameters.isRequired;
            }
            if ((n & 2) != 0) {
                format = billingAddressParameters.format;
            }
            if ((n & 4) != 0) {
                bl2 = billingAddressParameters.isPhoneNumberRequired;
            }
            return billingAddressParameters.copy(bl, format, bl2);
        }

        @NotNull
        public String toString() {
            return "BillingAddressParameters(isRequired=" + this.isRequired + ", format=" + (Object)((Object)this.format) + ", isPhoneNumberRequired=" + this.isPhoneNumberRequired + ")";
        }

        public int hashCode() {
            int n = this.isRequired ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Format format = this.format;
            int n2 = (n * 31 + (format != null ? ((Object)((Object)format)).hashCode() : 0)) * 31;
            int n3 = this.isPhoneNumberRequired ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BillingAddressParameters)) break block3;
                    BillingAddressParameters billingAddressParameters = (BillingAddressParameters)object;
                    if (this.isRequired != billingAddressParameters.isRequired || !Intrinsics.areEqual((Object)((Object)this.format), (Object)((Object)billingAddressParameters.format)) || this.isPhoneNumberRequired != billingAddressParameters.isPhoneNumberRequired) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$BillingAddressParameters$Format;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$stripe_release", "()Ljava/lang/String;", "Min", "Full", "stripe_release"})
        public static final class Format
        extends Enum<Format> {
            public static final /* enum */ Format Min;
            public static final /* enum */ Format Full;
            private static final /* synthetic */ Format[] $VALUES;
            @NotNull
            private final String code;

            static {
                Format[] formatArray = new Format[2];
                Format[] formatArray2 = formatArray;
                formatArray[0] = Min = new Format("MIN");
                formatArray[1] = Full = new Format("FULL");
                $VALUES = formatArray;
            }

            @NotNull
            public final String getCode$stripe_release() {
                return this.code;
            }

            private Format(String code) {
                this.code = code;
            }

            public static Format[] values() {
                return (Format[])$VALUES.clone();
            }

            public static Format valueOf(String string2) {
                return Enum.valueOf(Format.class, string2);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001:\u0002/0BS\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u001a\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b!J\u0012\u0010\"\u001a\u0004\u0018\u00010\tH\u00c0\u0003\u00a2\u0006\u0004\b#\u0010\u0014J\u0010\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u0004\u0018\u00010\fH\u00c0\u0003\u00a2\u0006\u0002\b'J^\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001\u00a2\u0006\u0002\u0010)J\u0013\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020\tH\u00d6\u0001J\t\u0010.\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0018\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u00061"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "", "currencyCode", "", "totalPriceStatus", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;", "countryCode", "transactionId", "totalPrice", "", "totalPriceLabel", "checkoutOption", "Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;", "(Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;)V", "getCheckoutOption$stripe_release", "()Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;", "getCountryCode$stripe_release", "()Ljava/lang/String;", "getCurrencyCode$stripe_release", "getTotalPrice$stripe_release", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getTotalPriceLabel$stripe_release", "getTotalPriceStatus$stripe_release", "()Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;", "getTransactionId$stripe_release", "component1", "component1$stripe_release", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "component4", "component4$stripe_release", "component5", "component5$stripe_release", "component6", "component6$stripe_release", "component7", "component7$stripe_release", "copy", "(Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;)Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo;", "equals", "", "other", "hashCode", "toString", "CheckoutOption", "TotalPriceStatus", "stripe_release"})
    public static final class TransactionInfo {
        @NotNull
        private final String currencyCode;
        @NotNull
        private final TotalPriceStatus totalPriceStatus;
        @Nullable
        private final String countryCode;
        @Nullable
        private final String transactionId;
        @Nullable
        private final Integer totalPrice;
        @Nullable
        private final String totalPriceLabel;
        @Nullable
        private final CheckoutOption checkoutOption;

        @NotNull
        public final String getCurrencyCode$stripe_release() {
            return this.currencyCode;
        }

        @NotNull
        public final TotalPriceStatus getTotalPriceStatus$stripe_release() {
            return this.totalPriceStatus;
        }

        @Nullable
        public final String getCountryCode$stripe_release() {
            return this.countryCode;
        }

        @Nullable
        public final String getTransactionId$stripe_release() {
            return this.transactionId;
        }

        @Nullable
        public final Integer getTotalPrice$stripe_release() {
            return this.totalPrice;
        }

        @Nullable
        public final String getTotalPriceLabel$stripe_release() {
            return this.totalPriceLabel;
        }

        @Nullable
        public final CheckoutOption getCheckoutOption$stripe_release() {
            return this.checkoutOption;
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice, @Nullable String totalPriceLabel, @Nullable CheckoutOption checkoutOption) {
            Intrinsics.checkParameterIsNotNull((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkParameterIsNotNull((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            this.currencyCode = currencyCode;
            this.totalPriceStatus = totalPriceStatus;
            this.countryCode = countryCode;
            this.transactionId = transactionId;
            this.totalPrice = totalPrice;
            this.totalPriceLabel = totalPriceLabel;
            this.checkoutOption = checkoutOption;
        }

        public /* synthetic */ TransactionInfo(String string2, TotalPriceStatus totalPriceStatus, String string3, String string4, Integer n, String string5, CheckoutOption checkoutOption, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string3 = null;
            }
            if ((n2 & 8) != 0) {
                string4 = null;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            if ((n2 & 0x20) != 0) {
                string5 = null;
            }
            if ((n2 & 0x40) != 0) {
                checkoutOption = null;
            }
            this(string2, totalPriceStatus, string3, string4, n, string5, checkoutOption);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice, @Nullable String totalPriceLabel) {
            this(currencyCode, totalPriceStatus, countryCode, transactionId, totalPrice, totalPriceLabel, null, 64, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice) {
            this(currencyCode, totalPriceStatus, countryCode, transactionId, totalPrice, null, null, 96, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId) {
            this(currencyCode, totalPriceStatus, countryCode, transactionId, null, null, null, 112, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode) {
            this(currencyCode, totalPriceStatus, countryCode, null, null, null, null, 120, null);
        }

        @JvmOverloads
        public TransactionInfo(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus) {
            this(currencyCode, totalPriceStatus, null, null, null, null, null, 124, null);
        }

        @NotNull
        public final String component1$stripe_release() {
            return this.currencyCode;
        }

        @NotNull
        public final TotalPriceStatus component2$stripe_release() {
            return this.totalPriceStatus;
        }

        @Nullable
        public final String component3$stripe_release() {
            return this.countryCode;
        }

        @Nullable
        public final String component4$stripe_release() {
            return this.transactionId;
        }

        @Nullable
        public final Integer component5$stripe_release() {
            return this.totalPrice;
        }

        @Nullable
        public final String component6$stripe_release() {
            return this.totalPriceLabel;
        }

        @Nullable
        public final CheckoutOption component7$stripe_release() {
            return this.checkoutOption;
        }

        @NotNull
        public final TransactionInfo copy(@NotNull String currencyCode, @NotNull TotalPriceStatus totalPriceStatus, @Nullable String countryCode, @Nullable String transactionId, @Nullable Integer totalPrice, @Nullable String totalPriceLabel, @Nullable CheckoutOption checkoutOption) {
            Intrinsics.checkParameterIsNotNull((Object)currencyCode, (String)"currencyCode");
            Intrinsics.checkParameterIsNotNull((Object)((Object)totalPriceStatus), (String)"totalPriceStatus");
            return new TransactionInfo(currencyCode, totalPriceStatus, countryCode, transactionId, totalPrice, totalPriceLabel, checkoutOption);
        }

        public static /* synthetic */ TransactionInfo copy$default(TransactionInfo transactionInfo, String string2, TotalPriceStatus totalPriceStatus, String string3, String string4, Integer n, String string5, CheckoutOption checkoutOption, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = transactionInfo.currencyCode;
            }
            if ((n2 & 2) != 0) {
                totalPriceStatus = transactionInfo.totalPriceStatus;
            }
            if ((n2 & 4) != 0) {
                string3 = transactionInfo.countryCode;
            }
            if ((n2 & 8) != 0) {
                string4 = transactionInfo.transactionId;
            }
            if ((n2 & 0x10) != 0) {
                n = transactionInfo.totalPrice;
            }
            if ((n2 & 0x20) != 0) {
                string5 = transactionInfo.totalPriceLabel;
            }
            if ((n2 & 0x40) != 0) {
                checkoutOption = transactionInfo.checkoutOption;
            }
            return transactionInfo.copy(string2, totalPriceStatus, string3, string4, n, string5, checkoutOption);
        }

        @NotNull
        public String toString() {
            return "TransactionInfo(currencyCode=" + this.currencyCode + ", totalPriceStatus=" + (Object)((Object)this.totalPriceStatus) + ", countryCode=" + this.countryCode + ", transactionId=" + this.transactionId + ", totalPrice=" + this.totalPrice + ", totalPriceLabel=" + this.totalPriceLabel + ", checkoutOption=" + (Object)((Object)this.checkoutOption) + ")";
        }

        public int hashCode() {
            String string2 = this.currencyCode;
            TotalPriceStatus totalPriceStatus = this.totalPriceStatus;
            String string3 = this.countryCode;
            String string4 = this.transactionId;
            Integer n = this.totalPrice;
            String string5 = this.totalPriceLabel;
            CheckoutOption checkoutOption = this.checkoutOption;
            return ((((((string2 != null ? string2.hashCode() : 0) * 31 + (totalPriceStatus != null ? ((Object)((Object)totalPriceStatus)).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (checkoutOption != null ? ((Object)((Object)checkoutOption)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TransactionInfo)) break block3;
                    TransactionInfo transactionInfo = (TransactionInfo)object;
                    if (!Intrinsics.areEqual((Object)this.currencyCode, (Object)transactionInfo.currencyCode) || !Intrinsics.areEqual((Object)((Object)this.totalPriceStatus), (Object)((Object)transactionInfo.totalPriceStatus)) || !Intrinsics.areEqual((Object)this.countryCode, (Object)transactionInfo.countryCode) || !Intrinsics.areEqual((Object)this.transactionId, (Object)transactionInfo.transactionId) || !Intrinsics.areEqual((Object)this.totalPrice, (Object)transactionInfo.totalPrice) || !Intrinsics.areEqual((Object)this.totalPriceLabel, (Object)transactionInfo.totalPriceLabel) || !Intrinsics.areEqual((Object)((Object)this.checkoutOption), (Object)((Object)transactionInfo.checkoutOption))) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$TotalPriceStatus;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$stripe_release", "()Ljava/lang/String;", "NotCurrentlyKnown", "Estimated", "Final", "stripe_release"})
        public static final class TotalPriceStatus
        extends Enum<TotalPriceStatus> {
            public static final /* enum */ TotalPriceStatus NotCurrentlyKnown;
            public static final /* enum */ TotalPriceStatus Estimated;
            public static final /* enum */ TotalPriceStatus Final;
            private static final /* synthetic */ TotalPriceStatus[] $VALUES;
            @NotNull
            private final String code;

            static {
                TotalPriceStatus[] totalPriceStatusArray = new TotalPriceStatus[3];
                TotalPriceStatus[] totalPriceStatusArray2 = totalPriceStatusArray;
                totalPriceStatusArray[0] = NotCurrentlyKnown = new TotalPriceStatus("NOT_CURRENTLY_KNOWN");
                totalPriceStatusArray[1] = Estimated = new TotalPriceStatus("ESTIMATED");
                totalPriceStatusArray[2] = Final = new TotalPriceStatus("FINAL");
                $VALUES = totalPriceStatusArray;
            }

            @NotNull
            public final String getCode$stripe_release() {
                return this.code;
            }

            private TotalPriceStatus(String code) {
                this.code = code;
            }

            public static TotalPriceStatus[] values() {
                return (TotalPriceStatus[])$VALUES.clone();
            }

            public static TotalPriceStatus valueOf(String string2) {
                return Enum.valueOf(TotalPriceStatus.class, string2);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$TransactionInfo$CheckoutOption;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode$stripe_release", "()Ljava/lang/String;", "Default", "CompleteImmediatePurchase", "stripe_release"})
        public static final class CheckoutOption
        extends Enum<CheckoutOption> {
            public static final /* enum */ CheckoutOption Default;
            public static final /* enum */ CheckoutOption CompleteImmediatePurchase;
            private static final /* synthetic */ CheckoutOption[] $VALUES;
            @NotNull
            private final String code;

            static {
                CheckoutOption[] checkoutOptionArray = new CheckoutOption[2];
                CheckoutOption[] checkoutOptionArray2 = checkoutOptionArray;
                checkoutOptionArray[0] = Default = new CheckoutOption("DEFAULT");
                checkoutOptionArray[1] = CompleteImmediatePurchase = new CheckoutOption("COMPLETE_IMMEDIATE_PURCHASE");
                $VALUES = checkoutOptionArray;
            }

            @NotNull
            public final String getCode$stripe_release() {
                return this.code;
            }

            private CheckoutOption(String code) {
                this.code = code;
            }

            public static CheckoutOption[] values() {
                return (CheckoutOption[])$VALUES.clone();
            }

            public static CheckoutOption valueOf(String string2) {
                return Enum.valueOf(CheckoutOption.class, string2);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0011J\u000e\u0010\u0012\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0013J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$ShippingAddressParameters;", "", "isRequired", "", "allowedCountryCodes", "", "", "phoneNumberRequired", "(ZLjava/util/Set;Z)V", "getAllowedCountryCodes$stripe_release", "()Ljava/util/Set;", "isRequired$stripe_release", "()Z", "getPhoneNumberRequired$stripe_release", "component1", "component1$stripe_release", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "copy", "equals", "other", "hashCode", "", "toString", "stripe_release"})
    public static final class ShippingAddressParameters {
        private final boolean isRequired;
        @NotNull
        private final Set<String> allowedCountryCodes;
        private final boolean phoneNumberRequired;

        public final boolean isRequired$stripe_release() {
            return this.isRequired;
        }

        @NotNull
        public final Set<String> getAllowedCountryCodes$stripe_release() {
            return this.allowedCountryCodes;
        }

        public final boolean getPhoneNumberRequired$stripe_release() {
            return this.phoneNumberRequired;
        }

        @JvmOverloads
        public ShippingAddressParameters(boolean isRequired, @NotNull Set<String> allowedCountryCodes, boolean phoneNumberRequired) {
            Intrinsics.checkParameterIsNotNull(allowedCountryCodes, (String)"allowedCountryCodes");
            this.isRequired = isRequired;
            this.allowedCountryCodes = allowedCountryCodes;
            this.phoneNumberRequired = phoneNumberRequired;
            String[] countryCodes = Locale.getISOCountries();
            Iterable $this$forEach$iv = this.allowedCountryCodes;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                String allowedShippingCountryCode;
                block2: {
                    allowedShippingCountryCode = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkExpressionValueIsNotNull((Object)countryCodes, (String)"countryCodes");
                    String[] $this$any$iv = countryCodes;
                    boolean $i$f$any = false;
                    String[] stringArray = $this$any$iv;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String element$iv2;
                        String it = element$iv2 = stringArray[i];
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)allowedShippingCountryCode, (Object)it)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                boolean bl4 = bl;
                boolean bl5 = false;
                boolean bl6 = false;
                if (bl4) continue;
                boolean bl7 = false;
                String string2 = '\'' + allowedShippingCountryCode + "' is not a valid country code";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
        }

        public /* synthetic */ ShippingAddressParameters(boolean bl, Set set, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                set = SetsKt.emptySet();
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(bl, set, bl2);
        }

        @JvmOverloads
        public ShippingAddressParameters(boolean isRequired, @NotNull Set<String> allowedCountryCodes) {
            this(isRequired, allowedCountryCodes, false, 4, null);
        }

        @JvmOverloads
        public ShippingAddressParameters(boolean isRequired) {
            this(isRequired, null, false, 6, null);
        }

        @JvmOverloads
        public ShippingAddressParameters() {
            this(false, null, false, 7, null);
        }

        public final boolean component1$stripe_release() {
            return this.isRequired;
        }

        @NotNull
        public final Set<String> component2$stripe_release() {
            return this.allowedCountryCodes;
        }

        public final boolean component3$stripe_release() {
            return this.phoneNumberRequired;
        }

        @NotNull
        public final ShippingAddressParameters copy(boolean isRequired, @NotNull Set<String> allowedCountryCodes, boolean phoneNumberRequired) {
            Intrinsics.checkParameterIsNotNull(allowedCountryCodes, (String)"allowedCountryCodes");
            return new ShippingAddressParameters(isRequired, allowedCountryCodes, phoneNumberRequired);
        }

        public static /* synthetic */ ShippingAddressParameters copy$default(ShippingAddressParameters shippingAddressParameters, boolean bl, Set set, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = shippingAddressParameters.isRequired;
            }
            if ((n & 2) != 0) {
                set = shippingAddressParameters.allowedCountryCodes;
            }
            if ((n & 4) != 0) {
                bl2 = shippingAddressParameters.phoneNumberRequired;
            }
            return shippingAddressParameters.copy(bl, set, bl2);
        }

        @NotNull
        public String toString() {
            return "ShippingAddressParameters(isRequired=" + this.isRequired + ", allowedCountryCodes=" + this.allowedCountryCodes + ", phoneNumberRequired=" + this.phoneNumberRequired + ")";
        }

        public int hashCode() {
            int n = this.isRequired ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            Set<String> set = this.allowedCountryCodes;
            int n2 = (n * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31;
            int n3 = this.phoneNumberRequired ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ShippingAddressParameters)) break block3;
                    ShippingAddressParameters shippingAddressParameters = (ShippingAddressParameters)object;
                    if (this.isRequired != shippingAddressParameters.isRequired || !Intrinsics.areEqual(this.allowedCountryCodes, shippingAddressParameters.allowedCountryCodes) || this.phoneNumberRequired != shippingAddressParameters.phoneNumberRequired) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\bJ\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$MerchantInfo;", "", "merchantName", "", "(Ljava/lang/String;)V", "getMerchantName$stripe_release", "()Ljava/lang/String;", "component1", "component1$stripe_release", "copy", "equals", "", "other", "hashCode", "", "toString", "stripe_release"})
    public static final class MerchantInfo {
        @Nullable
        private final String merchantName;

        @Nullable
        public final String getMerchantName$stripe_release() {
            return this.merchantName;
        }

        public MerchantInfo(@Nullable String merchantName) {
            this.merchantName = merchantName;
        }

        public /* synthetic */ MerchantInfo(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            this(string2);
        }

        public MerchantInfo() {
            this(null, 1, null);
        }

        @Nullable
        public final String component1$stripe_release() {
            return this.merchantName;
        }

        @NotNull
        public final MerchantInfo copy(@Nullable String merchantName) {
            return new MerchantInfo(merchantName);
        }

        public static /* synthetic */ MerchantInfo copy$default(MerchantInfo merchantInfo, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = merchantInfo.merchantName;
            }
            return merchantInfo.copy(string2);
        }

        @NotNull
        public String toString() {
            return "MerchantInfo(merchantName=" + this.merchantName + ")";
        }

        public int hashCode() {
            String string2 = this.merchantName;
            return string2 != null ? string2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof MerchantInfo)) break block3;
                    MerchantInfo merchantInfo = (MerchantInfo)object;
                    if (!Intrinsics.areEqual((Object)this.merchantName, (Object)merchantInfo.merchantName)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/GooglePayJsonFactory$Companion;", "", "()V", "ALLOWED_AUTH_METHODS", "", "", "ALLOWED_CARD_NETWORKS", "API_VERSION", "", "API_VERSION_MINOR", "CARD_PAYMENT_METHOD", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

