/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.Stripe;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u0000 (2\u00020\u0001:\u0004'()*B!\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0002J.\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0002J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0016J8\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0016J&\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000eJ.\u0010%\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/stripe/android/IssuingCardPinService;", "Lcom/stripe/android/EphemeralKeyManager$KeyManagerListener;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "(Lcom/stripe/android/EphemeralKeyProvider;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/OperationIdFactory;)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "retrievalListeners", "", "", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "updateListeners", "Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "fireRetrievePinRequest", "", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operationId", "arguments", "", "", "fireUpdatePinRequest", "onKeyError", "errorCode", "", "errorMessage", "onKeyUpdate", "action", "retrievePin", "cardId", "verificationId", "userOneTimeCode", "listener", "updatePin", "newPin", "CardPinActionError", "Companion", "IssuingCardPinRetrievalListener", "IssuingCardPinUpdateListener", "stripe_release"})
public final class IssuingCardPinService
implements EphemeralKeyManager.KeyManagerListener {
    private final Map<String, IssuingCardPinRetrievalListener> retrievalListeners;
    private final Map<String, IssuingCardPinUpdateListener> updateListeners;
    private final EphemeralKeyManager ephemeralKeyManager;
    private final StripeRepository stripeRepository;
    private final OperationIdFactory operationIdFactory;
    private static final String TAG;
    private static final long KEY_REFRESH_BUFFER_IN_SECONDS = 30L;
    private static final String PIN_RETRIEVE = "PIN_RETRIEVE";
    private static final String PIN_UPDATE = "PIN_UPDATE";
    private static final String ARGUMENT_CARD_ID = "cardId";
    private static final String ARGUMENT_VERIFICATION_ID = "verificationId";
    private static final String ARGUMENT_ONE_TIME_CODE = "userOneTimeCode";
    private static final String ARGUMENT_NEW_PIN = "newPin";
    public static final Companion Companion;

    public final void retrievePin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)ARGUMENT_CARD_ID);
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)ARGUMENT_VERIFICATION_ID);
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)ARGUMENT_ONE_TIME_CODE);
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ARGUMENT_CARD_ID, (Object)cardId), TuplesKt.to((Object)ARGUMENT_VERIFICATION_ID, (Object)verificationId), TuplesKt.to((Object)ARGUMENT_ONE_TIME_CODE, (Object)userOneTimeCode)});
        String operationId = this.operationIdFactory.create();
        this.retrievalListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey(operationId, PIN_RETRIEVE, arguments);
    }

    public final void updatePin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull IssuingCardPinUpdateListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)ARGUMENT_CARD_ID);
        Intrinsics.checkParameterIsNotNull((Object)newPin, (String)ARGUMENT_NEW_PIN);
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)ARGUMENT_VERIFICATION_ID);
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)ARGUMENT_ONE_TIME_CODE);
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Map arguments = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)ARGUMENT_CARD_ID, (Object)cardId), TuplesKt.to((Object)ARGUMENT_NEW_PIN, (Object)newPin), TuplesKt.to((Object)ARGUMENT_VERIFICATION_ID, (Object)verificationId), TuplesKt.to((Object)ARGUMENT_ONE_TIME_CODE, (Object)userOneTimeCode)});
        String operationId = this.operationIdFactory.create();
        this.updateListeners.put(operationId, listener);
        this.ephemeralKeyManager.retrieveEphemeralKey(operationId, PIN_UPDATE, arguments);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void onKeyUpdate(@NotNull EphemeralKey ephemeralKey, @NotNull String operationId, @Nullable String action, @Nullable Map<String, ? extends Object> arguments) {
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKey, (String)"ephemeralKey");
        Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
        String string = action;
        if (string == null) return;
        String string2 = string;
        switch (string2.hashCode()) {
            case 2081806035: {
                if (!string2.equals(PIN_UPDATE)) return;
                break;
            }
            case 1823178694: {
                if (!string2.equals(PIN_RETRIEVE)) return;
                this.fireRetrievePinRequest(ephemeralKey, operationId, arguments);
                return;
            }
        }
        this.fireUpdatePinRequest(ephemeralKey, operationId, arguments);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireRetrievePinRequest(EphemeralKey ephemeralKey, String operationId, Map<String, ? extends Object> arguments) {
        IssuingCardPinRetrievalListener listener = this.retrievalListeners.remove(operationId);
        if (listener == null) {
            Log.e((String)TAG, (String)(IssuingCardPinService.class.getName() + " was called without a listener"));
            return;
        }
        if (arguments == null) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "Arguments were lost during the ephemeral key call, this is not supposed to happen, please contact support@stripe.com for assistance.", null);
            return;
        }
        Object object = arguments.get(ARGUMENT_CARD_ID);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String cardId = (String)object;
        Object object2 = arguments.get(ARGUMENT_VERIFICATION_ID);
        bl2 = false;
        bl3 = false;
        bl3 = false;
        boolean bl5 = false;
        if (object2 == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String verificationId = (String)object2;
        Object object3 = arguments.get(ARGUMENT_ONE_TIME_CODE);
        bl3 = false;
        bl5 = false;
        bl5 = false;
        boolean bl7 = false;
        if (object3 == null) {
            boolean bl8 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String userOneTimeCode = (String)object3;
        try {
            String pin = this.stripeRepository.retrieveIssuingCardPin(cardId, verificationId, userOneTimeCode, ephemeralKey.getSecret());
            listener.onIssuingCardPinRetrieved(pin);
            return;
        }
        catch (InvalidRequestException e) {
            String string = e.getErrorCode();
            if (string != null) {
                switch (string) {
                    case "expired": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                        return;
                    }
                    case "incorrect_code": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect", null);
                        return;
                    }
                    case "too_many_attempts": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times", null);
                        return;
                    }
                    case "already_redeemed": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed", null);
                        return;
                    }
                }
            }
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to retrieve the PIN failed, possibly an error with the verification. Please check the exception.", e);
            return;
        }
        catch (APIConnectionException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (APIException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (AuthenticationException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (JSONException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
            return;
        }
        catch (CardException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN, please check the exception", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void fireUpdatePinRequest(EphemeralKey ephemeralKey, String operationId, Map<String, ? extends Object> arguments) {
        IssuingCardPinUpdateListener listener = this.updateListeners.remove(operationId);
        if (listener == null) {
            Log.e((String)TAG, (String)(IssuingCardPinService.class.getName() + " was called without a listener"));
            return;
        }
        if (arguments == null) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "Arguments were lost during the ephemeral key call, this is not supposed to happen, please contact support@stripe.com for assistance.", null);
            return;
        }
        Object object = arguments.get(ARGUMENT_CARD_ID);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String cardId = (String)object;
        Object object2 = arguments.get(ARGUMENT_NEW_PIN);
        bl2 = false;
        bl3 = false;
        bl3 = false;
        boolean bl5 = false;
        if (object2 == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String newPin = (String)object2;
        Object object3 = arguments.get(ARGUMENT_VERIFICATION_ID);
        bl3 = false;
        bl5 = false;
        bl5 = false;
        boolean bl7 = false;
        if (object3 == null) {
            boolean bl8 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String verificationId = (String)object3;
        Object object4 = arguments.get(ARGUMENT_ONE_TIME_CODE);
        bl5 = false;
        bl7 = false;
        bl7 = false;
        boolean bl9 = false;
        if (object4 == null) {
            boolean bl10 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String userOneTimeCode = (String)object4;
        try {
            this.stripeRepository.updateIssuingCardPin(cardId, newPin, verificationId, userOneTimeCode, ephemeralKey.getSecret());
            listener.onIssuingCardPinUpdated();
            return;
        }
        catch (InvalidRequestException e) {
            String string = e.getErrorCode();
            if (string != null) {
                switch (string) {
                    case "expired": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_EXPIRED, "The one-time code has expired", null);
                        return;
                    }
                    case "incorrect_code": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_INCORRECT, "The one-time code was incorrect", null);
                        return;
                    }
                    case "too_many_attempts": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_TOO_MANY_ATTEMPTS, "The verification challenge was attempted too many times", null);
                        return;
                    }
                    case "already_redeemed": {
                        listener.onError(CardPinActionError.ONE_TIME_CODE_ALREADY_REDEEMED, "The verification challenge was already redeemed", null);
                        return;
                    }
                }
            }
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "The call to update the PIN failed, possibly an error with the verification. Please check the exception.", e);
            return;
        }
        catch (APIConnectionException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
            return;
        }
        catch (APIException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
            return;
        }
        catch (AuthenticationException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
            return;
        }
        catch (CardException e) {
            listener.onError(CardPinActionError.UNKNOWN_ERROR, "An error occurred retrieving the PIN please check the exception", e);
        }
    }

    @Override
    public void onKeyError(@NotNull String operationId, int errorCode, @NotNull String errorMessage) {
        block1: {
            IssuingCardPinUpdateListener updateListener;
            block0: {
                IssuingCardPinRetrievalListener retrievalListener;
                Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                updateListener = this.updateListeners.remove(operationId);
                IssuingCardPinRetrievalListener issuingCardPinRetrievalListener = retrievalListener = this.retrievalListeners.remove(operationId);
                if (issuingCardPinRetrievalListener == null) break block0;
                issuingCardPinRetrievalListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
                break block1;
            }
            IssuingCardPinUpdateListener issuingCardPinUpdateListener = updateListener;
            if (issuingCardPinUpdateListener == null) break block1;
            issuingCardPinUpdateListener.onError(CardPinActionError.EPHEMERAL_KEY_ERROR, errorMessage, null);
        }
    }

    @VisibleForTesting
    public IssuingCardPinService(@NotNull EphemeralKeyProvider keyProvider, @NotNull StripeRepository stripeRepository, @NotNull OperationIdFactory operationIdFactory) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)keyProvider, (String)"keyProvider");
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)operationIdFactory, (String)"operationIdFactory");
        this.stripeRepository = stripeRepository;
        this.operationIdFactory = operationIdFactory;
        IssuingCardPinService issuingCardPinService = this;
        boolean bl = false;
        issuingCardPinService.retrievalListeners = map = (Map)new LinkedHashMap();
        issuingCardPinService = this;
        bl = false;
        issuingCardPinService.updateListeners = map = (Map)new LinkedHashMap();
        this.ephemeralKeyManager = new EphemeralKeyManager(keyProvider, this, 30L, null, this.operationIdFactory, true);
    }

    public /* synthetic */ IssuingCardPinService(EphemeralKeyProvider ephemeralKeyProvider, StripeRepository stripeRepository, OperationIdFactory operationIdFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        this(ephemeralKeyProvider, stripeRepository, operationIdFactory);
    }

    static {
        Companion = new Companion(null);
        String string = IssuingCardPinService.class.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IssuingCardPinService::class.java.name");
        TAG = string;
    }

    @JvmStatic
    @NotNull
    public static final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
        return Companion.create(context, keyProvider);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "", "(Ljava/lang/String;I)V", "UNKNOWN_ERROR", "EPHEMERAL_KEY_ERROR", "ONE_TIME_CODE_INCORRECT", "ONE_TIME_CODE_EXPIRED", "ONE_TIME_CODE_TOO_MANY_ATTEMPTS", "ONE_TIME_CODE_ALREADY_REDEEMED", "stripe_release"})
    public static final class CardPinActionError
    extends Enum<CardPinActionError> {
        public static final /* enum */ CardPinActionError UNKNOWN_ERROR;
        public static final /* enum */ CardPinActionError EPHEMERAL_KEY_ERROR;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_INCORRECT;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_EXPIRED;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_TOO_MANY_ATTEMPTS;
        public static final /* enum */ CardPinActionError ONE_TIME_CODE_ALREADY_REDEEMED;
        private static final /* synthetic */ CardPinActionError[] $VALUES;

        static {
            CardPinActionError[] cardPinActionErrorArray = new CardPinActionError[6];
            CardPinActionError[] cardPinActionErrorArray2 = cardPinActionErrorArray;
            cardPinActionErrorArray[0] = UNKNOWN_ERROR = new CardPinActionError();
            cardPinActionErrorArray[1] = EPHEMERAL_KEY_ERROR = new CardPinActionError();
            cardPinActionErrorArray[2] = ONE_TIME_CODE_INCORRECT = new CardPinActionError();
            cardPinActionErrorArray[3] = ONE_TIME_CODE_EXPIRED = new CardPinActionError();
            cardPinActionErrorArray[4] = ONE_TIME_CODE_TOO_MANY_ATTEMPTS = new CardPinActionError();
            cardPinActionErrorArray[5] = ONE_TIME_CODE_ALREADY_REDEEMED = new CardPinActionError();
            $VALUES = cardPinActionErrorArray;
        }

        public static CardPinActionError[] values() {
            return (CardPinActionError[])$VALUES.clone();
        }

        public static CardPinActionError valueOf(String string) {
            return Enum.valueOf(CardPinActionError.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H&\u00a8\u0006\f"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinRetrievalListener;", "", "onError", "", "errorCode", "Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "errorMessage", "", "exception", "", "onIssuingCardPinRetrieved", "pin", "stripe_release"})
    public static interface IssuingCardPinRetrievalListener {
        public void onIssuingCardPinRetrieved(@NotNull String var1);

        public void onError(@NotNull CardPinActionError var1, @Nullable String var2, @Nullable Throwable var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&J\b\u0010\n\u001a\u00020\u0003H&\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/IssuingCardPinService$IssuingCardPinUpdateListener;", "", "onError", "", "errorCode", "Lcom/stripe/android/IssuingCardPinService$CardPinActionError;", "errorMessage", "", "exception", "", "onIssuingCardPinUpdated", "stripe_release"})
    public static interface IssuingCardPinUpdateListener {
        public void onIssuingCardPinUpdated();

        public void onError(@NotNull CardPinActionError var1, @Nullable String var2, @Nullable Throwable var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/IssuingCardPinService$Companion;", "", "()V", "ARGUMENT_CARD_ID", "", "ARGUMENT_NEW_PIN", "ARGUMENT_ONE_TIME_CODE", "ARGUMENT_VERIFICATION_ID", "KEY_REFRESH_BUFFER_IN_SECONDS", "", "PIN_RETRIEVE", "PIN_UPDATE", "TAG", "create", "Lcom/stripe/android/IssuingCardPinService;", "context", "Landroid/content/Context;", "keyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IssuingCardPinService create(@NotNull Context context, @NotNull EphemeralKeyProvider keyProvider) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)keyProvider, (String)"keyProvider");
            return new IssuingCardPinService(keyProvider, new StripeApiRepository(context, Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, 508, null), new StripeOperationIdFactory());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

