/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeSystemPropertySupplier;
import com.stripe.android.SystemPropertySupplier;
import com.stripe.android.exception.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 (2\u00020\u0001:\u0002()BK\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0010\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0005H\u0002J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\r\u0010\u001e\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0000H\u0002R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00058@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/ApiRequest;", "Lcom/stripe/android/StripeRequest;", "method", "Lcom/stripe/android/StripeRequest$Method;", "url", "", "params", "", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "systemPropertySupplier", "Lcom/stripe/android/SystemPropertySupplier;", "(Lcom/stripe/android/StripeRequest$Method;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/AppInfo;Lcom/stripe/android/SystemPropertySupplier;)V", "apiVersion", "languageTag", "languageTag$annotations", "()V", "getLanguageTag$stripe_release", "()Ljava/lang/String;", "getOptions$stripe_release", "()Lcom/stripe/android/ApiRequest$Options;", "createHeaders", "createHeaders$stripe_release", "createStripeClientUserAgent", "equals", "", "other", "", "getOutputBytes", "", "getOutputBytes$stripe_release", "getUserAgent", "getUserAgent$stripe_release", "hashCode", "", "toString", "typedEquals", "obj", "Companion", "Options", "stripe_release"})
public final class ApiRequest
extends StripeRequest {
    private final String apiVersion;
    @NotNull
    private final Options options;
    private final AppInfo appInfo;
    private final SystemPropertySupplier systemPropertySupplier;
    @NotNull
    public static final String MIME_TYPE = "application/x-www-form-urlencoded";
    @NotNull
    public static final String API_HOST = "https://api.stripe.com";
    @NotNull
    public static final String HEADER_STRIPE_CLIENT_USER_AGENT = "X-Stripe-Client-User-Agent";
    private static final String PROP_USER_AGENT = "http.agent";
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void languageTag$annotations() {
    }

    @Nullable
    public final String getLanguageTag$stripe_release() {
        String string = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Locale.getDefault().toString()");
        String string2 = StringsKt.replace$default((String)string, (String)"_", (String)"-", (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return !StringsKt.isBlank((CharSequence)charSequence) ? string2 : null;
    }

    @Override
    @NotNull
    public Map<String, String> createHeaders$stripe_release() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String it;
        boolean bl;
        boolean bl2;
        Map map;
        String string;
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept-Charset", (Object)"UTF-8"), TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)HEADER_STRIPE_CLIENT_USER_AGENT, (Object)this.createStripeClientUserAgent()), TuplesKt.to((Object)"Stripe-Version", (Object)this.apiVersion), TuplesKt.to((Object)"Authorization", (Object)("Bearer " + this.options.getApiKey()))});
        String string2 = this.options.getStripeAccount$stripe_release();
        if (string2 != null) {
            string = string2;
            map = map2;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl3 = false;
            object4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Account", (Object)it));
            map2 = map;
            object3 = object4;
        } else {
            object3 = null;
        }
        string = object3;
        map = map2;
        bl2 = false;
        Object object5 = string;
        if (object5 == null) {
            object5 = MapsKt.emptyMap();
        }
        object4 = object5;
        Map map3 = MapsKt.plus((Map)map, (Map)object4);
        String string3 = this.options.getIdempotencyKey$stripe_release();
        if (string3 != null) {
            string = string3;
            map = map3;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl4 = false;
            object4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Idempotency-Key", (Object)it));
            map3 = map;
            object2 = object4;
        } else {
            object2 = null;
        }
        string = object2;
        map = map3;
        bl2 = false;
        Object object6 = string;
        if (object6 == null) {
            object6 = MapsKt.emptyMap();
        }
        object4 = object6;
        Map map4 = MapsKt.plus((Map)map, (Map)object4);
        String string4 = this.getLanguageTag$stripe_release();
        if (string4 != null) {
            string = string4;
            map = map4;
            bl2 = false;
            bl = false;
            it = string;
            boolean bl5 = false;
            object4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)it));
            map4 = map;
            object = object4;
        } else {
            object = null;
        }
        string = object;
        map = map4;
        bl2 = false;
        Object object7 = string;
        if (object7 == null) {
            object7 = MapsKt.emptyMap();
        }
        object4 = object7;
        return MapsKt.plus((Map)map, (Map)object4);
    }

    private final String createStripeClientUserAgent() {
        AppInfo appInfo = this.appInfo;
        Map map = appInfo != null ? appInfo.createClientHeaders$stripe_release() : null;
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"os.name", (Object)"android"), TuplesKt.to((Object)"os.version", (Object)String.valueOf(Build.VERSION.SDK_INT)), TuplesKt.to((Object)"bindings.version", (Object)"12.8.2"), TuplesKt.to((Object)"lang", (Object)"Java"), TuplesKt.to((Object)"publisher", (Object)"Stripe"), TuplesKt.to((Object)"java.version", (Object)this.systemPropertySupplier.get("java.version")), TuplesKt.to((Object)PROP_USER_AGENT, (Object)this.systemPropertySupplier.get(PROP_USER_AGENT))});
        boolean bl = false;
        Map map3 = map;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map map4 = map3;
        Map map5 = MapsKt.plus((Map)map2, (Map)map4);
        String string = new JSONObject(map5).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JSONObject(\n            \u2026   )\n        ).toString()");
        return string;
    }

    @Override
    @NotNull
    public String getUserAgent$stripe_release() {
        Object[] objectArray = new String[2];
        objectArray[0] = "Stripe/v1 AndroidBindings/12.8.2";
        AppInfo appInfo = this.appInfo;
        objectArray[1] = appInfo != null ? appInfo.toUserAgent$stripe_release() : null;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public byte[] getOutputBytes$stripe_release() throws UnsupportedEncodingException, InvalidRequestException {
        String string = this.getQuery$stripe_release();
        Object object = "UTF-8";
        boolean bl = false;
        Charset charset = Charset.forName((String)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object = charset;
        bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return this.getMethod().getCode() + ' ' + this.getBaseUrl();
    }

    public int hashCode() {
        return Objects.hash(this.getBaseHashCode$stripe_release(), this.options, this.appInfo);
    }

    public boolean equals(@Nullable Object other) {
        return super.equals(other) || other instanceof ApiRequest && this.typedEquals((ApiRequest)other);
    }

    private final boolean typedEquals(ApiRequest obj) {
        return super.typedEquals(obj) && Intrinsics.areEqual((Object)this.options, (Object)obj.options) && Intrinsics.areEqual((Object)this.appInfo, (Object)obj.appInfo);
    }

    @NotNull
    public final Options getOptions$stripe_release() {
        return this.options;
    }

    public ApiRequest(@NotNull StripeRequest.Method method, @NotNull String url, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo, @NotNull SystemPropertySupplier systemPropertySupplier) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)systemPropertySupplier, (String)"systemPropertySupplier");
        super(method, url, params, MIME_TYPE);
        this.options = options;
        this.appInfo = appInfo;
        this.systemPropertySupplier = systemPropertySupplier;
        this.apiVersion = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
    }

    public /* synthetic */ ApiRequest(StripeRequest.Method method, String string, Map map, Options options, AppInfo appInfo, SystemPropertySupplier systemPropertySupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            appInfo = null;
        }
        if ((n & 0x20) != 0) {
            systemPropertySupplier = new StripeSystemPropertySupplier();
        }
        this(method, string, map, options, appInfo, systemPropertySupplier);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000fJ+\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/ApiRequest$Options;", "Landroid/os/Parcelable;", "apiKey", "", "stripeAccount", "idempotencyKey", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getIdempotencyKey$stripe_release", "getStripeAccount$stripe_release", "component1", "component2", "component2$stripe_release", "component3", "component3$stripe_release", "copy", "describeContents", "", "equals", "", "other", "", "hashCode", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
    @Parcelize
    public static final class Options
    implements Parcelable {
        @NotNull
        private final String apiKey;
        @Nullable
        private final String stripeAccount;
        @Nullable
        private final String idempotencyKey;
        public static final Parcelable.Creator CREATOR = new Creator();

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        @Nullable
        public final String getStripeAccount$stripe_release() {
            return this.stripeAccount;
        }

        @Nullable
        public final String getIdempotencyKey$stripe_release() {
            return this.idempotencyKey;
        }

        public Options(@NotNull String apiKey, @Nullable String stripeAccount, @Nullable String idempotencyKey) {
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            this.apiKey = apiKey;
            this.stripeAccount = stripeAccount;
            this.idempotencyKey = idempotencyKey;
            new ApiKeyValidator().requireValid(this.apiKey);
        }

        public /* synthetic */ Options(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String component1() {
            return this.apiKey;
        }

        @Nullable
        public final String component2$stripe_release() {
            return this.stripeAccount;
        }

        @Nullable
        public final String component3$stripe_release() {
            return this.idempotencyKey;
        }

        @NotNull
        public final Options copy(@NotNull String apiKey, @Nullable String stripeAccount, @Nullable String idempotencyKey) {
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            return new Options(apiKey, stripeAccount, idempotencyKey);
        }

        public static /* synthetic */ Options copy$default(Options options, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = options.apiKey;
            }
            if ((n & 2) != 0) {
                string2 = options.stripeAccount;
            }
            if ((n & 4) != 0) {
                string3 = options.idempotencyKey;
            }
            return options.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Options(apiKey=" + this.apiKey + ", stripeAccount=" + this.stripeAccount + ", idempotencyKey=" + this.idempotencyKey + ")";
        }

        public int hashCode() {
            String string = this.apiKey;
            String string2 = this.stripeAccount;
            String string3 = this.idempotencyKey;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Options)) break block3;
                    Options options = (Options)object;
                    if (!Intrinsics.areEqual((Object)this.apiKey, (Object)options.apiKey) || !Intrinsics.areEqual((Object)this.stripeAccount, (Object)options.stripeAccount) || !Intrinsics.areEqual((Object)this.idempotencyKey, (Object)options.idempotencyKey)) break block3;
                }
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            parcel.writeString(this.apiKey);
            parcel.writeString(this.stripeAccount);
            parcel.writeString(this.idempotencyKey);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator {
            @NotNull
            public final Object[] newArray(int size) {
                return new Options[size];
            }

            @NotNull
            public final Object createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                return new Options(in.readString(), in.readString(), in.readString());
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ?\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0013J?\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00122\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/ApiRequest$Companion;", "", "()V", "API_HOST", "", "HEADER_STRIPE_CLIENT_USER_AGENT", "MIME_TYPE", "PROP_USER_AGENT", "createDelete", "Lcom/stripe/android/ApiRequest;", "url", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "createDelete$stripe_release", "createGet", "params", "", "createGet$stripe_release", "createPost", "createPost$stripe_release", "stripe_release"})
    public static final class Companion {
        @NotNull
        public final /* synthetic */ ApiRequest createGet$stripe_release(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, params, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createGet$stripe_release$default(Companion companion, String string, Options options, Map map, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            if ((n & 8) != 0) {
                appInfo = null;
            }
            return companion.createGet$stripe_release(string, options, map, appInfo);
        }

        @NotNull
        public final /* synthetic */ ApiRequest createPost$stripe_release(@NotNull String url, @NotNull Options options, @Nullable Map<String, ?> params, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, params, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createPost$stripe_release$default(Companion companion, String string, Options options, Map map, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                map = null;
            }
            if ((n & 8) != 0) {
                appInfo = null;
            }
            return companion.createPost$stripe_release(string, options, map, appInfo);
        }

        @NotNull
        public final /* synthetic */ ApiRequest createDelete$stripe_release(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.DELETE, url, null, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createDelete$stripe_release$default(Companion companion, String string, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createDelete$stripe_release(string, options, appInfo);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

