/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelProviders;
import com.google.android.material.snackbar.Snackbar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.AlertDisplayer;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.PaymentMethodSwipeCallback;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter;
import com.stripe.android.view.PaymentMethodsRecyclerView;
import com.stripe.android.view.PaymentMethodsViewModel;
import com.stripe.android.view.SwipeToDeleteCallbackListener;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.HashMap;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\"\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010 \u001a\u00020\u0014H\u0016J\u0012\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\b\u0010$\u001a\u00020\u0014H\u0014J\u0012\u0010%\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010&\u001a\u00020\u0010H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0010H\u0002J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+H\u0002J\u001f\u0010,\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010-\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b.R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "adapter", "Lcom/stripe/android/view/PaymentMethodsAdapter;", "alertDisplayer", "Lcom/stripe/android/view/AlertDisplayer;", "getAlertDisplayer", "()Lcom/stripe/android/view/AlertDisplayer;", "alertDisplayer$delegate", "Lkotlin/Lazy;", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "customerSession", "Lcom/stripe/android/CustomerSession;", "startedFromPaymentSession", "", "viewModel", "Lcom/stripe/android/view/PaymentMethodsViewModel;", "fetchCustomerPaymentMethods", "", "finishWithPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "resultCode", "", "initLoggingTokens", "onActivityResult", "requestCode", "data", "Landroid/content/Intent;", "onAddedPaymentMethod", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPaymentMethodCreated", "onSupportNavigateUp", "setCommunicatingProgress", "communicating", "setupRecyclerView", "args", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "showSnackbar", "stringRes", "showSnackbar$stripe_release", "Companion", "stripe_release"})
public final class PaymentMethodsActivity
extends AppCompatActivity {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private PaymentMethodsAdapter adapter;
    private boolean startedFromPaymentSession;
    private CustomerSession customerSession;
    private CardDisplayTextFactory cardDisplayTextFactory;
    private final Lazy alertDisplayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AlertDisplayer.DefaultAlertDisplayer>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        @NotNull
        public final AlertDisplayer.DefaultAlertDisplayer invoke() {
            return new AlertDisplayer.DefaultAlertDisplayer((Activity)this.this$0);
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    private PaymentMethodsViewModel viewModel;
    @NotNull
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PaymentMethodsActivity.class), "alertDisplayer", "getAlertDisplayer()Lcom/stripe/android/view/AlertDisplayer;"))};
        Companion = new Companion(null);
    }

    private final AlertDisplayer getAlertDisplayer() {
        Lazy lazy = this.alertDisplayer$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (AlertDisplayer)lazy.getValue();
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        this.customerSession = CustomerSession.Companion.getInstance();
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        PaymentMethodsActivityStarter.Args args2 = PaymentMethodsActivityStarter.Args.Companion.create$stripe_release(intent);
        FragmentActivity fragmentActivity = (FragmentActivity)this;
        CustomerSession customerSession2 = this.customerSession;
        if (customerSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        ViewModel viewModel2 = ViewModelProviders.of((FragmentActivity)fragmentActivity, (ViewModelProvider.Factory)new PaymentMethodsViewModel.Factory(customerSession2, args2.getInitialPaymentMethodId$stripe_release())).get(PaymentMethodsViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel2, (String)"ViewModelProviders.of(\n \u2026odsViewModel::class.java]");
        this.viewModel = (PaymentMethodsViewModel)viewModel2;
        Integer n = args2.getWindowFlags$stripe_release();
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            this.getWindow().addFlags(it);
        }
        this.startedFromPaymentSession = args2.isPaymentSessionActive$stripe_release();
        this.cardDisplayTextFactory = CardDisplayTextFactory.Companion.create$stripe_release((Context)this);
        this.setupRecyclerView(args2);
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.payment_methods_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        ActionBar actionBar2 = this.getSupportActionBar();
        if (actionBar2 != null) {
            actionBar2.setDisplayShowHomeEnabled(true);
        }
        this.fetchCustomerPaymentMethods();
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).requestFocusFromTouch();
    }

    private final void setupRecyclerView(PaymentMethodsActivityStarter.Args args2) {
        List<PaymentMethod.Type> list = args2.getPaymentMethodTypes$stripe_release();
        PaymentMethodsViewModel paymentMethodsViewModel = this.viewModel;
        if (paymentMethodsViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter = new PaymentMethodsAdapter(args2, list, paymentMethodsViewModel.getSelectedPaymentMethodId$stripe_release());
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsAdapter.setListener$stripe_release(new PaymentMethodsAdapter.Listener(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onClick(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                ((PaymentMethodsRecyclerView)this.this$0._$_findCachedViewById(R.id.payment_methods_recycler)).setTappedPaymentMethod$stripe_release(paymentMethod);
            }
            {
                this.this$0 = $outer;
            }
        });
        PaymentMethodsRecyclerView paymentMethodsRecyclerView = (PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)paymentMethodsRecyclerView), (String)"payment_methods_recycler");
        PaymentMethodsAdapter paymentMethodsAdapter2 = this.adapter;
        if (paymentMethodsAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsRecyclerView.setAdapter(paymentMethodsAdapter2);
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).setListener$stripe_release(new PaymentMethodsRecyclerView.Listener(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onPaymentMethodSelected(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                PaymentMethodsActivity.finishWithPaymentMethod$default(this.this$0, paymentMethod, 0, 2, null);
            }
            {
                this.this$0 = $outer;
            }
        });
        PaymentMethodsRecyclerView paymentMethodsRecyclerView2 = (PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Context context = (Context)this;
        PaymentMethodsAdapter paymentMethodsAdapter3 = this.adapter;
        if (paymentMethodsAdapter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        PaymentMethodsAdapter paymentMethodsAdapter4 = this.adapter;
        if (paymentMethodsAdapter4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        CardDisplayTextFactory cardDisplayTextFactory = this.cardDisplayTextFactory;
        if (cardDisplayTextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDisplayTextFactory");
        }
        CustomerSession customerSession2 = this.customerSession;
        if (customerSession2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        paymentMethodsRecyclerView2.attachItemTouchHelper$stripe_release(new PaymentMethodSwipeCallback(context, paymentMethodsAdapter3, new SwipeToDeleteCallbackListener(this, paymentMethodsAdapter4, cardDisplayTextFactory, customerSession2)));
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 6001 && resultCode == -1) {
            this.onPaymentMethodCreated(data);
        }
    }

    public boolean onSupportNavigateUp() {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.finishWithPaymentMethod(paymentMethodsAdapter.getSelectedPaymentMethod$stripe_release(), 0);
        return true;
    }

    private final void onPaymentMethodCreated(Intent data) {
        block6: {
            Intent intent;
            block5: {
                Unit unit;
                this.initLoggingTokens();
                intent = data;
                if (intent == null) break block5;
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl2 = false;
                Intent it = intent2;
                boolean bl3 = false;
                AddPaymentMethodActivityStarter.Result result = AddPaymentMethodActivityStarter.Result.Companion.fromIntent(data);
                Parcelable parcelable = result;
                if (parcelable != null && (parcelable = parcelable.getPaymentMethod()) != null) {
                    Parcelable parcelable2 = parcelable;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Parcelable it2 = parcelable2;
                    boolean bl6 = false;
                    this.onAddedPaymentMethod((PaymentMethod)it2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                intent = unit;
                if (unit != null) break block6;
            }
            this.fetchCustomerPaymentMethods();
            intent = Unit.INSTANCE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void onAddedPaymentMethod(PaymentMethod paymentMethod) {
        PaymentMethod.Type type;
        PaymentMethod.Type type2 = type = PaymentMethod.Type.Companion.lookup$stripe_release(paymentMethod.type);
        if (type2 != null) {
            if (type2.isReusable) {
                this.fetchCustomerPaymentMethods();
                this.showSnackbar$stripe_release(paymentMethod, R.string.added);
                return;
            }
        }
        PaymentMethodsActivity.finishWithPaymentMethod$default(this, paymentMethod, 0, 2, null);
    }

    public final /* synthetic */ void showSnackbar$stripe_release(@NotNull PaymentMethod paymentMethod, @StringRes int stringRes) {
        String snackbarText;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethod.Card paymentMethodId = card2;
            boolean bl3 = false;
            Object[] objectArray = new Object[1];
            CardDisplayTextFactory cardDisplayTextFactory = this.cardDisplayTextFactory;
            if (cardDisplayTextFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardDisplayTextFactory");
            }
            objectArray[0] = cardDisplayTextFactory.createUnstyled$stripe_release(paymentMethodId);
            string2 = this.getString(stringRes, objectArray);
        } else {
            string2 = snackbarText = null;
        }
        if (snackbarText != null) {
            Snackbar.make((View)((CoordinatorLayout)this._$_findCachedViewById(R.id.coordinator)), (CharSequence)snackbarText, (int)-1).show();
        }
    }

    public void onBackPressed() {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.finishWithPaymentMethod(paymentMethodsAdapter.getSelectedPaymentMethod$stripe_release(), 0);
    }

    private final void fetchCustomerPaymentMethods() {
        this.setCommunicatingProgress(true);
        PaymentMethodsViewModel paymentMethodsViewModel = this.viewModel;
        if (paymentMethodsViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        paymentMethodsViewModel.getPaymentMethods$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<PaymentMethodsViewModel.Result>(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public final void onChanged(PaymentMethodsViewModel.Result it) {
                PaymentMethodsViewModel.Result result = it;
                if (result instanceof PaymentMethodsViewModel.Result.Success) {
                    PaymentMethodsActivity.access$getAdapter$p(this.this$0).setPaymentMethods$stripe_release(((PaymentMethodsViewModel.Result.Success)it).getPaymentMethods());
                } else if (result instanceof PaymentMethodsViewModel.Result.Error) {
                    StripeException exception = ((PaymentMethodsViewModel.Result.Error)it).getException();
                    String displayedError = TranslatorManager.INSTANCE.getErrorMessageTranslator().translate(exception.getStatusCode(), exception.getMessage(), exception.getStripeError());
                    PaymentMethodsActivity.access$getAlertDisplayer$p(this.this$0).show(displayedError);
                }
                PaymentMethodsActivity.access$setCommunicatingProgress(this.this$0, false);
            }
            {
                this.this$0 = paymentMethodsActivity;
            }
        });
    }

    private final void initLoggingTokens() {
        if (this.startedFromPaymentSession) {
            CustomerSession customerSession2 = this.customerSession;
            if (customerSession2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
            }
            customerSession2.addProductUsageTokenIfValid$stripe_release("PaymentSession");
        }
        CustomerSession customerSession3 = this.customerSession;
        if (customerSession3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        customerSession3.addProductUsageTokenIfValid$stripe_release(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private final void setCommunicatingProgress(boolean communicating) {
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.payment_methods_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"payment_methods_progress_bar");
        progressBar.setVisibility(communicating ? 0 : 8);
    }

    private final void finishWithPaymentMethod(PaymentMethod paymentMethod, int resultCode) {
        Intent intent = new Intent();
        int n = resultCode;
        PaymentMethodsActivity paymentMethodsActivity = this;
        boolean bl = false;
        boolean bl2 = false;
        Intent it = intent;
        boolean bl3 = false;
        if (paymentMethod != null) {
            it.putExtras(new PaymentMethodsActivityStarter.Result(paymentMethod, false, 2, null).toBundle());
        }
        Intent intent2 = intent;
        paymentMethodsActivity.setResult(n, intent2);
        this.finish();
    }

    static /* synthetic */ void finishWithPaymentMethod$default(PaymentMethodsActivity paymentMethodsActivity, PaymentMethod paymentMethod, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        paymentMethodsActivity.finishWithPaymentMethod(paymentMethod, n);
    }

    protected void onDestroy() {
        PaymentMethodsViewModel paymentMethodsViewModel = this.viewModel;
        if (paymentMethodsViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        PaymentMethod paymentMethod = paymentMethodsAdapter.getSelectedPaymentMethod$stripe_release();
        paymentMethodsViewModel.setSelectedPaymentMethodId$stripe_release(paymentMethod != null ? paymentMethod.id : null);
        super.onDestroy();
    }

    public static final /* synthetic */ PaymentMethodsAdapter access$getAdapter$p(PaymentMethodsActivity $this) {
        PaymentMethodsAdapter paymentMethodsAdapter = $this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return paymentMethodsAdapter;
    }

    public static final /* synthetic */ void access$setAdapter$p(PaymentMethodsActivity $this, PaymentMethodsAdapter paymentMethodsAdapter) {
        $this.adapter = paymentMethodsAdapter;
    }

    public static final /* synthetic */ AlertDisplayer access$getAlertDisplayer$p(PaymentMethodsActivity $this) {
        return $this.getAlertDisplayer();
    }

    public static final /* synthetic */ void access$setCommunicatingProgress(PaymentMethodsActivity $this, boolean communicating) {
        $this.setCommunicatingProgress(communicating);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$Companion;", "", "()V", "TOKEN_PAYMENT_METHODS_ACTIVITY", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

