/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.model.Address;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardWidget;
import com.stripe.android.view.CvcEditText;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.ViewUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 u2\u00020\u00012\u00020\u0002:\u0001uB/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020E2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010G\u001a\u00020EH\u0016J\u0010\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020EH\u0002J\b\u0010M\u001a\u00020EH\u0002J\b\u0010N\u001a\u00020EH\u0002J\b\u0010O\u001a\u00020EH\u0002J(\u0010P\u001a\u00020E2\u0006\u0010Q\u001a\u00020\u001e2\u0006\u0010R\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020\u001eH\u0002J\b\u0010-\u001a\u00020\nH\u0016J\u0010\u0010S\u001a\u00020E2\u0006\u0010T\u001a\u00020\nH\u0016J\u0010\u0010U\u001a\u00020E2\u0006\u0010V\u001a\u00020\u0011H\u0016J\u0012\u0010W\u001a\u00020E2\b\u0010X\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010Y\u001a\u00020E2\b\u0010Z\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010[\u001a\u00020E2\b\u0010\\\u001a\u0004\u0018\u00010]J\u0012\u0010^\u001a\u00020E2\b\u0010_\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010`\u001a\u00020E2\b\u0010a\u001a\u0004\u0018\u00010\u0011J\u0010\u0010b\u001a\u00020E2\b\u0010c\u001a\u0004\u0018\u00010]J\u0010\u0010d\u001a\u00020E2\u0006\u0010e\u001a\u00020\nH\u0016J\u001c\u0010f\u001a\u00020E2\b\b\u0001\u0010g\u001a\u00020\b2\b\b\u0001\u0010h\u001a\u00020\bH\u0016J\u0010\u0010i\u001a\u00020E2\b\u0010j\u001a\u0004\u0018\u00010]J\u0010\u0010k\u001a\u00020E2\b\u0010l\u001a\u0004\u0018\u00010]J\u000e\u0010m\u001a\u00020E2\u0006\u0010\t\u001a\u00020\nJ\b\u0010n\u001a\u00020EH\u0002J\b\u0010o\u001a\u00020EH\u0002J\u001a\u0010p\u001a\u00020E2\b\b\u0001\u0010q\u001a\u00020\b2\u0006\u0010r\u001a\u00020\nH\u0002J\u0006\u0010s\u001a\u00020\nJ\u0006\u0010t\u001a\u00020\nR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\b8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010.\u001a\u0004\u0018\u00010/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0013\u00102\u001a\u0004\u0018\u0001038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0016\u00106\u001a\u0004\u0018\u0001078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010:\u001a\u0004\u0018\u00010;8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/stripe/android/view/CardMultilineWidget;", "Landroid/widget/LinearLayout;", "Lcom/stripe/android/view/CardWidget;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "shouldShowPostalCode", "", "(Landroid/content/Context;Landroid/util/AttributeSet;IZ)V", "card", "Lcom/stripe/android/model/Card;", "getCard", "()Lcom/stripe/android/model/Card;", "cardBrand", "", "cardBrand$annotations", "()V", "cardBuilder", "Lcom/stripe/android/model/Card$Builder;", "getCardBuilder", "()Lcom/stripe/android/model/Card$Builder;", "cardHintText", "cardInputListener", "Lcom/stripe/android/view/CardInputListener;", "cardNumberEditText", "Lcom/stripe/android/view/CardNumberEditText;", "cardNumberTextInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "customCvcLabel", "cvcEditText", "Lcom/stripe/android/view/CvcEditText;", "cvcHelperText", "getCvcHelperText", "()I", "cvcTextInputLayout", "dynamicBufferInPixels", "expiryDateEditText", "Lcom/stripe/android/view/ExpiryDateEditText;", "expiryTextInputLayout", "hasAdjustedDrawable", "isCvcLengthValid", "()Z", "isEnabled", "paymentMethodBillingDetails", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "getPaymentMethodBillingDetails", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "paymentMethodBillingDetailsBuilder", "Lcom/stripe/android/model/PaymentMethod$BillingDetails$Builder;", "getPaymentMethodBillingDetailsBuilder", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails$Builder;", "paymentMethodCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "getPaymentMethodCard", "()Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodCreateParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "pixelsToAdjust", "", "postalCodeEditText", "Lcom/stripe/android/view/StripeEditText;", "postalInputLayout", "tintColorInt", "adjustViewForPostalCodeAttribute", "", "checkAttributeSet", "clear", "createDrawableBounds", "Landroid/graphics/Rect;", "drawable", "Landroid/graphics/drawable/Drawable;", "flipToCvcIconIfNotFinished", "initDeleteEmptyListeners", "initErrorMessages", "initFocusChangeListeners", "initTextInputLayoutErrorHandlers", "cardInputLayout", "expiryInputLayout", "onWindowFocusChanged", "hasWindowFocus", "setCardHint", "cardHint", "setCardInputListener", "listener", "setCardNumber", "cardNumber", "setCardNumberTextWatcher", "cardNumberTextWatcher", "Landroid/text/TextWatcher;", "setCvcCode", "cvcCode", "setCvcLabel", "cvcLabel", "setCvcNumberTextWatcher", "cvcNumberTextWatcher", "setEnabled", "enabled", "setExpiryDate", "month", "year", "setExpiryDateTextWatcher", "expiryDateTextWatcher", "setPostalCodeTextWatcher", "postalCodeTextWatcher", "setShouldShowPostalCode", "updateBrandUi", "updateCvc", "updateDrawable", "iconResourceId", "needsTint", "validateAllFields", "validateCardNumber", "Companion", "stripe_release"})
public final class CardMultilineWidget
extends LinearLayout
implements CardWidget {
    private final CardNumberEditText cardNumberEditText;
    private final ExpiryDateEditText expiryDateEditText;
    private final CvcEditText cvcEditText;
    private final StripeEditText postalCodeEditText;
    private final TextInputLayout cardNumberTextInputLayout;
    private final TextInputLayout expiryTextInputLayout;
    private final TextInputLayout cvcTextInputLayout;
    private final TextInputLayout postalInputLayout;
    private CardInputListener cardInputListener;
    private boolean isEnabled;
    private boolean hasAdjustedDrawable;
    private String customCvcLabel;
    private String cardBrand;
    @ColorInt
    private final int tintColorInt;
    private String cardHintText;
    private final double pixelsToAdjust;
    private final int dynamicBufferInPixels;
    private boolean shouldShowPostalCode;
    @NotNull
    public static final String CARD_MULTILINE_TOKEN = "CardMultilineView";
    public static final long CARD_NUMBER_HINT_DELAY = 120L;
    public static final long COMMON_HINT_DELAY = 90L;
    private static final int POSTAL_MAX_LENGTH = 5;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private static /* synthetic */ void cardBrand$annotations() {
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams.Card getPaymentMethodCard() {
        PaymentMethodCreateParams.Card card;
        if (this.validateAllFields()) {
            Pair<Integer, Integer> pair = this.expiryDateEditText.getValidDateFields();
            if (pair != null) {
                Pair<Integer, Integer> pair2 = pair;
                boolean bl = false;
                boolean bl2 = false;
                Pair<Integer, Integer> $dstr$month$year = pair2;
                boolean bl3 = false;
                int month = ((Number)$dstr$month$year.component1()).intValue();
                int year = ((Number)$dstr$month$year.component2()).intValue();
                Editable editable = this.cvcEditText.getText();
                card = new PaymentMethodCreateParams.Card.Builder().setNumber(this.cardNumberEditText.getCardNumber()).setCvc(editable != null ? editable.toString() : null).setExpiryMonth(month).setExpiryYear(year).build();
            } else {
                card = null;
            }
        } else {
            card = null;
        }
        return card;
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams paymentMethodCreateParams;
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card != null) {
            PaymentMethodCreateParams.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethodCreateParams.Card it = card2;
            boolean bl3 = false;
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, it, this.getPaymentMethodBillingDetails(), null, 4, null);
        } else {
            paymentMethodCreateParams = null;
        }
        return paymentMethodCreateParams;
    }

    @Nullable
    public final PaymentMethod.BillingDetails getPaymentMethodBillingDetails() {
        PaymentMethod.BillingDetails.Builder builder = this.getPaymentMethodBillingDetailsBuilder();
        return builder != null ? builder.build() : null;
    }

    @Nullable
    public final PaymentMethod.BillingDetails.Builder getPaymentMethodBillingDetailsBuilder() {
        PaymentMethod.BillingDetails.Builder builder;
        if (this.shouldShowPostalCode && this.validateAllFields()) {
            Editable editable = this.postalCodeEditText.getText();
            builder = new PaymentMethod.BillingDetails.Builder().setAddress(new Address.Builder().setPostalCode(editable != null ? editable.toString() : null).build());
        } else {
            builder = null;
        }
        return builder;
    }

    @Override
    @Nullable
    public Card getCard() {
        Card.Builder builder = this.getCardBuilder();
        return builder != null ? builder.build() : null;
    }

    @Override
    @Nullable
    public Card.Builder getCardBuilder() {
        if (!this.validateAllFields()) {
            return null;
        }
        String cardNumber = this.cardNumberEditText.getCardNumber();
        Pair<Integer, Integer> pair = this.expiryDateEditText.getValidDateFields();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (pair == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Pair<Integer, Integer> cardDate = pair;
        Editable editable = this.cvcEditText.getText();
        String cvcValue = editable != null ? editable.toString() : null;
        Editable editable2 = this.postalCodeEditText.getText();
        String string3 = editable2 != null ? editable2.toString() : null;
        bl3 = false;
        boolean bl5 = false;
        String it = string3;
        boolean bl6 = false;
        String postalCode = this.shouldShowPostalCode ? string3 : null;
        return new Card.Builder(cardNumber, (Integer)cardDate.getFirst(), (Integer)cardDate.getSecond(), cvcValue).addressZip(postalCode).loggingTokens(CollectionsKt.listOf((Object)CARD_MULTILINE_TOKEN));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean isCvcLengthValid() {
        v0 = this.cvcEditText.getText();
        if (v0 == null || (v0 = v0.toString()) == null) ** GOTO lbl-1000
        var2_1 /* !! */  = v0;
        var3_4 = false;
        v1 /* !! */  = var2_1 /* !! */ ;
        if (v1 /* !! */  == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        v0 = StringsKt.trim((CharSequence)((CharSequence)v1 /* !! */ )).toString();
        if (v0 != null) {
            v2 = v0.length();
        } else lbl-1000:
        // 2 sources

        {
            v2 = cvcLength = null;
        }
        if (!TextUtils.equals((CharSequence)"American Express", (CharSequence)this.cardBrand)) ** GOTO lbl-1000
        v3 = cvcLength;
        var2_2 = 4;
        if (v3 != null && v3 == var2_2) {
            v4 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = cvcLength;
            var2_3 = 3;
            v4 = v5 != null && v5 == var2_3;
        }
        return v4;
    }

    @StringRes
    private final int getCvcHelperText() {
        return Intrinsics.areEqual((Object)"American Express", (Object)this.cardBrand) ? R.string.cvc_multiline_helper_amex : R.string.cvc_multiline_helper;
    }

    @Override
    public void clear() {
        this.cardNumberEditText.setText("");
        this.expiryDateEditText.setText("");
        this.cvcEditText.setText("");
        this.postalCodeEditText.setText("");
        this.cardNumberEditText.setShouldShowError(false);
        this.expiryDateEditText.setShouldShowError(false);
        this.cvcEditText.setShouldShowError(false);
        this.postalCodeEditText.setShouldShowError(false);
        this.cardBrand = "Unknown";
        this.updateBrandUi();
    }

    @Override
    public void setCardInputListener(@Nullable CardInputListener listener) {
        this.cardInputListener = listener;
    }

    @Override
    public void setCardHint(@NotNull String cardHint) {
        Intrinsics.checkParameterIsNotNull((Object)cardHint, (String)"cardHint");
        this.cardHintText = cardHint;
    }

    public final boolean validateAllFields() {
        boolean cardNumberIsValid = CardUtils.isValidCardNumber(this.cardNumberEditText.getCardNumber());
        boolean expiryIsValid = this.expiryDateEditText.getValidDateFields() != null;
        boolean cvcIsValid = this.isCvcLengthValid();
        this.cardNumberEditText.setShouldShowError(!cardNumberIsValid);
        this.expiryDateEditText.setShouldShowError(!expiryIsValid);
        this.cvcEditText.setShouldShowError(!cvcIsValid);
        boolean postalCodeIsValidOrGone = false;
        if (this.shouldShowPostalCode) {
            Editable editable = this.postalCodeEditText.getText();
            postalCodeIsValidOrGone = com.stripe.android.view.CardMultilineWidget$Companion.isPostalCodeMaximalLength$stripe_release$default(Companion, editable != null ? editable.toString() : null, 0, 2, null);
            this.postalCodeEditText.setShouldShowError(!postalCodeIsValidOrGone);
        } else {
            postalCodeIsValidOrGone = true;
        }
        List fields = CollectionsKt.listOf((Object[])new StripeEditText[]{this.cardNumberEditText, this.expiryDateEditText, this.cvcEditText, this.postalCodeEditText});
        for (StripeEditText field : fields) {
            if (!field.getShouldShowError()) continue;
            field.requestFocus();
            break;
        }
        return cardNumberIsValid && expiryIsValid && cvcIsValid && postalCodeIsValidOrGone;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.updateBrandUi();
        }
    }

    public final void setCvcLabel(@Nullable String cvcLabel) {
        this.customCvcLabel = cvcLabel;
        this.updateCvc();
    }

    public final void setShouldShowPostalCode(boolean shouldShowPostalCode) {
        this.shouldShowPostalCode = shouldShowPostalCode;
        this.adjustViewForPostalCodeAttribute();
    }

    @Override
    public void setCardNumber(@Nullable String cardNumber) {
        this.cardNumberEditText.setText(cardNumber);
    }

    @Override
    public void setExpiryDate(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        this.expiryDateEditText.setText(DateUtils.createDateStringFromIntegerInput(month, year));
    }

    @Override
    public void setCvcCode(@Nullable String cvcCode) {
        this.cvcEditText.setText(cvcCode);
    }

    public final boolean validateCardNumber() {
        boolean cardNumberIsValid = CardUtils.isValidCardNumber(this.cardNumberEditText.getCardNumber());
        this.cardNumberEditText.setShouldShowError(!cardNumberIsValid);
        return cardNumberIsValid;
    }

    public final void setCardNumberTextWatcher(@Nullable TextWatcher cardNumberTextWatcher) {
        this.cardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    public final void setExpiryDateTextWatcher(@Nullable TextWatcher expiryDateTextWatcher) {
        this.expiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    public final void setCvcNumberTextWatcher(@Nullable TextWatcher cvcNumberTextWatcher) {
        this.cvcEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    public final void setPostalCodeTextWatcher(@Nullable TextWatcher postalCodeTextWatcher) {
        this.postalCodeEditText.addTextChangedListener(postalCodeTextWatcher);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.expiryTextInputLayout.setEnabled(enabled);
        this.cardNumberTextInputLayout.setEnabled(enabled);
        this.cvcTextInputLayout.setEnabled(enabled);
        this.postalInputLayout.setEnabled(enabled);
        this.isEnabled = enabled;
    }

    private final void adjustViewForPostalCodeAttribute() {
        int expiryLabel = this.shouldShowPostalCode ? R.string.expiry_label_short : R.string.acc_label_expiry_date;
        this.expiryTextInputLayout.setHint((CharSequence)this.getResources().getString(expiryLabel));
        int focusForward = this.shouldShowPostalCode ? R.id.et_postal_code : -1;
        this.cvcEditText.setNextFocusForwardId(focusForward);
        this.cvcEditText.setNextFocusDownId(focusForward);
        int postalCodeVisibility = this.shouldShowPostalCode ? 0 : 8;
        this.postalInputLayout.setVisibility(postalCodeVisibility);
        this.cvcEditText.setImeOptions(postalCodeVisibility == 8 ? 6 : 5);
        int marginPixels = this.shouldShowPostalCode ? this.getResources().getDimensionPixelSize(R.dimen.stripe_add_card_expiry_middle_margin) : 0;
        ViewGroup.LayoutParams layoutParams = this.cvcTextInputLayout.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        }
        LinearLayout.LayoutParams linearParams = (LinearLayout.LayoutParams)layoutParams;
        linearParams.setMargins(0, 0, marginPixels, 0);
        linearParams.setMarginEnd(marginPixels);
        this.cvcTextInputLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAttributeSet(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardElement, 0, 0);
        try {
            this.shouldShowPostalCode = a.getBoolean(R.styleable.CardElement_shouldShowPostalCode, false);
        }
        finally {
            a.recycle();
        }
    }

    private final void flipToCvcIconIfNotFinished() {
        Editable editable = this.cvcEditText.getText();
        if (ViewUtils.isCvcMaximalLength(this.cardBrand, editable != null ? editable.toString() : null)) {
            return;
        }
        int resourceId = Intrinsics.areEqual((Object)"American Express", (Object)this.cardBrand) ? R.drawable.stripe_ic_cvc_amex : R.drawable.stripe_ic_cvc;
        this.updateDrawable(resourceId, true);
    }

    private final void initDeleteEmptyListeners() {
        this.expiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cardNumberEditText));
        this.cvcEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.expiryDateEditText));
        this.postalCodeEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cvcEditText));
    }

    private final void initErrorMessages() {
        this.cardNumberEditText.setErrorMessage(this.getContext().getString(R.string.invalid_card_number));
        this.expiryDateEditText.setErrorMessage(this.getContext().getString(R.string.invalid_expiry_year));
        this.cvcEditText.setErrorMessage(this.getContext().getString(R.string.invalid_cvc));
        this.postalCodeEditText.setErrorMessage(this.getContext().getString(R.string.invalid_zip));
    }

    private final void initFocusChangeListeners() {
        this.cardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$getCardNumberEditText$p(this.this$0).setHintDelayed(CardMultilineWidget.access$getCardHintText$p(this.this$0), 120L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_card");
                    }
                } else {
                    CardMultilineWidget.access$getCardNumberEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.expiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$getExpiryDateEditText$p(this.this$0).setHintDelayed(R.string.expiry_date_hint, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_expiry");
                    }
                } else {
                    CardMultilineWidget.access$getExpiryDateEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.cvcEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$flipToCvcIconIfNotFinished(this.this$0);
                    CardMultilineWidget.access$getCvcEditText$p(this.this$0).setHintDelayed(CardMultilineWidget.access$getCvcHelperText$p(this.this$0), 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_cvc");
                    }
                } else {
                    CardMultilineWidget.access$updateBrandUi(this.this$0);
                    CardMultilineWidget.access$getCvcEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.postalCodeEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (!CardMultilineWidget.access$getShouldShowPostalCode$p(this.this$0)) {
                    return;
                }
                if (hasFocus) {
                    CardMultilineWidget.access$getPostalCodeEditText$p(this.this$0).setHintDelayed(R.string.zip_helper, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_postal");
                    }
                } else {
                    CardMultilineWidget.access$getPostalCodeEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
    }

    private final void initTextInputLayoutErrorHandlers(TextInputLayout cardInputLayout, TextInputLayout expiryInputLayout, TextInputLayout cvcTextInputLayout, TextInputLayout postalInputLayout) {
        this.cardNumberEditText.setErrorMessageListener(new ErrorListener(cardInputLayout));
        this.expiryDateEditText.setErrorMessageListener(new ErrorListener(expiryInputLayout));
        this.cvcEditText.setErrorMessageListener(new ErrorListener(cvcTextInputLayout));
        this.postalCodeEditText.setErrorMessageListener(new ErrorListener(postalInputLayout));
    }

    private final void updateBrandUi() {
        this.updateCvc();
        this.updateDrawable(Card.Companion.getBrandIcon(this.cardBrand), Intrinsics.areEqual((Object)"Unknown", (Object)this.cardBrand));
    }

    private final void updateCvc() {
        this.cvcEditText.updateBrand$stripe_release(this.cardBrand, this.customCvcLabel, this.cvcTextInputLayout);
    }

    private final void updateDrawable(@DrawableRes int iconResourceId, boolean needsTint) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)iconResourceId);
        if (drawable2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026iconResourceId) ?: return");
        Drawable icon = drawable2;
        Drawable drawable3 = this.cardNumberEditText.getCompoundDrawablesRelative()[0];
        if (drawable3 == null) {
            return;
        }
        Drawable original = drawable3;
        int iconPadding = this.cardNumberEditText.getCompoundDrawablePadding();
        icon.setBounds(this.createDrawableBounds(original));
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        if (needsTint) {
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.tintColorInt);
        }
        this.cardNumberEditText.setCompoundDrawablePadding(iconPadding);
        this.cardNumberEditText.setCompoundDrawablesRelative(compatIcon, null, null, null);
    }

    private final Rect createDrawableBounds(Drawable drawable2) {
        Rect newBounds = new Rect();
        drawable2.copyBounds(newBounds);
        if (!this.hasAdjustedDrawable) {
            newBounds.top -= this.dynamicBufferInPixels;
            newBounds.bottom -= this.dynamicBufferInPixels;
            this.hasAdjustedDrawable = true;
        }
        return newBounds;
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, boolean shouldShowPostalCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.shouldShowPostalCode = shouldShowPostalCode;
        this.cardBrand = "Unknown";
        String string2 = this.getResources().getString(R.string.card_number_hint);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(R.string.card_number_hint)");
        this.cardHintText = string2;
        this.pixelsToAdjust = this.getResources().getDimension(R.dimen.stripe_card_icon_multiline_padding_bottom);
        this.dynamicBufferInPixels = new BigDecimal(this.pixelsToAdjust).setScale(0, RoundingMode.HALF_DOWN).intValue();
        this.setOrientation(1);
        View.inflate((Context)this.getContext(), (int)R.layout.card_multiline_widget, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.et_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.et_card_number)");
        this.cardNumberEditText = (CardNumberEditText)view;
        View view2 = this.findViewById(R.id.et_expiry);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.et_expiry)");
        this.expiryDateEditText = (ExpiryDateEditText)view2;
        View view3 = this.findViewById(R.id.et_cvc);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.et_cvc)");
        this.cvcEditText = (CvcEditText)view3;
        View view4 = this.findViewById(R.id.et_postal_code);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.et_postal_code)");
        this.postalCodeEditText = (StripeEditText)view4;
        ColorStateList colorStateList = this.cardNumberEditText.getHintTextColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"cardNumberEditText.hintTextColors");
        this.tintColorInt = colorStateList.getDefaultColor();
        if (Build.VERSION.SDK_INT >= 26) {
            this.cardNumberEditText.setAutofillHints(new String[]{"creditCardNumber"});
            this.expiryDateEditText.setAutofillHints(new String[]{"creditCardExpirationDate"});
            this.postalCodeEditText.setAutofillHints(new String[]{"postalCode"});
        }
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            this.checkAttributeSet(it);
        }
        View view5 = this.findViewById(R.id.tl_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById(R.id.tl_card_number)");
        this.cardNumberTextInputLayout = (TextInputLayout)view5;
        View view6 = this.findViewById(R.id.tl_expiry);
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"findViewById(R.id.tl_expiry)");
        this.expiryTextInputLayout = (TextInputLayout)view6;
        View view7 = this.findViewById(R.id.tl_cvc);
        Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"findViewById(R.id.tl_cvc)");
        this.cvcTextInputLayout = (TextInputLayout)view7;
        View view8 = this.findViewById(R.id.tl_postal_code);
        Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"findViewById(R.id.tl_postal_code)");
        this.postalInputLayout = (TextInputLayout)view8;
        if (this.shouldShowPostalCode) {
            this.expiryTextInputLayout.setHint((CharSequence)this.getResources().getString(R.string.expiry_label_short));
        }
        this.initTextInputLayoutErrorHandlers(this.cardNumberTextInputLayout, this.expiryTextInputLayout, this.cvcTextInputLayout, this.postalInputLayout);
        this.initErrorMessages();
        this.initFocusChangeListeners();
        this.initDeleteEmptyListeners();
        this.cardNumberEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    expiryDateEditText.requestFocus();
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener == null) break block0;
                    cardInputListener.onCardComplete();
                }
            }
        }));
        this.cardNumberEditText.setBrandChangeCallback$stripe_release((Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String brand) {
                Intrinsics.checkParameterIsNotNull((Object)brand, (String)"brand");
                cardBrand = brand;
                this.updateBrandUi();
            }
        }));
        this.expiryDateEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    cvcEditText.requestFocus();
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener == null) break block0;
                    cardInputListener.onExpirationComplete();
                }
            }
        }));
        this.cvcEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public void onTextChanged(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (ViewUtils.isCvcMaximalLength(cardBrand, text)) {
                    this.updateBrandUi();
                    if (shouldShowPostalCode) {
                        postalCodeEditText.requestFocus();
                    }
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener != null) {
                        cardInputListener.onCvcComplete();
                    }
                } else {
                    this.flipToCvcIconIfNotFinished();
                }
                cvcEditText.setShouldShowError(false);
            }
        });
        this.adjustViewForPostalCodeAttribute();
        this.postalCodeEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public void onTextChanged(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (com.stripe.android.view.CardMultilineWidget$Companion.isPostalCodeMaximalLength$stripe_release$default(Companion, text, 0, 2, null)) {
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener != null) {
                        cardInputListener.onPostalCodeComplete();
                    }
                }
                postalCodeEditText.setShouldShowError(false);
            }
        });
        this.cardNumberEditText.updateLengthFilter$stripe_release();
        this.cardBrand = "Unknown";
        this.updateBrandUi();
        this.isEnabled = true;
    }

    public /* synthetic */ CardMultilineWidget(Context context, AttributeSet attributeSet, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(context, attributeSet, n, bl);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, false, 8, null);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, false, 12, null);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context) {
        this(context, null, 0, false, 14, null);
    }

    public static final /* synthetic */ CardNumberEditText access$getCardNumberEditText$p(CardMultilineWidget $this) {
        return $this.cardNumberEditText;
    }

    public static final /* synthetic */ String access$getCardHintText$p(CardMultilineWidget $this) {
        return $this.cardHintText;
    }

    public static final /* synthetic */ void access$setCardHintText$p(CardMultilineWidget $this, String string2) {
        $this.cardHintText = string2;
    }

    public static final /* synthetic */ void access$setCardInputListener$p(CardMultilineWidget $this, CardInputListener cardInputListener) {
        $this.cardInputListener = cardInputListener;
    }

    public static final /* synthetic */ int access$getCvcHelperText$p(CardMultilineWidget $this) {
        return $this.getCvcHelperText();
    }

    public static final /* synthetic */ void access$setShouldShowPostalCode$p(CardMultilineWidget $this, boolean bl) {
        $this.shouldShowPostalCode = bl;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\r\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/CardMultilineWidget$Companion;", "", "()V", "CARD_MULTILINE_TOKEN", "", "CARD_NUMBER_HINT_DELAY", "", "COMMON_HINT_DELAY", "POSTAL_MAX_LENGTH", "", "isPostalCodeMaximalLength", "", "postalCode", "maxLength", "isPostalCodeMaximalLength$stripe_release", "stripe_release"})
    public static final class Companion {
        public final /* synthetic */ boolean isPostalCodeMaximalLength$stripe_release(@Nullable String postalCode, int maxLength) {
            String string2 = postalCode;
            return string2 != null && string2.length() == maxLength;
        }

        public static /* synthetic */ boolean isPostalCodeMaximalLength$stripe_release$default(Companion companion, String string2, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 5;
            }
            return companion.isPostalCodeMaximalLength$stripe_release(string2, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

