/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Transformation;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.stripe.android.R;
import com.stripe.android.model.Card;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardWidget;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.ViewUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001e\u0018\u0000 ~2\u00020\u00012\u00020\u0002:\u0005}~\u007f\u0080\u0001B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0019H\u0002J\b\u00108\u001a\u000206H\u0016J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\u0018\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u00020\u001bH\u0002J\u0017\u0010?\u001a\u0004\u0018\u00010\u001b2\u0006\u0010@\u001a\u00020\bH\u0001\u00a2\u0006\u0002\bAJ\u0010\u0010B\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\u0010\u0010C\u001a\u00020:2\u0006\u0010;\u001a\u00020:H\u0002J\u0012\u0010D\u001a\u0002062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020:H\u0002J\b\u0010G\u001a\u00020\u0019H\u0016J\u0010\u0010H\u001a\u00020\u00192\u0006\u0010I\u001a\u00020JH\u0016J0\u0010K\u001a\u0002062\u0006\u0010L\u001a\u00020\u00192\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\b2\u0006\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\bH\u0014J\u0010\u0010Q\u001a\u0002062\u0006\u0010R\u001a\u00020SH\u0014J\b\u0010T\u001a\u00020SH\u0014J\u0010\u0010U\u001a\u0002062\u0006\u0010V\u001a\u00020\u0019H\u0016J\b\u0010W\u001a\u000206H\u0002J\b\u0010X\u001a\u000206H\u0002J\u0010\u0010Y\u001a\u0002062\u0006\u0010Z\u001a\u00020:H\u0016J\u0012\u0010[\u001a\u0002062\b\u0010\\\u001a\u0004\u0018\u00010\u0015H\u0016J\u0012\u0010]\u001a\u0002062\b\u0010^\u001a\u0004\u0018\u00010:H\u0016J\u0015\u0010_\u001a\u0002062\u0006\u0010\u0018\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b`J\u0010\u0010a\u001a\u0002062\b\u0010b\u001a\u0004\u0018\u00010cJ\u0012\u0010d\u001a\u0002062\b\u0010e\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010f\u001a\u0002062\b\u0010g\u001a\u0004\u0018\u00010cJ\u0017\u0010h\u001a\u0002062\b\u0010i\u001a\u0004\u0018\u00010\u001dH\u0001\u00a2\u0006\u0002\bjJ\u0010\u0010k\u001a\u0002062\u0006\u0010G\u001a\u00020\u0019H\u0016J\u001c\u0010l\u001a\u0002062\b\b\u0001\u0010m\u001a\u00020\b2\b\b\u0001\u0010n\u001a\u00020\bH\u0016J\u0010\u0010o\u001a\u0002062\b\u0010p\u001a\u0004\u0018\u00010cJ \u0010q\u001a\u0002062\u0006\u0010r\u001a\u00020\b2\u0006\u0010s\u001a\u00020\b2\u0006\u0010>\u001a\u00020\u001bH\u0002J\u0010\u0010t\u001a\u0002062\u0006\u0010;\u001a\u00020:H\u0002J\u0010\u0010u\u001a\u0002062\u0006\u0010;\u001a\u00020:H\u0002J\"\u0010v\u001a\u0002062\u0006\u0010;\u001a\u00020:2\u0006\u0010w\u001a\u00020\u00192\b\u0010x\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010y\u001a\u0002062\u0006\u0010&\u001a\u00020\u0019H\u0002J\u0015\u0010z\u001a\u0002062\u0006\u0010{\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b|R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\u0004\u0018\u00010(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0016\u0010+\u001a\u0004\u0018\u00010,8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0012\u00103\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0081\u0001"}, d2={"Lcom/stripe/android/view/CardInputWidget;", "Landroid/widget/LinearLayout;", "Lcom/stripe/android/view/CardWidget;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "card", "Lcom/stripe/android/model/Card;", "getCard", "()Lcom/stripe/android/model/Card;", "cardBuilder", "Lcom/stripe/android/model/Card$Builder;", "getCardBuilder", "()Lcom/stripe/android/model/Card$Builder;", "cardIconImageView", "Landroid/widget/ImageView;", "cardInputListener", "Lcom/stripe/android/view/CardInputListener;", "cardNumberEditText", "Lcom/stripe/android/view/CardNumberEditText;", "cardNumberIsViewed", "", "cvcNumberEditText", "Lcom/stripe/android/view/StripeEditText;", "dimensionOverrides", "Lcom/stripe/android/view/CardInputWidget$DimensionOverrideSettings;", "expiryDateEditText", "Lcom/stripe/android/view/ExpiryDateEditText;", "frameLayout", "Landroid/widget/FrameLayout;", "frameWidth", "getFrameWidth", "()I", "initFlag", "isAmEx", "paymentMethodCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "getPaymentMethodCard", "()Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodCreateParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "placementParameters", "Lcom/stripe/android/view/CardInputWidget$PlacementParameters;", "getPlacementParameters$stripe_release", "()Lcom/stripe/android/view/CardInputWidget$PlacementParameters;", "tintColorInt", "totalLengthInPixels", "applyTint", "", "isCvc", "clear", "getCvcPlaceHolderForBrand", "", "brand", "getDesiredWidthInPixels", "text", "editText", "getFocusRequestOnTouch", "touchX", "getFocusRequestOnTouch$stripe_release", "getHiddenTextForBrand", "getPeekCardTextForBrand", "initView", "isCvcLengthValid", "cvcValue", "isEnabled", "onInterceptTouchEvent", "ev", "Landroid/view/MotionEvent;", "onLayout", "changed", "l", "t", "r", "b", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "onWindowFocusChanged", "hasWindowFocus", "scrollLeft", "scrollRight", "setCardHint", "cardHint", "setCardInputListener", "listener", "setCardNumber", "cardNumber", "setCardNumberIsViewed", "setCardNumberIsViewed$stripe_release", "setCardNumberTextWatcher", "cardNumberTextWatcher", "Landroid/text/TextWatcher;", "setCvcCode", "cvcCode", "setCvcNumberTextWatcher", "cvcNumberTextWatcher", "setDimensionOverrideSettings", "dimensonOverrides", "setDimensionOverrideSettings$stripe_release", "setEnabled", "setExpiryDate", "month", "year", "setExpiryDateTextWatcher", "expiryDateTextWatcher", "setLayoutValues", "width", "margin", "updateCvc", "updateIcon", "updateIconCvc", "hasFocus", "cvcText", "updateIconForCvcEntry", "updateSpaceSizes", "isCardViewed", "updateSpaceSizes$stripe_release", "AnimationEndListener", "Companion", "DimensionOverrideSettings", "PlacementParameters", "stripe_release"})
public final class CardInputWidget
extends LinearLayout
implements CardWidget {
    private final ImageView cardIconImageView;
    private final FrameLayout frameLayout;
    private final CardNumberEditText cardNumberEditText;
    private final StripeEditText cvcNumberEditText;
    private final ExpiryDateEditText expiryDateEditText;
    private CardInputListener cardInputListener;
    private boolean cardNumberIsViewed;
    @ColorInt
    private int tintColorInt;
    private boolean isAmEx;
    private boolean initFlag;
    private int totalLengthInPixels;
    private DimensionOverrideSettings dimensionOverrides;
    @NotNull
    private final PlacementParameters placementParameters;
    @NotNull
    public static final String LOGGING_TOKEN = "CardInputView";
    private static final String PEEK_TEXT_COMMON = "4242";
    private static final String PEEK_TEXT_DINERS = "88";
    private static final String PEEK_TEXT_AMEX = "34343";
    private static final String CVC_PLACEHOLDER_COMMON = "CVC";
    private static final String CVC_PLACEHOLDER_AMEX = "2345";
    private static final String HIDDEN_TEXT_AMEX = "3434 343434 ";
    private static final String HIDDEN_TEXT_COMMON = "4242 4242 4242 ";
    private static final String FULL_SIZING_CARD_TEXT = "4242 4242 4242 4242";
    private static final String FULL_SIZING_DATE_TEXT = "MM/MM";
    private static final String EXTRA_CARD_VIEWED = "extra_card_viewed";
    private static final String EXTRA_SUPER_STATE = "extra_super_state";
    @IdRes
    private static final int DEFAULT_READER_ID;
    private static final long ANIMATION_LENGTH = 150L;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @NotNull
    public final PlacementParameters getPlacementParameters$stripe_release() {
        return this.placementParameters;
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams.Card getPaymentMethodCard() {
        String cardNumber = this.cardNumberEditText.getCardNumber();
        Pair<Integer, Integer> cardDate = this.expiryDateEditText.getValidDateFields();
        String string2 = String.valueOf(this.cvcNumberEditText.getText());
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String cvcValue = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        return cardNumber == null || cardDate == null || !this.isCvcLengthValid(cvcValue) ? null : new PaymentMethodCreateParams.Card.Builder().setNumber(cardNumber).setCvc(cvcValue).setExpiryMonth((Integer)cardDate.getFirst()).setExpiryYear((Integer)cardDate.getSecond()).build();
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card == null) {
            return null;
        }
        PaymentMethodCreateParams.Card card2 = card;
        return PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, card2, null, null, 6, null);
    }

    @Override
    @Nullable
    public Card getCard() {
        Card.Builder builder;
        Card.Builder builder2 = builder = this.getCardBuilder();
        return builder2 != null ? builder2.build() : null;
    }

    @Override
    @Nullable
    public Card.Builder getCardBuilder() {
        Card.Builder builder;
        String cardNumber = this.cardNumberEditText.getCardNumber();
        Pair<Integer, Integer> cardDate = this.expiryDateEditText.getValidDateFields();
        if (cardNumber == null || cardDate == null) {
            builder = null;
        } else {
            String string2 = String.valueOf(this.cvcNumberEditText.getText());
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String cvcValue = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            builder = !this.isCvcLengthValid(cvcValue) ? null : new Card.Builder(cardNumber, (Integer)cardDate.getFirst(), (Integer)cardDate.getSecond(), cvcValue).loggingTokens(CollectionsKt.listOf((Object)LOGGING_TOKEN));
        }
        return builder;
    }

    private final int getFrameWidth() {
        DimensionOverrideSettings dimensionOverrideSettings = this.dimensionOverrides;
        return dimensionOverrideSettings != null ? dimensionOverrideSettings.getFrameWidth() : this.frameLayout.getWidth();
    }

    @Override
    public void setCardInputListener(@Nullable CardInputListener listener) {
        this.cardInputListener = listener;
    }

    @Override
    public void setCardNumber(@Nullable String cardNumber) {
        this.cardNumberEditText.setText(cardNumber);
        this.setCardNumberIsViewed$stripe_release(!this.cardNumberEditText.isCardNumberValid());
    }

    @Override
    public void setCardHint(@NotNull String cardHint) {
        Intrinsics.checkParameterIsNotNull((Object)cardHint, (String)"cardHint");
        this.cardNumberEditText.setHint(cardHint);
    }

    @Override
    public void setExpiryDate(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        this.expiryDateEditText.setText(DateUtils.createDateStringFromIntegerInput(month, year));
    }

    @Override
    public void setCvcCode(@Nullable String cvcCode) {
        this.cvcNumberEditText.setText(cvcCode);
    }

    @Override
    public void clear() {
        if (this.cardNumberEditText.hasFocus() || this.expiryDateEditText.hasFocus() || this.cvcNumberEditText.hasFocus() || this.hasFocus()) {
            this.cardNumberEditText.requestFocus();
        }
        this.cvcNumberEditText.setText("");
        this.expiryDateEditText.setText("");
        this.cardNumberEditText.setText("");
    }

    public void setEnabled(boolean isEnabled) {
        this.cardNumberEditText.setEnabled(isEnabled);
        this.expiryDateEditText.setEnabled(isEnabled);
        this.cvcNumberEditText.setEnabled(isEnabled);
    }

    public final void setCardNumberTextWatcher(@Nullable TextWatcher cardNumberTextWatcher) {
        this.cardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    public final void setExpiryDateTextWatcher(@Nullable TextWatcher expiryDateTextWatcher) {
        this.expiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    public final void setCvcNumberTextWatcher(@Nullable TextWatcher cvcNumberTextWatcher) {
        this.cvcNumberEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    public boolean isEnabled() {
        return this.cardNumberEditText.isEnabled() && this.expiryDateEditText.isEnabled() && this.cvcNumberEditText.isEnabled();
    }

    public boolean onInterceptTouchEvent(@NotNull MotionEvent ev) {
        Intrinsics.checkParameterIsNotNull((Object)ev, (String)"ev");
        if (ev.getAction() != 0) {
            return super.onInterceptTouchEvent(ev);
        }
        StripeEditText focusEditText = this.getFocusRequestOnTouch$stripe_release((int)ev.getX());
        if (focusEditText != null) {
            focusEditText.requestFocus();
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA_SUPER_STATE, super.onSaveInstanceState());
        bundle.putBoolean(EXTRA_CARD_VIEWED, this.cardNumberIsViewed);
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof Bundle) {
            this.cardNumberIsViewed = ((Bundle)state).getBoolean(EXTRA_CARD_VIEWED, true);
            this.updateSpaceSizes$stripe_release(this.cardNumberIsViewed);
            this.totalLengthInPixels = this.getFrameWidth();
            int cardMargin = 0;
            int dateMargin = 0;
            int cvcMargin = 0;
            if (this.cardNumberIsViewed) {
                cardMargin = 0;
                dateMargin = this.placementParameters.getCardWidth() + this.placementParameters.getCardDateSeparation();
                cvcMargin = this.totalLengthInPixels;
            } else {
                cardMargin = -1 * this.placementParameters.getHiddenCardWidth();
                dateMargin = this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation();
                cvcMargin = dateMargin + this.placementParameters.getDateWidth() + this.placementParameters.getDateCvcSeparation();
            }
            this.setLayoutValues(this.placementParameters.getCardWidth(), cardMargin, this.cardNumberEditText);
            this.setLayoutValues(this.placementParameters.getDateWidth(), dateMargin, this.expiryDateEditText);
            this.setLayoutValues(this.placementParameters.getCvcWidth(), cvcMargin, this.cvcNumberEditText);
            super.onRestoreInstanceState(((Bundle)state).getParcelable(EXTRA_SUPER_STATE));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @VisibleForTesting
    @Nullable
    public final StripeEditText getFocusRequestOnTouch$stripe_release(int touchX) {
        int frameStart = this.frameLayout.getLeft();
        return this.cardNumberIsViewed ? (touchX < frameStart + this.placementParameters.getCardWidth() ? null : (touchX < this.placementParameters.getCardTouchBufferLimit() ? (StripeEditText)this.cardNumberEditText : (touchX < this.placementParameters.getDateStartPosition() ? (StripeEditText)this.expiryDateEditText : null))) : (touchX < frameStart + this.placementParameters.getPeekCardWidth() ? null : (touchX < this.placementParameters.getCardTouchBufferLimit() ? (StripeEditText)this.cardNumberEditText : (touchX < this.placementParameters.getDateStartPosition() ? (StripeEditText)this.expiryDateEditText : (touchX < this.placementParameters.getDateStartPosition() + this.placementParameters.getDateWidth() ? null : (touchX < this.placementParameters.getDateRightTouchBufferLimit() ? (StripeEditText)this.expiryDateEditText : (touchX < this.placementParameters.getCvcStartPosition() ? this.cvcNumberEditText : null))))));
    }

    @VisibleForTesting
    public final void setDimensionOverrideSettings$stripe_release(@Nullable DimensionOverrideSettings dimensonOverrides) {
        this.dimensionOverrides = dimensonOverrides;
    }

    @VisibleForTesting
    public final void setCardNumberIsViewed$stripe_release(boolean cardNumberIsViewed) {
        this.cardNumberIsViewed = cardNumberIsViewed;
    }

    @VisibleForTesting
    public final void updateSpaceSizes$stripe_release(boolean isCardViewed) {
        int frameWidth = this.getFrameWidth();
        int frameStart = this.frameLayout.getLeft();
        if (frameWidth == 0) {
            return;
        }
        this.placementParameters.setCardWidth(this.getDesiredWidthInPixels(FULL_SIZING_CARD_TEXT, this.cardNumberEditText));
        this.placementParameters.setDateWidth(this.getDesiredWidthInPixels(FULL_SIZING_DATE_TEXT, this.expiryDateEditText));
        String brand = this.cardNumberEditText.getCardBrand();
        this.placementParameters.setHiddenCardWidth(this.getDesiredWidthInPixels(this.getHiddenTextForBrand(brand), this.cardNumberEditText));
        this.placementParameters.setCvcWidth(this.getDesiredWidthInPixels(this.getCvcPlaceHolderForBrand(brand), this.cvcNumberEditText));
        this.placementParameters.setPeekCardWidth(this.getDesiredWidthInPixels(this.getPeekCardTextForBrand(brand), this.cardNumberEditText));
        if (isCardViewed) {
            this.placementParameters.setCardDateSeparation(frameWidth - this.placementParameters.getCardWidth() - this.placementParameters.getDateWidth());
            this.placementParameters.setCardTouchBufferLimit(frameStart + this.placementParameters.getCardWidth() + this.placementParameters.getCardDateSeparation() / 2);
            this.placementParameters.setDateStartPosition(frameStart + this.placementParameters.getCardWidth() + this.placementParameters.getCardDateSeparation());
        } else {
            this.placementParameters.setCardDateSeparation(frameWidth / 2 - this.placementParameters.getPeekCardWidth() - this.placementParameters.getDateWidth() / 2);
            this.placementParameters.setDateCvcSeparation(frameWidth - this.placementParameters.getPeekCardWidth() - this.placementParameters.getCardDateSeparation() - this.placementParameters.getDateWidth() - this.placementParameters.getCvcWidth());
            this.placementParameters.setCardTouchBufferLimit(frameStart + this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation() / 2);
            this.placementParameters.setDateStartPosition(frameStart + this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation());
            this.placementParameters.setDateRightTouchBufferLimit(this.placementParameters.getDateStartPosition() + this.placementParameters.getDateWidth() + this.placementParameters.getDateCvcSeparation() / 2);
            this.placementParameters.setCvcStartPosition(this.placementParameters.getDateStartPosition() + this.placementParameters.getDateWidth() + this.placementParameters.getDateCvcSeparation());
        }
    }

    private final boolean isCvcLengthValid(String cvcValue) {
        int cvcLength = cvcValue.length();
        return this.isAmEx && cvcLength == 4 ? true : cvcLength == 3;
    }

    private final void setLayoutValues(int width, int margin, StripeEditText editText) {
        ViewGroup.LayoutParams layoutParams = editText.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
        FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams)layoutParams;
        layoutParams2.width = width;
        layoutParams2.leftMargin = margin;
        editText.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
    }

    private final int getDesiredWidthInPixels(String text, StripeEditText editText) {
        DimensionOverrideSettings dimensionOverrideSettings = this.dimensionOverrides;
        return dimensionOverrideSettings != null ? dimensionOverrideSettings.getPixelWidth(text, (EditText)editText) : (int)Layout.getDesiredWidth((CharSequence)text, (TextPaint)editText.getPaint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initView(AttributeSet attrs) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.cardNumberEditText.setAutofillHints(new String[]{"creditCardNumber"});
            this.expiryDateEditText.setAutofillHints(new String[]{"creditCardExpirationDate"});
            this.cvcNumberEditText.setAutofillHints(new String[]{"creditCardSecurityCode"});
        }
        ViewCompat.setAccessibilityDelegate((View)((View)this.cvcNumberEditText), (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
                Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                String string2 = this.this$0.getResources().getString(R.string.acc_label_cvc_node, new Object[]{CardInputWidget.access$getCvcNumberEditText$p(this.this$0).getText()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(\n   \u2026ext\n                    )");
                String accLabel = string2;
                info.setText((CharSequence)accLabel);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.cardNumberIsViewed = true;
        int errorColorInt = this.cardNumberEditText.getDefaultErrorColorInt();
        ColorStateList colorStateList = this.cardNumberEditText.getHintTextColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"cardNumberEditText.hintTextColors");
        this.tintColorInt = colorStateList.getDefaultColor();
        String cardHintText = null;
        if (attrs != null) {
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardInputView, 0, 0);
            try {
                this.tintColorInt = a.getColor(R.styleable.CardInputView_cardTint, this.tintColorInt);
                errorColorInt = a.getColor(R.styleable.CardInputView_cardTextErrorColor, errorColorInt);
                cardHintText = a.getString(R.styleable.CardInputView_cardHintText);
            }
            finally {
                a.recycle();
            }
        }
        String string2 = cardHintText;
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            this.cardNumberEditText.setHint(it);
        }
        this.cardNumberEditText.setErrorColor(errorColorInt);
        this.expiryDateEditText.setErrorColor(errorColorInt);
        this.cvcNumberEditText.setErrorColor(errorColorInt);
        this.cardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                block1: {
                    if (!hasFocus) break block1;
                    CardInputWidget.access$scrollLeft(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_card");
                    }
                }
            }
            {
                this.this$0 = cardInputWidget;
            }
        });
        this.expiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                block1: {
                    if (!hasFocus) break block1;
                    CardInputWidget.access$scrollRight(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_expiry");
                    }
                }
            }
            {
                this.this$0 = cardInputWidget;
            }
        });
        this.expiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cardNumberEditText));
        this.cvcNumberEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.expiryDateEditText));
        this.cvcNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardInputWidget.access$scrollRight(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_cvc");
                    }
                }
                CardInputWidget.access$updateIconCvc(this.this$0, CardInputWidget.access$getCardNumberEditText$p(this.this$0).getCardBrand(), hasFocus, String.valueOf(CardInputWidget.access$getCvcNumberEditText$p(this.this$0).getText()));
            }
            {
                this.this$0 = cardInputWidget;
            }
        });
        this.cvcNumberEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onTextChanged(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (ViewUtils.isCvcMaximalLength(CardInputWidget.access$getCardNumberEditText$p(this.this$0).getCardBrand(), text)) {
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onCvcComplete();
                    }
                }
                CardInputWidget.access$updateIconCvc(this.this$0, CardInputWidget.access$getCardNumberEditText$p(this.this$0).getCardBrand(), CardInputWidget.access$getCvcNumberEditText$p(this.this$0).hasFocus(), text);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.cardNumberEditText.setCardNumberCompleteListener$stripe_release(new CardNumberEditText.CardNumberCompleteListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onCardNumberComplete() {
                block0: {
                    CardInputWidget.access$scrollRight(this.this$0);
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener == null) break block0;
                    cardInputListener.onCardComplete();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        this.cardNumberEditText.setCardBrandChangeListener$stripe_release(new CardNumberEditText.CardBrandChangeListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onCardBrandChanged(@NotNull String brand) {
                Intrinsics.checkParameterIsNotNull((Object)brand, (String)"brand");
                CardInputWidget.access$setAmEx$p(this.this$0, Intrinsics.areEqual((Object)"American Express", (Object)brand));
                CardInputWidget.access$updateIcon(this.this$0, brand);
                CardInputWidget.access$updateCvc(this.this$0, brand);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.expiryDateEditText.setExpiryDateEditListener$stripe_release(new ExpiryDateEditText.ExpiryDateEditListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onExpiryDateComplete() {
                block0: {
                    CardInputWidget.access$getCvcNumberEditText$p(this.this$0).requestFocus();
                    CardInputListener cardInputListener = CardInputWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener == null) break block0;
                    cardInputListener.onExpirationComplete();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        this.cardNumberEditText.requestFocus();
    }

    private final void scrollLeft() {
        if (this.cardNumberIsViewed || !this.initFlag) {
            return;
        }
        int dateStartPosition = this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation();
        int cvcStartPosition = dateStartPosition + this.placementParameters.getDateWidth() + this.placementParameters.getDateCvcSeparation();
        this.updateSpaceSizes$stripe_release(true);
        ViewGroup.LayoutParams layoutParams = this.cardNumberEditText.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
        }
        int startPoint = ((FrameLayout.LayoutParams)layoutParams).leftMargin;
        Animation slideCardLeftAnimation2 = new Animation(this, startPoint){
            final /* synthetic */ CardInputWidget this$0;
            final /* synthetic */ int $startPoint;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                super.applyTransformation(interpolatedTime, t);
                ViewGroup.LayoutParams layoutParams = CardInputWidget.access$getCardNumberEditText$p(this.this$0).getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)layoutParams;
                params.leftMargin = (int)((float)this.$startPoint * (1.0f - interpolatedTime));
                CardInputWidget.access$getCardNumberEditText$p(this.this$0).setLayoutParams((ViewGroup.LayoutParams)params);
            }
            {
                this.this$0 = $outer;
                this.$startPoint = $captured_local_variable$1;
            }
        };
        int dateDestination = this.placementParameters.getCardWidth() + this.placementParameters.getCardDateSeparation();
        Animation slideDateLeftAnimation2 = new Animation(this, dateDestination, dateStartPosition){
            final /* synthetic */ CardInputWidget this$0;
            final /* synthetic */ int $dateDestination;
            final /* synthetic */ int $dateStartPosition;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)this.$dateDestination + (1.0f - interpolatedTime) * (float)this.$dateStartPosition);
                ViewGroup.LayoutParams layoutParams = CardInputWidget.access$getExpiryDateEditText$p(this.this$0).getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)layoutParams;
                params.leftMargin = tempValue;
                CardInputWidget.access$getExpiryDateEditText$p(this.this$0).setLayoutParams((ViewGroup.LayoutParams)params);
            }
            {
                this.this$0 = $outer;
                this.$dateDestination = $captured_local_variable$1;
                this.$dateStartPosition = $captured_local_variable$2;
            }
        };
        int cvcDestination = cvcStartPosition + (dateDestination - dateStartPosition);
        Animation slideCvcLeftAnimation2 = new Animation(this, cvcDestination, cvcStartPosition){
            final /* synthetic */ CardInputWidget this$0;
            final /* synthetic */ int $cvcDestination;
            final /* synthetic */ int $cvcStartPosition;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)this.$cvcDestination + (1.0f - interpolatedTime) * (float)this.$cvcStartPosition);
                ViewGroup.LayoutParams layoutParams = CardInputWidget.access$getCvcNumberEditText$p(this.this$0).getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)layoutParams;
                params.leftMargin = tempValue;
                params.rightMargin = 0;
                params.width = this.this$0.getPlacementParameters$stripe_release().getCvcWidth();
                CardInputWidget.access$getCvcNumberEditText$p(this.this$0).setLayoutParams((ViewGroup.LayoutParams)params);
            }
            {
                this.this$0 = $outer;
                this.$cvcDestination = $captured_local_variable$1;
                this.$cvcStartPosition = $captured_local_variable$2;
            }
        };
        slideCardLeftAnimation2.setAnimationListener((Animation.AnimationListener)new AnimationEndListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                CardInputWidget.access$getCardNumberEditText$p(this.this$0).requestFocus();
            }
            {
                this.this$0 = $outer;
            }
        });
        slideCardLeftAnimation2.setDuration(150L);
        slideDateLeftAnimation2.setDuration(150L);
        slideCvcLeftAnimation2.setDuration(150L);
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation(slideCardLeftAnimation2);
        animationSet.addAnimation(slideDateLeftAnimation2);
        animationSet.addAnimation(slideCvcLeftAnimation2);
        this.frameLayout.startAnimation((Animation)animationSet);
        this.cardNumberIsViewed = true;
    }

    private final void scrollRight() {
        if (!this.cardNumberIsViewed || !this.initFlag) {
            return;
        }
        int dateStartMargin = this.placementParameters.getCardWidth() + this.placementParameters.getCardDateSeparation();
        this.updateSpaceSizes$stripe_release(false);
        Animation slideCardRightAnimation2 = new Animation(this){
            final /* synthetic */ CardInputWidget this$0;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                super.applyTransformation(interpolatedTime, t);
                ViewGroup.LayoutParams layoutParams = CardInputWidget.access$getCardNumberEditText$p(this.this$0).getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams cardParams = (FrameLayout.LayoutParams)layoutParams;
                cardParams.leftMargin = (int)(-1.0f * (float)this.this$0.getPlacementParameters$stripe_release().getHiddenCardWidth() * interpolatedTime);
                CardInputWidget.access$getCardNumberEditText$p(this.this$0).setLayoutParams((ViewGroup.LayoutParams)cardParams);
            }
            {
                this.this$0 = $outer;
            }
        };
        int dateDestination = this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation();
        Animation slideDateRightAnimation2 = new Animation(this, dateDestination, dateStartMargin){
            final /* synthetic */ CardInputWidget this$0;
            final /* synthetic */ int $dateDestination;
            final /* synthetic */ int $dateStartMargin;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)this.$dateDestination + (1.0f - interpolatedTime) * (float)this.$dateStartMargin);
                ViewGroup.LayoutParams layoutParams = CardInputWidget.access$getExpiryDateEditText$p(this.this$0).getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams dateParams = (FrameLayout.LayoutParams)layoutParams;
                dateParams.leftMargin = tempValue;
                CardInputWidget.access$getExpiryDateEditText$p(this.this$0).setLayoutParams((ViewGroup.LayoutParams)dateParams);
            }
            {
                this.this$0 = $outer;
                this.$dateDestination = $captured_local_variable$1;
                this.$dateStartMargin = $captured_local_variable$2;
            }
        };
        int cvcDestination = this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation() + this.placementParameters.getDateWidth() + this.placementParameters.getDateCvcSeparation();
        int cvcStartMargin = cvcDestination + (dateStartMargin - dateDestination);
        Animation slideCvcRightAnimation2 = new Animation(this, cvcDestination, cvcStartMargin){
            final /* synthetic */ CardInputWidget this$0;
            final /* synthetic */ int $cvcDestination;
            final /* synthetic */ int $cvcStartMargin;

            protected void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                super.applyTransformation(interpolatedTime, t);
                int tempValue = (int)(interpolatedTime * (float)this.$cvcDestination + (1.0f - interpolatedTime) * (float)this.$cvcStartMargin);
                ViewGroup.LayoutParams layoutParams = CardInputWidget.access$getCvcNumberEditText$p(this.this$0).getLayoutParams();
                if (layoutParams == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.widget.FrameLayout.LayoutParams");
                }
                FrameLayout.LayoutParams cardParams = (FrameLayout.LayoutParams)layoutParams;
                cardParams.leftMargin = tempValue;
                cardParams.rightMargin = 0;
                cardParams.width = this.this$0.getPlacementParameters$stripe_release().getCvcWidth();
                CardInputWidget.access$getCvcNumberEditText$p(this.this$0).setLayoutParams((ViewGroup.LayoutParams)cardParams);
            }
            {
                this.this$0 = $outer;
                this.$cvcDestination = $captured_local_variable$1;
                this.$cvcStartMargin = $captured_local_variable$2;
            }
        };
        slideCardRightAnimation2.setDuration(150L);
        slideDateRightAnimation2.setDuration(150L);
        slideCvcRightAnimation2.setDuration(150L);
        slideCardRightAnimation2.setAnimationListener((Animation.AnimationListener)new AnimationEndListener(this){
            final /* synthetic */ CardInputWidget this$0;

            public void onAnimationEnd(@NotNull Animation animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                CardInputWidget.access$getExpiryDateEditText$p(this.this$0).requestFocus();
            }
            {
                this.this$0 = $outer;
            }
        });
        AnimationSet animationSet = new AnimationSet(true);
        animationSet.addAnimation(slideCardRightAnimation2);
        animationSet.addAnimation(slideDateRightAnimation2);
        animationSet.addAnimation(slideCvcRightAnimation2);
        this.frameLayout.startAnimation((Animation)animationSet);
        this.cardNumberIsViewed = false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.applyTint(false);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (!this.initFlag && this.getWidth() != 0) {
            this.initFlag = true;
            this.totalLengthInPixels = this.getFrameWidth();
            this.updateSpaceSizes$stripe_release(this.cardNumberIsViewed);
            int cardLeftMargin = this.cardNumberIsViewed ? 0 : -1 * this.placementParameters.getHiddenCardWidth();
            this.setLayoutValues(this.placementParameters.getCardWidth(), cardLeftMargin, this.cardNumberEditText);
            int dateMargin = this.cardNumberIsViewed ? this.placementParameters.getCardWidth() + this.placementParameters.getCardDateSeparation() : this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation();
            this.setLayoutValues(this.placementParameters.getDateWidth(), dateMargin, this.expiryDateEditText);
            int cvcMargin = this.cardNumberIsViewed ? this.totalLengthInPixels : this.placementParameters.getPeekCardWidth() + this.placementParameters.getCardDateSeparation() + this.placementParameters.getDateWidth() + this.placementParameters.getDateCvcSeparation();
            this.setLayoutValues(this.placementParameters.getCvcWidth(), cvcMargin, this.cvcNumberEditText);
        }
    }

    private final String getHiddenTextForBrand(String brand) {
        return Intrinsics.areEqual((Object)"American Express", (Object)brand) ? HIDDEN_TEXT_AMEX : HIDDEN_TEXT_COMMON;
    }

    private final String getCvcPlaceHolderForBrand(String brand) {
        return Intrinsics.areEqual((Object)"American Express", (Object)brand) ? CVC_PLACEHOLDER_AMEX : CVC_PLACEHOLDER_COMMON;
    }

    private final String getPeekCardTextForBrand(String brand) {
        String string2;
        switch (brand) {
            case "American Express": {
                string2 = PEEK_TEXT_AMEX;
                break;
            }
            case "Diners Club": {
                string2 = PEEK_TEXT_DINERS;
                break;
            }
            default: {
                string2 = PEEK_TEXT_COMMON;
            }
        }
        return string2;
    }

    private final void applyTint(boolean isCvc) {
        if (isCvc || Intrinsics.areEqual((Object)"Unknown", (Object)this.cardNumberEditText.getCardBrand())) {
            Drawable icon = this.cardIconImageView.getDrawable();
            Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.tintColorInt);
            this.cardIconImageView.setImageDrawable(DrawableCompat.unwrap((Drawable)compatIcon));
        }
    }

    private final void updateCvc(String brand) {
        if (Intrinsics.areEqual((Object)"American Express", (Object)brand)) {
            this.cvcNumberEditText.setFilters(new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(4)});
            this.cvcNumberEditText.setHint(R.string.cvc_amex_hint);
        } else {
            this.cvcNumberEditText.setFilters(new InputFilter[]{(InputFilter)new InputFilter.LengthFilter(3)});
            this.cvcNumberEditText.setHint(R.string.cvc_number_hint);
        }
    }

    private final void updateIcon(String brand) {
        if (Intrinsics.areEqual((Object)"Unknown", (Object)brand)) {
            Drawable icon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_unknown);
            this.cardIconImageView.setImageDrawable(icon);
            this.applyTint(false);
        } else {
            this.cardIconImageView.setImageResource(Card.Companion.getBrandIcon(brand));
        }
    }

    private final void updateIconCvc(String brand, boolean hasFocus, String cvcText) {
        if (Companion.shouldIconShowBrand$stripe_release(brand, hasFocus, cvcText)) {
            this.updateIcon(brand);
        } else {
            this.updateIconForCvcEntry(Intrinsics.areEqual((Object)"American Express", (Object)brand));
        }
    }

    private final void updateIconForCvcEntry(boolean isAmEx) {
        if (isAmEx) {
            this.cardIconImageView.setImageResource(R.drawable.ic_cvc_amex);
        } else {
            this.cardIconImageView.setImageResource(R.drawable.ic_cvc);
        }
        this.applyTint(true);
    }

    @JvmOverloads
    public CardInputWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.cardNumberIsViewed = true;
        this.placementParameters = new PlacementParameters();
        View.inflate((Context)this.getContext(), (int)R.layout.card_input_widget, (ViewGroup)((ViewGroup)this));
        if (this.getId() == -1) {
            this.setId(DEFAULT_READER_ID);
        }
        this.setOrientation(0);
        this.setMinimumWidth(this.getResources().getDimensionPixelSize(R.dimen.stripe_card_widget_min_width));
        View view = this.findViewById(R.id.iv_card_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.iv_card_icon)");
        this.cardIconImageView = (ImageView)view;
        View view2 = this.findViewById(R.id.et_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.et_card_number)");
        this.cardNumberEditText = (CardNumberEditText)view2;
        View view3 = this.findViewById(R.id.et_expiry_date);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.et_expiry_date)");
        this.expiryDateEditText = (ExpiryDateEditText)view3;
        View view4 = this.findViewById(R.id.et_cvc_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.et_cvc_number)");
        this.cvcNumberEditText = (StripeEditText)view4;
        View view5 = this.findViewById(R.id.frame_container);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById(R.id.frame_container)");
        this.frameLayout = (FrameLayout)view5;
        this.initView(attrs);
    }

    public /* synthetic */ CardInputWidget(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public CardInputWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CardInputWidget(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_READER_ID = R.id.stripe_default_reader_id;
    }

    public static final /* synthetic */ StripeEditText access$getCvcNumberEditText$p(CardInputWidget $this) {
        return $this.cvcNumberEditText;
    }

    public static final /* synthetic */ void access$scrollLeft(CardInputWidget $this) {
        $this.scrollLeft();
    }

    public static final /* synthetic */ CardInputListener access$getCardInputListener$p(CardInputWidget $this) {
        return $this.cardInputListener;
    }

    public static final /* synthetic */ void access$setCardInputListener$p(CardInputWidget $this, CardInputListener cardInputListener) {
        $this.cardInputListener = cardInputListener;
    }

    public static final /* synthetic */ void access$scrollRight(CardInputWidget $this) {
        $this.scrollRight();
    }

    public static final /* synthetic */ void access$updateIconCvc(CardInputWidget $this, String brand, boolean hasFocus, String cvcText) {
        $this.updateIconCvc(brand, hasFocus, cvcText);
    }

    public static final /* synthetic */ CardNumberEditText access$getCardNumberEditText$p(CardInputWidget $this) {
        return $this.cardNumberEditText;
    }

    public static final /* synthetic */ boolean access$isAmEx$p(CardInputWidget $this) {
        return $this.isAmEx;
    }

    public static final /* synthetic */ void access$setAmEx$p(CardInputWidget $this, boolean bl) {
        $this.isAmEx = bl;
    }

    public static final /* synthetic */ void access$updateIcon(CardInputWidget $this, String brand) {
        $this.updateIcon(brand);
    }

    public static final /* synthetic */ void access$updateCvc(CardInputWidget $this, String brand) {
        $this.updateCvc(brand);
    }

    public static final /* synthetic */ ExpiryDateEditText access$getExpiryDateEditText$p(CardInputWidget $this) {
        return $this.expiryDateEditText;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\ba\u0018\u00002\u00020\u0001J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/view/CardInputWidget$DimensionOverrideSettings;", "", "frameWidth", "", "getFrameWidth", "()I", "getPixelWidth", "text", "", "editText", "Landroid/widget/EditText;", "stripe_release"})
    @VisibleForTesting
    public static interface DimensionOverrideSettings {
        public int getFrameWidth();

        public int getPixelWidth(@NotNull String var1, @NotNull EditText var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b#\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\bR\u001a\u0010\u0015\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\bR\u001a\u0010\u001b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0006\"\u0004\b\u001d\u0010\bR\u001a\u0010\u001e\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0006\"\u0004\b \u0010\bR\u001a\u0010!\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0006\"\u0004\b#\u0010\bR\u001a\u0010$\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\b\u00a8\u0006)"}, d2={"Lcom/stripe/android/view/CardInputWidget$PlacementParameters;", "", "()V", "cardDateSeparation", "", "getCardDateSeparation", "()I", "setCardDateSeparation", "(I)V", "cardTouchBufferLimit", "getCardTouchBufferLimit", "setCardTouchBufferLimit", "cardWidth", "getCardWidth", "setCardWidth", "cvcStartPosition", "getCvcStartPosition", "setCvcStartPosition", "cvcWidth", "getCvcWidth", "setCvcWidth", "dateCvcSeparation", "getDateCvcSeparation", "setDateCvcSeparation", "dateRightTouchBufferLimit", "getDateRightTouchBufferLimit", "setDateRightTouchBufferLimit", "dateStartPosition", "getDateStartPosition", "setDateStartPosition", "dateWidth", "getDateWidth", "setDateWidth", "hiddenCardWidth", "getHiddenCardWidth", "setHiddenCardWidth", "peekCardWidth", "getPeekCardWidth", "setPeekCardWidth", "toString", "", "stripe_release"})
    public static final class PlacementParameters {
        private int cardWidth;
        private int hiddenCardWidth;
        private int peekCardWidth;
        private int cardDateSeparation;
        private int dateWidth;
        private int dateCvcSeparation;
        private int cvcWidth;
        private int cardTouchBufferLimit;
        private int dateStartPosition;
        private int dateRightTouchBufferLimit;
        private int cvcStartPosition;

        public final int getCardWidth() {
            return this.cardWidth;
        }

        public final void setCardWidth(int n) {
            this.cardWidth = n;
        }

        public final int getHiddenCardWidth() {
            return this.hiddenCardWidth;
        }

        public final void setHiddenCardWidth(int n) {
            this.hiddenCardWidth = n;
        }

        public final int getPeekCardWidth() {
            return this.peekCardWidth;
        }

        public final void setPeekCardWidth(int n) {
            this.peekCardWidth = n;
        }

        public final int getCardDateSeparation() {
            return this.cardDateSeparation;
        }

        public final void setCardDateSeparation(int n) {
            this.cardDateSeparation = n;
        }

        public final int getDateWidth() {
            return this.dateWidth;
        }

        public final void setDateWidth(int n) {
            this.dateWidth = n;
        }

        public final int getDateCvcSeparation() {
            return this.dateCvcSeparation;
        }

        public final void setDateCvcSeparation(int n) {
            this.dateCvcSeparation = n;
        }

        public final int getCvcWidth() {
            return this.cvcWidth;
        }

        public final void setCvcWidth(int n) {
            this.cvcWidth = n;
        }

        public final int getCardTouchBufferLimit() {
            return this.cardTouchBufferLimit;
        }

        public final void setCardTouchBufferLimit(int n) {
            this.cardTouchBufferLimit = n;
        }

        public final int getDateStartPosition() {
            return this.dateStartPosition;
        }

        public final void setDateStartPosition(int n) {
            this.dateStartPosition = n;
        }

        public final int getDateRightTouchBufferLimit() {
            return this.dateRightTouchBufferLimit;
        }

        public final void setDateRightTouchBufferLimit(int n) {
            this.dateRightTouchBufferLimit = n;
        }

        public final int getCvcStartPosition() {
            return this.cvcStartPosition;
        }

        public final void setCvcStartPosition(int n) {
            this.cvcStartPosition = n;
        }

        @NotNull
        public String toString() {
            String touchBufferData = "Touch Buffer Data:\n" + "CardTouchBufferLimit = " + this.cardTouchBufferLimit + '\n' + "DateStartPosition = " + this.dateStartPosition + '\n' + "DateRightTouchBufferLimit = " + this.dateRightTouchBufferLimit + '\n' + "CvcStartPosition = " + this.cvcStartPosition;
            String elementSizeData = "CardWidth = " + this.cardWidth + '\n' + "HiddenCardWidth = " + this.hiddenCardWidth + '\n' + "PeekCardWidth = " + this.peekCardWidth + '\n' + "CardDateSeparation = " + this.cardDateSeparation + '\n' + "DateWidth = " + this.dateWidth + '\n' + "DateCvcSeparation = " + this.dateCvcSeparation + '\n' + "CvcWidth = " + this.cvcWidth + '\n';
            return elementSizeData + touchBufferData;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/CardInputWidget$AnimationEndListener;", "Landroid/view/animation/Animation$AnimationListener;", "(Lcom/stripe/android/view/CardInputWidget;)V", "onAnimationRepeat", "", "animation", "Landroid/view/animation/Animation;", "onAnimationStart", "stripe_release"})
    private abstract class AnimationEndListener
    implements Animation.AnimationListener {
        public void onAnimationStart(@NotNull Animation animation) {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        }

        public void onAnimationRepeat(@NotNull Animation animation) {
            Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0001\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/CardInputWidget$Companion;", "", "()V", "ANIMATION_LENGTH", "", "CVC_PLACEHOLDER_AMEX", "", "CVC_PLACEHOLDER_COMMON", "DEFAULT_READER_ID", "", "EXTRA_CARD_VIEWED", "EXTRA_SUPER_STATE", "FULL_SIZING_CARD_TEXT", "FULL_SIZING_DATE_TEXT", "HIDDEN_TEXT_AMEX", "HIDDEN_TEXT_COMMON", "LOGGING_TOKEN", "PEEK_TEXT_AMEX", "PEEK_TEXT_COMMON", "PEEK_TEXT_DINERS", "shouldIconShowBrand", "", "brand", "cvcHasFocus", "cvcText", "shouldIconShowBrand$stripe_release", "stripe_release"})
    public static final class Companion {
        @VisibleForTesting
        public final boolean shouldIconShowBrand$stripe_release(@NotNull String brand, boolean cvcHasFocus, @Nullable String cvcText) {
            Intrinsics.checkParameterIsNotNull((Object)brand, (String)"brand");
            return !cvcHasFocus ? true : ViewUtils.isCvcMaximalLength(brand, cvcText);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

