/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.util.Pair;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.ApiRequest;
import com.stripe.android.CustomerSessionProductUsage;
import com.stripe.android.EphemeralKey;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.io.Serializable;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002()B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015H\u0000\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J \u0010!\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\tH\u0002J(\u0010$\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0018\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/CustomerSessionRunnableFactory;", "", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "handler", "Landroid/os/Handler;", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "publishableKey", "", "stripeAccountId", "productUsage", "Lcom/stripe/android/CustomerSessionProductUsage;", "(Lcom/stripe/android/StripeRepository;Landroid/os/Handler;Landroidx/localbroadcastmanager/content/LocalBroadcastManager;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/CustomerSessionProductUsage;)V", "create", "Ljava/lang/Runnable;", "ephemeralKey", "Lcom/stripe/android/EphemeralKey;", "operationId", "actionString", "arguments", "", "create$stripe_release", "createAddCustomerSourceRunnable", "key", "sourceId", "sourceType", "createAttachPaymentMethodRunnable", "paymentMethodId", "createDeleteCustomerSourceRunnable", "createDetachPaymentMethodRunnable", "createGetPaymentMethodsRunnable", "paymentMethodType", "createSetCustomerShippingInformationRunnable", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "createSetCustomerSourceDefaultRunnable", "createUpdateCustomerRunnable", "retrieveCustomerWithKey", "Lcom/stripe/android/model/Customer;", "CustomerSessionRunnable", "MessageCode", "stripe_release"})
public final class CustomerSessionRunnableFactory {
    private final StripeRepository stripeRepository;
    private final Handler handler;
    private final LocalBroadcastManager localBroadcastManager;
    private final String publishableKey;
    private final String stripeAccountId;
    private final CustomerSessionProductUsage productUsage;

    @Nullable
    public final Runnable create$stripe_release(@NotNull EphemeralKey ephemeralKey, @NotNull String operationId, @Nullable String actionString, @Nullable Map<String, ? extends Object> arguments) {
        Runnable runnable;
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKey, (String)"ephemeralKey");
        Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
        if (actionString == null) {
            runnable = this.createUpdateCustomerRunnable(ephemeralKey, operationId);
        } else {
            if (arguments == null) {
                return null;
            }
            if (Intrinsics.areEqual((Object)"add_source", (Object)actionString) && arguments.containsKey("source") && arguments.containsKey("source_type")) {
                Object object = arguments.get("source");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                Object object2 = arguments.get("source_type");
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                runnable = this.createAddCustomerSourceRunnable(ephemeralKey, (String)object, (String)object2, operationId);
            } else if (Intrinsics.areEqual((Object)"delete_source", (Object)actionString) && arguments.containsKey("source")) {
                Object object = arguments.get("source");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                runnable = this.createDeleteCustomerSourceRunnable(ephemeralKey, (String)object, operationId);
            } else if (Intrinsics.areEqual((Object)"attach_payment_method", (Object)actionString) && arguments.containsKey("payment_method")) {
                Object object = arguments.get("payment_method");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                runnable = this.createAttachPaymentMethodRunnable(ephemeralKey, (String)object, operationId);
            } else if (Intrinsics.areEqual((Object)"detach_payment_method", (Object)actionString) && arguments.containsKey("payment_method")) {
                Object object = arguments.get("payment_method");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                runnable = this.createDetachPaymentMethodRunnable(ephemeralKey, (String)object, operationId);
            } else if (Intrinsics.areEqual((Object)"get_payment_methods", (Object)actionString)) {
                Object object = arguments.get("payment_method_type");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                runnable = this.createGetPaymentMethodsRunnable(ephemeralKey, (String)object, operationId);
            } else if (Intrinsics.areEqual((Object)"default_source", (Object)actionString) && arguments.containsKey("source") && arguments.containsKey("source_type")) {
                Object object = arguments.get("source");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                Object object3 = arguments.get("source_type");
                if (object3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                runnable = this.createSetCustomerSourceDefaultRunnable(ephemeralKey, (String)object, (String)object3, operationId);
            } else if (Intrinsics.areEqual((Object)"set_shipping_info", (Object)actionString) && arguments.containsKey("shipping_info")) {
                Object object = arguments.get("shipping_info");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.model.ShippingInformation");
                }
                runnable = this.createSetCustomerShippingInformationRunnable(ephemeralKey, (ShippingInformation)object, operationId);
            } else {
                runnable = null;
            }
        }
        return runnable;
    }

    private final Runnable createAddCustomerSourceRunnable(EphemeralKey key, String sourceId, String sourceType, String operationId) {
        return new CustomerSessionRunnable<Source>(this, key, sourceId, sourceType, operationId, this.handler, this.localBroadcastManager, 3, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $sourceId;
            final /* synthetic */ String $sourceType;
            final /* synthetic */ String $operationId;

            @Nullable
            public Source createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).addCustomerSource(this.$key.getObjectId$stripe_release(), CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), this.$sourceId, this.$sourceType, new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$sourceId = $captured_local_variable$2;
                this.$sourceType = $captured_local_variable$3;
                this.$operationId = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    private final Runnable createDeleteCustomerSourceRunnable(EphemeralKey key, String sourceId, String operationId) {
        return new CustomerSessionRunnable<Source>(this, key, sourceId, operationId, this.handler, this.localBroadcastManager, 3, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $sourceId;
            final /* synthetic */ String $operationId;

            @Nullable
            public Source createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).deleteCustomerSource(this.$key.getObjectId$stripe_release(), CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), this.$sourceId, new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$sourceId = $captured_local_variable$2;
                this.$operationId = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final Runnable createAttachPaymentMethodRunnable(EphemeralKey key, String paymentMethodId, String operationId) {
        return new CustomerSessionRunnable<PaymentMethod>(this, key, paymentMethodId, operationId, this.handler, this.localBroadcastManager, 4, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $paymentMethodId;
            final /* synthetic */ String $operationId;

            @Nullable
            public PaymentMethod createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).attachPaymentMethod(this.$key.getObjectId$stripe_release(), CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), this.$paymentMethodId, new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$paymentMethodId = $captured_local_variable$2;
                this.$operationId = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final Runnable createDetachPaymentMethodRunnable(EphemeralKey key, String paymentMethodId, String operationId) {
        return new CustomerSessionRunnable<PaymentMethod>(this, paymentMethodId, key, operationId, this.handler, this.localBroadcastManager, 4, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ String $paymentMethodId;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $operationId;

            @Nullable
            public PaymentMethod createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).detachPaymentMethod(CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), this.$paymentMethodId, new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$paymentMethodId = $captured_local_variable$1;
                this.$key = $captured_local_variable$2;
                this.$operationId = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final Runnable createGetPaymentMethodsRunnable(EphemeralKey key, String paymentMethodType, String operationId) {
        return new CustomerSessionRunnable<List<? extends PaymentMethod>>(this, key, paymentMethodType, operationId, this.handler, this.localBroadcastManager, 6, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $paymentMethodType;
            final /* synthetic */ String $operationId;

            @NotNull
            public List<PaymentMethod> createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).getPaymentMethods(this.$key.getObjectId$stripe_release(), this.$paymentMethodType, CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$paymentMethodType = $captured_local_variable$2;
                this.$operationId = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final Runnable createSetCustomerSourceDefaultRunnable(EphemeralKey key, String sourceId, String sourceType, String operationId) {
        return new CustomerSessionRunnable<Customer>(this, key, sourceId, sourceType, operationId, this.handler, this.localBroadcastManager, 2, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $sourceId;
            final /* synthetic */ String $sourceType;
            final /* synthetic */ String $operationId;

            @Nullable
            public Customer createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).setDefaultCustomerSource(this.$key.getObjectId$stripe_release(), CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), this.$sourceId, this.$sourceType, new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$sourceId = $captured_local_variable$2;
                this.$sourceType = $captured_local_variable$3;
                this.$operationId = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        };
    }

    private final Runnable createSetCustomerShippingInformationRunnable(EphemeralKey key, ShippingInformation shippingInformation, String operationId) {
        return new CustomerSessionRunnable<Customer>(this, key, shippingInformation, operationId, this.handler, this.localBroadcastManager, 5, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ ShippingInformation $shippingInformation;
            final /* synthetic */ String $operationId;

            @Nullable
            public Customer createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$getStripeRepository$p(this.this$0).setCustomerShippingInfo(this.$key.getObjectId$stripe_release(), CustomerSessionRunnableFactory.access$getPublishableKey$p(this.this$0), CustomerSessionRunnableFactory.access$getProductUsage$p(this.this$0).get(), this.$shippingInformation, new ApiRequest.Options(this.$key.getSecret(), CustomerSessionRunnableFactory.access$getStripeAccountId$p(this.this$0), null, 4, null));
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$shippingInformation = $captured_local_variable$2;
                this.$operationId = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    private final Runnable createUpdateCustomerRunnable(EphemeralKey key, String operationId) {
        return new CustomerSessionRunnable<Customer>(this, key, operationId, this.handler, this.localBroadcastManager, 2, operationId){
            final /* synthetic */ CustomerSessionRunnableFactory this$0;
            final /* synthetic */ EphemeralKey $key;
            final /* synthetic */ String $operationId;

            @Nullable
            public Customer createMessageObject() throws StripeException {
                return CustomerSessionRunnableFactory.access$retrieveCustomerWithKey(this.this$0, this.$key);
            }
            {
                this.this$0 = $outer;
                this.$key = $captured_local_variable$1;
                this.$operationId = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }

    private final Customer retrieveCustomerWithKey(EphemeralKey key) throws StripeException {
        return this.stripeRepository.retrieveCustomer(key.getObjectId$stripe_release(), new ApiRequest.Options(key.getSecret(), this.stripeAccountId, null, 4, null));
    }

    public CustomerSessionRunnableFactory(@NotNull StripeRepository stripeRepository, @NotNull Handler handler, @NotNull LocalBroadcastManager localBroadcastManager, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CustomerSessionProductUsage productUsage) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull((Object)localBroadcastManager, (String)"localBroadcastManager");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)productUsage, (String)"productUsage");
        this.stripeRepository = stripeRepository;
        this.handler = handler;
        this.localBroadcastManager = localBroadcastManager;
        this.publishableKey = publishableKey;
        this.stripeAccountId = stripeAccountId;
        this.productUsage = productUsage;
    }

    public static final /* synthetic */ StripeRepository access$getStripeRepository$p(CustomerSessionRunnableFactory $this) {
        return $this.stripeRepository;
    }

    public static final /* synthetic */ String access$getPublishableKey$p(CustomerSessionRunnableFactory $this) {
        return $this.publishableKey;
    }

    public static final /* synthetic */ CustomerSessionProductUsage access$getProductUsage$p(CustomerSessionRunnableFactory $this) {
        return $this.productUsage;
    }

    public static final /* synthetic */ String access$getStripeAccountId$p(CustomerSessionRunnableFactory $this) {
        return $this.stripeAccountId;
    }

    public static final /* synthetic */ Customer access$retrieveCustomerWithKey(CustomerSessionRunnableFactory $this, EphemeralKey key) {
        return $this.retrieveCustomerWithKey(key);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/CustomerSessionRunnableFactory$MessageCode;", "", "Companion", "stripe_release"})
    public static @interface MessageCode {
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int ERROR = 1;
        public static final int CUSTOMER_RETRIEVED = 2;
        public static final int SOURCE_RETRIEVED = 3;
        public static final int PAYMENT_METHOD_RETRIEVED = 4;
        public static final int CUSTOMER_SHIPPING_INFO_SAVED = 5;
        public static final int PAYMENT_METHODS_RETRIEVED = 6;

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSessionRunnableFactory$MessageCode$Companion;", "", "()V", "CUSTOMER_RETRIEVED", "", "CUSTOMER_SHIPPING_INFO_SAVED", "ERROR", "PAYMENT_METHODS_RETRIEVED", "PAYMENT_METHOD_RETRIEVED", "SOURCE_RETRIEVED", "stripe_release"})
        public static final class Companion {
            public static final int ERROR = 1;
            public static final int CUSTOMER_RETRIEVED = 2;
            public static final int SOURCE_RETRIEVED = 3;
            public static final int PAYMENT_METHOD_RETRIEVED = 4;
            public static final int CUSTOMER_SHIPPING_INFO_SAVED = 5;
            public static final int PAYMENT_METHODS_RETRIEVED = 6;
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u0004\u0018\u00018\u0000H \u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0017\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/CustomerSessionRunnableFactory$CustomerSessionRunnable;", "T", "Ljava/lang/Runnable;", "handler", "Landroid/os/Handler;", "localBroadcastManager", "Landroidx/localbroadcastmanager/content/LocalBroadcastManager;", "messageCode", "", "operationId", "", "(Landroid/os/Handler;Landroidx/localbroadcastmanager/content/LocalBroadcastManager;ILjava/lang/String;)V", "createMessageObject", "createMessageObject$stripe_release", "()Ljava/lang/Object;", "run", "", "sendErrorIntent", "exception", "Lcom/stripe/android/exception/StripeException;", "sendErrorMessage", "stripeEx", "sendMessage", "messageObject", "(Ljava/lang/Object;)V", "stripe_release"})
    private static abstract class CustomerSessionRunnable<T>
    implements Runnable {
        private final Handler handler;
        private final LocalBroadcastManager localBroadcastManager;
        private final int messageCode;
        private final String operationId;

        @Nullable
        public abstract T createMessageObject$stripe_release() throws StripeException;

        @Override
        public void run() {
            try {
                this.sendMessage(this.createMessageObject$stripe_release());
            }
            catch (StripeException stripeEx) {
                this.sendErrorMessage(stripeEx);
                this.sendErrorIntent(stripeEx);
            }
        }

        private final void sendMessage(T messageObject) {
            this.handler.sendMessage(this.handler.obtainMessage(this.messageCode, (Object)Pair.create((Object)this.operationId, messageObject)));
        }

        private final void sendErrorMessage(StripeException stripeEx) {
            this.handler.sendMessage(this.handler.obtainMessage(1, (Object)Pair.create((Object)this.operationId, (Object)stripeEx)));
        }

        private final void sendErrorIntent(StripeException exception) {
            Bundle bundle = new Bundle();
            bundle.putSerializable("exception", (Serializable)exception);
            this.localBroadcastManager.sendBroadcast(new Intent("action_api_exception").putExtras(bundle));
        }

        public CustomerSessionRunnable(@NotNull Handler handler, @NotNull LocalBroadcastManager localBroadcastManager, int messageCode, @NotNull String operationId) {
            Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
            Intrinsics.checkParameterIsNotNull((Object)localBroadcastManager, (String)"localBroadcastManager");
            Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
            this.handler = handler;
            this.localBroadcastManager = localBroadcastManager;
            this.messageCode = messageCode;
            this.operationId = operationId;
        }
    }
}

