/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.AppInfo;
import com.stripe.android.CustomerSessionEphemeralKeyManagerListener;
import com.stripe.android.CustomerSessionHandler;
import com.stripe.android.CustomerSessionProductUsage;
import com.stripe.android.CustomerSessionRunnableFactory;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeError;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CustomerSession {
    public static final String ACTION_API_EXCEPTION = "action_api_exception";
    public static final String EXTRA_EXCEPTION = "exception";
    public static final String EVENT_SHIPPING_INFO_SAVED = "shipping_info_saved";
    static final String ACTION_ADD_SOURCE = "add_source";
    static final String ACTION_DELETE_SOURCE = "delete_source";
    static final String ACTION_ATTACH_PAYMENT_METHOD = "attach_payment_method";
    static final String ACTION_DETACH_PAYMENT_METHOD = "detach_payment_method";
    static final String ACTION_GET_PAYMENT_METHODS = "get_payment_methods";
    static final String ACTION_SET_DEFAULT_SOURCE = "default_source";
    static final String ACTION_SET_CUSTOMER_SHIPPING_INFO = "set_shipping_info";
    static final String KEY_PAYMENT_METHOD = "payment_method";
    static final String KEY_PAYMENT_METHOD_TYPE = "payment_method_type";
    static final String KEY_SOURCE = "source";
    static final String KEY_SOURCE_TYPE = "source_type";
    static final String KEY_SHIPPING_INFO = "shipping_info";
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final long KEY_REFRESH_BUFFER_IN_SECONDS = 30L;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    private static CustomerSession mInstance;
    @Nullable
    private Customer mCustomer;
    private long mCustomerCacheTime;
    @NonNull
    private final LocalBroadcastManager mLocalBroadcastManager;
    @NonNull
    private final OperationIdFactory mOperationIdFactory;
    @NonNull
    private final EphemeralKeyManager mEphemeralKeyManager;
    @Nullable
    private final Calendar mProxyNowCalendar;
    @NonNull
    private final ThreadPoolExecutor mThreadPoolExecutor;
    @NonNull
    private final CustomerSessionProductUsage mProductUsage;
    @NonNull
    private final HashMap<String, RetrievalListener> listeners = new HashMap();

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        CustomerSession.setInstance(new CustomerSession(context, ephemeralKeyProvider, Stripe.getAppInfo(), PaymentConfiguration.getInstance(context).getPublishableKey(), stripeAccountId, shouldPrefetchEphemeralKey));
    }

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId) {
        CustomerSession.initCustomerSession(context, ephemeralKeyProvider, stripeAccountId, true);
    }

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
        CustomerSession.initCustomerSession(context, ephemeralKeyProvider, null, shouldPrefetchEphemeralKey);
    }

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider) {
        CustomerSession.initCustomerSession(context, ephemeralKeyProvider, null);
    }

    @NonNull
    public static CustomerSession getInstance() {
        if (mInstance == null) {
            throw new IllegalStateException("Attempted to get instance of CustomerSession without initialization.");
        }
        return mInstance;
    }

    @VisibleForTesting
    static void setInstance(@Nullable CustomerSession customerSession) {
        mInstance = customerSession;
    }

    public static void endCustomerSession() {
        CustomerSession.clearInstance();
    }

    @VisibleForTesting
    static void clearInstance() {
        if (mInstance != null) {
            CustomerSession.mInstance.listeners.clear();
        }
        CustomerSession.cancelCallbacks();
        CustomerSession.setInstance(null);
    }

    public static void cancelCallbacks() {
        if (mInstance == null) {
            return;
        }
        CustomerSession.mInstance.mThreadPoolExecutor.shutdownNow();
    }

    private CustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider keyProvider, @Nullable AppInfo appInfo, @NonNull String publishableKey, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        this(context, keyProvider, null, CustomerSession.createThreadPoolExecutor(), new StripeApiRepository(context, appInfo), publishableKey, stripeAccountId, shouldPrefetchEphemeralKey);
    }

    @VisibleForTesting
    CustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider keyProvider, @Nullable Calendar proxyNowCalendar, @NonNull ThreadPoolExecutor threadPoolExecutor, @NonNull StripeRepository stripeRepository, @NonNull String publishableKey, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        this.mOperationIdFactory = new OperationIdFactory();
        this.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        this.mThreadPoolExecutor = threadPoolExecutor;
        this.mProxyNowCalendar = proxyNowCalendar;
        this.mProductUsage = new CustomerSessionProductUsage();
        CustomerSessionEphemeralKeyManagerListener keyManagerListener = new CustomerSessionEphemeralKeyManagerListener(new CustomerSessionRunnableFactory(stripeRepository, this.createHandler(), this.mLocalBroadcastManager, publishableKey, stripeAccountId, this.mProductUsage), threadPoolExecutor, this.listeners, this.mProductUsage);
        this.mEphemeralKeyManager = new EphemeralKeyManager(keyProvider, keyManagerListener, 30L, proxyNowCalendar, this.mOperationIdFactory, shouldPrefetchEphemeralKey);
    }

    @NonNull
    private Handler createHandler() {
        return new CustomerSessionHandler(new CustomerSessionHandler.Listener(){

            @Override
            public void onCustomerRetrieved(@Nullable Customer customer, @NonNull String operationId) {
                CustomerSession.this.mCustomer = customer;
                CustomerSession.this.mCustomerCacheTime = CustomerSession.this.getCalendarInstance().getTimeInMillis();
                CustomerRetrievalListener listener = (CustomerRetrievalListener)CustomerSession.this.getListener(operationId);
                if (listener != null && customer != null) {
                    listener.onCustomerRetrieved(customer);
                }
            }

            @Override
            public void onSourceRetrieved(@Nullable Source source, @NonNull String operationId) {
                SourceRetrievalListener listener = (SourceRetrievalListener)CustomerSession.this.getListener(operationId);
                if (listener != null && source != null) {
                    listener.onSourceRetrieved(source);
                }
            }

            @Override
            public void onPaymentMethodRetrieved(@Nullable PaymentMethod paymentMethod, @NonNull String operationId) {
                PaymentMethodRetrievalListener listener = (PaymentMethodRetrievalListener)CustomerSession.this.getListener(operationId);
                if (listener != null && paymentMethod != null) {
                    listener.onPaymentMethodRetrieved(paymentMethod);
                }
            }

            @Override
            public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> paymentMethods, @NonNull String operationId) {
                PaymentMethodsRetrievalListener listener = (PaymentMethodsRetrievalListener)CustomerSession.this.getListener(operationId);
                if (listener != null) {
                    listener.onPaymentMethodsRetrieved(paymentMethods);
                }
            }

            @Override
            public void onCustomerShippingInfoSaved(@Nullable Customer customer) {
                CustomerSession.this.mCustomer = customer;
                CustomerSession.this.mLocalBroadcastManager.sendBroadcast(new Intent(CustomerSession.EVENT_SHIPPING_INFO_SAVED));
            }

            @Override
            public void onError(@NonNull StripeException exception, @NonNull String operationId) {
                CustomerSession.this.handleRetrievalError(operationId, exception);
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addProductUsageTokenIfValid(@Nullable String token) {
        this.mProductUsage.add(token);
    }

    public void retrieveCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        Customer cachedCustomer = this.getCachedCustomer();
        if (cachedCustomer != null) {
            listener.onCustomerRetrieved(cachedCustomer);
        } else {
            this.mCustomer = null;
            this.startOperation(null, null, listener);
        }
    }

    public void updateCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        this.mCustomer = null;
        this.startOperation(null, null, listener);
    }

    @Nullable
    public Customer getCachedCustomer() {
        if (this.canUseCachedCustomer()) {
            return this.mCustomer;
        }
        return null;
    }

    public void addCustomerSource(@NonNull String sourceId, @NonNull String sourceType, @NonNull SourceRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        this.startOperation(ACTION_ADD_SOURCE, arguments, listener);
    }

    public void deleteCustomerSource(@NonNull String sourceId, @NonNull SourceRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        this.startOperation(ACTION_DELETE_SOURCE, arguments, listener);
    }

    public void attachPaymentMethod(@NonNull String paymentMethodId, @NonNull PaymentMethodRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_PAYMENT_METHOD, paymentMethodId);
        this.startOperation(ACTION_ATTACH_PAYMENT_METHOD, arguments, listener);
    }

    public void detachPaymentMethod(@NonNull String paymentMethodId, @NonNull PaymentMethodRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_PAYMENT_METHOD, paymentMethodId);
        this.startOperation(ACTION_DETACH_PAYMENT_METHOD, arguments, listener);
    }

    public void getPaymentMethods(@NonNull PaymentMethod.Type paymentMethodType, @NonNull PaymentMethodsRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_PAYMENT_METHOD_TYPE, paymentMethodType.code);
        this.startOperation(ACTION_GET_PAYMENT_METHODS, arguments, listener);
    }

    public void setCustomerShippingInformation(@NonNull ShippingInformation shippingInformation) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SHIPPING_INFO, shippingInformation);
        this.startOperation(ACTION_SET_CUSTOMER_SHIPPING_INFO, arguments, null);
    }

    public void setCustomerDefaultSource(@NonNull String sourceId, @NonNull String sourceType, @NonNull CustomerRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        this.startOperation(ACTION_SET_DEFAULT_SOURCE, arguments, listener);
    }

    private void startOperation(@Nullable String action, @Nullable Map<String, Object> arguments, @Nullable RetrievalListener listener) {
        String operationId = this.mOperationIdFactory.create();
        this.listeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, action, arguments);
    }

    void resetUsageTokens() {
        this.mProductUsage.reset();
    }

    @Nullable
    @VisibleForTesting
    Customer getCustomer() {
        return this.mCustomer;
    }

    @VisibleForTesting
    long getCustomerCacheTime() {
        return this.mCustomerCacheTime;
    }

    @VisibleForTesting
    Set<String> getProductUsageTokens() {
        return this.mProductUsage.get();
    }

    private boolean canUseCachedCustomer() {
        long currentTime = this.getCalendarInstance().getTimeInMillis();
        return this.mCustomer != null && currentTime - this.mCustomerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    private void handleRetrievalError(@NonNull String operationId, @NonNull StripeException exception) {
        RetrievalListener listener = this.listeners.remove(operationId);
        if (listener != null) {
            String message = exception.getLocalizedMessage();
            listener.onError(exception.getStatusCode(), message != null ? message : "", exception.getStripeError());
        }
        this.resetUsageTokens();
    }

    @NonNull
    private static ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(3, 3, 2L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue<Runnable>());
    }

    @NonNull
    private Calendar getCalendarInstance() {
        return this.mProxyNowCalendar == null ? Calendar.getInstance() : this.mProxyNowCalendar;
    }

    @Nullable
    private <L extends RetrievalListener> L getListener(@NonNull String operationId) {
        return (L)this.listeners.remove(operationId);
    }

    public static abstract class ActivityPaymentMethodRetrievalListener<A extends Activity>
    implements PaymentMethodRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityPaymentMethodRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    public static abstract class ActivitySourceRetrievalListener<A extends Activity>
    implements SourceRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivitySourceRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    public static abstract class ActivityPaymentMethodsRetrievalListener<A extends Activity>
    implements PaymentMethodsRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityPaymentMethodsRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    static interface RetrievalListener {
        public void onError(int var1, @NonNull String var2, @Nullable StripeError var3);
    }

    public static interface PaymentMethodsRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> var1);
    }

    public static interface PaymentMethodRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodRetrieved(@NonNull PaymentMethod var1);
    }

    public static interface SourceRetrievalListener
    extends RetrievalListener {
        public void onSourceRetrieved(@NonNull Source var1);
    }

    public static interface CustomerRetrievalListener
    extends RetrievalListener {
        public void onCustomerRetrieved(@NonNull Customer var1);
    }

    public static abstract class ActivityCustomerRetrievalListener<A extends Activity>
    implements CustomerRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityCustomerRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }
}

