/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.UidParamsFactory;
import com.stripe.android.model.Card;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tJ)\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\t2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\tH\u0000\u00a2\u0006\u0002\b\u0010J,\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\t2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u00030\t2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/StripeNetworkUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "uidParamsFactory", "Lcom/stripe/android/UidParamsFactory;", "(Lcom/stripe/android/UidParamsFactory;)V", "createCardTokenParams", "", "", "card", "Lcom/stripe/android/model/Card;", "createUidParams", "paramsWithUid", "intentParams", "paramsWithUid$stripe_release", "stripeIntentParams", "key", "stripe_release"})
public final class StripeNetworkUtils {
    private final UidParamsFactory uidParamsFactory;

    @NotNull
    public final Map<String, Object> createCardTokenParams(@NotNull Card card) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        return MapsKt.plus((Map)MapsKt.plus(card.toParamMap(), (Pair)TuplesKt.to((Object)"product_usage", card.getLoggingTokens$stripe_release())), this.uidParamsFactory.createParams());
    }

    @NotNull
    public final Map<String, ?> paramsWithUid$stripe_release(@NotNull Map<String, ?> intentParams) {
        Intrinsics.checkParameterIsNotNull(intentParams, (String)"intentParams");
        return intentParams.containsKey("source_data") ? this.paramsWithUid(intentParams, "source_data") : (intentParams.containsKey("payment_method_data") ? this.paramsWithUid(intentParams, "payment_method_data") : intentParams);
    }

    private final Map<String, ?> paramsWithUid(Map<String, ?> stripeIntentParams, String key) {
        Map map;
        Object data = stripeIntentParams.get(key);
        if (data instanceof Map) {
            Map mutableParams = MapsKt.toMutableMap(stripeIntentParams);
            mutableParams.put(key, MapsKt.plus((Map)((Map)data), this.uidParamsFactory.createParams()));
            map = MapsKt.toMap((Map)mutableParams);
        } else {
            map = stripeIntentParams;
        }
        return map;
    }

    @NotNull
    public final Map<String, String> createUidParams() {
        return this.uidParamsFactory.createParams();
    }

    @VisibleForTesting
    public StripeNetworkUtils(@NotNull UidParamsFactory uidParamsFactory) {
        Intrinsics.checkParameterIsNotNull((Object)uidParamsFactory, (String)"uidParamsFactory");
        this.uidParamsFactory = uidParamsFactory;
    }

    public StripeNetworkUtils(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(UidParamsFactory.Companion.create(context));
    }
}

