/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002$%B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0000H\u0002R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006&"}, d2={"Lcom/stripe/android/model/Token;", "Lcom/stripe/android/model/StripePaymentSource;", "id", "", "livemode", "", "created", "Ljava/util/Date;", "used", "card", "Lcom/stripe/android/model/Card;", "(Ljava/lang/String;ZLjava/util/Date;Ljava/lang/Boolean;Lcom/stripe/android/model/Card;)V", "bankAccount", "Lcom/stripe/android/model/BankAccount;", "(Ljava/lang/String;ZLjava/util/Date;Ljava/lang/Boolean;Lcom/stripe/android/model/BankAccount;)V", "type", "(Ljava/lang/String;Ljava/lang/String;ZLjava/util/Date;Ljava/lang/Boolean;)V", "getBankAccount", "()Lcom/stripe/android/model/BankAccount;", "getCard", "()Lcom/stripe/android/model/Card;", "getCreated", "()Ljava/util/Date;", "getId", "()Ljava/lang/String;", "getLivemode", "()Z", "getType", "getUsed", "equals", "other", "", "hashCode", "", "typedEquals", "token", "Companion", "TokenType", "stripe_release"})
public final class Token
implements StripePaymentSource {
    @NotNull
    private final String id;
    @NotNull
    private final String type;
    @NotNull
    private final Date created;
    private final boolean livemode;
    private final boolean used;
    @Nullable
    private final BankAccount bankAccount;
    @Nullable
    private final Card card;
    private static final String FIELD_BANK_ACCOUNT = "bank_account";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_ID = "id";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USED = "used";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final Date getCreated() {
        return this.created;
    }

    public final boolean getLivemode() {
        return this.livemode;
    }

    public final boolean getUsed() {
        return this.used;
    }

    @Nullable
    public final BankAccount getBankAccount() {
        return this.bankAccount;
    }

    @Nullable
    public final Card getCard() {
        return this.card;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.type, this.created, this.livemode, this.used, this.bankAccount, this.card);
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof Token ? this.typedEquals((Token)other) : false);
    }

    private final boolean typedEquals(Token token) {
        return Intrinsics.areEqual((Object)this.getId(), (Object)token.getId()) && Intrinsics.areEqual((Object)this.type, (Object)token.type) && Intrinsics.areEqual((Object)this.created, (Object)token.created) && this.livemode == token.livemode && this.used == token.used && Intrinsics.areEqual((Object)this.bankAccount, (Object)token.bankAccount) && Intrinsics.areEqual((Object)this.card, (Object)token.card);
    }

    public Token(@NotNull String id2, boolean livemode, @NotNull Date created, @Nullable Boolean used, @Nullable Card card) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)FIELD_ID);
        Intrinsics.checkParameterIsNotNull((Object)created, (String)FIELD_CREATED);
        this.id = id2;
        this.type = FIELD_CARD;
        this.created = created;
        this.livemode = livemode;
        this.card = card;
        this.used = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)used);
        this.bankAccount = null;
    }

    public Token(@NotNull String id2, boolean livemode, @NotNull Date created, @Nullable Boolean used, @NotNull BankAccount bankAccount) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)FIELD_ID);
        Intrinsics.checkParameterIsNotNull((Object)created, (String)FIELD_CREATED);
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        this.id = id2;
        this.type = FIELD_BANK_ACCOUNT;
        this.created = created;
        this.livemode = livemode;
        this.card = null;
        this.used = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)used);
        this.bankAccount = bankAccount;
    }

    public Token(@NotNull String id2, @NotNull String type, boolean livemode, @NotNull Date created, @Nullable Boolean used) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)FIELD_ID);
        Intrinsics.checkParameterIsNotNull((Object)type, (String)FIELD_TYPE);
        Intrinsics.checkParameterIsNotNull((Object)created, (String)FIELD_CREATED);
        this.id = id2;
        this.type = type;
        this.created = created;
        this.card = null;
        this.bankAccount = null;
        this.used = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)used);
        this.livemode = livemode;
    }

    @JvmStatic
    @Nullable
    public static final Token fromString(@Nullable String jsonString) {
        return Companion.fromString(jsonString);
    }

    @JvmStatic
    @Nullable
    public static final Token fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0087\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/model/Token$TokenType;", "", "Companion", "stripe_release"})
    public static @interface TokenType {
        public static final Companion Companion = Companion.$$INSTANCE;
        @NotNull
        public static final String CARD = "card";
        @NotNull
        public static final String BANK_ACCOUNT = "bank_account";
        @NotNull
        public static final String PII = "pii";
        @NotNull
        public static final String ACCOUNT = "account";
        @NotNull
        public static final String CVC_UPDATE = "cvc_update";

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/model/Token$TokenType$Companion;", "", "()V", "ACCOUNT", "", "BANK_ACCOUNT", "CARD", "CVC_UPDATE", "PII", "stripe_release"})
        public static final class Companion {
            @NotNull
            public static final String CARD = "card";
            @NotNull
            public static final String BANK_ACCOUNT = "bank_account";
            @NotNull
            public static final String PII = "pii";
            @NotNull
            public static final String ACCOUNT = "account";
            @NotNull
            public static final String CVC_UPDATE = "cvc_update";
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/model/Token$Companion;", "", "()V", "FIELD_BANK_ACCOUNT", "", "FIELD_CARD", "FIELD_CREATED", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_TYPE", "FIELD_USED", "asTokenType", "possibleTokenType", "fromJson", "Lcom/stripe/android/model/Token;", "jsonObject", "Lorg/json/JSONObject;", "fromString", "jsonString", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Token fromString(@Nullable String jsonString) {
            Token token;
            if (jsonString == null) {
                return null;
            }
            try {
                JSONObject tokenObject = new JSONObject(jsonString);
                token = this.fromJson(tokenObject);
            }
            catch (JSONException exception) {
                token = null;
            }
            return token;
        }

        @JvmStatic
        @Nullable
        public final Token fromJson(@Nullable JSONObject jsonObject) {
            Token token;
            if (jsonObject == null) {
                return null;
            }
            String tokenId = StripeJsonUtils.optString(jsonObject, Token.FIELD_ID);
            Long createdTimeStamp = StripeJsonUtils.optLong(jsonObject, Token.FIELD_CREATED);
            Boolean liveModeOpt = StripeJsonUtils.optBoolean(jsonObject, Token.FIELD_LIVEMODE);
            String tokenType = this.asTokenType(StripeJsonUtils.optString(jsonObject, Token.FIELD_TYPE));
            Boolean usedOpt = StripeJsonUtils.optBoolean(jsonObject, Token.FIELD_USED);
            if (tokenId == null || createdTimeStamp == null || liveModeOpt == null) {
                return null;
            }
            boolean used = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)usedOpt);
            boolean liveMode = Intrinsics.areEqual((Object)Boolean.TRUE, (Object)liveModeOpt);
            Date date = new Date(createdTimeStamp * (long)1000);
            if (Intrinsics.areEqual((Object)Token.FIELD_BANK_ACCOUNT, (Object)tokenType)) {
                JSONObject jSONObject = jsonObject.optJSONObject(Token.FIELD_BANK_ACCOUNT);
                if (jSONObject == null) {
                    return null;
                }
                JSONObject bankAccountObject = jSONObject;
                token = new Token(tokenId, liveMode, date, (Boolean)used, BankAccount.Companion.fromJson(bankAccountObject));
            } else if (Intrinsics.areEqual((Object)Token.FIELD_CARD, (Object)tokenType)) {
                JSONObject jSONObject = jsonObject.optJSONObject(Token.FIELD_CARD);
                if (jSONObject == null) {
                    return null;
                }
                JSONObject cardObject = jSONObject;
                token = new Token(tokenId, liveMode, date, (Boolean)used, Card.Companion.fromJson(cardObject));
            } else {
                token = Intrinsics.areEqual((Object)"pii", (Object)tokenType) || Intrinsics.areEqual((Object)"account", (Object)tokenType) || Intrinsics.areEqual((Object)"cvc_update", (Object)tokenType) ? new Token(tokenId, tokenType, liveMode, date, used) : null;
            }
            return token;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asTokenType(String possibleTokenType) {
            CharSequence charSequence = possibleTokenType;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null) return null;
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            boolean bl3 = false;
            if (bl3) {
                return null;
            }
            String string2 = possibleTokenType;
            if (string2 == null) return null;
            switch (string2) {
                case "card": {
                    return Token.FIELD_CARD;
                }
                case "bank_account": {
                    return Token.FIELD_BANK_ACCOUNT;
                }
                case "pii": {
                    return "pii";
                }
                case "account": {
                    return "account";
                }
                case "cvc_update": {
                    return "cvc_update";
                }
                default: {
                    return null;
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

