/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.Logger;
import com.stripe.android.StripeConnection;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/StripeApiRequestExecutor;", "Lcom/stripe/android/ApiRequestExecutor;", "logger", "Lcom/stripe/android/Logger;", "(Lcom/stripe/android/Logger;)V", "connectionFactory", "Lcom/stripe/android/ConnectionFactory;", "execute", "Lcom/stripe/android/StripeResponse;", "request", "Lcom/stripe/android/ApiRequest;", "stripe_release"})
public final class StripeApiRequestExecutor
implements ApiRequestExecutor {
    private final ConnectionFactory connectionFactory;
    private final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StripeResponse execute(@NotNull ApiRequest request) throws APIConnectionException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.logger.info(request.toString());
        Closeable closeable = this.connectionFactory.create(request);
        boolean bl = false;
        Throwable throwable = null;
        try {
            StripeConnection it = (StripeConnection)closeable;
            boolean bl2 = false;
            try {
                StripeResponse stripeResponse = it.getResponse$stripe_release();
                this.logger.info(stripeResponse.toString());
                StripeResponse stripeResponse2 = stripeResponse;
                return stripeResponse2;
            }
            catch (IOException e) {
                try {
                    this.logger.error("Exception while making Stripe API request", e);
                    throw (Throwable)APIConnectionException.Companion.create(request.getBaseUrl(), e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public StripeApiRequestExecutor(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.connectionFactory = new ConnectionFactory();
    }

    public /* synthetic */ StripeApiRequestExecutor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = Logger.Companion.noop$stripe_release();
        }
        this(logger);
    }

    public StripeApiRequestExecutor() {
        this(null, 1, null);
    }
}

