/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\nJ&\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u00062\b\b\u0001\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/view/StripeColorUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getIdentifier", "", "attrName", "", "getThemeAccentColor", "Landroid/util/TypedValue;", "getThemeColorControlNormal", "getThemeTextColorPrimary", "getThemeTextColorSecondary", "getTintedIconWithAttribute", "Landroid/graphics/drawable/Drawable;", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "attributeResource", "iconResourceId", "Companion", "stripe_release"})
public final class StripeColorUtils {
    private final Context context;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final TypedValue getThemeAccentColor() {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843829 : this.getIdentifier("colorAccent");
        TypedValue outValue = new TypedValue();
        this.context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NotNull
    public final TypedValue getThemeColorControlNormal() {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16843817 : this.getIdentifier("colorControlNormal");
        TypedValue outValue = new TypedValue();
        this.context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    private final int getIdentifier(String attrName) {
        return this.context.getResources().getIdentifier(attrName, "attr", this.context.getPackageName());
    }

    @NotNull
    public final TypedValue getThemeTextColorSecondary() {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16842808 : 17170439;
        TypedValue outValue = new TypedValue();
        this.context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NotNull
    public final TypedValue getThemeTextColorPrimary() {
        int colorAttr = Build.VERSION.SDK_INT >= 21 ? 16842806 : 17170435;
        TypedValue outValue = new TypedValue();
        this.context.getTheme().resolveAttribute(colorAttr, outValue, true);
        return outValue;
    }

    @NotNull
    public final Drawable getTintedIconWithAttribute(@NotNull Resources.Theme theme, @AttrRes int attributeResource, @DrawableRes int iconResourceId) {
        Drawable icon;
        Intrinsics.checkParameterIsNotNull((Object)theme, (String)"theme");
        TypedValue typedValue = new TypedValue();
        theme.resolveAttribute(attributeResource, typedValue, true);
        int color = typedValue.data;
        Drawable drawable2 = icon = ContextCompat.getDrawable((Context)this.context, (int)iconResourceId);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        Drawable compatIcon = DrawableCompat.wrap((Drawable)drawable2);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)color);
        Drawable drawable3 = compatIcon;
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable3, (String)"compatIcon");
        return drawable3;
    }

    public StripeColorUtils(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @JvmStatic
    public static final boolean isColorTransparent(@ColorInt int color) {
        return Companion.isColorTransparent(color);
    }

    @JvmStatic
    public static final boolean isColorDark(@ColorInt int color) {
        return Companion.isColorDark(color);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/view/StripeColorUtils$Companion;", "", "()V", "isColorDark", "", "color", "", "isColorTransparent", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        public final boolean isColorTransparent(@ColorInt int color) {
            return Color.alpha((int)color) < 16;
        }

        @JvmStatic
        public final boolean isColorDark(@ColorInt int color) {
            double luminescence = 0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color);
            double luminescencePercentage = luminescence / (double)255;
            return luminescencePercentage <= 0.5;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

