/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.PaymentMethodSwipeCallback;
import com.stripe.android.view.PaymentMethodsActivity;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 02\u00020\u0001:\u00040123B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\"\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\u0012\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0012\u0010 \u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u001eH\u0014J\b\u0010#\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\nH\u0002J\u0010\u0010&\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\fJ\b\u0010'\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u0010+\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\f2\b\b\u0001\u0010,\u001a\u00020\u0016H\u0002J\u0016\u0010-\u001a\u00020\u000e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\f0/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "adapter", "Lcom/stripe/android/view/PaymentMethodsAdapter;", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "customerSession", "Lcom/stripe/android/CustomerSession;", "startedFromPaymentSession", "", "tappedPaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "cancelAndFinish", "", "confirmDeletePaymentMethod", "paymentMethod", "fetchCustomerPaymentMethods", "finishWithPaymentMethod", "initLoggingTokens", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onAddedPaymentMethod", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDeletedPaymentMethod", "onPaymentMethodCreated", "onSaveInstanceState", "outState", "onSupportNavigateUp", "setCommunicatingProgress", "communicating", "setSelectionAndFinish", "setupRecyclerView", "showError", "error", "", "showSnackbar", "stringRes", "updatePaymentMethods", "paymentMethods", "", "Companion", "PaymentMethodDeleteListener", "PaymentMethodsRetrievalListener", "SwipeToDeleteCallbackListener", "stripe_release"})
public final class PaymentMethodsActivity
extends AppCompatActivity {
    private PaymentMethodsAdapter adapter;
    private boolean startedFromPaymentSession;
    private CustomerSession customerSession;
    private CardDisplayTextFactory cardDisplayTextFactory;
    private PaymentMethod tappedPaymentMethod;
    private static final String STATE_SELECTED_PAYMENT_METHOD_ID = "state_selected_payment_method_id";
    @NotNull
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        PaymentMethodsActivityStarter.Args args = PaymentMethodsActivityStarter.Args.Companion.create(intent);
        this.startedFromPaymentSession = args.isPaymentSessionActive$stripe_release();
        this.cardDisplayTextFactory = CardDisplayTextFactory.Companion.create((Context)this);
        CustomerSession customerSession = CustomerSession.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)customerSession, (String)"CustomerSession.getInstance()");
        this.customerSession = customerSession;
        Object object = savedInstanceState;
        if (object == null || (object = object.getString(STATE_SELECTED_PAYMENT_METHOD_ID)) == null) {
            object = args.getInitialPaymentMethodId$stripe_release();
        }
        Object initiallySelectedPaymentMethodId = object;
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter = new PaymentMethodsAdapter((String)initiallySelectedPaymentMethodId, args, args.getPaymentMethodTypes$stripe_release());
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsAdapter.setListener(new PaymentMethodsAdapter.Listener(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onClick(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                PaymentMethodsActivity.access$setTappedPaymentMethod$p(this.this$0, paymentMethod);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.setupRecyclerView();
        Context context = (Context)this;
        PaymentMethodsAdapter paymentMethodsAdapter2 = this.adapter;
        if (paymentMethodsAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new PaymentMethodSwipeCallback(context, paymentMethodsAdapter2, new SwipeToDeleteCallbackListener(this)));
        itemTouchHelper.attachToRecyclerView((RecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler));
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.payment_methods_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        ActionBar actionBar2 = this.getSupportActionBar();
        if (actionBar2 != null) {
            actionBar2.setDisplayShowHomeEnabled(true);
        }
        this.fetchCustomerPaymentMethods();
        ((RecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).requestFocusFromTouch();
    }

    private final void setupRecyclerView() {
        ((RecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).setHasFixedSize(false);
        RecyclerView recyclerView = (RecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"payment_methods_recycler");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        RecyclerView recyclerView2 = (RecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"payment_methods_recycler");
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        recyclerView2.setAdapter((RecyclerView.Adapter)paymentMethodsAdapter);
        RecyclerView recyclerView3 = (RecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView3, (String)"payment_methods_recycler");
        recyclerView3.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onAnimationFinished(@NotNull RecyclerView.ViewHolder viewHolder) {
                Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
                super.onAnimationFinished(viewHolder);
                if (PaymentMethodsActivity.access$getTappedPaymentMethod$p(this.this$0) != null) {
                    this.this$0.setSelectionAndFinish(PaymentMethodsActivity.access$getTappedPaymentMethod$p(this.this$0));
                    PaymentMethodsActivity.access$setTappedPaymentMethod$p(this.this$0, null);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 6001 && resultCode == -1) {
            this.onPaymentMethodCreated(data);
        }
    }

    public boolean onSupportNavigateUp() {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.setSelectionAndFinish(paymentMethodsAdapter.getSelectedPaymentMethod());
        return true;
    }

    private final void onPaymentMethodCreated(Intent data) {
        this.initLoggingTokens();
        if (data != null) {
            AddPaymentMethodActivityStarter.Result result = AddPaymentMethodActivityStarter.Result.Companion.fromIntent(data);
            Parcelable parcelable = result;
            if (parcelable != null && (parcelable = parcelable.getPaymentMethod()) != null) {
                Parcelable parcelable2 = parcelable;
                boolean bl = false;
                boolean bl2 = false;
                Parcelable it = parcelable2;
                boolean bl3 = false;
                this.onAddedPaymentMethod((PaymentMethod)it);
            }
        } else {
            this.fetchCustomerPaymentMethods();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void onAddedPaymentMethod(PaymentMethod paymentMethod) {
        PaymentMethod.Type type;
        PaymentMethod.Type type2 = type = PaymentMethod.Type.lookup(paymentMethod.type);
        if (type2 != null) {
            if (type2.isReusable) {
                this.fetchCustomerPaymentMethods();
                this.showSnackbar(paymentMethod, R.string.added);
                return;
            }
        }
        this.finishWithPaymentMethod(paymentMethod);
    }

    private final void onDeletedPaymentMethod(PaymentMethod paymentMethod) {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsAdapter.deletePaymentMethod(paymentMethod);
        if (paymentMethod.id != null) {
            CustomerSession customerSession = this.customerSession;
            if (customerSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
            }
            customerSession.detachPaymentMethod(paymentMethod.id, new PaymentMethodDeleteListener());
        }
        this.showSnackbar(paymentMethod, R.string.removed);
    }

    private final void showSnackbar(PaymentMethod paymentMethod, @StringRes int stringRes) {
        String snackbarText;
        String string2;
        if (paymentMethod.card != null) {
            Object[] objectArray = new Object[1];
            CardDisplayTextFactory cardDisplayTextFactory = this.cardDisplayTextFactory;
            if (cardDisplayTextFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardDisplayTextFactory");
            }
            objectArray[0] = cardDisplayTextFactory.createUnstyled(paymentMethod.card);
            string2 = this.getString(stringRes, objectArray);
        } else {
            string2 = snackbarText = null;
        }
        if (snackbarText != null) {
            Snackbar.make((View)((CoordinatorLayout)this._$_findCachedViewById(R.id.payment_methods_coordinator)), (CharSequence)snackbarText, (int)-1).show();
        }
    }

    public void onBackPressed() {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.setSelectionAndFinish(paymentMethodsAdapter.getSelectedPaymentMethod());
    }

    private final void fetchCustomerPaymentMethods() {
        this.setCommunicatingProgress(true);
        CustomerSession customerSession = this.customerSession;
        if (customerSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        customerSession.getPaymentMethods(PaymentMethod.Type.Card, new PaymentMethodsRetrievalListener(this));
    }

    private final void updatePaymentMethods(List<PaymentMethod> paymentMethods) {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsAdapter.setPaymentMethods(paymentMethods);
    }

    private final void initLoggingTokens() {
        if (this.startedFromPaymentSession) {
            CustomerSession customerSession = this.customerSession;
            if (customerSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
            }
            customerSession.addProductUsageTokenIfValid("PaymentSession");
        }
        CustomerSession customerSession = this.customerSession;
        if (customerSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        customerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private final void cancelAndFinish() {
        this.setResult(0);
        this.finish();
    }

    private final void setCommunicatingProgress(boolean communicating) {
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.payment_methods_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"payment_methods_progress_bar");
        progressBar.setVisibility(communicating ? 0 : 8);
        this.supportInvalidateOptionsMenu();
    }

    public final void setSelectionAndFinish(@Nullable PaymentMethod paymentMethod) {
        PaymentMethod paymentMethod2 = paymentMethod;
        if ((paymentMethod2 != null ? paymentMethod2.id : null) == null) {
            this.cancelAndFinish();
            return;
        }
        this.finishWithPaymentMethod(paymentMethod);
    }

    private final void finishWithPaymentMethod(PaymentMethod paymentMethod) {
        this.setResult(-1, new Intent().putExtras(new PaymentMethodsActivityStarter.Result(paymentMethod, false, 2, null).toBundle()));
        this.finish();
    }

    private final void showError(String error) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, (DialogInterface.OnClickListener)showError.1.INSTANCE).create().show();
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        PaymentMethod paymentMethod = paymentMethodsAdapter.getSelectedPaymentMethod();
        outState.putString(STATE_SELECTED_PAYMENT_METHOD_ID, paymentMethod != null ? paymentMethod.id : null);
    }

    private final void confirmDeletePaymentMethod(PaymentMethod paymentMethod) {
        String string2;
        if (paymentMethod.card != null) {
            CardDisplayTextFactory cardDisplayTextFactory = this.cardDisplayTextFactory;
            if (cardDisplayTextFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardDisplayTextFactory");
            }
            string2 = cardDisplayTextFactory.createUnstyled(paymentMethod.card);
        } else {
            string2 = null;
        }
        String message = string2;
        new AlertDialog.Builder((Context)this).setTitle(R.string.delete_payment_method).setMessage((CharSequence)message).setPositiveButton(17039379, new DialogInterface.OnClickListener(this, paymentMethod){
            final /* synthetic */ PaymentMethodsActivity this$0;
            final /* synthetic */ PaymentMethod $paymentMethod;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                PaymentMethodsActivity.access$onDeletedPaymentMethod(this.this$0, this.$paymentMethod);
            }
            {
                this.this$0 = paymentMethodsActivity;
                this.$paymentMethod = paymentMethod;
            }
        }).setNegativeButton(17039369, new DialogInterface.OnClickListener(this, paymentMethod){
            final /* synthetic */ PaymentMethodsActivity this$0;
            final /* synthetic */ PaymentMethod $paymentMethod;

            public final void onClick(DialogInterface $noName_0, int $noName_1) {
                PaymentMethodsActivity.access$getAdapter$p(this.this$0).resetPaymentMethod(this.$paymentMethod);
            }
            {
                this.this$0 = paymentMethodsActivity;
                this.$paymentMethod = paymentMethod;
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(this, paymentMethod){
            final /* synthetic */ PaymentMethodsActivity this$0;
            final /* synthetic */ PaymentMethod $paymentMethod;

            public final void onCancel(DialogInterface it) {
                PaymentMethodsActivity.access$getAdapter$p(this.this$0).resetPaymentMethod(this.$paymentMethod);
            }
            {
                this.this$0 = paymentMethodsActivity;
                this.$paymentMethod = paymentMethod;
            }
        }).create().show();
    }

    public static final /* synthetic */ PaymentMethod access$getTappedPaymentMethod$p(PaymentMethodsActivity $this) {
        return $this.tappedPaymentMethod;
    }

    public static final /* synthetic */ void access$setTappedPaymentMethod$p(PaymentMethodsActivity $this, PaymentMethod paymentMethod) {
        $this.tappedPaymentMethod = paymentMethod;
    }

    public static final /* synthetic */ void access$onDeletedPaymentMethod(PaymentMethodsActivity $this, PaymentMethod paymentMethod) {
        $this.onDeletedPaymentMethod(paymentMethod);
    }

    public static final /* synthetic */ PaymentMethodsAdapter access$getAdapter$p(PaymentMethodsActivity $this) {
        PaymentMethodsAdapter paymentMethodsAdapter = $this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return paymentMethodsAdapter;
    }

    public static final /* synthetic */ void access$setAdapter$p(PaymentMethodsActivity $this, PaymentMethodsAdapter paymentMethodsAdapter) {
        $this.adapter = paymentMethodsAdapter;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\r\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$PaymentMethodsRetrievalListener;", "Lcom/stripe/android/CustomerSession$ActivityPaymentMethodsRetrievalListener;", "Lcom/stripe/android/view/PaymentMethodsActivity;", "activity", "(Lcom/stripe/android/view/PaymentMethodsActivity;)V", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "onPaymentMethodsRetrieved", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    private static final class PaymentMethodsRetrievalListener
    extends CustomerSession.ActivityPaymentMethodsRetrievalListener<PaymentMethodsActivity> {
        @Override
        public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
            Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
            PaymentMethodsActivity paymentMethodsActivity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (paymentMethodsActivity == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)paymentMethodsActivity), (String)"activity ?: return");
            PaymentMethodsActivity activity = paymentMethodsActivity;
            activity.updatePaymentMethods(paymentMethods);
            activity.setCommunicatingProgress(false);
        }

        @Override
        public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
            PaymentMethodsActivity paymentMethodsActivity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (paymentMethodsActivity == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)paymentMethodsActivity), (String)"activity ?: return");
            PaymentMethodsActivity activity = paymentMethodsActivity;
            String string2 = TranslatorManager.getErrorMessageTranslator().translate(errorCode, errorMessage, stripeError);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"TranslatorManager.getErr\u2026rrorMessage, stripeError)");
            String displayedError = string2;
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }

        public PaymentMethodsRetrievalListener(@NotNull PaymentMethodsActivity activity) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            super((Activity)activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$PaymentMethodDeleteListener;", "Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "()V", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "onPaymentMethodRetrieved", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    private static final class PaymentMethodDeleteListener
    implements CustomerSession.PaymentMethodRetrievalListener {
        @Override
        public void onPaymentMethodRetrieved(@NotNull PaymentMethod paymentMethod) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
        }

        @Override
        public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
            Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$SwipeToDeleteCallbackListener;", "Lcom/stripe/android/view/PaymentMethodSwipeCallback$Listener;", "activity", "Lcom/stripe/android/view/PaymentMethodsActivity;", "(Lcom/stripe/android/view/PaymentMethodsActivity;)V", "onSwiped", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    private static final class SwipeToDeleteCallbackListener
    implements PaymentMethodSwipeCallback.Listener {
        private final PaymentMethodsActivity activity;

        @Override
        public void onSwiped(@NotNull PaymentMethod paymentMethod) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
            this.activity.confirmDeletePaymentMethod(paymentMethod);
        }

        public SwipeToDeleteCallbackListener(@NotNull PaymentMethodsActivity activity) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            this.activity = activity;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$Companion;", "", "()V", "STATE_SELECTED_PAYMENT_METHOD_ID", "", "TOKEN_PAYMENT_METHODS_ACTIVITY", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

