/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/model/ModelUtils;", "", "()V", "hasMonthPassed", "", "year", "", "month", "now", "Ljava/util/Calendar;", "hasYearPassed", "isDigitsOnly", "str", "", "isWholePositiveNumber", "value", "", "normalizeYear", "stripe_release"})
public final class ModelUtils {
    public static final ModelUtils INSTANCE;

    @JvmStatic
    public static final boolean isWholePositiveNumber(@Nullable String value) {
        return value != null && INSTANCE.isDigitsOnly(value);
    }

    private final boolean isDigitsOnly(CharSequence str) {
        int cp;
        for (int i = 0; i < str.length(); i += Character.charCount(cp)) {
            cp = Character.codePointAt(str, i);
            if (Character.isDigit(cp)) continue;
            return false;
        }
        return true;
    }

    @JvmStatic
    public static final boolean hasMonthPassed(int year, int month, @NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        return ModelUtils.hasYearPassed(year, now) ? true : ModelUtils.normalizeYear(year, now) == now.get(1) && month < now.get(2) + 1;
    }

    @JvmStatic
    public static final boolean hasYearPassed(int year, @NotNull Calendar now) {
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        return ModelUtils.normalizeYear(year, now) < now.get(1);
    }

    @JvmStatic
    public static final int normalizeYear(int year, @NotNull Calendar now) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)now, (String)"now");
        int n2 = year;
        if (0 <= n2 && 99 >= n2) {
            String currentYear;
            String string2 = currentYear = String.valueOf(now.get(1));
            int n3 = 0;
            int n4 = currentYear.length() - 2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n3, n4);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String prefix = string4;
            string2 = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string5 = "%s%02d";
            Object[] objectArray = new Object[]{prefix, year};
            boolean bl2 = false;
            String string6 = String.format(locale2, string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            n = Integer.parseInt(string6);
        } else {
            n = year;
        }
        return n;
    }

    private ModelUtils() {
    }

    static {
        ModelUtils modelUtils;
        INSTANCE = modelUtils = new ModelUtils();
    }
}

