/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeSystemPropertySupplier;
import com.stripe.android.SystemPropertySupplier;
import com.stripe.android.exception.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 (2\u00020\u0001:\u0002()BK\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0010\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0005H\u0002J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\r\u0010\u001e\u001a\u00020\u001fH\u0010\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u0000H\u0002R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00058@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/ApiRequest;", "Lcom/stripe/android/StripeRequest;", "method", "Lcom/stripe/android/StripeRequest$Method;", "url", "", "params", "", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "systemPropertySupplier", "Lcom/stripe/android/SystemPropertySupplier;", "(Lcom/stripe/android/StripeRequest$Method;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/AppInfo;Lcom/stripe/android/SystemPropertySupplier;)V", "apiVersion", "languageTag", "languageTag$annotations", "()V", "getLanguageTag$stripe_release", "()Ljava/lang/String;", "getOptions$stripe_release", "()Lcom/stripe/android/ApiRequest$Options;", "createHeaders", "createHeaders$stripe_release", "createStripeClientUserAgent", "equals", "", "other", "", "getOutputBytes", "", "getOutputBytes$stripe_release", "getUserAgent", "getUserAgent$stripe_release", "hashCode", "", "toString", "typedEquals", "obj", "Companion", "Options", "stripe_release"})
public final class ApiRequest
extends StripeRequest {
    private final String apiVersion;
    @NotNull
    private final Options options;
    private final AppInfo appInfo;
    private final SystemPropertySupplier systemPropertySupplier;
    @NotNull
    public static final String MIME_TYPE = "application/x-www-form-urlencoded";
    @NotNull
    public static final String API_HOST = "https://api.stripe.com";
    @NotNull
    public static final String HEADER_STRIPE_CLIENT_USER_AGENT = "X-Stripe-Client-User-Agent";
    private static final String PROP_USER_AGENT = "http.agent";
    private static final boolean SHOULD_INCLUDE_ACCEPT_LANGUAGE_HEADER = false;
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void languageTag$annotations() {
    }

    @Nullable
    public final String getLanguageTag$stripe_release() {
        String string2 = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().toString()");
        String string3 = StringsKt.replace$default((String)string2, (String)"_", (String)"-", (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return !StringsKt.isBlank((CharSequence)charSequence) ? string3 : null;
    }

    @Override
    @NotNull
    public Map<String, String> createHeaders$stripe_release() {
        Object object;
        Object object2;
        Object object3;
        Object it;
        boolean bl;
        boolean bl2;
        Map map;
        Object object4;
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"Accept-Charset", (Object)"UTF-8"), TuplesKt.to((Object)"Accept", (Object)"application/json"), TuplesKt.to((Object)HEADER_STRIPE_CLIENT_USER_AGENT, (Object)this.createStripeClientUserAgent()), TuplesKt.to((Object)"Stripe-Version", (Object)this.apiVersion), TuplesKt.to((Object)"Authorization", (Object)("Bearer " + this.options.getApiKey()))});
        String string2 = this.options.getStripeAccount();
        if (string2 != null) {
            object4 = string2;
            map = map2;
            bl2 = false;
            bl = false;
            it = object4;
            boolean bl3 = false;
            object3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Account", (Object)it));
            map2 = map;
            object2 = object3;
        } else {
            object2 = null;
        }
        object4 = object2;
        map = map2;
        bl2 = false;
        Object object5 = object4;
        if (object5 == null) {
            object5 = MapsKt.emptyMap();
        }
        object3 = object5;
        object4 = this.getLanguageTag$stripe_release();
        map = MapsKt.plus((Map)map, (Map)object3);
        bl2 = false;
        bl = false;
        it = object4;
        boolean bl4 = false;
        object3 = false ? object4 : null;
        Map map3 = map;
        Object object6 = object3;
        if (object6 != null) {
            object4 = object6;
            map = map3;
            bl2 = false;
            bl = false;
            it = object4;
            boolean bl5 = false;
            object3 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)it));
            map3 = map;
            object = object3;
        } else {
            object = null;
        }
        object4 = object;
        map = map3;
        bl2 = false;
        Object object7 = object4;
        if (object7 == null) {
            object7 = MapsKt.emptyMap();
        }
        object3 = object7;
        return MapsKt.plus((Map)map, (Map)object3);
    }

    private final String createStripeClientUserAgent() {
        AppInfo appInfo = this.appInfo;
        Map map = appInfo != null ? appInfo.createClientHeaders$stripe_release() : null;
        Map map2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"os.name", (Object)"android"), TuplesKt.to((Object)"os.version", (Object)String.valueOf(Build.VERSION.SDK_INT)), TuplesKt.to((Object)"bindings.version", (Object)"11.3.0"), TuplesKt.to((Object)"lang", (Object)"Java"), TuplesKt.to((Object)"publisher", (Object)"Stripe"), TuplesKt.to((Object)"java.version", (Object)this.systemPropertySupplier.get("java.version")), TuplesKt.to((Object)PROP_USER_AGENT, (Object)this.systemPropertySupplier.get(PROP_USER_AGENT))});
        boolean bl = false;
        Map map3 = map;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map map4 = map3;
        Map map5 = MapsKt.plus((Map)map2, (Map)map4);
        String string2 = new JSONObject(map5).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JSONObject(\n            \u2026   )\n        ).toString()");
        return string2;
    }

    @Override
    @NotNull
    public String getUserAgent$stripe_release() {
        Object[] objectArray = new String[2];
        objectArray[0] = "Stripe/v1 AndroidBindings/11.3.0";
        AppInfo appInfo = this.appInfo;
        objectArray[1] = appInfo != null ? appInfo.toUserAgent$stripe_release() : null;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public byte[] getOutputBytes$stripe_release() throws UnsupportedEncodingException, InvalidRequestException {
        String string2 = this.createQuery();
        Object object = "UTF-8";
        boolean bl = false;
        Charset charset = Charset.forName((String)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object = charset;
        bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public String toString() {
        return this.getMethod().getCode() + ' ' + this.getBaseUrl();
    }

    public int hashCode() {
        return Objects.hash(this.getBaseHashCode(), this.options, this.appInfo);
    }

    public boolean equals(@Nullable Object other) {
        return super.equals(other) || other instanceof ApiRequest && this.typedEquals((ApiRequest)other);
    }

    private final boolean typedEquals(ApiRequest obj) {
        return super.typedEquals(obj) && Intrinsics.areEqual((Object)this.options, (Object)obj.options) && Intrinsics.areEqual((Object)this.appInfo, (Object)obj.appInfo);
    }

    @NotNull
    public final Options getOptions$stripe_release() {
        return this.options;
    }

    public ApiRequest(@NotNull StripeRequest.Method method, @NotNull String url, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo, @NotNull SystemPropertySupplier systemPropertySupplier) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)systemPropertySupplier, (String)"systemPropertySupplier");
        super(method, url, params, MIME_TYPE);
        this.options = options;
        this.appInfo = appInfo;
        this.systemPropertySupplier = systemPropertySupplier;
        this.apiVersion = ApiVersion.Companion.get().getCode();
    }

    public /* synthetic */ ApiRequest(StripeRequest.Method method, String string2, Map map, Options options, AppInfo appInfo, SystemPropertySupplier systemPropertySupplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map = null;
        }
        if ((n & 0x10) != 0) {
            appInfo = null;
        }
        if ((n & 0x20) != 0) {
            systemPropertySupplier = new StripeSystemPropertySupplier();
        }
        this(method, string2, map, options, appInfo, systemPropertySupplier);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createGet(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createGet(url, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createGet(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createGet(url, params, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createPost(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createPost(url, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createPost(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createPost(url, params, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createDelete(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createDelete(url, options, appInfo);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0000H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/ApiRequest$Options;", "", "apiKey", "", "stripeAccount", "(Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getStripeAccount", "equals", "", "other", "hashCode", "", "typedEquals", "obj", "Companion", "stripe_release"})
    public static final class Options {
        @NotNull
        private final String apiKey;
        @Nullable
        private final String stripeAccount;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        public int hashCode() {
            return Objects.hash(this.apiKey, this.stripeAccount);
        }

        public boolean equals(@Nullable Object other) {
            return this == other ? true : (other instanceof Options ? this.typedEquals((Options)other) : false);
        }

        private final boolean typedEquals(Options obj) {
            return Intrinsics.areEqual((Object)this.apiKey, (Object)obj.apiKey) && Intrinsics.areEqual((Object)this.stripeAccount, (Object)obj.stripeAccount);
        }

        @Nullable
        public final String getStripeAccount() {
            return this.stripeAccount;
        }

        private Options(String apiKey, String stripeAccount) {
            this.stripeAccount = stripeAccount;
            this.apiKey = new ApiKeyValidator().requireValid(apiKey);
        }

        public /* synthetic */ Options(String apiKey, String stripeAccount, DefaultConstructorMarker $constructor_marker) {
            this(apiKey, stripeAccount);
        }

        @JvmStatic
        @NotNull
        public static final Options create(@NotNull String apiKey) {
            return Companion.create(apiKey);
        }

        @JvmStatic
        @NotNull
        public static final Options create(@NotNull String apiKey, @Nullable String stripeAccount) {
            return Companion.create(apiKey, stripeAccount);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/ApiRequest$Options$Companion;", "", "()V", "create", "Lcom/stripe/android/ApiRequest$Options;", "apiKey", "", "stripeAccount", "stripe_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Options create(@NotNull String apiKey) {
                Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
                return new Options(apiKey, null, null);
            }

            @JvmStatic
            @NotNull
            public final Options create(@NotNull String apiKey, @Nullable String stripeAccount) {
                Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
                return new Options(apiKey, stripeAccount, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J6\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00132\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J6\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0010\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00132\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/ApiRequest$Companion;", "", "()V", "API_HOST", "", "HEADER_STRIPE_CLIENT_USER_AGENT", "MIME_TYPE", "PROP_USER_AGENT", "SHOULD_INCLUDE_ACCEPT_LANGUAGE_HEADER", "", "createDelete", "Lcom/stripe/android/ApiRequest;", "url", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "createGet", "params", "", "createPost", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ApiRequest createGet(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, null, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createGet$default(Companion companion, String string2, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createGet(string2, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createGet(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, params, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createGet$default(Companion companion, String string2, Map map, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 8) != 0) {
                appInfo = null;
            }
            return companion.createGet(string2, map, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createPost(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, null, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createPost$default(Companion companion, String string2, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createPost(string2, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createPost(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, params, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createPost$default(Companion companion, String string2, Map map, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 8) != 0) {
                appInfo = null;
            }
            return companion.createPost(string2, map, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createDelete(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.DELETE, url, null, options, appInfo, null, 32, null);
        }

        public static /* synthetic */ ApiRequest createDelete$default(Companion companion, String string2, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createDelete(string2, options, appInfo);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

