/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.annotation.IntRange;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import java.util.Calendar;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u0004H\u0007J\u001a\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0007J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00142\b\b\u0001\u0010\u0015\u001a\u00020\nH\u0007\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/view/DateUtils;", "", "()V", "MAX_VALID_YEAR", "", "convertTwoDigitYearToFour", "inputYear", "calendar", "Ljava/util/Calendar;", "createDateStringFromIntegerInput", "", "month", "year", "isExpiryDataValid", "", "expiryMonth", "expiryYear", "isValidMonth", "monthString", "separateDateStringParts", "", "expiryInput", "(Ljava/lang/String;)[Ljava/lang/String;", "stripe_release"})
public final class DateUtils {
    private static final int MAX_VALID_YEAR = 9980;
    public static final DateUtils INSTANCE;

    @JvmStatic
    public static final boolean isValidMonth(@Nullable String monthString) {
        boolean bl;
        if (monthString == null) {
            return false;
        }
        try {
            int monthInt;
            int n = monthInt = Integer.parseInt(monthString);
            bl = 1 <= n && 12 >= n;
        }
        catch (NumberFormatException numEx) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @Size(value=2L)
    @NotNull
    public static final String[] separateDateStringParts(@Size(max=4L) @NotNull String expiryInput) {
        String[] stringArray;
        Intrinsics.checkParameterIsNotNull((Object)expiryInput, (String)"expiryInput");
        if (expiryInput.length() >= 2) {
            String string2;
            Object[] objectArray;
            String string3 = expiryInput;
            int n = 0;
            int n2 = 2;
            int n3 = 0;
            Object[] objectArray2 = objectArray = new String[2];
            boolean bl = false;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            objectArray[n3] = string2 = string4;
            string3 = expiryInput;
            n = 2;
            n3 = 1;
            objectArray = objectArray2;
            n2 = 0;
            String string5 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            objectArray[n3] = string2 = string5;
            Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object[])objectArray2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray2;
        } else {
            Collection $this$toTypedArray$iv = CollectionsKt.listOf((Object[])new String[]{expiryInput, ""});
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            if (stringArray3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            stringArray = stringArray3;
        }
        return stringArray;
    }

    @JvmStatic
    public static final boolean isExpiryDataValid(int expiryMonth, int expiryYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return DateUtils.isExpiryDataValid(expiryMonth, expiryYear, calendar);
    }

    @JvmStatic
    @VisibleForTesting
    public static final boolean isExpiryDataValid(int expiryMonth, int expiryYear, @NotNull Calendar calendar) {
        int readableMonth;
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        if (expiryMonth < 1 || expiryMonth > 12) {
            return false;
        }
        if (expiryYear < 0 || expiryYear > 9980) {
            return false;
        }
        int currentYear = calendar.get(1);
        return expiryYear < currentYear ? false : (expiryYear > currentYear ? true : expiryMonth >= (readableMonth = calendar.get(2) + 1));
    }

    @JvmStatic
    @NotNull
    public static final String createDateStringFromIntegerInput(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        String yearString;
        String monthString = String.valueOf(month);
        if (monthString.length() == 1) {
            monthString = '0' + monthString;
        }
        if ((yearString = String.valueOf(year)).length() == 3) {
            return "";
        }
        if (yearString.length() > 2) {
            String string2 = yearString;
            int n = yearString.length() - 2;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            yearString = string4;
        } else if (yearString.length() == 1) {
            yearString = '0' + yearString;
        }
        return monthString + yearString;
    }

    @JvmStatic
    @IntRange(from=1000L, to=9999L)
    public static final int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear) {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance()");
        return DateUtils.convertTwoDigitYearToFour(inputYear, calendar);
    }

    @JvmStatic
    @VisibleForTesting
    @IntRange(from=1000L, to=9999L)
    public static final int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear, @NotNull Calendar calendar) {
        Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
        int year = calendar.get(1);
        int centuryBase = year / 100;
        if (year % 100 > 80 && inputYear < 20) {
            ++centuryBase;
        } else if (year % 100 < 20 && inputYear > 80) {
            --centuryBase;
        }
        return centuryBase * 100 + inputYear;
    }

    private DateUtils() {
    }

    static {
        DateUtils dateUtils;
        INSTANCE = dateUtils = new DateUtils();
    }
}

