/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0012\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010'\u001a\u00020(H\u0016J\u0013\u0010)\u001a\u00020\u000e2\b\u0010*\u001a\u0004\u0018\u00010+H\u0096\u0002J\b\u0010,\u001a\u00020(H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0000H\u0002J\u000e\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u000201J\u0018\u00102\u001a\u0002032\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u00104\u001a\u00020(H\u0016R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0012@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R$\u0010$\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\n\"\u0004\b&\u0010\f\u00a8\u00066"}, d2={"Lcom/stripe/android/PaymentSessionData;", "Landroid/os/Parcelable;", "()V", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "<set-?>", "", "cartTotal", "getCartTotal", "()J", "setCartTotal$stripe_release", "(J)V", "isPaymentReadyToCharge", "", "()Z", "setPaymentReadyToCharge", "(Z)V", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethod", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "setPaymentMethod$stripe_release", "(Lcom/stripe/android/model/PaymentMethod;)V", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "getShippingInformation", "()Lcom/stripe/android/model/ShippingInformation;", "setShippingInformation", "(Lcom/stripe/android/model/ShippingInformation;)V", "shippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "getShippingMethod", "()Lcom/stripe/android/model/ShippingMethod;", "setShippingMethod", "(Lcom/stripe/android/model/ShippingMethod;)V", "shippingTotal", "getShippingTotal", "setShippingTotal$stripe_release", "describeContents", "", "equals", "other", "", "hashCode", "typedEquals", "data", "updateIsPaymentReadyToCharge", "config", "Lcom/stripe/android/PaymentSessionConfig;", "writeToParcel", "", "i", "Companion", "stripe_release"})
public final class PaymentSessionData
implements Parcelable {
    private long cartTotal;
    private boolean isPaymentReadyToCharge;
    private long shippingTotal;
    @Nullable
    private ShippingInformation shippingInformation;
    @Nullable
    private ShippingMethod shippingMethod;
    @Nullable
    private PaymentMethod paymentMethod;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<PaymentSessionData> CREATOR;
    public static final Companion Companion;

    public final long getCartTotal() {
        return this.cartTotal;
    }

    public final void setCartTotal$stripe_release(long l) {
        this.cartTotal = l;
    }

    public final boolean isPaymentReadyToCharge() {
        return this.isPaymentReadyToCharge;
    }

    public final void setPaymentReadyToCharge(boolean bl) {
        this.isPaymentReadyToCharge = bl;
    }

    public final long getShippingTotal() {
        return this.shippingTotal;
    }

    public final void setShippingTotal$stripe_release(long l) {
        this.shippingTotal = l;
    }

    @Nullable
    public final ShippingInformation getShippingInformation() {
        return this.shippingInformation;
    }

    public final void setShippingInformation(@Nullable ShippingInformation shippingInformation) {
        this.shippingInformation = shippingInformation;
    }

    @Nullable
    public final ShippingMethod getShippingMethod() {
        return this.shippingMethod;
    }

    public final void setShippingMethod(@Nullable ShippingMethod shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    @Nullable
    public final PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    public final void setPaymentMethod$stripe_release(@Nullable PaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public final boolean updateIsPaymentReadyToCharge(@NotNull PaymentSessionConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.isPaymentReadyToCharge = !(this.paymentMethod == null || config.isShippingInfoRequired() && this.shippingInformation == null || config.isShippingMethodRequired() && this.shippingMethod == null);
        return this.isPaymentReadyToCharge;
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (other instanceof PaymentSessionData ? this.typedEquals((PaymentSessionData)other) : false);
    }

    private final boolean typedEquals(PaymentSessionData data) {
        return this.cartTotal == data.cartTotal && this.isPaymentReadyToCharge == data.isPaymentReadyToCharge && this.shippingTotal == data.shippingTotal && Intrinsics.areEqual((Object)this.shippingInformation, (Object)data.shippingInformation) && Intrinsics.areEqual((Object)this.shippingMethod, (Object)data.shippingMethod) && Intrinsics.areEqual((Object)this.paymentMethod, (Object)data.paymentMethod);
    }

    public int hashCode() {
        return Objects.hash(this.cartTotal, this.isPaymentReadyToCharge, this.paymentMethod, this.shippingTotal, this.shippingInformation, this.shippingMethod);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel parcel, int i) {
        Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
        parcel.writeLong(this.cartTotal);
        parcel.writeInt(this.isPaymentReadyToCharge ? 1 : 0);
        parcel.writeParcelable((Parcelable)this.paymentMethod, i);
        parcel.writeParcelable((Parcelable)this.shippingInformation, i);
        parcel.writeParcelable((Parcelable)this.shippingMethod, i);
        parcel.writeLong(this.shippingTotal);
    }

    public PaymentSessionData() {
    }

    private PaymentSessionData(Parcel parcel) {
        this.cartTotal = parcel.readLong();
        this.isPaymentReadyToCharge = parcel.readInt() == 1;
        this.paymentMethod = (PaymentMethod)parcel.readParcelable(PaymentMethod.class.getClassLoader());
        this.shippingInformation = (ShippingInformation)parcel.readParcelable(ShippingInformation.class.getClassLoader());
        this.shippingMethod = (ShippingMethod)parcel.readParcelable(ShippingMethod.class.getClassLoader());
        this.shippingTotal = parcel.readLong();
    }

    static {
        Companion = new Companion(null);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<PaymentSessionData>(){

            @NotNull
            public PaymentSessionData createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                return new PaymentSessionData(parcel, null);
            }

            @NotNull
            public PaymentSessionData[] newArray(int size) {
                return new PaymentSessionData[size];
            }
        };
    }

    public /* synthetic */ PaymentSessionData(Parcel parcel, DefaultConstructorMarker $constructor_marker) {
        this(parcel);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/PaymentSessionData$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/stripe/android/PaymentSessionData;", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

