/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.StripeRequest;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Lcom/stripe/android/ConnectionFactory;", "", "()V", "create", "Ljava/net/HttpURLConnection;", "request", "Lcom/stripe/android/StripeRequest;", "getRequestOutputBytes", "", "Companion", "stripe_release"})
public final class ConnectionFactory {
    private static final StripeSSLSocketFactory SSL_SOCKET_FACTORY;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final HttpURLConnection create(@NotNull StripeRequest request) throws IOException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        URL stripeURL = new URL(request.getUrl());
        URLConnection uRLConnection = stripeURL.openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection conn = (HttpURLConnection)uRLConnection;
        conn.setConnectTimeout(30000);
        conn.setReadTimeout(80000);
        conn.setUseCaches(false);
        Object object = request.getHeaders();
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> object2;
            Map.Entry<String, String> entry = object2 = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            entry = object2;
            bl2 = false;
            String value = entry.getValue();
            conn.setRequestProperty(key, value);
        }
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
        }
        conn.setRequestMethod(request.getMethod().getCode());
        if (StripeRequest.Method.POST == request.getMethod()) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", request.getContentType());
            Closeable closeable = conn.getOutputStream();
            boolean bl3 = false;
            object = null;
            try {
                OutputStream output = (OutputStream)closeable;
                boolean bl4 = false;
                output.write(this.getRequestOutputBytes(request));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        return conn;
    }

    @NotNull
    public final byte[] getRequestOutputBytes(@NotNull StripeRequest request) throws InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            return request.getOutputBytes$stripe_release();
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new InvalidRequestException("Unable to encode parameters to " + StandardCharsets.UTF_8.name() + ". " + "Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, e);
        }
    }

    static {
        Companion = new Companion(null);
        SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/ConnectionFactory$Companion;", "", "()V", "SSL_SOCKET_FACTORY", "Lcom/stripe/android/StripeSSLSocketFactory;", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

