/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B=\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0010\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0002J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\r\u0010\u001c\u001a\u00020\u001dH\u0010\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u0005H\u0010\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0000H\u0002R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00058@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/stripe/android/ApiRequest;", "Lcom/stripe/android/StripeRequest;", "method", "Lcom/stripe/android/StripeRequest$Method;", "url", "", "params", "", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "(Lcom/stripe/android/StripeRequest$Method;Ljava/lang/String;Ljava/util/Map;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/AppInfo;)V", "apiVersion", "languageTag", "languageTag$annotations", "()V", "getLanguageTag$stripe_release", "()Ljava/lang/String;", "getOptions$stripe_release", "()Lcom/stripe/android/ApiRequest$Options;", "createHeaders", "createHeaders$stripe_release", "createStripeClientUserAgent", "equals", "", "other", "", "getOutputBytes", "", "getOutputBytes$stripe_release", "getUserAgent", "getUserAgent$stripe_release", "hashCode", "", "toString", "typedEquals", "obj", "Companion", "Options", "stripe_release"})
public final class ApiRequest
extends StripeRequest {
    private final String apiVersion;
    @NotNull
    private final Options options;
    private final AppInfo appInfo;
    @NotNull
    public static final String MIME_TYPE = "application/x-www-form-urlencoded";
    @NotNull
    public static final String API_HOST = "https://api.stripe.com";
    private static final boolean SHOULD_INCLUDE_ACCEPT_LANGUAGE_HEADER = false;
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void languageTag$annotations() {
    }

    @Nullable
    public final String getLanguageTag$stripe_release() {
        String string2 = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().toString()");
        String string3 = StringsKt.replace$default((String)string2, (String)"_", (String)"-", (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        CharSequence charSequence = it;
        boolean bl4 = false;
        return !StringsKt.isBlank((CharSequence)charSequence) ? string3 : null;
    }

    @Override
    @NotNull
    public Map<String, String> createHeaders$stripe_release() {
        Object object;
        Object object2;
        block7: {
            block6: {
                Object it;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                block5: {
                    block4: {
                        Pair[] pairArray = new Pair[5];
                        pairArray[0] = TuplesKt.to((Object)"Accept-Charset", (Object)"UTF-8");
                        pairArray[1] = TuplesKt.to((Object)"Accept", (Object)"application/json");
                        pairArray[2] = TuplesKt.to((Object)"X-Stripe-Client-User-Agent", (Object)this.createStripeClientUserAgent());
                        pairArray[3] = TuplesKt.to((Object)"Stripe-Version", (Object)this.apiVersion);
                        object7 = StringCompanionObject.INSTANCE;
                        Locale locale = Locale.ENGLISH;
                        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
                        Locale locale2 = locale;
                        String string2 = "Bearer %s";
                        Object[] objectArray = new Object[]{this.options.getApiKey()};
                        String string3 = "Authorization";
                        int n = 4;
                        object6 = pairArray;
                        object5 = pairArray;
                        boolean bl = false;
                        String string4 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
                        String string5 = string4;
                        object6[n] = TuplesKt.to((Object)string3, (Object)string5);
                        object4 = MapsKt.mapOf((Pair[])object5);
                        object3 = this.options.getStripeAccount();
                        if (object3 == null) break block4;
                        object7 = object3;
                        object5 = object4;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        it = object7;
                        boolean bl4 = false;
                        object6 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Stripe-Account", (Object)it));
                        object4 = object5;
                        object3 = object6;
                        if (object6 != null) break block5;
                    }
                    object3 = MapsKt.emptyMap();
                }
                object7 = this.getLanguageTag$stripe_release();
                object5 = MapsKt.plus((Map)object4, (Map)object3);
                boolean bl = false;
                boolean bl5 = false;
                it = object7;
                boolean bl6 = false;
                object6 = false ? object7 : null;
                object2 = object5;
                object = object6;
                if (object == null) break block6;
                object7 = object;
                object5 = object2;
                bl = false;
                bl5 = false;
                it = object7;
                boolean bl7 = false;
                object6 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Accept-Language", (Object)it));
                object2 = object5;
                object = object6;
                if (object != null) break block7;
            }
            object = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)object2, (Map)object);
    }

    private final String createStripeClientUserAgent() {
        String javaVersion = System.getProperty("java.version");
        Map map = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"os.name", (Object)"android"), TuplesKt.to((Object)"os.version", (Object)String.valueOf(Build.VERSION.SDK_INT)), TuplesKt.to((Object)"bindings.version", (Object)"11.2.1"), TuplesKt.to((Object)"lang", (Object)"Java"), TuplesKt.to((Object)"publisher", (Object)"Stripe")});
        Object object = this.appInfo;
        if (object == null || (object = ((AppInfo)object).createClientHeaders$stripe_release()) == null) {
            object = MapsKt.emptyMap();
        }
        Map propertyMap = MapsKt.plus((Map)MapsKt.plus((Map)map, (Map)object), (Map)(javaVersion != null ? MapsKt.mapOf((Pair)TuplesKt.to((Object)"java.version", (Object)javaVersion)) : MapsKt.emptyMap()));
        String string2 = new JSONObject(propertyMap).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JSONObject(propertyMap).toString()");
        return string2;
    }

    @Override
    @NotNull
    public String getUserAgent$stripe_release() {
        Object[] objectArray = new String[2];
        objectArray[0] = StripeRequest.DEFAULT_USER_AGENT;
        AppInfo appInfo = this.appInfo;
        objectArray[1] = appInfo != null ? appInfo.toUserAgent$stripe_release() : null;
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public byte[] getOutputBytes$stripe_release() throws UnsupportedEncodingException, InvalidRequestException {
        String string2 = this.createQuery();
        Object object = "UTF-8";
        boolean bl = false;
        Charset charset = Charset.forName((String)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
        object = charset;
        bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes((Charset)object);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @NotNull
    public String toString() {
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        Locale locale = Locale.ROOT;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
        Locale locale2 = locale;
        String string2 = "%s %s";
        Object[] objectArray = new Object[]{this.getMethod().getCode(), this.getBaseUrl()};
        boolean bl = false;
        String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        return string3;
    }

    public int hashCode() {
        return Objects.hash(this.getBaseHashCode(), this.options, this.appInfo);
    }

    public boolean equals(@Nullable Object other) {
        return super.equals(other) || other instanceof ApiRequest && this.typedEquals((ApiRequest)other);
    }

    private final boolean typedEquals(ApiRequest obj) {
        return super.typedEquals(obj) && Intrinsics.areEqual((Object)this.options, (Object)obj.options) && Intrinsics.areEqual((Object)this.appInfo, (Object)obj.appInfo);
    }

    @NotNull
    public final Options getOptions$stripe_release() {
        return this.options;
    }

    public ApiRequest(@NotNull StripeRequest.Method method, @NotNull String url, @Nullable Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        super(method, url, params, MIME_TYPE);
        this.options = options;
        this.appInfo = appInfo;
        this.apiVersion = ApiVersion.Companion.get().getCode();
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createGet(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createGet(url, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createGet(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createGet(url, params, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createPost(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createPost(url, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createPost(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createPost(url, params, options, appInfo);
    }

    @JvmStatic
    @NotNull
    public static final ApiRequest createDelete(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
        return Companion.createDelete(url, options, appInfo);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0000H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/ApiRequest$Options;", "", "apiKey", "", "stripeAccount", "(Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "getStripeAccount", "equals", "", "other", "hashCode", "", "typedEquals", "obj", "Companion", "stripe_release"})
    public static final class Options {
        @NotNull
        private final String apiKey;
        @Nullable
        private final String stripeAccount;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        public int hashCode() {
            return Objects.hash(this.apiKey, this.stripeAccount);
        }

        public boolean equals(@Nullable Object other) {
            return this == other ? true : (other instanceof Options ? this.typedEquals((Options)other) : false);
        }

        private final boolean typedEquals(Options obj) {
            return Intrinsics.areEqual((Object)this.apiKey, (Object)obj.apiKey) && Intrinsics.areEqual((Object)this.stripeAccount, (Object)obj.stripeAccount);
        }

        @Nullable
        public final String getStripeAccount() {
            return this.stripeAccount;
        }

        private Options(String apiKey, String stripeAccount) {
            this.stripeAccount = stripeAccount;
            this.apiKey = new ApiKeyValidator().requireValid(apiKey);
        }

        public /* synthetic */ Options(String apiKey, String stripeAccount, DefaultConstructorMarker $constructor_marker) {
            this(apiKey, stripeAccount);
        }

        @JvmStatic
        @NotNull
        public static final Options create(@NotNull String apiKey) {
            return Companion.create(apiKey);
        }

        @JvmStatic
        @NotNull
        public static final Options create(@NotNull String apiKey, @Nullable String stripeAccount) {
            return Companion.create(apiKey, stripeAccount);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/ApiRequest$Options$Companion;", "", "()V", "create", "Lcom/stripe/android/ApiRequest$Options;", "apiKey", "", "stripeAccount", "stripe_release"})
        public static final class Companion {
            @JvmStatic
            @NotNull
            public final Options create(@NotNull String apiKey) {
                Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
                return new Options(apiKey, null, null);
            }

            @JvmStatic
            @NotNull
            public final Options create(@NotNull String apiKey, @Nullable String stripeAccount) {
                Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
                return new Options(apiKey, stripeAccount, null);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J$\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J6\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00112\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J$\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J6\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00112\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/ApiRequest$Companion;", "", "()V", "API_HOST", "", "MIME_TYPE", "SHOULD_INCLUDE_ACCEPT_LANGUAGE_HEADER", "", "createDelete", "Lcom/stripe/android/ApiRequest;", "url", "options", "Lcom/stripe/android/ApiRequest$Options;", "appInfo", "Lcom/stripe/android/AppInfo;", "createGet", "params", "", "createPost", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ApiRequest createGet(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, null, options, appInfo);
        }

        public static /* synthetic */ ApiRequest createGet$default(Companion companion, String string2, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createGet(string2, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createGet(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.GET, url, params, options, appInfo);
        }

        public static /* synthetic */ ApiRequest createGet$default(Companion companion, String string2, Map map, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 8) != 0) {
                appInfo = null;
            }
            return companion.createGet(string2, map, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createPost(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, null, options, appInfo);
        }

        public static /* synthetic */ ApiRequest createPost$default(Companion companion, String string2, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createPost(string2, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createPost(@NotNull String url, @NotNull Map<String, ?> params, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.POST, url, params, options, appInfo);
        }

        public static /* synthetic */ ApiRequest createPost$default(Companion companion, String string2, Map map, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 8) != 0) {
                appInfo = null;
            }
            return companion.createPost(string2, map, options, appInfo);
        }

        @JvmStatic
        @NotNull
        public final ApiRequest createDelete(@NotNull String url, @NotNull Options options, @Nullable AppInfo appInfo) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            return new ApiRequest(StripeRequest.Method.DELETE, url, null, options, appInfo);
        }

        public static /* synthetic */ ApiRequest createDelete$default(Companion companion, String string2, Options options, AppInfo appInfo, int n, Object object) {
            if ((n & 4) != 0) {
                appInfo = null;
            }
            return companion.createDelete(string2, options, appInfo);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

