/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.AsyncTask;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ResultWrapper;
import com.stripe.android.exception.StripeException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0002B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J'\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\n\"\u00020\u0003H\u0014\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\f\u001a\u0004\u0018\u00018\u0000H \u00a2\u0006\u0004\b\r\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/ApiOperation;", "ResultType", "Landroid/os/AsyncTask;", "Ljava/lang/Void;", "Lcom/stripe/android/ResultWrapper;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/ApiResultCallback;)V", "doInBackground", "voids", "", "([Ljava/lang/Void;)Lcom/stripe/android/ResultWrapper;", "getResult", "getResult$stripe_release", "()Ljava/lang/Object;", "onPostExecute", "", "resultWrapper", "stripe_release"})
public abstract class ApiOperation<ResultType>
extends AsyncTask<Void, Void, ResultWrapper<ResultType>> {
    private final ApiResultCallback<ResultType> callback;

    @Nullable
    public abstract ResultType getResult$stripe_release();

    @NotNull
    protected ResultWrapper<ResultType> doInBackground(Void ... voids) {
        ResultWrapper<ResultType> resultWrapper;
        Intrinsics.checkParameterIsNotNull((Object)voids, (String)"voids");
        try {
            resultWrapper = ResultWrapper.Companion.create(this.getResult$stripe_release());
        }
        catch (StripeException e) {
            resultWrapper = ResultWrapper.Companion.create(e);
        }
        catch (JSONException e) {
            resultWrapper = ResultWrapper.Companion.create((Exception)((Object)e));
        }
        return resultWrapper;
    }

    protected void onPostExecute(@NotNull ResultWrapper<ResultType> resultWrapper) {
        Intrinsics.checkParameterIsNotNull(resultWrapper, (String)"resultWrapper");
        super.onPostExecute(resultWrapper);
        if (resultWrapper.getResult() != null) {
            this.callback.onSuccess(resultWrapper.getResult());
        } else if (resultWrapper.getError() != null) {
            this.callback.onError(resultWrapper.getError());
        } else {
            this.callback.onError(new RuntimeException("The API operation returned neither a result or exception"));
        }
    }

    public ApiOperation(@NotNull ApiResultCallback<ResultType> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.callback = callback;
    }
}

