/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import androidx.annotation.VisibleForTesting;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/StripeFireAndForgetRequestExecutor;", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "()V", "connectionFactory", "Lcom/stripe/android/ConnectionFactory;", "closeConnection", "", "conn", "Ljava/net/HttpURLConnection;", "responseCode", "", "closeStream", "stream", "Ljava/io/Closeable;", "execute", "request", "Lcom/stripe/android/StripeRequest;", "executeAsync", "stripe_release"})
public final class StripeFireAndForgetRequestExecutor
implements FireAndForgetRequestExecutor {
    private final ConnectionFactory connectionFactory = new ConnectionFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int execute(@NotNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        HttpURLConnection conn = null;
        try {
            conn = this.connectionFactory.create(request);
            int responseCode = conn.getResponseCode();
            this.closeConnection(conn, responseCode);
            int n = responseCode;
            return n;
        }
        catch (IOException e) {
            throw (Throwable)APIConnectionException.Companion.create(request.getBaseUrl(), e);
        }
        finally {
            block5: {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) break block5;
                httpURLConnection.disconnect();
            }
        }
    }

    private final void closeConnection(HttpURLConnection conn, int responseCode) throws IOException {
        int n = responseCode;
        if (200 <= n && 299 >= n) {
            this.closeStream(conn.getInputStream());
        } else {
            this.closeStream(conn.getErrorStream());
        }
    }

    private final void closeStream(Closeable stream) throws IOException {
        block0: {
            Closeable closeable = stream;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    @Override
    public void executeAsync(@NotNull StripeRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ StripeFireAndForgetRequestExecutor this$0;
            final /* synthetic */ StripeRequest $request;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        this.this$0.execute(this.$request);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = stripeFireAndForgetRequestExecutor;
                this.$request = stripeRequest;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

