/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import androidx.annotation.ColorInt;
import androidx.annotation.StringRes;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import com.stripe.android.R;
import com.stripe.android.view.StripeColorUtils;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001:\u0004<=>?B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020%H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020%H\u0014J\u0010\u00102\u001a\u00020%2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u00103\u001a\u00020%2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u00104\u001a\u00020%2\b\b\u0001\u0010\u0016\u001a\u00020\u0007J\u0010\u00105\u001a\u00020%2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u00106\u001a\u00020%2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u00107\u001a\u00020%2\b\b\u0001\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:J\u0016\u00107\u001a\u00020%2\u0006\u0010;\u001a\u00020\u00192\u0006\u00109\u001a\u00020:R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006@"}, d2={"Lcom/stripe/android/view/StripeEditText;", "Landroidx/appcompat/widget/AppCompatEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "afterTextChangedListener", "Lcom/stripe/android/view/StripeEditText$AfterTextChangedListener;", "<set-?>", "Landroid/content/res/ColorStateList;", "cachedColorStateList", "getCachedColorStateList", "()Landroid/content/res/ColorStateList;", "defaultErrorColor", "defaultErrorColorInt", "getDefaultErrorColorInt", "()I", "deleteEmptyListener", "Lcom/stripe/android/view/StripeEditText$DeleteEmptyListener;", "errorColor", "Ljava/lang/Integer;", "errorMessage", "", "errorMessageListener", "Lcom/stripe/android/view/StripeEditText$ErrorMessageListener;", "hintHandler", "Landroid/os/Handler;", "shouldShowError", "", "getShouldShowError", "()Z", "setShouldShowError", "(Z)V", "determineDefaultErrorColor", "", "initView", "isEmptyDelete", "keyCode", "event", "Landroid/view/KeyEvent;", "listenForDeleteEmpty", "listenForTextChanges", "onCreateInputConnection", "Landroid/view/inputmethod/InputConnection;", "outAttrs", "Landroid/view/inputmethod/EditorInfo;", "onDetachedFromWindow", "setAfterTextChangedListener", "setDeleteEmptyListener", "setErrorColor", "setErrorMessage", "setErrorMessageListener", "setHintDelayed", "hintResource", "delayMilliseconds", "", "hint", "AfterTextChangedListener", "DeleteEmptyListener", "ErrorMessageListener", "SoftDeleteInputConnection", "stripe_release"})
public class StripeEditText
extends AppCompatEditText {
    private AfterTextChangedListener afterTextChangedListener;
    private DeleteEmptyListener deleteEmptyListener;
    @Nullable
    private ColorStateList cachedColorStateList;
    private boolean shouldShowError;
    @ColorInt
    private int defaultErrorColor;
    @ColorInt
    private Integer errorColor;
    private final Handler hintHandler;
    private String errorMessage;
    private ErrorMessageListener errorMessageListener;
    private HashMap _$_findViewCache;

    @Nullable
    public final ColorStateList getCachedColorStateList() {
        return this.cachedColorStateList;
    }

    public final boolean getShouldShowError() {
        return this.shouldShowError;
    }

    public final void setShouldShowError(boolean shouldShowError) {
        if (this.errorMessage != null) {
            String string2 = this.errorMessage;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String errorMessage = shouldShowError ? string2 : null;
            ErrorMessageListener errorMessageListener = this.errorMessageListener;
            if (errorMessageListener != null) {
                errorMessageListener.displayErrorMessage(errorMessage);
            }
            this.shouldShowError = shouldShowError;
        } else {
            this.shouldShowError = shouldShowError;
            if (this.shouldShowError) {
                Integer n = this.errorColor;
                this.setTextColor(n != null ? n : this.defaultErrorColor);
            } else {
                this.setTextColor(this.cachedColorStateList);
            }
            this.refreshDrawableState();
        }
    }

    @ColorInt
    public final int getDefaultErrorColorInt() {
        this.determineDefaultErrorColor();
        return this.defaultErrorColor;
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NotNull EditorInfo outAttrs) {
        Intrinsics.checkParameterIsNotNull((Object)outAttrs, (String)"outAttrs");
        InputConnection inputConnection = super.onCreateInputConnection(outAttrs);
        return inputConnection != null ? (InputConnection)new SoftDeleteInputConnection(inputConnection, true, this.deleteEmptyListener) : null;
    }

    public final void setAfterTextChangedListener(@Nullable AfterTextChangedListener afterTextChangedListener) {
        this.afterTextChangedListener = afterTextChangedListener;
    }

    public final void setDeleteEmptyListener(@Nullable DeleteEmptyListener deleteEmptyListener) {
        this.deleteEmptyListener = deleteEmptyListener;
    }

    public final void setErrorMessageListener(@Nullable ErrorMessageListener errorMessageListener) {
        this.errorMessageListener = errorMessageListener;
    }

    public final void setErrorMessage(@Nullable String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public final void setErrorColor(@ColorInt int errorColor) {
        this.errorColor = errorColor;
    }

    public final void setHintDelayed(@StringRes int hintResource, long delayMilliseconds) {
        this.hintHandler.postDelayed(new Runnable(this, hintResource){
            final /* synthetic */ StripeEditText this$0;
            final /* synthetic */ int $hintResource;

            public final void run() {
                this.this$0.setHint(this.$hintResource);
            }
            {
                this.this$0 = stripeEditText;
                this.$hintResource = n;
            }
        }, delayMilliseconds);
    }

    public final void setHintDelayed(@NotNull String hint, long delayMilliseconds) {
        Intrinsics.checkParameterIsNotNull((Object)hint, (String)"hint");
        this.hintHandler.postDelayed(new Runnable(this, hint){
            final /* synthetic */ StripeEditText this$0;
            final /* synthetic */ String $hint;

            public final void run() {
                this.this$0.setHint(this.$hint);
            }
            {
                this.this$0 = stripeEditText;
                this.$hint = string2;
            }
        }, delayMilliseconds);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.hintHandler.removeCallbacksAndMessages(null);
    }

    private final void initView() {
        this.listenForTextChanges();
        this.listenForDeleteEmpty();
        this.determineDefaultErrorColor();
        this.cachedColorStateList = this.getTextColors();
    }

    private final void determineDefaultErrorColor() {
        this.cachedColorStateList = this.getTextColors();
        Context context = this.getContext();
        ColorStateList colorStateList = this.getTextColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"textColors");
        this.defaultErrorColor = ContextCompat.getColor((Context)context, (int)(StripeColorUtils.Companion.isColorDark(colorStateList.getDefaultColor()) ? R.color.error_text_light_theme : R.color.error_text_dark_theme));
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ StripeEditText this$0;

            public void beforeTextChanged(@NotNull CharSequence s, int start2, int count, int after) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void onTextChanged(@NotNull CharSequence s, int start2, int before, int count) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void afterTextChanged(@NotNull Editable s) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                    AfterTextChangedListener afterTextChangedListener = StripeEditText.access$getAfterTextChangedListener$p(this.this$0);
                    if (afterTextChangedListener == null) break block0;
                    afterTextChangedListener.onTextChanged(s.toString());
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void listenForDeleteEmpty() {
        this.setOnKeyListener(new View.OnKeyListener(this){
            final /* synthetic */ StripeEditText this$0;

            public final boolean onKey(View $noName_0, int keyCode, KeyEvent event) {
                block1: {
                    KeyEvent keyEvent = event;
                    Intrinsics.checkExpressionValueIsNotNull((Object)keyEvent, (String)"event");
                    if (!StripeEditText.access$isEmptyDelete(this.this$0, keyCode, keyEvent)) break block1;
                    DeleteEmptyListener deleteEmptyListener = StripeEditText.access$getDeleteEmptyListener$p(this.this$0);
                    if (deleteEmptyListener != null) {
                        deleteEmptyListener.onDeleteEmpty();
                    }
                }
                return false;
            }
            {
                this.this$0 = stripeEditText;
            }
        });
    }

    private final boolean isEmptyDelete(int keyCode, KeyEvent event) {
        return keyCode == 67 && event.getAction() == 0 && this.length() == 0;
    }

    @JvmOverloads
    public StripeEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.hintHandler = new Handler();
        this.initView();
    }

    public /* synthetic */ StripeEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public StripeEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public StripeEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ AfterTextChangedListener access$getAfterTextChangedListener$p(StripeEditText $this) {
        return $this.afterTextChangedListener;
    }

    public static final /* synthetic */ void access$setAfterTextChangedListener$p(StripeEditText $this, AfterTextChangedListener afterTextChangedListener) {
        $this.afterTextChangedListener = afterTextChangedListener;
    }

    public static final /* synthetic */ boolean access$isEmptyDelete(StripeEditText $this, int keyCode, KeyEvent event) {
        return $this.isEmptyDelete(keyCode, event);
    }

    public static final /* synthetic */ DeleteEmptyListener access$getDeleteEmptyListener$p(StripeEditText $this) {
        return $this.deleteEmptyListener;
    }

    public static final /* synthetic */ void access$setDeleteEmptyListener$p(StripeEditText $this, DeleteEmptyListener deleteEmptyListener) {
        $this.deleteEmptyListener = deleteEmptyListener;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/view/StripeEditText$DeleteEmptyListener;", "", "onDeleteEmpty", "", "stripe_release"})
    public static interface DeleteEmptyListener {
        public void onDeleteEmpty();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/StripeEditText$AfterTextChangedListener;", "", "onTextChanged", "", "text", "", "stripe_release"})
    public static interface AfterTextChangedListener {
        public void onTextChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/StripeEditText$ErrorMessageListener;", "", "displayErrorMessage", "", "message", "", "stripe_release"})
    public static interface ErrorMessageListener {
        public void displayErrorMessage(@Nullable String var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/android/view/StripeEditText$SoftDeleteInputConnection;", "Landroid/view/inputmethod/InputConnectionWrapper;", "target", "Landroid/view/inputmethod/InputConnection;", "mutable", "", "deleteEmptyListener", "Lcom/stripe/android/view/StripeEditText$DeleteEmptyListener;", "(Landroid/view/inputmethod/InputConnection;ZLcom/stripe/android/view/StripeEditText$DeleteEmptyListener;)V", "deleteSurroundingText", "beforeLength", "", "afterLength", "stripe_release"})
    private static final class SoftDeleteInputConnection
    extends InputConnectionWrapper {
        private final DeleteEmptyListener deleteEmptyListener;

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            block1: {
                CharSequence charSequence = this.getTextBeforeCursor(1, 0);
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"getTextBeforeCursor(1, 0)");
                CharSequence charSequence2 = charSequence;
                boolean bl = false;
                if (!(charSequence2.length() == 0)) break block1;
                DeleteEmptyListener deleteEmptyListener = this.deleteEmptyListener;
                if (deleteEmptyListener != null) {
                    deleteEmptyListener.onDeleteEmpty();
                }
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }

        public SoftDeleteInputConnection(@NotNull InputConnection target, boolean mutable, @Nullable DeleteEmptyListener deleteEmptyListener) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            super(target, mutable);
            this.deleteEmptyListener = deleteEmptyListener;
        }
    }
}

