/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import java.util.Objects;

public final class PaymentConfiguration
implements Parcelable {
    @Nullable
    private static PaymentConfiguration mInstance;
    @NonNull
    private final String mPublishableKey;
    public static final Parcelable.Creator<PaymentConfiguration> CREATOR;

    private PaymentConfiguration(@NonNull String publishableKey) {
        this.mPublishableKey = ApiKeyValidator.get().requireValid(publishableKey);
    }

    private PaymentConfiguration(@NonNull Parcel in) {
        this.mPublishableKey = Objects.requireNonNull(in.readString());
    }

    @NonNull
    public static PaymentConfiguration getInstance(@NonNull Context context) {
        if (mInstance == null) {
            PaymentConfiguration loadedInstance = new Store(context).load();
            if (loadedInstance != null) {
                mInstance = loadedInstance;
            } else {
                throw new IllegalStateException("PaymentConfiguration was not initialized");
            }
        }
        return mInstance;
    }

    public static void init(@NonNull Context context, @NonNull String publishableKey) {
        mInstance = new PaymentConfiguration(publishableKey);
        new Store(context).save(publishableKey);
    }

    @NonNull
    public String getPublishableKey() {
        return this.mPublishableKey;
    }

    @VisibleForTesting
    static void clearInstance() {
        mInstance = null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPublishableKey);
    }

    public int hashCode() {
        return Objects.hash(this.mPublishableKey);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof PaymentConfiguration && this.typedEquals((PaymentConfiguration)obj);
    }

    private boolean typedEquals(@NonNull PaymentConfiguration obj) {
        return Objects.equals(this.mPublishableKey, obj.mPublishableKey);
    }

    static {
        CREATOR = new Parcelable.Creator<PaymentConfiguration>(){

            public PaymentConfiguration createFromParcel(@NonNull Parcel in) {
                return new PaymentConfiguration(in);
            }

            public PaymentConfiguration[] newArray(int size) {
                return new PaymentConfiguration[size];
            }
        };
    }

    private static final class Store {
        @NonNull
        private final SharedPreferences mPrefs;
        private static final String NAME = PaymentConfiguration.class.getCanonicalName();
        private static final String KEY_PUBLISHABLE_KEY = "key_publishable_key";

        private Store(@NonNull Context context) {
            this.mPrefs = context.getApplicationContext().getSharedPreferences(NAME, 0);
        }

        private void save(@NonNull String publishableKey) {
            this.mPrefs.edit().putString(KEY_PUBLISHABLE_KEY, publishableKey).apply();
        }

        @Nullable
        private PaymentConfiguration load() {
            String publishableKey = this.mPrefs.getString(KEY_PUBLISHABLE_KEY, null);
            if (publishableKey == null) {
                return null;
            }
            return new PaymentConfiguration(publishableKey);
        }
    }
}

