/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.StripeUid;
import com.stripe.android.Supplier;
import com.stripe.android.UidSupplier;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB5\b\u0007\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001dH\u0002J\u0014\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001dH\u0002J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001dJ\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010!\u001a\u00020\fH\u0002R\u0014\u0010\u0011\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0013R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/stripe/android/TelemetryClientUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "uidSupplier", "Lcom/stripe/android/Supplier;", "Lcom/stripe/android/StripeUid;", "(Landroid/content/Context;Lcom/stripe/android/Supplier;)V", "displayMetrics", "Landroid/util/DisplayMetrics;", "packageName", "", "packageManager", "Landroid/content/pm/PackageManager;", "timeZone", "(Lcom/stripe/android/Supplier;Landroid/util/DisplayMetrics;Ljava/lang/String;Landroid/content/pm/PackageManager;Ljava/lang/String;)V", "androidVersionString", "getAndroidVersionString", "()Ljava/lang/String;", "hashedMuid", "getHashedMuid", "hashedUid", "getHashedUid", "screen", "getScreen", "versionName", "getVersionName", "createFirstMap", "", "createSecondMap", "createTelemetryMap", "createValueMap", "value", "Companion", "stripe_release"})
public final class TelemetryClientUtil {
    private final Supplier<StripeUid> uidSupplier;
    private final DisplayMetrics displayMetrics;
    private final String packageName;
    private final PackageManager packageManager;
    private final String timeZone;
    public static final Companion Companion = new Companion(null);

    private final String getVersionName() {
        CharSequence charSequence = this.packageName;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            try {
                PackageInfo packageInfo;
                PackageInfo packageInfo2 = packageInfo = this.packageManager.getPackageInfo(this.packageName, 0);
                if ((packageInfo2 != null ? packageInfo2.versionName : null) != null) {
                    return packageInfo.versionName;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private final String getScreen() {
        return this.displayMetrics.widthPixels + "w_" + this.displayMetrics.heightPixels + "h_" + this.displayMetrics.densityDpi + "dpi";
    }

    private final String getAndroidVersionString() {
        return "Android " + Build.VERSION.RELEASE + ' ' + Build.VERSION.CODENAME + ' ' + Build.VERSION.SDK_INT;
    }

    @NotNull
    public final String getHashedUid() {
        String string2;
        String uid = this.uidSupplier.get().getValue();
        if (StringsKt.isBlank((CharSequence)uid)) {
            string2 = "";
        } else {
            string2 = StripeTextUtils.shaHashInput(uid);
            if (string2 == null) {
                string2 = "";
            }
        }
        return string2;
    }

    private final String getHashedMuid() {
        String string2 = StripeTextUtils.shaHashInput(this.packageName + this.getHashedUid());
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final Map<String, Object> createTelemetryMap() {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"v2", (Object)1), TuplesKt.to((Object)"tag", (Object)"11.1.4"), TuplesKt.to((Object)"src", (Object)"android-sdk"), TuplesKt.to((Object)"a", this.createFirstMap()), TuplesKt.to((Object)"b", this.createSecondMap())});
    }

    private final Map<String, Object> createFirstMap() {
        Pair[] pairArray = new Pair[4];
        String string2 = Locale.getDefault().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Locale.getDefault().toString()");
        pairArray[0] = TuplesKt.to((Object)"c", this.createValueMap(string2));
        pairArray[1] = TuplesKt.to((Object)"d", this.createValueMap(this.getAndroidVersionString()));
        pairArray[2] = TuplesKt.to((Object)"f", this.createValueMap(this.getScreen()));
        pairArray[3] = TuplesKt.to((Object)"g", this.createValueMap(this.timeZone));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> createSecondMap() {
        Object object;
        block3: {
            Map params;
            block2: {
                params = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"d", (Object)this.getHashedMuid()), TuplesKt.to((Object)"k", (Object)this.packageName), TuplesKt.to((Object)"o", (Object)Build.VERSION.RELEASE), TuplesKt.to((Object)"p", (Object)Build.VERSION.SDK_INT), TuplesKt.to((Object)"q", (Object)Build.MANUFACTURER), TuplesKt.to((Object)"r", (Object)Build.BRAND), TuplesKt.to((Object)"s", (Object)Build.MODEL), TuplesKt.to((Object)"t", (Object)Build.TAGS)});
                object = this.getVersionName();
                if (object == null) break block2;
                String string2 = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                object = MapsKt.plus((Map)params, (Pair)TuplesKt.to((Object)"l", (Object)it));
                if (object != null) break block3;
            }
            object = params;
        }
        return object;
    }

    private final Map<String, Object> createValueMap(String value) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"v", (Object)value));
    }

    @VisibleForTesting
    public TelemetryClientUtil(@NotNull Supplier<StripeUid> uidSupplier, @NotNull DisplayMetrics displayMetrics, @NotNull String packageName, @NotNull PackageManager packageManager, @NotNull String timeZone) {
        Intrinsics.checkParameterIsNotNull(uidSupplier, (String)"uidSupplier");
        Intrinsics.checkParameterIsNotNull((Object)displayMetrics, (String)"displayMetrics");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)packageManager, (String)"packageManager");
        Intrinsics.checkParameterIsNotNull((Object)timeZone, (String)"timeZone");
        this.uidSupplier = uidSupplier;
        this.displayMetrics = displayMetrics;
        this.packageName = packageName;
        this.packageManager = packageManager;
        this.timeZone = timeZone;
    }

    public TelemetryClientUtil(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this(context2, new UidSupplier(context));
    }

    public TelemetryClientUtil(@NotNull Context context, @NotNull Supplier<StripeUid> uidSupplier) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(uidSupplier, (String)"uidSupplier");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Intrinsics.checkExpressionValueIsNotNull((Object)displayMetrics, (String)"context.resources.displayMetrics");
        String string2 = context.getPackageName();
        if (string2 == null) {
            string2 = "";
        }
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)packageManager, (String)"context.packageManager");
        this(uidSupplier, displayMetrics, string2, packageManager, TelemetryClientUtil.Companion.createTimezone());
    }

    public /* synthetic */ TelemetryClientUtil(Context context, Supplier supplier, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            supplier = new UidSupplier(context);
        }
        this(context, supplier);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/TelemetryClientUtil$Companion;", "", "()V", "createTimezone", "", "stripe_release"})
    public static final class Companion {
        private final String createTimezone() {
            TimeZone timeZone = TimeZone.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)timeZone, (String)"TimeZone.getDefault()");
            int minutes = (int)TimeUnit.MINUTES.convert(timeZone.getRawOffset(), TimeUnit.MILLISECONDS);
            if (minutes % 60 == 0) {
                return String.valueOf(minutes / 60);
            }
            BigDecimal decimalValue = new BigDecimal(minutes).setScale(2, 6);
            BigDecimal decHours = decimalValue.divide(new BigDecimal(60), new MathContext(2)).setScale(2, 6);
            String string2 = decHours.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"decHours.toString()");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

